untrusted comment: verify with openbsd-67-base.pub
RWRmkIA877Io3lIiMZEq4fQ0I5uII7OjbTidL2+vtANzxkFw2FLoMd5KVVw7gRfscpeudP6656Kbra4m7h/RxIarNy/a5nwYwAU=

OpenBSD 6.7 errata 016, July 31, 2020:

Malformed messages can cause heap corruption in the X Input Method
client implementation in libX11.

Apply by doing:
    signify -Vep /etc/signify/openbsd-67-base.pub -x 016_ximcp.patch.sig \
        -m - | (cd /usr/xenocara && patch -p0)

And then compile and rebuild the X11 library
    cd /usr/xenocara/lib/libX11
    make -f Makefile.bsd-wrapper obj
    make -f Makefile.bsd-wrapper build

Index: lib/libX11/modules/im/ximcp/imDefIc.c
===================================================================
RCS file: /cvs/xenocara/lib/libX11/modules/im/ximcp/imDefIc.c,v
retrieving revision 1.11
diff -u -p -r1.11 imDefIc.c
--- lib/libX11/modules/im/ximcp/imDefIc.c	23 Aug 2018 19:38:12 -0000	1.11
+++ lib/libX11/modules/im/ximcp/imDefIc.c	25 Jul 2020 08:48:13 -0000
@@ -350,7 +350,7 @@ _XimProtoGetICValues(
 	     + sizeof(INT16)
 	     + XIM_PAD(2 + buf_size);
 
-    if (!(buf = Xmalloc(buf_size)))
+    if (!(buf = Xcalloc(buf_size, 1)))
 	return arg->name;
     buf_s = (CARD16 *)&buf[XIM_HEADER_SIZE];
 
@@ -708,6 +708,7 @@ _XimProtoSetICValues(
 #endif /* XIM_CONNECTABLE */
 
     _XimGetCurrentICValues(ic, &ic_values);
+    memset(tmp_buf, 0, sizeof(tmp_buf32));
     buf = tmp_buf;
     buf_size = XIM_HEADER_SIZE
 	+ sizeof(CARD16) + sizeof(CARD16) + sizeof(INT16) + sizeof(CARD16);
@@ -730,7 +731,7 @@ _XimProtoSetICValues(
 
 	buf_size += ret_len;
 	if (buf == tmp_buf) {
-	    if (!(tmp = Xmalloc(buf_size + data_len))) {
+	    if (!(tmp = Xcalloc(buf_size + data_len, 1))) {
 		return tmp_name;
 	    }
 	    memcpy(tmp, buf, buf_size);
@@ -740,6 +741,7 @@ _XimProtoSetICValues(
 		Xfree(buf);
 		return tmp_name;
 	    }
+            memset(&tmp[buf_size], 0, data_len);
 	    buf = tmp;
 	}
     }
Index: lib/libX11/modules/im/ximcp/imDefIm.c
===================================================================
RCS file: /cvs/xenocara/lib/libX11/modules/im/ximcp/imDefIm.c,v
retrieving revision 1.9
diff -u -p -r1.9 imDefIm.c
--- lib/libX11/modules/im/ximcp/imDefIm.c	4 Aug 2019 13:34:53 -0000	1.9
+++ lib/libX11/modules/im/ximcp/imDefIm.c	25 Jul 2020 08:48:13 -0000
@@ -62,6 +62,7 @@ PERFORMANCE OF THIS SOFTWARE.
 #include "XimTrInt.h"
 #include "Ximint.h"
 
+#include <limits.h>
 
 int
 _XimCheckDataSize(
@@ -807,12 +808,16 @@ _XimOpen(
     int			 buf_size;
     int			 ret_code;
     char		*locale_name;
+    size_t		 locale_len;
 
     locale_name = im->private.proto.locale_name;
-    len = strlen(locale_name);
-    buf_b[0] = (BYTE)len;			   /* length of locale name */
-    (void)strcpy((char *)&buf_b[1], locale_name);  /* locale name */
-    len += sizeof(BYTE);			   /* sizeof length */
+    locale_len = strlen(locale_name);
+    if (locale_len > UCHAR_MAX)
+      return False;
+    memset(buf32, 0, sizeof(buf32));
+    buf_b[0] = (BYTE)locale_len;		/* length of locale name */
+    memcpy(&buf_b[1], locale_name, locale_len);	   /* locale name */
+    len = (INT16)(locale_len + sizeof(BYTE));	   /* sizeof length */
     XIM_SET_PAD(buf_b, len);			   /* pad */
 
     _XimSetHeader((XPointer)buf, XIM_OPEN, 0, &len);
@@ -1287,6 +1292,7 @@ _XimProtoSetIMValues(
 #endif /* XIM_CONNECTABLE */
 
     _XimGetCurrentIMValues(im, &im_values);
+    memset(tmp_buf, 0, sizeof(tmp_buf32));
     buf = tmp_buf;
     buf_size = XIM_HEADER_SIZE + sizeof(CARD16) + sizeof(INT16);
     data_len = BUFSIZE - buf_size;
@@ -1307,7 +1313,7 @@ _XimProtoSetIMValues(
 
 	buf_size += ret_len;
 	if (buf == tmp_buf) {
-	    if (!(tmp = Xmalloc(buf_size + data_len))) {
+	    if (!(tmp = Xcalloc(buf_size + data_len, 1))) {
 		return arg->name;
 	    }
 	    memcpy(tmp, buf, buf_size);
@@ -1317,6 +1323,7 @@ _XimProtoSetIMValues(
 		Xfree(buf);
 		return arg->name;
 	    }
+            memset(&tmp[buf_size], 0, data_len);
 	    buf = tmp;
 	}
     }
@@ -1458,7 +1465,7 @@ _XimProtoGetIMValues(
 	     + sizeof(INT16)
 	     + XIM_PAD(buf_size);
 
-    if (!(buf = Xmalloc(buf_size)))
+    if (!(buf = Xcalloc(buf_size, 1)))
 	return arg->name;
     buf_s = (CARD16 *)&buf[XIM_HEADER_SIZE];
 
@@ -1720,7 +1727,7 @@ _XimEncodingNegotiation(
 	+ sizeof(CARD16)
 	+ detail_len;
 
-    if (!(buf = Xmalloc(XIM_HEADER_SIZE + len)))
+    if (!(buf = Xcalloc(XIM_HEADER_SIZE + len, 1)))
 	goto free_detail_ptr;
 
     buf_s = (CARD16 *)&buf[XIM_HEADER_SIZE];
@@ -1816,6 +1823,7 @@ _XimSendSavedIMValues(
     int			 ret_code;
 
     _XimGetCurrentIMValues(im, &im_values);
+    memset(tmp_buf, 0, sizeof(tmp_buf32));
     buf = tmp_buf;
     buf_size = XIM_HEADER_SIZE + sizeof(CARD16) + sizeof(INT16);
     data_len = BUFSIZE - buf_size;
@@ -1838,7 +1846,7 @@ _XimSendSavedIMValues(
 
 	buf_size += ret_len;
 	if (buf == tmp_buf) {
-	    if (!(tmp = Xmalloc(buf_size + data_len))) {
+	    if (!(tmp = Xcalloc(buf_size + data_len, 1))) {
 		return False;
 	    }
 	    memcpy(tmp, buf, buf_size);
@@ -1848,6 +1856,7 @@ _XimSendSavedIMValues(
 		Xfree(buf);
 		return False;
 	    }
+            memset(&tmp[buf_size], 0, data_len);
 	    buf = tmp;
 	}
     }
Index: lib/libX11/modules/im/ximcp/imRmAttr.c
===================================================================
RCS file: /cvs/xenocara/lib/libX11/modules/im/ximcp/imRmAttr.c,v
retrieving revision 1.9
diff -u -p -r1.9 imRmAttr.c
--- lib/libX11/modules/im/ximcp/imRmAttr.c	6 Apr 2015 20:57:56 -0000	1.9
+++ lib/libX11/modules/im/ximcp/imRmAttr.c	25 Jul 2020 08:48:13 -0000
@@ -29,6 +29,8 @@ PERFORMANCE OF THIS SOFTWARE.
 #ifdef HAVE_CONFIG_H
 #include <config.h>
 #endif
+#include <limits.h>
+
 #include "Xlibint.h"
 #include "Xlcint.h"
 #include "Ximint.h"
@@ -214,7 +216,7 @@ _XimAttributeToValue(
     Xic			  ic,
     XIMResourceList	  res,
     CARD16		 *data,
-    INT16		  data_len,
+    CARD16		  data_len,
     XPointer		  value,
     BITMASK32		  mode)
 {
@@ -250,18 +252,24 @@ _XimAttributeToValue(
 
     case XimType_XIMStyles:
 	{
-	    INT16		 num = data[0];
+	    CARD16		 num = data[0];
 	    register CARD32	*style_list = (CARD32 *)&data[2];
 	    XIMStyle		*style;
 	    XIMStyles		*rep;
 	    register int	 i;
 	    char		*p;
-	    int			 alloc_len;
+	    unsigned int         alloc_len;
 
 	    if (!(value))
 		return False;
 
+	    if (num > (USHRT_MAX / sizeof(XIMStyle)))
+		return False;
+	    if ((sizeof(num) + (num * sizeof(XIMStyle))) > data_len)
+		return False;
 	    alloc_len = sizeof(XIMStyles) + sizeof(XIMStyle) * num;
+	    if (alloc_len < sizeof(XIMStyles))
+		return False;
 	    if (!(p = Xmalloc(alloc_len)))
 		return False;
 
@@ -313,7 +321,7 @@ _XimAttributeToValue(
 
     case XimType_XFontSet:
 	{
-	    INT16	 len = data[0];
+	    CARD16	 len = data[0];
 	    char	*base_name;
 	    XFontSet	 rep = (XFontSet)NULL;
 	    char	**missing_list = NULL;
@@ -324,11 +332,12 @@ _XimAttributeToValue(
 		return False;
 	    if (!ic)
 		return False;
-
+	    if (len > data_len)
+		return False;
 	    if (!(base_name = Xmalloc(len + 1)))
 		return False;
 
-	    (void)strncpy(base_name, (char *)&data[1], (int)len);
+	    (void)strncpy(base_name, (char *)&data[1], (size_t)len);
 	    base_name[len] = '\0';
 
 	    if (mode & XIM_PREEDIT_ATTR) {
@@ -357,19 +366,25 @@ _XimAttributeToValue(
 
     case XimType_XIMHotKeyTriggers:
 	{
-	    INT32			 num = *((CARD32 *)data);
+	    CARD32			 num = *((CARD32 *)data);
 	    register CARD32		*key_list = (CARD32 *)&data[2];
 	    XIMHotKeyTrigger		*key;
 	    XIMHotKeyTriggers		*rep;
 	    register int		 i;
 	    char			*p;
-	    int				 alloc_len;
+	    unsigned int		 alloc_len;
 
 	    if (!(value))
 		return False;
 
+	    if (num > (UINT_MAX / sizeof(XIMHotKeyTrigger)))
+		return False;
+	    if ((sizeof(num) + (num * sizeof(XIMHotKeyTrigger))) > data_len)
+		return False;
 	    alloc_len = sizeof(XIMHotKeyTriggers)
 		      + sizeof(XIMHotKeyTrigger) * num;
+	    if (alloc_len < sizeof(XIMHotKeyTriggers))
+		return False;
 	    if (!(p = Xmalloc(alloc_len)))
 		return False;
 
@@ -1378,13 +1393,13 @@ _XimEncodeSavedICATTRIBUTE(
 
 static unsigned int
 _XimCountNumberOfAttr(
-    INT16	 total,
-    CARD16	*attr,
-    int		*names_len)
+    CARD16	  total,
+    CARD16	 *attr,
+    unsigned int *names_len)
 {
     unsigned int n;
-    INT16	 len;
-    INT16	 min_len = sizeof(CARD16)	/* sizeof attribute ID */
+    CARD16	 len;
+    CARD16	 min_len = sizeof(CARD16)	/* sizeof attribute ID */
 			 + sizeof(CARD16)	/* sizeof type of value */
 			 + sizeof(INT16);	/* sizeof length of attribute */
 
@@ -1392,6 +1407,9 @@ _XimCountNumberOfAttr(
     *names_len = 0;
     while (total > min_len) {
 	len = attr[2];
+	if (len >= (total - min_len)) {
+	    return 0;
+	}
 	*names_len += (len + 1);
 	len += (min_len + XIM_PAD(len + 2));
 	total -= len;
@@ -1406,17 +1424,15 @@ _XimGetAttributeID(
     Xim			  im,
     CARD16		 *buf)
 {
-    unsigned int	  n;
+    unsigned int	  n, names_len, values_len;
     XIMResourceList	  res;
     char		 *names;
-    int			  names_len;
     XPointer		  tmp;
     XIMValuesList	 *values_list;
     char		**values;
-    int			  values_len;
     register int	  i;
-    INT16		  len;
-    INT16		  min_len = sizeof(CARD16) /* sizeof attribute ID */
+    CARD16		  len;
+    CARD16		  min_len = sizeof(CARD16) /* sizeof attribute ID */
 				  + sizeof(CARD16) /* sizeof type of value */
 				  + sizeof(INT16); /* sizeof length of attr */
     /*
