/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.fileobjects;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.BaseFileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.LockForFile;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.MutualExclusionSupport;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.utils.FSException;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileChangedManager;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileInfo;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.Enumerations;
import org.openide.util.Utilities;

public class FileObj
extends BaseFileObj {
    static final long serialVersionUID = -1133540210876356809L;
    private long lastModified = -1L;
    private boolean realLastModifiedCached;

    FileObj(File file, FileNaming fileNaming) {
        super(file, fileNaming);
        this.setLastModified(System.currentTimeMillis());
    }

    public OutputStream getOutputStream(FileLock fileLock) throws IOException {
        ProvidedExtensions providedExtensions = this.getProvidedExtensions();
        File file = this.getFileName().getFile();
        if (!Utilities.isWindows() && !file.isFile()) {
            throw new IOException(file.getAbsolutePath());
        }
        return this.getOutputStream(fileLock, providedExtensions, this);
    }

    public OutputStream getOutputStream(FileLock fileLock, ProvidedExtensions providedExtensions, FileObject fileObject) throws IOException {
        final File file = this.getFileName().getFile();
        if (!Utilities.isWindows() && !file.isFile()) {
            throw new IOException(file.getAbsolutePath());
        }
        if (providedExtensions != null) {
            providedExtensions.beforeChange(fileObject);
        }
        final MutualExclusionSupport.Closeable closeable = MutualExclusionSupport.getDefault().addResource((Object)this, false);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file){

                public void close() throws IOException {
                    if (!closeable.isClosed()) {
                        super.close();
                        closeable.close();
                        FileObj.this.setLastModified(file.lastModified());
                        FileObj.this.fireFileChangedEvent(false);
                    }
                }
            };
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (closeable != null) {
                closeable.close();
            }
            FileNotFoundException fileNotFoundException2 = fileNotFoundException;
            if (!FileChangedManager.getInstance().exists(file)) {
                fileNotFoundException2 = (FileNotFoundException)new FileNotFoundException(fileNotFoundException.getLocalizedMessage()).initCause(fileNotFoundException);
            } else if (!file.canWrite()) {
                fileNotFoundException2 = (FileNotFoundException)new FileNotFoundException(fileNotFoundException.getLocalizedMessage()).initCause(fileNotFoundException);
            } else if (file.getParentFile() == null) {
                fileNotFoundException2 = (FileNotFoundException)new FileNotFoundException(fileNotFoundException.getLocalizedMessage()).initCause(fileNotFoundException);
            } else if (!FileChangedManager.getInstance().exists(file.getParentFile())) {
                fileNotFoundException2 = (FileNotFoundException)new FileNotFoundException(fileNotFoundException.getLocalizedMessage()).initCause(fileNotFoundException);
            }
            FSException.annotateException(fileNotFoundException2);
            throw fileNotFoundException2;
        }
        return fileOutputStream;
    }

    public InputStream getInputStream() throws FileNotFoundException {
        FileInputStream fileInputStream;
        File file = this.getFileName().getFile();
        MutualExclusionSupport.Closeable closeable = null;
        try {
            MutualExclusionSupport.Closeable closeable2;
            if (!Utilities.isWindows() && !file.isFile()) {
                return new ByteArrayInputStream(new byte[0]);
            }
            closeable = closeable2 = MutualExclusionSupport.getDefault().addResource((Object)this, true);
            fileInputStream = new FileInputStream(file){

                public void close() throws IOException {
                    super.close();
                    closeable2.close();
                }
            };
        }
        catch (IOException iOException) {
            if (closeable != null) {
                closeable.close();
            }
            FileNotFoundException fileNotFoundException = null;
            fileNotFoundException = !FileChangedManager.getInstance().exists(file) ? (FileNotFoundException)new FileNotFoundException(iOException.getLocalizedMessage()).initCause(iOException) : (!file.canRead() ? (FileNotFoundException)new FileNotFoundException(iOException.getLocalizedMessage()).initCause(iOException) : (file.getParentFile() == null ? (FileNotFoundException)new FileNotFoundException(iOException.getLocalizedMessage()).initCause(iOException) : (!FileChangedManager.getInstance().exists(file.getParentFile()) ? (FileNotFoundException)new FileNotFoundException(iOException.getLocalizedMessage()).initCause(iOException) : (new FileInfo(file).isUnixSpecialFile() ? (FileNotFoundException)new FileNotFoundException(iOException.toString()).initCause(iOException) : (FileNotFoundException)new FileNotFoundException(iOException.toString()).initCause(iOException)))));
            FSException.annotateException(fileNotFoundException);
            throw fileNotFoundException;
        }
        assert (fileInputStream != null);
        return fileInputStream;
    }

    public boolean isReadOnly() {
        File file = this.getFileName().getFile();
        if (!Utilities.isWindows() && !file.isFile()) {
            return true;
        }
        return super.isReadOnly();
    }

    public boolean canWrite() {
        File file = this.getFileName().getFile();
        if (!Utilities.isWindows() && !file.isFile()) {
            return false;
        }
        return super.canWrite();
    }

    public final Date lastModified() {
        File file = this.getFileName().getFile();
        return new Date(file.lastModified());
    }

    final void setLastModified(long l) {
        if (this.lastModified != -1L && !this.realLastModifiedCached) {
            this.realLastModifiedCached = true;
        }
        this.lastModified = l;
    }

    public final FileObject createFolder(String string) throws IOException {
        throw new IOException(this.getPath());
    }

    public final FileObject createData(String string, String string2) throws IOException {
        throw new IOException(this.getPath());
    }

    public final FileObject[] getChildren() {
        return new FileObject[0];
    }

    public final FileObject getFileObject(String string, String string2) {
        return null;
    }

    public boolean isValid() {
        boolean bl = this.lastModified != 0L;
        return bl;
    }

    protected void setValid(boolean bl) {
        if (bl) {
            assert (this.isValid()) : this.toString();
        } else {
            this.lastModified = 0L;
        }
    }

    public final boolean isFolder() {
        return false;
    }

    public void refreshImpl(boolean bl, boolean bl2) {
        boolean bl3;
        long l = this.lastModified;
        boolean bl4 = this.realLastModifiedCached;
        this.setLastModified(this.getFileName().getFile().lastModified());
        boolean bl5 = bl4 ? l != this.lastModified : (bl3 = l < this.lastModified);
        if (bl2 && l != -1L && this.lastModified != -1L && this.lastModified != 0L && bl3) {
            this.fireFileChangedEvent(bl);
        }
    }

    public final void refresh(boolean bl) {
        this.refresh(bl, true);
    }

    public final Enumeration getChildren(boolean bl) {
        return Enumerations.empty();
    }

    public final Enumeration getFolders(boolean bl) {
        return Enumerations.empty();
    }

    public final Enumeration getData(boolean bl) {
        return Enumerations.empty();
    }

    public final FileLock lock() throws IOException {
        File file = this.getFileName().getFile();
        try {
            LockForFile lockForFile = LockForFile.tryLock(file);
            this.getProvidedExtensions().fileLocked(this);
            return lockForFile;
        }
        catch (FileNotFoundException fileNotFoundException) {
            FileNotFoundException fileNotFoundException2 = fileNotFoundException;
            if (!FileChangedManager.getInstance().exists(file)) {
                fileNotFoundException2 = (FileNotFoundException)new FileNotFoundException(fileNotFoundException.getLocalizedMessage()).initCause(fileNotFoundException);
            } else if (!file.canRead()) {
                fileNotFoundException2 = (FileNotFoundException)new FileNotFoundException(fileNotFoundException.getLocalizedMessage()).initCause(fileNotFoundException);
            } else if (!file.canWrite()) {
                fileNotFoundException2 = (FileNotFoundException)new FileNotFoundException(fileNotFoundException.getLocalizedMessage()).initCause(fileNotFoundException);
            } else if (file.getParentFile() == null) {
                fileNotFoundException2 = (FileNotFoundException)new FileNotFoundException(fileNotFoundException.getLocalizedMessage()).initCause(fileNotFoundException);
            } else if (!FileChangedManager.getInstance().exists(file.getParentFile())) {
                fileNotFoundException2 = (FileNotFoundException)new FileNotFoundException(fileNotFoundException.getLocalizedMessage()).initCause(fileNotFoundException);
            }
            FSException.annotateException(fileNotFoundException2);
            throw fileNotFoundException2;
        }
    }

    final boolean checkLock(FileLock fileLock) throws IOException {
        File file = this.getFileName().getFile();
        return fileLock instanceof LockForFile && ((LockForFile)fileLock).getFile().equals(file);
    }

    public void rename(FileLock fileLock, String string, String string2, ProvidedExtensions.IOHandler iOHandler) throws IOException {
        super.rename(fileLock, string, string2, iOHandler);
        this.setLastModified(this.getFileName().getFile().lastModified());
    }
}

