"""Generated message classes for netapp version v1beta1.

Google Cloud NetApp Volumes is a fully-managed, cloud-based data storage
service that provides advanced data management capabilities and highly
scalable performance with global availability.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'netapp'


class ActiveDirectory(_messages.Message):
  r"""ActiveDirectory is the public representation of the active directory
  config.

  Enums:
    StateValueValuesEnum: Output only. The state of the AD.

  Messages:
    LabelsValue: Labels for the active directory.

  Fields:
    administrators: Optional. Users to be added to the Built-in
      Admininstrators group.
    aesEncryption: If enabled, AES encryption will be enabled for SMB
      communication.
    backupOperators: Optional. Users to be added to the Built-in Backup
      Operator active directory group.
    createTime: Output only. Create time of the active directory.
    description: Description of the active directory.
    dns: Required. Comma separated list of DNS server IP addresses for the
      Active Directory domain.
    domain: Required. Name of the Active Directory domain
    encryptDcConnections: If enabled, traffic between the SMB server to Domain
      Controller (DC) will be encrypted.
    kdcHostname: Name of the active directory machine. This optional parameter
      is used only while creating kerberos volume
    kdcIp: KDC server IP address for the active directory machine.
    labels: Labels for the active directory.
    ldapSigning: Specifies whether or not the LDAP traffic needs to be signed.
    name: Identifier. The resource name of the active directory. Format: `proj
      ects/{project_number}/locations/{location_id}/activeDirectories/{active_
      directory_id}`.
    netBiosPrefix: Required. NetBIOSPrefix is used as a prefix for SMB server
      name.
    nfsUsersWithLdap: If enabled, will allow access to local users and LDAP
      users. If access is needed for only LDAP users, it has to be disabled.
    organizationalUnit: The Organizational Unit (OU) within the Windows Active
      Directory the user belongs to.
    password: Required. Password of the Active Directory domain administrator.
    securityOperators: Optional. Domain users to be given the
      SeSecurityPrivilege.
    site: The Active Directory site the service will limit Domain Controller
      discovery too.
    state: Output only. The state of the AD.
    stateDetails: Output only. The state details of the Active Directory.
    username: Required. Username of the Active Directory domain administrator.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The state of the AD.

    Values:
      STATE_UNSPECIFIED: Unspecified Active Directory State
      CREATING: Active Directory State is Creating
      READY: Active Directory State is Ready
      UPDATING: Active Directory State is Updating
      IN_USE: Active Directory State is In use
      DELETING: Active Directory State is Deleting
      ERROR: Active Directory State is Error
      DIAGNOSING: Active Directory State is Diagnosing.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    READY = 2
    UPDATING = 3
    IN_USE = 4
    DELETING = 5
    ERROR = 6
    DIAGNOSING = 7

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels for the active directory.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  administrators = _messages.StringField(1, repeated=True)
  aesEncryption = _messages.BooleanField(2)
  backupOperators = _messages.StringField(3, repeated=True)
  createTime = _messages.StringField(4)
  description = _messages.StringField(5)
  dns = _messages.StringField(6)
  domain = _messages.StringField(7)
  encryptDcConnections = _messages.BooleanField(8)
  kdcHostname = _messages.StringField(9)
  kdcIp = _messages.StringField(10)
  labels = _messages.MessageField('LabelsValue', 11)
  ldapSigning = _messages.BooleanField(12)
  name = _messages.StringField(13)
  netBiosPrefix = _messages.StringField(14)
  nfsUsersWithLdap = _messages.BooleanField(15)
  organizationalUnit = _messages.StringField(16)
  password = _messages.StringField(17)
  securityOperators = _messages.StringField(18, repeated=True)
  site = _messages.StringField(19)
  state = _messages.EnumField('StateValueValuesEnum', 20)
  stateDetails = _messages.StringField(21)
  username = _messages.StringField(22)


class Backup(_messages.Message):
  r"""A NetApp Backup.

  Enums:
    BackupTypeValueValuesEnum: Output only. Type of backup, manually created
      or created by a backup policy.
    StateValueValuesEnum: Output only. The backup state.

  Messages:
    LabelsValue: Resource labels to represent user provided metadata.

  Fields:
    backupRegion: Output only. Region in which backup is stored. Format:
      `projects/{project_id}/locations/{location}`
    backupType: Output only. Type of backup, manually created or created by a
      backup policy.
    chainStorageBytes: Output only. Total size of all backups in a chain in
      bytes = baseline backup size + sum(incremental backup size)
    createTime: Output only. The time when the backup was created.
    description: A description of the backup with 2048 characters or less.
      Requests with longer descriptions will be rejected.
    enforcedRetentionEndTime: Output only. The time until which the backup is
      not deletable.
    labels: Resource labels to represent user provided metadata.
    name: Identifier. The resource name of the backup. Format: `projects/{proj
      ect_id}/locations/{location}/backupVaults/{backup_vault_id}/backups/{bac
      kup_id}`.
    satisfiesPzi: Output only. Reserved for future use
    satisfiesPzs: Output only. Reserved for future use
    sourceSnapshot: If specified, backup will be created from the given
      snapshot. If not specified, there will be a new snapshot taken to
      initiate the backup creation. Format: `projects/{project_id}/locations/{
      location}/volumes/{volume_id}/snapshots/{snapshot_id}`
    sourceVolume: Volume full name of this backup belongs to. Format:
      `projects/{projects_id}/locations/{location}/volumes/{volume_id}`
    state: Output only. The backup state.
    volumeRegion: Output only. Region of the volume from which the backup was
      created. Format: `projects/{project_id}/locations/{location}`
    volumeUsageBytes: Output only. Size of the file system when the backup was
      created. When creating a new volume from the backup, the volume capacity
      will have to be at least as big.
  """

  class BackupTypeValueValuesEnum(_messages.Enum):
    r"""Output only. Type of backup, manually created or created by a backup
    policy.

    Values:
      TYPE_UNSPECIFIED: Unspecified backup type.
      MANUAL: Manual backup type.
      SCHEDULED: Scheduled backup type.
    """
    TYPE_UNSPECIFIED = 0
    MANUAL = 1
    SCHEDULED = 2

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The backup state.

    Values:
      STATE_UNSPECIFIED: State not set.
      CREATING: Backup is being created. While in this state, the snapshot for
        the backup point-in-time may not have been created yet, and so the
        point-in-time may not have been fixed.
      UPLOADING: Backup is being uploaded. While in this state, none of the
        writes to the volume will be included in the backup.
      READY: Backup is available for use.
      DELETING: Backup is being deleted.
      ERROR: Backup is not valid and cannot be used for creating new volumes
        or restoring existing volumes.
      UPDATING: Backup is being updated.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    UPLOADING = 2
    READY = 3
    DELETING = 4
    ERROR = 5
    UPDATING = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Resource labels to represent user provided metadata.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  backupRegion = _messages.StringField(1)
  backupType = _messages.EnumField('BackupTypeValueValuesEnum', 2)
  chainStorageBytes = _messages.IntegerField(3)
  createTime = _messages.StringField(4)
  description = _messages.StringField(5)
  enforcedRetentionEndTime = _messages.StringField(6)
  labels = _messages.MessageField('LabelsValue', 7)
  name = _messages.StringField(8)
  satisfiesPzi = _messages.BooleanField(9)
  satisfiesPzs = _messages.BooleanField(10)
  sourceSnapshot = _messages.StringField(11)
  sourceVolume = _messages.StringField(12)
  state = _messages.EnumField('StateValueValuesEnum', 13)
  volumeRegion = _messages.StringField(14)
  volumeUsageBytes = _messages.IntegerField(15)


class BackupConfig(_messages.Message):
  r"""BackupConfig contains backup related config on a volume.

  Fields:
    backupChainBytes: Output only. Total size of all backups in a chain in
      bytes = baseline backup size + sum(incremental backup size).
    backupPolicies: Optional. When specified, schedule backups will be created
      based on the policy configuration.
    backupVault: Optional. Name of backup vault. Format:
      projects/{project_id}/locations/{location}/backupVaults/{backup_vault_id
      }
    scheduledBackupEnabled: Optional. When set to true, scheduled backup is
      enabled on the volume. This field should be nil when there's no backup
      policy attached.
  """

  backupChainBytes = _messages.IntegerField(1)
  backupPolicies = _messages.StringField(2, repeated=True)
  backupVault = _messages.StringField(3)
  scheduledBackupEnabled = _messages.BooleanField(4)


class BackupPolicy(_messages.Message):
  r"""Backup Policy.

  Enums:
    StateValueValuesEnum: Output only. The backup policy state.

  Messages:
    LabelsValue: Resource labels to represent user provided metadata.

  Fields:
    assignedVolumeCount: Output only. The total number of volumes assigned by
      this backup policy.
    createTime: Output only. The time when the backup policy was created.
    dailyBackupLimit: Number of daily backups to keep. Note that the minimum
      daily backup limit is 2.
    description: Description of the backup policy.
    enabled: If enabled, make backups automatically according to the
      schedules. This will be applied to all volumes that have this policy
      attached and enforced on volume level. If not specified, default is
      true.
    labels: Resource labels to represent user provided metadata.
    monthlyBackupLimit: Number of monthly backups to keep. Note that the sum
      of daily, weekly and monthly backups should be greater than 1.
    name: Identifier. The resource name of the backup policy. Format: `project
      s/{project_id}/locations/{location}/backupPolicies/{backup_policy_id}`.
    state: Output only. The backup policy state.
    weeklyBackupLimit: Number of weekly backups to keep. Note that the sum of
      daily, weekly and monthly backups should be greater than 1.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The backup policy state.

    Values:
      STATE_UNSPECIFIED: State not set.
      CREATING: BackupPolicy is being created.
      READY: BackupPolicy is available for use.
      DELETING: BackupPolicy is being deleted.
      ERROR: BackupPolicy is not valid and cannot be used.
      UPDATING: BackupPolicy is being updated.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    READY = 2
    DELETING = 3
    ERROR = 4
    UPDATING = 5

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Resource labels to represent user provided metadata.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  assignedVolumeCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  createTime = _messages.StringField(2)
  dailyBackupLimit = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  description = _messages.StringField(4)
  enabled = _messages.BooleanField(5)
  labels = _messages.MessageField('LabelsValue', 6)
  monthlyBackupLimit = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  name = _messages.StringField(8)
  state = _messages.EnumField('StateValueValuesEnum', 9)
  weeklyBackupLimit = _messages.IntegerField(10, variant=_messages.Variant.INT32)


class BackupRetentionPolicy(_messages.Message):
  r"""Retention policy for backups in the backup vault

  Fields:
    backupMinimumEnforcedRetentionDays: Required. Minimum retention duration
      in days for backups in the backup vault.
    dailyBackupImmutable: Optional. Indicates if the daily backups are
      immutable. At least one of daily_backup_immutable,
      weekly_backup_immutable, monthly_backup_immutable and
      manual_backup_immutable must be true.
    manualBackupImmutable: Optional. Indicates if the manual backups are
      immutable. At least one of daily_backup_immutable,
      weekly_backup_immutable, monthly_backup_immutable and
      manual_backup_immutable must be true.
    monthlyBackupImmutable: Optional. Indicates if the monthly backups are
      immutable. At least one of daily_backup_immutable,
      weekly_backup_immutable, monthly_backup_immutable and
      manual_backup_immutable must be true.
    weeklyBackupImmutable: Optional. Indicates if the weekly backups are
      immutable. At least one of daily_backup_immutable,
      weekly_backup_immutable, monthly_backup_immutable and
      manual_backup_immutable must be true.
  """

  backupMinimumEnforcedRetentionDays = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  dailyBackupImmutable = _messages.BooleanField(2)
  manualBackupImmutable = _messages.BooleanField(3)
  monthlyBackupImmutable = _messages.BooleanField(4)
  weeklyBackupImmutable = _messages.BooleanField(5)


class BackupVault(_messages.Message):
  r"""A NetApp BackupVault.

  Enums:
    BackupVaultTypeValueValuesEnum: Optional. Type of backup vault to be
      created. Default is IN_REGION.
    EncryptionStateValueValuesEnum: Output only. Field indicating encryption
      state of CMEK backups.
    StateValueValuesEnum: Output only. The backup vault state.

  Messages:
    LabelsValue: Resource labels to represent user provided metadata.

  Fields:
    backupRegion: Optional. Region where the backups are stored. Format:
      `projects/{project_id}/locations/{location}`
    backupRetentionPolicy: Optional. Backup retention policy defining the
      retention of backups.
    backupVaultType: Optional. Type of backup vault to be created. Default is
      IN_REGION.
    backupsCryptoKeyVersion: Output only. The crypto key version used to
      encrypt the backup vault. Format: `projects/{project}/locations/{locatio
      n}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto
      _key_version}`
    createTime: Output only. Create time of the backup vault.
    description: Description of the backup vault.
    destinationBackupVault: Output only. Name of the Backup vault created in
      backup region. Format: `projects/{project_id}/locations/{location}/backu
      pVaults/{backup_vault_id}`
    encryptionState: Output only. Field indicating encryption state of CMEK
      backups.
    keyStateVersion: Output only. The version of the key state. Provided as a
      timestamp in microseconds since the UNIX epoch. This is used to filter
      out states older than the last state applied.
    kmsConfig: Optional. Specifies the Key Management System (KMS)
      configuration to be used for backup encryption. Format:
      `projects/{project}/locations/{location}/kmsConfigs/{kms_config}`
    labels: Resource labels to represent user provided metadata.
    name: Identifier. The resource name of the backup vault. Format: `projects
      /{project_id}/locations/{location}/backupVaults/{backup_vault_id}`.
    sourceBackupVault: Output only. Name of the Backup vault created in source
      region. Format: `projects/{project_id}/locations/{location}/backupVaults
      /{backup_vault_id}`
    sourceRegion: Output only. Region in which the backup vault is created.
      Format: `projects/{project_id}/locations/{location}`
    state: Output only. The backup vault state.
  """

  class BackupVaultTypeValueValuesEnum(_messages.Enum):
    r"""Optional. Type of backup vault to be created. Default is IN_REGION.

    Values:
      BACKUP_VAULT_TYPE_UNSPECIFIED: BackupVault type not set.
      IN_REGION: BackupVault type is IN_REGION.
      CROSS_REGION: BackupVault type is CROSS_REGION.
    """
    BACKUP_VAULT_TYPE_UNSPECIFIED = 0
    IN_REGION = 1
    CROSS_REGION = 2

  class EncryptionStateValueValuesEnum(_messages.Enum):
    r"""Output only. Field indicating encryption state of CMEK backups.

    Values:
      ENCRYPTION_STATE_UNSPECIFIED: Encryption state not set.
      ENCRYPTION_STATE_PENDING: Encryption state is pending.
      ENCRYPTION_STATE_COMPLETED: Encryption is complete.
      ENCRYPTION_STATE_IN_PROGRESS: Encryption is in progress.
      ENCRYPTION_STATE_FAILED: Encryption has failed.
    """
    ENCRYPTION_STATE_UNSPECIFIED = 0
    ENCRYPTION_STATE_PENDING = 1
    ENCRYPTION_STATE_COMPLETED = 2
    ENCRYPTION_STATE_IN_PROGRESS = 3
    ENCRYPTION_STATE_FAILED = 4

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The backup vault state.

    Values:
      STATE_UNSPECIFIED: State not set.
      CREATING: BackupVault is being created.
      READY: BackupVault is available for use.
      DELETING: BackupVault is being deleted.
      ERROR: BackupVault is not valid and cannot be used.
      UPDATING: BackupVault is being updated.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    READY = 2
    DELETING = 3
    ERROR = 4
    UPDATING = 5

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Resource labels to represent user provided metadata.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  backupRegion = _messages.StringField(1)
  backupRetentionPolicy = _messages.MessageField('BackupRetentionPolicy', 2)
  backupVaultType = _messages.EnumField('BackupVaultTypeValueValuesEnum', 3)
  backupsCryptoKeyVersion = _messages.StringField(4)
  createTime = _messages.StringField(5)
  description = _messages.StringField(6)
  destinationBackupVault = _messages.StringField(7)
  encryptionState = _messages.EnumField('EncryptionStateValueValuesEnum', 8)
  keyStateVersion = _messages.IntegerField(9, variant=_messages.Variant.UINT64)
  kmsConfig = _messages.StringField(10)
  labels = _messages.MessageField('LabelsValue', 11)
  name = _messages.StringField(12)
  sourceBackupVault = _messages.StringField(13)
  sourceRegion = _messages.StringField(14)
  state = _messages.EnumField('StateValueValuesEnum', 15)


class BlockDevice(_messages.Message):
  r"""Block device represents the device(s) which are stored in the block
  volume.

  Enums:
    OsTypeValueValuesEnum: Required. Immutable. The OS type of the volume.
      This field can't be changed after the block device is created.

  Fields:
    hostGroups: Optional. A list of host groups that identify hosts that can
      mount the block volume. Format:
      `projects/{project_id}/locations/{location}/hostGroups/{host_group_id}`
      This field can be updated after the block device is created.
    identifier: Output only. Device identifier of the block volume. This
      represents `lun_serial_number` for iSCSI volumes.
    name: Optional. User-defined name for the block device, unique within the
      volume. In case no user input is provided, name will be auto-generated
      in the backend. The name must meet the following requirements: * Be
      between 1 and 255 characters long. * Contain only uppercase or lowercase
      letters (A-Z, a-z), numbers (0-9), and the following special characters:
      "-", "_", "}", "{", ".". * Spaces are not allowed.
    osType: Required. Immutable. The OS type of the volume. This field can't
      be changed after the block device is created.
    sizeGib: Optional. The size of the block device in GiB. Any value provided
      for the `size_gib` field during volume creation is ignored. The block
      device's size is system-managed and will be set to match the parent
      Volume's `capacity_gib`.
  """

  class OsTypeValueValuesEnum(_messages.Enum):
    r"""Required. Immutable. The OS type of the volume. This field can't be
    changed after the block device is created.

    Values:
      OS_TYPE_UNSPECIFIED: Unspecified OS Type
      LINUX: OS Type is Linux
      WINDOWS: OS Type is Windows
      ESXI: OS Type is VMware ESXi
    """
    OS_TYPE_UNSPECIFIED = 0
    LINUX = 1
    WINDOWS = 2
    ESXI = 3

  hostGroups = _messages.StringField(1, repeated=True)
  identifier = _messages.StringField(2)
  name = _messages.StringField(3)
  osType = _messages.EnumField('OsTypeValueValuesEnum', 4)
  sizeGib = _messages.IntegerField(5)


class BlockProperties(_messages.Message):
  r"""Block properties of the volume.

  Enums:
    OsTypeValueValuesEnum: Required. The OS type of the volume.

  Fields:
    hostGroups: Optional. A list of host groups that can be used to mount the
      block volume. Format:
      `projects/{project_id}/locations/{location}/hostGroups/{host_group_id}`
    lunSerialNumber: Output only. Lun serial number of the block volume.
    osType: Required. The OS type of the volume.
  """

  class OsTypeValueValuesEnum(_messages.Enum):
    r"""Required. The OS type of the volume.

    Values:
      OS_TYPE_UNSPECIFIED: Unspecified OS Type
      LINUX: OS Type is Linux
      WINDOWS: OS Type is Windows
      ESXI: OS Type is VMware ESXi
    """
    OS_TYPE_UNSPECIFIED = 0
    LINUX = 1
    WINDOWS = 2
    ESXI = 3

  hostGroups = _messages.StringField(1, repeated=True)
  lunSerialNumber = _messages.StringField(2)
  osType = _messages.EnumField('OsTypeValueValuesEnum', 3)


class CacheConfig(_messages.Message):
  r"""Configuration of the cache volume.

  Enums:
    CachePrePopulateStateValueValuesEnum: Output only. State of the
      prepopulation job indicating how the prepopulation is progressing.

  Fields:
    atimeScrubDays: Optional. Duration in days after which inactive files can
      be scrubbed from FlexCache volume.
    atimeScrubEnabled: Optional. Flag indicating whether the atime based scrub
      is enabled for the FlexCache volume.
    cachePrePopulate: Optional. Pre-populate cache volume with data from the
      origin volume.
    cachePrePopulateState: Output only. State of the prepopulation job
      indicating how the prepopulation is progressing.
    cifsChangeNotifyEnabled: Optional. Flag indicating whether a CIFS change
      notification is enabled for the FlexCache volume.
    writebackEnabled: Optional. Flag indicating whether writeback is enabled
      for the FlexCache volume.
  """

  class CachePrePopulateStateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the prepopulation job indicating how the
    prepopulation is progressing.

    Values:
      CACHE_PRE_POPULATE_STATE_UNSPECIFIED: Default unspecified state.
      NOT_NEEDED: State representing when the most recent create or update
        request did not require a prepopulation job.
      IN_PROGRESS: State representing when the most recent update request
        requested a prepopulation job but it has not yet completed.
      COMPLETE: State representing when the most recent update request
        requested a prepopulation job and it has completed successfully.
      ERROR: State representing when the most recent update request requested
        a prepopulation job but the prepopulate job failed.
    """
    CACHE_PRE_POPULATE_STATE_UNSPECIFIED = 0
    NOT_NEEDED = 1
    IN_PROGRESS = 2
    COMPLETE = 3
    ERROR = 4

  atimeScrubDays = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  atimeScrubEnabled = _messages.BooleanField(2)
  cachePrePopulate = _messages.MessageField('CachePrePopulate', 3)
  cachePrePopulateState = _messages.EnumField('CachePrePopulateStateValueValuesEnum', 4)
  cifsChangeNotifyEnabled = _messages.BooleanField(5)
  writebackEnabled = _messages.BooleanField(6)


class CacheParameters(_messages.Message):
  r"""Cache Parameters for the volume.

  Enums:
    CacheStateValueValuesEnum: Output only. State of the cache volume
      indicating the peering status.

  Fields:
    cacheConfig: Optional. Configuration of the cache volume.
    cacheState: Output only. State of the cache volume indicating the peering
      status.
    command: Output only. Copy-paste-able commands to be used on user's ONTAP
      to accept peering requests.
    enableGlobalFileLock: Optional. Indicates whether the cache volume has
      global file lock enabled.
    passphrase: Output only. Temporary passphrase generated to accept cluster
      peering command.
    peerClusterName: Required. Name of the origin volume's ONTAP cluster.
    peerIpAddresses: Required. List of IC LIF addresses of the origin volume's
      ONTAP cluster.
    peerSvmName: Required. Name of the origin volume's SVM.
    peerVolumeName: Required. Name of the origin volume for the cache volume.
    peeringCommandExpiryTime: Optional. Expiration time for the peering
      command to be executed on user's ONTAP.
    stateDetails: Output only. Detailed description of the current cache
      state.
  """

  class CacheStateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the cache volume indicating the peering status.

    Values:
      CACHE_STATE_UNSPECIFIED: Default unspecified state.
      PENDING_CLUSTER_PEERING: State indicating waiting for cluster peering to
        be established.
      PENDING_SVM_PEERING: State indicating waiting for SVM peering to be
        established.
      PEERED: State indicating successful establishment of peering with origin
        volumes's ONTAP cluster.
      ERROR: Terminal state wherein peering with origin volume's ONTAP cluster
        has failed.
    """
    CACHE_STATE_UNSPECIFIED = 0
    PENDING_CLUSTER_PEERING = 1
    PENDING_SVM_PEERING = 2
    PEERED = 3
    ERROR = 4

  cacheConfig = _messages.MessageField('CacheConfig', 1)
  cacheState = _messages.EnumField('CacheStateValueValuesEnum', 2)
  command = _messages.StringField(3)
  enableGlobalFileLock = _messages.BooleanField(4)
  passphrase = _messages.StringField(5)
  peerClusterName = _messages.StringField(6)
  peerIpAddresses = _messages.StringField(7, repeated=True)
  peerSvmName = _messages.StringField(8)
  peerVolumeName = _messages.StringField(9)
  peeringCommandExpiryTime = _messages.StringField(10)
  stateDetails = _messages.StringField(11)


class CachePrePopulate(_messages.Message):
  r"""Pre-populate cache volume with data from the origin volume.

  Fields:
    excludePathList: Optional. List of directory-paths to be excluded for pre-
      population for the FlexCache volume.
    pathList: Optional. List of directory-paths to be pre-populated for the
      FlexCache volume.
    recursion: Optional. Flag indicating whether the directories listed with
      the `path_list` need to be recursively pre-populated.
  """

  excludePathList = _messages.StringField(1, repeated=True)
  pathList = _messages.StringField(2, repeated=True)
  recursion = _messages.BooleanField(3)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class CloneDetails(_messages.Message):
  r"""Details about a clone volume.

  Fields:
    sharedSpaceGib: Output only. Shared space in GiB. Determined at volume
      creation time based on size of source snapshot.
    sourceSnapshot: Output only. Specifies the full resource name of the
      source snapshot from which this volume was cloned. Format: projects/{pro
      ject}/locations/{location}/volumes/{volume}/snapshots/{snapshot}
    sourceVolume: Output only. Full name of the source volume resource.
      Format: projects/{project}/locations/{location}/volumes/{volume}
  """

  sharedSpaceGib = _messages.IntegerField(1)
  sourceSnapshot = _messages.StringField(2)
  sourceVolume = _messages.StringField(3)


class DailySchedule(_messages.Message):
  r"""Make a snapshot every day e.g. at 04:00, 05:20, 23:50

  Fields:
    hour: Set the hour to start the snapshot (0-23), defaults to midnight (0).
    minute: Set the minute of the hour to start the snapshot (0-59), defaults
      to the top of the hour (0).
    snapshotsToKeep: The maximum number of Snapshots to keep for the hourly
      schedule
  """

  hour = _messages.FloatField(1)
  minute = _messages.FloatField(2)
  snapshotsToKeep = _messages.FloatField(3)


class DestinationVolumeParameters(_messages.Message):
  r"""DestinationVolumeParameters specify input parameters used for creating
  destination volume.

  Fields:
    description: Description for the destination volume.
    shareName: Destination volume's share name. If not specified, source
      volume's share name will be used.
    storagePool: Required. Existing destination StoragePool name.
    tieringPolicy: Optional. Tiering policy for the volume.
    volumeId: Desired destination volume resource id. If not specified, source
      volume's resource id will be used. This value must start with a
      lowercase letter followed by up to 62 lowercase letters, numbers, or
      hyphens, and cannot end with a hyphen.
  """

  description = _messages.StringField(1)
  shareName = _messages.StringField(2)
  storagePool = _messages.StringField(3)
  tieringPolicy = _messages.MessageField('TieringPolicy', 4)
  volumeId = _messages.StringField(5)


class EncryptVolumesRequest(_messages.Message):
  r"""EncryptVolumesRequest specifies the KMS config to encrypt existing
  volumes.
  """



class EstablishPeeringRequest(_messages.Message):
  r"""EstablishPeeringRequest establishes cluster and svm peerings between the
  source and the destination replications.

  Fields:
    peerClusterName: Required. Name of the user's local source cluster to be
      peered with the destination cluster.
    peerIpAddresses: Optional. List of IPv4 ip addresses to be used for
      peering.
    peerSvmName: Required. Name of the user's local source vserver svm to be
      peered with the destination vserver svm.
    peerVolumeName: Required. Name of the user's local source volume to be
      peered with the destination volume.
  """

  peerClusterName = _messages.StringField(1)
  peerIpAddresses = _messages.StringField(2, repeated=True)
  peerSvmName = _messages.StringField(3)
  peerVolumeName = _messages.StringField(4)


class EstablishVolumePeeringRequest(_messages.Message):
  r"""EstablishVolumePeeringRequest establishes cluster and svm peerings
  between the source and destination clusters.

  Fields:
    peerClusterName: Required. Name of the user's local source cluster to be
      peered with the destination cluster.
    peerIpAddresses: Optional. List of IPv4 ip addresses to be used for
      peering.
    peerSvmName: Required. Name of the user's local source vserver svm to be
      peered with the destination vserver svm.
    peerVolumeName: Required. Name of the user's local source volume to be
      peered with the destination volume.
  """

  peerClusterName = _messages.StringField(1)
  peerIpAddresses = _messages.StringField(2, repeated=True)
  peerSvmName = _messages.StringField(3)
  peerVolumeName = _messages.StringField(4)


class ExecuteOntapDeleteResponse(_messages.Message):
  r"""Response message for `ExecuteOntapDelete` API.

  Messages:
    BodyValue: The raw `JSON` body of the response.

  Fields:
    body: The raw `JSON` body of the response.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class BodyValue(_messages.Message):
    r"""The raw `JSON` body of the response.

    Messages:
      AdditionalProperty: An additional property for a BodyValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a BodyValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  body = _messages.MessageField('BodyValue', 1)


class ExecuteOntapListResponse(_messages.Message):
  r"""Response message for `ExecuteOntapList` API.

  Messages:
    RawResponseValue: The raw `JSON` body of the response.
    ResultsValueListEntry: A ResultsValueListEntry object.

  Fields:
    rawResponse: The raw `JSON` body of the response.
    results: The list of results from the ONTAP `LIST` request.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class RawResponseValue(_messages.Message):
    r"""The raw `JSON` body of the response.

    Messages:
      AdditionalProperty: An additional property for a RawResponseValue
        object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a RawResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResultsValueListEntry(_messages.Message):
    r"""A ResultsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a ResultsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResultsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  rawResponse = _messages.MessageField('RawResponseValue', 1)
  results = _messages.MessageField('ResultsValueListEntry', 2, repeated=True)


class ExecuteOntapPatchRequest(_messages.Message):
  r"""Request message for `ExecuteOntapPatch` API.

  Messages:
    BodyValue: Required. The raw `JSON` body of the request. The body should
      be in the format of the ONTAP resource. For example: ``` { "body": {
      "field1": "value1", "field2": "value2", } } ```

  Fields:
    body: Required. The raw `JSON` body of the request. The body should be in
      the format of the ONTAP resource. For example: ``` { "body": { "field1":
      "value1", "field2": "value2", } } ```
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class BodyValue(_messages.Message):
    r"""Required. The raw `JSON` body of the request. The body should be in
    the format of the ONTAP resource. For example: ``` { "body": { "field1":
    "value1", "field2": "value2", } } ```

    Messages:
      AdditionalProperty: An additional property for a BodyValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a BodyValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  body = _messages.MessageField('BodyValue', 1)


class ExecuteOntapPatchResponse(_messages.Message):
  r"""Response message for `ExecuteOntapPatch` API.

  Messages:
    BodyValue: The raw `JSON` body of the response.

  Fields:
    body: The raw `JSON` body of the response.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class BodyValue(_messages.Message):
    r"""The raw `JSON` body of the response.

    Messages:
      AdditionalProperty: An additional property for a BodyValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a BodyValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  body = _messages.MessageField('BodyValue', 1)


class ExecuteOntapPostRequest(_messages.Message):
  r"""Request message for `ExecuteOntapPost` API.

  Messages:
    BodyValue: Required. The raw `JSON` body of the request. The body should
      be in the format of the ONTAP resource. For example: ``` { "body": {
      "field1": "value1", "field2": "value2", } } ```

  Fields:
    body: Required. The raw `JSON` body of the request. The body should be in
      the format of the ONTAP resource. For example: ``` { "body": { "field1":
      "value1", "field2": "value2", } } ```
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class BodyValue(_messages.Message):
    r"""Required. The raw `JSON` body of the request. The body should be in
    the format of the ONTAP resource. For example: ``` { "body": { "field1":
    "value1", "field2": "value2", } } ```

    Messages:
      AdditionalProperty: An additional property for a BodyValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a BodyValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  body = _messages.MessageField('BodyValue', 1)


class ExecuteOntapPostResponse(_messages.Message):
  r"""Response message for `ExecuteOntapPost` API.

  Messages:
    BodyValue: The raw `JSON` body of the response.

  Fields:
    body: The raw `JSON` body of the response.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class BodyValue(_messages.Message):
    r"""The raw `JSON` body of the response.

    Messages:
      AdditionalProperty: An additional property for a BodyValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a BodyValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  body = _messages.MessageField('BodyValue', 1)


class ExportPolicy(_messages.Message):
  r"""Defines the export policy for the volume.

  Fields:
    rules: Required. List of export policy rules
  """

  rules = _messages.MessageField('SimpleExportPolicyRule', 1, repeated=True)


class GoogleProtobufEmpty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class HostGroup(_messages.Message):
  r"""Host group is a collection of hosts that can be used for accessing a
  Block Volume.

  Enums:
    OsTypeValueValuesEnum: Required. The OS type of the host group. It
      indicates the type of operating system used by all of the hosts in the
      HostGroup. All hosts in a HostGroup must be of the same OS type. This
      can be set only when creating a HostGroup.
    StateValueValuesEnum: Output only. State of the host group.
    TypeValueValuesEnum: Required. Type of the host group.

  Messages:
    LabelsValue: Optional. Labels of the host group.

  Fields:
    createTime: Output only. Create time of the host group.
    description: Optional. Description of the host group.
    hosts: Required. The list of hosts associated with the host group.
    labels: Optional. Labels of the host group.
    name: Identifier. The resource name of the host group. Format: `projects/{
      project_number}/locations/{location_id}/hostGroups/{host_group_id}`.
    osType: Required. The OS type of the host group. It indicates the type of
      operating system used by all of the hosts in the HostGroup. All hosts in
      a HostGroup must be of the same OS type. This can be set only when
      creating a HostGroup.
    state: Output only. State of the host group.
    type: Required. Type of the host group.
  """

  class OsTypeValueValuesEnum(_messages.Enum):
    r"""Required. The OS type of the host group. It indicates the type of
    operating system used by all of the hosts in the HostGroup. All hosts in a
    HostGroup must be of the same OS type. This can be set only when creating
    a HostGroup.

    Values:
      OS_TYPE_UNSPECIFIED: Unspecified OS Type
      LINUX: OS Type is Linux
      WINDOWS: OS Type is Windows
      ESXI: OS Type is VMware ESXi
    """
    OS_TYPE_UNSPECIFIED = 0
    LINUX = 1
    WINDOWS = 2
    ESXI = 3

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the host group.

    Values:
      STATE_UNSPECIFIED: Unspecified state for host group.
      CREATING: Host group is creating.
      READY: Host group is ready.
      UPDATING: Host group is updating.
      DELETING: Host group is deleting.
      DISABLED: Host group is disabled.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    READY = 2
    UPDATING = 3
    DELETING = 4
    DISABLED = 5

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. Type of the host group.

    Values:
      TYPE_UNSPECIFIED: Unspecified type for host group.
      ISCSI_INITIATOR: iSCSI initiator host group.
    """
    TYPE_UNSPECIFIED = 0
    ISCSI_INITIATOR = 1

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels of the host group.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  hosts = _messages.StringField(3, repeated=True)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  osType = _messages.EnumField('OsTypeValueValuesEnum', 6)
  state = _messages.EnumField('StateValueValuesEnum', 7)
  type = _messages.EnumField('TypeValueValuesEnum', 8)


class HourlySchedule(_messages.Message):
  r"""Make a snapshot every hour e.g. at 04:00, 05:00, 06:00.

  Fields:
    minute: Set the minute of the hour to start the snapshot (0-59), defaults
      to the top of the hour (0).
    snapshotsToKeep: The maximum number of Snapshots to keep for the hourly
      schedule
  """

  minute = _messages.FloatField(1)
  snapshotsToKeep = _messages.FloatField(2)


class HybridPeeringDetails(_messages.Message):
  r"""HybridPeeringDetails contains details about the hybrid peering.

  Fields:
    command: Output only. Copy-paste-able commands to be used on user's ONTAP
      to accept peering requests.
    commandExpiryTime: Output only. Expiration time for the peering command to
      be executed on user's ONTAP.
    passphrase: Output only. Temporary passphrase generated to accept cluster
      peering command.
    peerClusterName: Output only. Name of the user's local source cluster to
      be peered with the destination cluster.
    peerSvmName: Output only. Name of the user's local source vserver svm to
      be peered with the destination vserver svm.
    peerVolumeName: Output only. Name of the user's local source volume to be
      peered with the destination volume.
    subnetIp: Output only. IP address of the subnet.
  """

  command = _messages.StringField(1)
  commandExpiryTime = _messages.StringField(2)
  passphrase = _messages.StringField(3)
  peerClusterName = _messages.StringField(4)
  peerSvmName = _messages.StringField(5)
  peerVolumeName = _messages.StringField(6)
  subnetIp = _messages.StringField(7)


class HybridReplicationParameters(_messages.Message):
  r"""The Hybrid Replication parameters for the volume.

  Enums:
    HybridReplicationTypeValueValuesEnum: Optional. Type of the hybrid
      replication.
    ReplicationScheduleValueValuesEnum: Optional. Replication Schedule for the
      replication created.

  Messages:
    LabelsValue: Optional. Labels to be added to the replication as the key
      value pairs.

  Fields:
    clusterLocation: Optional. Name of source cluster location associated with
      the Hybrid replication. This is a free-form field for the display
      purpose only.
    description: Optional. Description of the replication.
    hybridReplicationType: Optional. Type of the hybrid replication.
    labels: Optional. Labels to be added to the replication as the key value
      pairs.
    largeVolumeConstituentCount: Optional. Constituent volume count for large
      volume.
    peerClusterName: Required. Name of the user's local source cluster to be
      peered with the destination cluster.
    peerIpAddresses: Required. List of node ip addresses to be peered with.
    peerSvmName: Required. Name of the user's local source vserver svm to be
      peered with the destination vserver svm.
    peerVolumeName: Required. Name of the user's local source volume to be
      peered with the destination volume.
    replication: Required. Desired name for the replication of this volume.
    replicationSchedule: Optional. Replication Schedule for the replication
      created.
  """

  class HybridReplicationTypeValueValuesEnum(_messages.Enum):
    r"""Optional. Type of the hybrid replication.

    Values:
      VOLUME_HYBRID_REPLICATION_TYPE_UNSPECIFIED: Unspecified hybrid
        replication type.
      MIGRATION: Hybrid replication type for migration.
      CONTINUOUS_REPLICATION: Hybrid replication type for continuous
        replication.
      ONPREM_REPLICATION: New field for reversible OnPrem replication, to be
        used for data protection.
      REVERSE_ONPREM_REPLICATION: New field for reversible OnPrem replication,
        to be used for data protection.
    """
    VOLUME_HYBRID_REPLICATION_TYPE_UNSPECIFIED = 0
    MIGRATION = 1
    CONTINUOUS_REPLICATION = 2
    ONPREM_REPLICATION = 3
    REVERSE_ONPREM_REPLICATION = 4

  class ReplicationScheduleValueValuesEnum(_messages.Enum):
    r"""Optional. Replication Schedule for the replication created.

    Values:
      HYBRID_REPLICATION_SCHEDULE_UNSPECIFIED: Unspecified
        HybridReplicationSchedule
      EVERY_10_MINUTES: Replication happens once every 10 minutes.
      HOURLY: Replication happens once every hour.
      DAILY: Replication happens once every day.
    """
    HYBRID_REPLICATION_SCHEDULE_UNSPECIFIED = 0
    EVERY_10_MINUTES = 1
    HOURLY = 2
    DAILY = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels to be added to the replication as the key value
    pairs.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  clusterLocation = _messages.StringField(1)
  description = _messages.StringField(2)
  hybridReplicationType = _messages.EnumField('HybridReplicationTypeValueValuesEnum', 3)
  labels = _messages.MessageField('LabelsValue', 4)
  largeVolumeConstituentCount = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  peerClusterName = _messages.StringField(6)
  peerIpAddresses = _messages.StringField(7, repeated=True)
  peerSvmName = _messages.StringField(8)
  peerVolumeName = _messages.StringField(9)
  replication = _messages.StringField(10)
  replicationSchedule = _messages.EnumField('ReplicationScheduleValueValuesEnum', 11)


class KmsConfig(_messages.Message):
  r"""KmsConfig is the customer-managed encryption key(CMEK) configuration.

  Enums:
    StateValueValuesEnum: Output only. State of the KmsConfig.

  Messages:
    LabelsValue: Labels as key value pairs

  Fields:
    createTime: Output only. Create time of the KmsConfig.
    cryptoKeyName: Required. Customer-managed crypto key resource full name.
      Format: `projects/{project}/locations/{location}/keyRings/{key_ring}/cry
      ptoKeys/{crypto_key}`
    description: Description of the KmsConfig.
    instructions: Output only. Instructions to provide the access to the
      customer provided encryption key.
    labels: Labels as key value pairs
    name: Identifier. Name of the KmsConfig. Format:
      `projects/{project}/locations/{location}/kmsConfigs/{kms_config}`
    primaryCryptoKeyVersion: Output only. Active key version corresponding to
      the crypto key name. Format: projects/{project}/locations/{location}/key
      Rings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_v
      ersion}.
    serviceAccount: Output only. The Service account which will have access to
      the customer provided encryption key.
    state: Output only. State of the KmsConfig.
    stateDetails: Output only. State details of the KmsConfig.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the KmsConfig.

    Values:
      STATE_UNSPECIFIED: Unspecified KmsConfig State
      READY: KmsConfig State is Ready
      CREATING: KmsConfig State is Creating
      DELETING: KmsConfig State is Deleting
      UPDATING: KmsConfig State is Updating
      IN_USE: KmsConfig State is In Use.
      ERROR: KmsConfig State is Error
      KEY_CHECK_PENDING: KmsConfig State is Pending to verify crypto key
        access.
      KEY_NOT_REACHABLE: KmsConfig State is Not accessbile by the SDE service
        account to the crypto key.
      DISABLING: KmsConfig State is Disabling.
      DISABLED: KmsConfig State is Disabled.
      MIGRATING: KmsConfig State is Migrating. The existing volumes are
        migrating from SMEK to CMEK.
    """
    STATE_UNSPECIFIED = 0
    READY = 1
    CREATING = 2
    DELETING = 3
    UPDATING = 4
    IN_USE = 5
    ERROR = 6
    KEY_CHECK_PENDING = 7
    KEY_NOT_REACHABLE = 8
    DISABLING = 9
    DISABLED = 10
    MIGRATING = 11

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  cryptoKeyName = _messages.StringField(2)
  description = _messages.StringField(3)
  instructions = _messages.StringField(4)
  labels = _messages.MessageField('LabelsValue', 5)
  name = _messages.StringField(6)
  primaryCryptoKeyVersion = _messages.StringField(7)
  serviceAccount = _messages.StringField(8)
  state = _messages.EnumField('StateValueValuesEnum', 9)
  stateDetails = _messages.StringField(10)


class LargeCapacityConfig(_messages.Message):
  r"""Configuration for a Large Capacity Volume. A Large Capacity Volume
  supports sizes ranging from 12 TiB to 20 PiB, it is composed of multiple
  internal constituents, and must be created in a large capacity pool.

  Fields:
    constituentCount: Optional. The number of internal constituents (e.g.,
      FlexVols) for this large volume. The minimum number of constituents is
      2.
  """

  constituentCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class ListActiveDirectoriesResponse(_messages.Message):
  r"""ListActiveDirectoriesResponse contains all the active directories
  requested.

  Fields:
    activeDirectories: The list of active directories.
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  activeDirectories = _messages.MessageField('ActiveDirectory', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListBackupPoliciesResponse(_messages.Message):
  r"""ListBackupPoliciesResponse contains all the backup policies requested.

  Fields:
    backupPolicies: The list of backup policies.
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  backupPolicies = _messages.MessageField('BackupPolicy', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListBackupVaultsResponse(_messages.Message):
  r"""ListBackupVaultsResponse is the result of ListBackupVaultsRequest.

  Fields:
    backupVaults: A list of backupVaults in the project for the specified
      location.
    nextPageToken: The token you can use to retrieve the next page of results.
      Not returned if there are no more results in the list.
    unreachable: Locations that could not be reached.
  """

  backupVaults = _messages.MessageField('BackupVault', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListBackupsResponse(_messages.Message):
  r"""ListBackupsResponse is the result of ListBackupsRequest.

  Fields:
    backups: A list of backups in the project.
    nextPageToken: The token you can use to retrieve the next page of results.
      Not returned if there are no more results in the list.
    unreachable: Locations that could not be reached.
  """

  backups = _messages.MessageField('Backup', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListHostGroupsResponse(_messages.Message):
  r"""ListHostGroupsResponse is the response to a ListHostGroupsRequest.

  Fields:
    hostGroups: The list of host groups.
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  hostGroups = _messages.MessageField('HostGroup', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListKmsConfigsResponse(_messages.Message):
  r"""ListKmsConfigsResponse is the response to a ListKmsConfigsRequest.

  Fields:
    kmsConfigs: The list of KmsConfigs
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  kmsConfigs = _messages.MessageField('KmsConfig', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
    unreachable: Unordered list. Unreachable resources. Populated when the
      request sets `ListOperationsRequest.return_partial_success` and reads
      across collections. For example, when attempting to list all resources
      across all supported locations.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListQuotaRulesResponse(_messages.Message):
  r"""ListQuotaRulesResponse is the response to a ListQuotaRulesRequest.

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    quotaRules: List of quota rules
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  quotaRules = _messages.MessageField('QuotaRule', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListReplicationsResponse(_messages.Message):
  r"""ListReplicationsResponse is the result of ListReplicationsRequest.

  Fields:
    nextPageToken: The token you can use to retrieve the next page of results.
      Not returned if there are no more results in the list.
    replications: A list of replications in the project for the specified
      volume.
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  replications = _messages.MessageField('Replication', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListSnapshotsResponse(_messages.Message):
  r"""ListSnapshotsResponse is the result of ListSnapshotsRequest.

  Fields:
    nextPageToken: The token you can use to retrieve the next page of results.
      Not returned if there are no more results in the list.
    snapshots: A list of snapshots in the project for the specified volume.
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  snapshots = _messages.MessageField('Snapshot', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListStoragePoolsResponse(_messages.Message):
  r"""ListStoragePoolsResponse is the response to a ListStoragePoolsRequest.

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    storagePools: The list of StoragePools
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  storagePools = _messages.MessageField('StoragePool', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListVolumesResponse(_messages.Message):
  r"""Message for response to listing Volumes

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
    volumes: The list of Volume
  """

  nextPageToken = _messages.StringField(1)
  unreachable = _messages.StringField(2, repeated=True)
  volumes = _messages.MessageField('Volume', 3, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class LocationMetadata(_messages.Message):
  r"""Metadata for a given google.cloud.location.Location.

  Enums:
    SupportedFlexPerformanceValueListEntryValuesEnum:
    SupportedServiceLevelsValueListEntryValuesEnum:

  Fields:
    hasOntapProxy: Output only. Indicates if the location has ONTAP Proxy
      support.
    hasVcp: Output only. Indicates if the location has VCP support.
    supportedFlexPerformance: Output only. Supported flex performance in a
      location.
    supportedServiceLevels: Output only. Supported service levels in a
      location.
  """

  class SupportedFlexPerformanceValueListEntryValuesEnum(_messages.Enum):
    r"""SupportedFlexPerformanceValueListEntryValuesEnum enum type.

    Values:
      FLEX_PERFORMANCE_UNSPECIFIED: Unspecified flex performance.
      FLEX_PERFORMANCE_DEFAULT: Flex Storage Pool with default performance.
      FLEX_PERFORMANCE_CUSTOM: Flex Storage Pool with custom performance.
    """
    FLEX_PERFORMANCE_UNSPECIFIED = 0
    FLEX_PERFORMANCE_DEFAULT = 1
    FLEX_PERFORMANCE_CUSTOM = 2

  class SupportedServiceLevelsValueListEntryValuesEnum(_messages.Enum):
    r"""SupportedServiceLevelsValueListEntryValuesEnum enum type.

    Values:
      SERVICE_LEVEL_UNSPECIFIED: Unspecified service level.
      PREMIUM: Premium service level.
      EXTREME: Extreme service level.
      STANDARD: Standard service level.
      FLEX: Flex service level.
    """
    SERVICE_LEVEL_UNSPECIFIED = 0
    PREMIUM = 1
    EXTREME = 2
    STANDARD = 3
    FLEX = 4

  hasOntapProxy = _messages.BooleanField(1)
  hasVcp = _messages.BooleanField(2)
  supportedFlexPerformance = _messages.EnumField('SupportedFlexPerformanceValueListEntryValuesEnum', 3, repeated=True)
  supportedServiceLevels = _messages.EnumField('SupportedServiceLevelsValueListEntryValuesEnum', 4, repeated=True)


class MonthlySchedule(_messages.Message):
  r"""Make a snapshot once a month e.g. at 2nd 04:00, 7th 05:20, 24th 23:50

  Fields:
    daysOfMonth: Set the day or days of the month to make a snapshot (1-31).
      Accepts a comma separated number of days. Defaults to '1'.
    hour: Set the hour to start the snapshot (0-23), defaults to midnight (0).
    minute: Set the minute of the hour to start the snapshot (0-59), defaults
      to the top of the hour (0).
    snapshotsToKeep: The maximum number of Snapshots to keep for the hourly
      schedule
  """

  daysOfMonth = _messages.StringField(1)
  hour = _messages.FloatField(2)
  minute = _messages.FloatField(3)
  snapshotsToKeep = _messages.FloatField(4)


class MountOption(_messages.Message):
  r"""View only mount options for a volume.

  Enums:
    ProtocolValueValuesEnum: Protocol to mount with.

  Fields:
    export: Export string
    exportFull: Full export string
    instructions: Instructions for mounting
    ipAddress: Output only. IP Address.
    protocol: Protocol to mount with.
  """

  class ProtocolValueValuesEnum(_messages.Enum):
    r"""Protocol to mount with.

    Values:
      PROTOCOLS_UNSPECIFIED: Unspecified protocol
      NFSV3: NFS V3 protocol
      NFSV4: NFS V4 protocol
      SMB: SMB protocol
      ISCSI: ISCSI protocol
    """
    PROTOCOLS_UNSPECIFIED = 0
    NFSV3 = 1
    NFSV4 = 2
    SMB = 3
    ISCSI = 4

  export = _messages.StringField(1)
  exportFull = _messages.StringField(2)
  instructions = _messages.StringField(3)
  ipAddress = _messages.StringField(4)
  protocol = _messages.EnumField('ProtocolValueValuesEnum', 5)


class NetappProjectsLocationsActiveDirectoriesCreateRequest(_messages.Message):
  r"""A NetappProjectsLocationsActiveDirectoriesCreateRequest object.

  Fields:
    activeDirectory: A ActiveDirectory resource to be passed as the request
      body.
    activeDirectoryId: Required. ID of the active directory to create. Must be
      unique within the parent resource. Must contain only letters, numbers
      and hyphen, with the first character a letter , the last a letter or a
      number, and a 63 character maximum.
    parent: Required. Value for parent.
  """

  activeDirectory = _messages.MessageField('ActiveDirectory', 1)
  activeDirectoryId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetappProjectsLocationsActiveDirectoriesDeleteRequest(_messages.Message):
  r"""A NetappProjectsLocationsActiveDirectoriesDeleteRequest object.

  Fields:
    name: Required. Name of the active directory.
  """

  name = _messages.StringField(1, required=True)


class NetappProjectsLocationsActiveDirectoriesGetRequest(_messages.Message):
  r"""A NetappProjectsLocationsActiveDirectoriesGetRequest object.

  Fields:
    name: Required. Name of the active directory.
  """

  name = _messages.StringField(1, required=True)


class NetappProjectsLocationsActiveDirectoriesListRequest(_messages.Message):
  r"""A NetappProjectsLocationsActiveDirectoriesListRequest object.

  Fields:
    filter: Filtering results
    orderBy: Hint for how to order the results
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, the server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. Parent value for ListActiveDirectoriesRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class NetappProjectsLocationsActiveDirectoriesPatchRequest(_messages.Message):
  r"""A NetappProjectsLocationsActiveDirectoriesPatchRequest object.

  Fields:
    activeDirectory: A ActiveDirectory resource to be passed as the request
      body.
    name: Identifier. The resource name of the active directory. Format: `proj
      ects/{project_number}/locations/{location_id}/activeDirectories/{active_
      directory_id}`.
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the Active Directory resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
  """

  activeDirectory = _messages.MessageField('ActiveDirectory', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class NetappProjectsLocationsBackupPoliciesCreateRequest(_messages.Message):
  r"""A NetappProjectsLocationsBackupPoliciesCreateRequest object.

  Fields:
    backupPolicy: A BackupPolicy resource to be passed as the request body.
    backupPolicyId: Required. The ID to use for the backup policy. The ID must
      be unique within the specified location. Must contain only letters,
      numbers and hyphen, with the first character a letter, the last a letter
      or a number, and a 63 character maximum.
    parent: Required. The location to create the backup policies of, in the
      format `projects/{project_id}/locations/{location}`
  """

  backupPolicy = _messages.MessageField('BackupPolicy', 1)
  backupPolicyId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetappProjectsLocationsBackupPoliciesDeleteRequest(_messages.Message):
  r"""A NetappProjectsLocationsBackupPoliciesDeleteRequest object.

  Fields:
    name: Required. The backup policy resource name, in the format `projects/{
      project_id}/locations/{location}/backupPolicies/{backup_policy_id}`
  """

  name = _messages.StringField(1, required=True)


class NetappProjectsLocationsBackupPoliciesGetRequest(_messages.Message):
  r"""A NetappProjectsLocationsBackupPoliciesGetRequest object.

  Fields:
    name: Required. The backupPolicy resource name, in the format `projects/{p
      roject_id}/locations/{location}/backupPolicies/{backup_policy_id}`
  """

  name = _messages.StringField(1, required=True)


class NetappProjectsLocationsBackupPoliciesListRequest(_messages.Message):
  r"""A NetappProjectsLocationsBackupPoliciesListRequest object.

  Fields:
    filter: Filtering results
    orderBy: Hint for how to order the results
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, the server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. Parent value for ListBackupPoliciesRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class NetappProjectsLocationsBackupPoliciesPatchRequest(_messages.Message):
  r"""A NetappProjectsLocationsBackupPoliciesPatchRequest object.

  Fields:
    backupPolicy: A BackupPolicy resource to be passed as the request body.
    name: Identifier. The resource name of the backup policy. Format: `project
      s/{project_id}/locations/{location}/backupPolicies/{backup_policy_id}`.
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the Backup Policy resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
  """

  backupPolicy = _messages.MessageField('BackupPolicy', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class NetappProjectsLocationsBackupVaultsBackupsCreateRequest(_messages.Message):
  r"""A NetappProjectsLocationsBackupVaultsBackupsCreateRequest object.

  Fields:
    backup: A Backup resource to be passed as the request body.
    backupId: Required. The ID to use for the backup. The ID must be unique
      within the specified backupVault. Must contain only letters, numbers and
      hyphen, with the first character a letter, the last a letter or a
      number, and a 63 character maximum.
    parent: Required. The NetApp backupVault to create the backups of, in the
      format `projects/*/locations/*/backupVaults/{backup_vault_id}`
  """

  backup = _messages.MessageField('Backup', 1)
  backupId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetappProjectsLocationsBackupVaultsBackupsDeleteRequest(_messages.Message):
  r"""A NetappProjectsLocationsBackupVaultsBackupsDeleteRequest object.

  Fields:
    name: Required. The backup resource name, in the format `projects/{project
      _id}/locations/{location}/backupVaults/{backup_vault_id}/backups/{backup
      _id}`
  """

  name = _messages.StringField(1, required=True)


class NetappProjectsLocationsBackupVaultsBackupsGetRequest(_messages.Message):
  r"""A NetappProjectsLocationsBackupVaultsBackupsGetRequest object.

  Fields:
    name: Required. The backup resource name, in the format `projects/{project
      _id}/locations/{location}/backupVaults/{backup_vault_id}/backups/{backup
      _id}`
  """

  name = _messages.StringField(1, required=True)


class NetappProjectsLocationsBackupVaultsBackupsListRequest(_messages.Message):
  r"""A NetappProjectsLocationsBackupVaultsBackupsListRequest object.

  Fields:
    filter: The standard list filter. If specified, backups will be returned
      based on the attribute name that matches the filter expression. If
      empty, then no backups are filtered out. See https://google.aip.dev/160
    orderBy: Sort results. Supported values are "name", "name desc" or ""
      (unsorted).
    pageSize: The maximum number of items to return. The service may return
      fewer than this value. The maximum value is 1000; values above 1000 will
      be coerced to 1000.
    pageToken: The next_page_token value to use if there are additional
      results to retrieve for this list request.
    parent: Required. The backupVault for which to retrieve backup
      information, in the format `projects/{project_id}/locations/{location}/b
      ackupVaults/{backup_vault_id}`. To retrieve backup information for all
      locations, use "-" for the `{location}` value. To retrieve backup
      information for all backupVaults, use "-" for the `{backup_vault_id}`
      value. To retrieve backup information for a volume, use "-" for the
      `{backup_vault_id}` value and specify volume full name with the filter.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class NetappProjectsLocationsBackupVaultsBackupsPatchRequest(_messages.Message):
  r"""A NetappProjectsLocationsBackupVaultsBackupsPatchRequest object.

  Fields:
    backup: A Backup resource to be passed as the request body.
    name: Identifier. The resource name of the backup. Format: `projects/{proj
      ect_id}/locations/{location}/backupVaults/{backup_vault_id}/backups/{bac
      kup_id}`.
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the Backup resource to be updated. The fields specified
      in the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. If the user does not
      provide a mask then all fields will be overwritten.
  """

  backup = _messages.MessageField('Backup', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class NetappProjectsLocationsBackupVaultsCreateRequest(_messages.Message):
  r"""A NetappProjectsLocationsBackupVaultsCreateRequest object.

  Fields:
    backupVault: A BackupVault resource to be passed as the request body.
    backupVaultId: Required. The ID to use for the backupVault. The ID must be
      unique within the specified location. Must contain only letters, numbers
      and hyphen, with the first character a letter, the last a letter or a
      number, and a 63 character maximum.
    parent: Required. The location to create the backup vaults, in the format
      `projects/{project_id}/locations/{location}`
  """

  backupVault = _messages.MessageField('BackupVault', 1)
  backupVaultId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetappProjectsLocationsBackupVaultsDeleteRequest(_messages.Message):
  r"""A NetappProjectsLocationsBackupVaultsDeleteRequest object.

  Fields:
    name: Required. The backupVault resource name, in the format `projects/{pr
      oject_id}/locations/{location}/backupVaults/{backup_vault_id}`
  """

  name = _messages.StringField(1, required=True)


class NetappProjectsLocationsBackupVaultsGetRequest(_messages.Message):
  r"""A NetappProjectsLocationsBackupVaultsGetRequest object.

  Fields:
    name: Required. The backupVault resource name, in the format `projects/{pr
      oject_id}/locations/{location}/backupVaults/{backup_vault_id}`
  """

  name = _messages.StringField(1, required=True)


class NetappProjectsLocationsBackupVaultsListRequest(_messages.Message):
  r"""A NetappProjectsLocationsBackupVaultsListRequest object.

  Fields:
    filter: List filter.
    orderBy: Sort results. Supported values are "name", "name desc" or ""
      (unsorted).
    pageSize: The maximum number of items to return.
    pageToken: The next_page_token value to use if there are additional
      results to retrieve for this list request.
    parent: Required. The location for which to retrieve backupVault
      information, in the format `projects/{project_id}/locations/{location}`.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class NetappProjectsLocationsBackupVaultsPatchRequest(_messages.Message):
  r"""A NetappProjectsLocationsBackupVaultsPatchRequest object.

  Fields:
    backupVault: A BackupVault resource to be passed as the request body.
    name: Identifier. The resource name of the backup vault. Format: `projects
      /{project_id}/locations/{location}/backupVaults/{backup_vault_id}`.
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the Backup resource to be updated. The fields specified
      in the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. If the user does not
      provide a mask then all fields will be overwritten.
  """

  backupVault = _messages.MessageField('BackupVault', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class NetappProjectsLocationsGetRequest(_messages.Message):
  r"""A NetappProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class NetappProjectsLocationsHostGroupsCreateRequest(_messages.Message):
  r"""A NetappProjectsLocationsHostGroupsCreateRequest object.

  Fields:
    hostGroup: A HostGroup resource to be passed as the request body.
    hostGroupId: Required. ID of the host group to create. Must be unique
      within the parent resource. Must contain only letters, numbers, and
      hyphen, with the first character a letter or underscore, the last a
      letter or underscore or a number, and a 63 character maximum.
    parent: Required. Parent value for CreateHostGroupRequest
  """

  hostGroup = _messages.MessageField('HostGroup', 1)
  hostGroupId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetappProjectsLocationsHostGroupsDeleteRequest(_messages.Message):
  r"""A NetappProjectsLocationsHostGroupsDeleteRequest object.

  Fields:
    name: Required. The resource name of the host group. Format: `projects/{pr
      oject_number}/locations/{location_id}/hostGroups/{host_group_id}`.
  """

  name = _messages.StringField(1, required=True)


class NetappProjectsLocationsHostGroupsGetRequest(_messages.Message):
  r"""A NetappProjectsLocationsHostGroupsGetRequest object.

  Fields:
    name: Required. The resource name of the host group. Format: `projects/{pr
      oject_number}/locations/{location_id}/hostGroups/{host_group_id}`.
  """

  name = _messages.StringField(1, required=True)


class NetappProjectsLocationsHostGroupsListRequest(_messages.Message):
  r"""A NetappProjectsLocationsHostGroupsListRequest object.

  Fields:
    filter: Optional. Filter to apply to the request.
    orderBy: Optional. Hint for how to order the results
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, the server will pick an appropriate
      default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListHostGroupsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class NetappProjectsLocationsHostGroupsPatchRequest(_messages.Message):
  r"""A NetappProjectsLocationsHostGroupsPatchRequest object.

  Fields:
    hostGroup: A HostGroup resource to be passed as the request body.
    name: Identifier. The resource name of the host group. Format: `projects/{
      project_number}/locations/{location_id}/hostGroups/{host_group_id}`.
    updateMask: Optional. The list of fields to update.
  """

  hostGroup = _messages.MessageField('HostGroup', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class NetappProjectsLocationsKmsConfigsCreateRequest(_messages.Message):
  r"""A NetappProjectsLocationsKmsConfigsCreateRequest object.

  Fields:
    kmsConfig: A KmsConfig resource to be passed as the request body.
    kmsConfigId: Required. Id of the requesting KmsConfig. Must be unique
      within the parent resource. Must contain only letters, numbers and
      hyphen, with the first character a letter, the last a letter or a
      number, and a 63 character maximum.
    parent: Required. Value for parent.
  """

  kmsConfig = _messages.MessageField('KmsConfig', 1)
  kmsConfigId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetappProjectsLocationsKmsConfigsDeleteRequest(_messages.Message):
  r"""A NetappProjectsLocationsKmsConfigsDeleteRequest object.

  Fields:
    name: Required. Name of the KmsConfig.
  """

  name = _messages.StringField(1, required=True)


class NetappProjectsLocationsKmsConfigsEncryptRequest(_messages.Message):
  r"""A NetappProjectsLocationsKmsConfigsEncryptRequest object.

  Fields:
    encryptVolumesRequest: A EncryptVolumesRequest resource to be passed as
      the request body.
    name: Required. Name of the KmsConfig.
  """

  encryptVolumesRequest = _messages.MessageField('EncryptVolumesRequest', 1)
  name = _messages.StringField(2, required=True)


class NetappProjectsLocationsKmsConfigsGetRequest(_messages.Message):
  r"""A NetappProjectsLocationsKmsConfigsGetRequest object.

  Fields:
    name: Required. Name of the KmsConfig
  """

  name = _messages.StringField(1, required=True)


class NetappProjectsLocationsKmsConfigsListRequest(_messages.Message):
  r"""A NetappProjectsLocationsKmsConfigsListRequest object.

  Fields:
    filter: List filter.
    orderBy: Sort results. Supported values are "name", "name desc" or ""
      (unsorted).
    pageSize: The maximum number of items to return.
    pageToken: The next_page_token value to use if there are additional
      results to retrieve for this list request.
    parent: Required. Parent value
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class NetappProjectsLocationsKmsConfigsPatchRequest(_messages.Message):
  r"""A NetappProjectsLocationsKmsConfigsPatchRequest object.

  Fields:
    kmsConfig: A KmsConfig resource to be passed as the request body.
    name: Identifier. Name of the KmsConfig. Format:
      `projects/{project}/locations/{location}/kmsConfigs/{kms_config}`
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the KmsConfig resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
  """

  kmsConfig = _messages.MessageField('KmsConfig', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class NetappProjectsLocationsKmsConfigsVerifyRequest(_messages.Message):
  r"""A NetappProjectsLocationsKmsConfigsVerifyRequest object.

  Fields:
    name: Required. Name of the KMS Config to be verified.
    verifyKmsConfigRequest: A VerifyKmsConfigRequest resource to be passed as
      the request body.
  """

  name = _messages.StringField(1, required=True)
  verifyKmsConfigRequest = _messages.MessageField('VerifyKmsConfigRequest', 2)


class NetappProjectsLocationsListRequest(_messages.Message):
  r"""A NetappProjectsLocationsListRequest object.

  Fields:
    extraLocationTypes: Optional. Do not use this field. It is unsupported and
      is ignored unless explicitly documented otherwise. This is primarily for
      internal usage.
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  extraLocationTypes = _messages.StringField(1, repeated=True)
  filter = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)


class NetappProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A NetappProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class NetappProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A NetappProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class NetappProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A NetappProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class NetappProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A NetappProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    returnPartialSuccess: When set to `true`, operations that are reachable
      are returned as normal, and those that are unreachable are returned in
      the ListOperationsResponse.unreachable field. This can only be `true`
      when reading across collections. For example, when `parent` is set to
      `"projects/example/locations/-"`. This field is not supported by default
      and will result in an `UNIMPLEMENTED` error if set unless explicitly
      documented otherwise in service or product specific documentation.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  returnPartialSuccess = _messages.BooleanField(5)


class NetappProjectsLocationsStoragePoolsCreateRequest(_messages.Message):
  r"""A NetappProjectsLocationsStoragePoolsCreateRequest object.

  Fields:
    parent: Required. Value for parent.
    storagePool: A StoragePool resource to be passed as the request body.
    storagePoolId: Required. Id of the requesting storage pool. Must be unique
      within the parent resource. Must contain only letters, numbers and
      hyphen, with the first character a letter, the last a letter or a
      number, and a 63 character maximum.
  """

  parent = _messages.StringField(1, required=True)
  storagePool = _messages.MessageField('StoragePool', 2)
  storagePoolId = _messages.StringField(3)


class NetappProjectsLocationsStoragePoolsDeleteRequest(_messages.Message):
  r"""A NetappProjectsLocationsStoragePoolsDeleteRequest object.

  Fields:
    name: Required. Name of the storage pool
  """

  name = _messages.StringField(1, required=True)


class NetappProjectsLocationsStoragePoolsGetRequest(_messages.Message):
  r"""A NetappProjectsLocationsStoragePoolsGetRequest object.

  Fields:
    name: Required. Name of the storage pool
  """

  name = _messages.StringField(1, required=True)


class NetappProjectsLocationsStoragePoolsListRequest(_messages.Message):
  r"""A NetappProjectsLocationsStoragePoolsListRequest object.

  Fields:
    filter: Optional. List filter.
    orderBy: Optional. Sort results. Supported values are "name", "name desc"
      or "" (unsorted).
    pageSize: Optional. The maximum number of items to return.
    pageToken: Optional. The next_page_token value to use if there are
      additional results to retrieve for this list request.
    parent: Required. Parent value
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class NetappProjectsLocationsStoragePoolsOntapExecuteOntapDeleteRequest(_messages.Message):
  r"""A NetappProjectsLocationsStoragePoolsOntapExecuteOntapDeleteRequest
  object.

  Fields:
    name: Required. The resource name of the ONTAP resource. Format: `projects
      /{project_number}/locations/{location_id}/storagePools/{storage_pool_id}
      /ontap/{ontap_resource_path}`. For example:
      `projects/123456789/locations/us-central1/storagePools/my-storage-
      pool/ontap/api/my-ontap-resource`.
  """

  name = _messages.StringField(1, required=True)


class NetappProjectsLocationsStoragePoolsOntapExecuteOntapListRequest(_messages.Message):
  r"""A NetappProjectsLocationsStoragePoolsOntapExecuteOntapListRequest
  object.

  Fields:
    name: Required. The resource name of the ONTAP resource. Format: `projects
      /{project_number}/locations/{location_id}/storagePools/{storage_pool_id}
      /ontap/{ontap_resource_path}`. For example:
      `projects/123456789/locations/us-central1/storagePools/my-storage-
      pool/ontap/api/my-ontap-resource`.
  """

  name = _messages.StringField(1, required=True)


class NetappProjectsLocationsStoragePoolsOntapExecuteOntapPatchRequest(_messages.Message):
  r"""A NetappProjectsLocationsStoragePoolsOntapExecuteOntapPatchRequest
  object.

  Fields:
    executeOntapPatchRequest: A ExecuteOntapPatchRequest resource to be passed
      as the request body.
    name: Required. The resource name of the ONTAP resource. Format: `projects
      /{project_number}/locations/{location_id}/storagePools/{storage_pool_id}
      /ontap/{ontap_resource_path}`. For example:
      `projects/123456789/locations/us-central1/storagePools/my-storage-
      pool/ontap/api/my-ontap-resource`.
  """

  executeOntapPatchRequest = _messages.MessageField('ExecuteOntapPatchRequest', 1)
  name = _messages.StringField(2, required=True)


class NetappProjectsLocationsStoragePoolsOntapExecuteOntapPostRequest(_messages.Message):
  r"""A NetappProjectsLocationsStoragePoolsOntapExecuteOntapPostRequest
  object.

  Fields:
    executeOntapPostRequest: A ExecuteOntapPostRequest resource to be passed
      as the request body.
    name: Required. The resource name of the ONTAP resource. Format: `projects
      /{project_number}/locations/{location_id}/storagePools/{storage_pool_id}
      /ontap/{ontap_resource_path}`. For example:
      `projects/123456789/locations/us-central1/storagePools/my-storage-
      pool/ontap/api/my-ontap-resource`.
  """

  executeOntapPostRequest = _messages.MessageField('ExecuteOntapPostRequest', 1)
  name = _messages.StringField(2, required=True)


class NetappProjectsLocationsStoragePoolsPatchRequest(_messages.Message):
  r"""A NetappProjectsLocationsStoragePoolsPatchRequest object.

  Fields:
    name: Identifier. Name of the storage pool
    storagePool: A StoragePool resource to be passed as the request body.
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the StoragePool resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
  """

  name = _messages.StringField(1, required=True)
  storagePool = _messages.MessageField('StoragePool', 2)
  updateMask = _messages.StringField(3)


class NetappProjectsLocationsStoragePoolsSwitchRequest(_messages.Message):
  r"""A NetappProjectsLocationsStoragePoolsSwitchRequest object.

  Fields:
    name: Required. Name of the storage pool
    switchActiveReplicaZoneRequest: A SwitchActiveReplicaZoneRequest resource
      to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  switchActiveReplicaZoneRequest = _messages.MessageField('SwitchActiveReplicaZoneRequest', 2)


class NetappProjectsLocationsStoragePoolsValidateDirectoryServiceRequest(_messages.Message):
  r"""A NetappProjectsLocationsStoragePoolsValidateDirectoryServiceRequest
  object.

  Fields:
    name: Required. Name of the storage pool
    validateDirectoryServiceRequest: A ValidateDirectoryServiceRequest
      resource to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  validateDirectoryServiceRequest = _messages.MessageField('ValidateDirectoryServiceRequest', 2)


class NetappProjectsLocationsVolumesCreateRequest(_messages.Message):
  r"""A NetappProjectsLocationsVolumesCreateRequest object.

  Fields:
    parent: Required. Value for parent.
    volume: A Volume resource to be passed as the request body.
    volumeId: Required. Id of the requesting volume. Must be unique within the
      parent resource. Must contain only letters, numbers and hyphen, with the
      first character a letter, the last a letter or a number, and a 63
      character maximum.
  """

  parent = _messages.StringField(1, required=True)
  volume = _messages.MessageField('Volume', 2)
  volumeId = _messages.StringField(3)


class NetappProjectsLocationsVolumesDeleteRequest(_messages.Message):
  r"""A NetappProjectsLocationsVolumesDeleteRequest object.

  Fields:
    force: If this field is set as true, CCFE will not block the volume
      resource deletion even if it has any snapshots resource. (Otherwise, the
      request will only work if the volume has no snapshots.)
    name: Required. Name of the volume
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class NetappProjectsLocationsVolumesEstablishPeeringRequest(_messages.Message):
  r"""A NetappProjectsLocationsVolumesEstablishPeeringRequest object.

  Fields:
    establishVolumePeeringRequest: A EstablishVolumePeeringRequest resource to
      be passed as the request body.
    name: Required. The volume resource name, in the format
      `projects/{project_id}/locations/{location}/volumes/{volume_id}`
  """

  establishVolumePeeringRequest = _messages.MessageField('EstablishVolumePeeringRequest', 1)
  name = _messages.StringField(2, required=True)


class NetappProjectsLocationsVolumesGetRequest(_messages.Message):
  r"""A NetappProjectsLocationsVolumesGetRequest object.

  Fields:
    name: Required. Name of the volume
  """

  name = _messages.StringField(1, required=True)


class NetappProjectsLocationsVolumesListRequest(_messages.Message):
  r"""A NetappProjectsLocationsVolumesListRequest object.

  Fields:
    filter: Filtering results
    orderBy: Hint for how to order the results
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, the server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. Parent value for ListVolumesRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class NetappProjectsLocationsVolumesPatchRequest(_messages.Message):
  r"""A NetappProjectsLocationsVolumesPatchRequest object.

  Fields:
    name: Identifier. Name of the volume
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the Volume resource by the update. The fields specified
      in the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. If the user does not
      provide a mask then all fields will be overwritten.
    volume: A Volume resource to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  updateMask = _messages.StringField(2)
  volume = _messages.MessageField('Volume', 3)


class NetappProjectsLocationsVolumesQuotaRulesCreateRequest(_messages.Message):
  r"""A NetappProjectsLocationsVolumesQuotaRulesCreateRequest object.

  Fields:
    parent: Required. Parent value for CreateQuotaRuleRequest
    quotaRule: A QuotaRule resource to be passed as the request body.
    quotaRuleId: Required. ID of the quota rule to create. Must be unique
      within the parent resource. Must contain only letters, numbers,
      underscore and hyphen, with the first character a letter or underscore,
      the last a letter or underscore or a number, and a 63 character maximum.
  """

  parent = _messages.StringField(1, required=True)
  quotaRule = _messages.MessageField('QuotaRule', 2)
  quotaRuleId = _messages.StringField(3)


class NetappProjectsLocationsVolumesQuotaRulesDeleteRequest(_messages.Message):
  r"""A NetappProjectsLocationsVolumesQuotaRulesDeleteRequest object.

  Fields:
    name: Required. Name of the quota rule.
  """

  name = _messages.StringField(1, required=True)


class NetappProjectsLocationsVolumesQuotaRulesGetRequest(_messages.Message):
  r"""A NetappProjectsLocationsVolumesQuotaRulesGetRequest object.

  Fields:
    name: Required. Name of the quota rule
  """

  name = _messages.StringField(1, required=True)


class NetappProjectsLocationsVolumesQuotaRulesListRequest(_messages.Message):
  r"""A NetappProjectsLocationsVolumesQuotaRulesListRequest object.

  Fields:
    filter: Optional. Filtering results
    orderBy: Optional. Hint for how to order the results
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, the server will pick an appropriate
      default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListQuotaRulesRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class NetappProjectsLocationsVolumesQuotaRulesPatchRequest(_messages.Message):
  r"""A NetappProjectsLocationsVolumesQuotaRulesPatchRequest object.

  Fields:
    name: Identifier. The resource name of the quota rule. Format: `projects/{
      project_number}/locations/{location_id}/volumes/volumes/{volume_id}/quot
      aRules/{quota_rule_id}`.
    quotaRule: A QuotaRule resource to be passed as the request body.
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the Quota Rule resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
  """

  name = _messages.StringField(1, required=True)
  quotaRule = _messages.MessageField('QuotaRule', 2)
  updateMask = _messages.StringField(3)


class NetappProjectsLocationsVolumesReplicationsCreateRequest(_messages.Message):
  r"""A NetappProjectsLocationsVolumesReplicationsCreateRequest object.

  Fields:
    parent: Required. The NetApp volume to create the replications of, in the
      format `projects/{project_id}/locations/{location}/volumes/{volume_id}`
    replication: A Replication resource to be passed as the request body.
    replicationId: Required. ID of the replication to create. Must be unique
      within the parent resource. Must contain only letters, numbers and
      hyphen, with the first character a letter, the last a letter or a
      number, and a 63 character maximum.
  """

  parent = _messages.StringField(1, required=True)
  replication = _messages.MessageField('Replication', 2)
  replicationId = _messages.StringField(3)


class NetappProjectsLocationsVolumesReplicationsDeleteRequest(_messages.Message):
  r"""A NetappProjectsLocationsVolumesReplicationsDeleteRequest object.

  Fields:
    name: Required. The replication resource name, in the format
      `projects/*/locations/*/volumes/*/replications/{replication_id}`
  """

  name = _messages.StringField(1, required=True)


class NetappProjectsLocationsVolumesReplicationsEstablishPeeringRequest(_messages.Message):
  r"""A NetappProjectsLocationsVolumesReplicationsEstablishPeeringRequest
  object.

  Fields:
    establishPeeringRequest: A EstablishPeeringRequest resource to be passed
      as the request body.
    name: Required. The resource name of the replication, in the format of pro
      jects/{project_id}/locations/{location}/volumes/{volume_id}/replications
      /{replication_id}.
  """

  establishPeeringRequest = _messages.MessageField('EstablishPeeringRequest', 1)
  name = _messages.StringField(2, required=True)


class NetappProjectsLocationsVolumesReplicationsGetRequest(_messages.Message):
  r"""A NetappProjectsLocationsVolumesReplicationsGetRequest object.

  Fields:
    name: Required. The replication resource name, in the format `projects/{pr
      oject_id}/locations/{location}/volumes/{volume_id}/replications/{replica
      tion_id}`
  """

  name = _messages.StringField(1, required=True)


class NetappProjectsLocationsVolumesReplicationsListRequest(_messages.Message):
  r"""A NetappProjectsLocationsVolumesReplicationsListRequest object.

  Fields:
    filter: List filter.
    orderBy: Sort results. Supported values are "name", "name desc" or ""
      (unsorted).
    pageSize: The maximum number of items to return.
    pageToken: The next_page_token value to use if there are additional
      results to retrieve for this list request.
    parent: Required. The volume for which to retrieve replication
      information, in the format
      `projects/{project_id}/locations/{location}/volumes/{volume_id}`.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class NetappProjectsLocationsVolumesReplicationsPatchRequest(_messages.Message):
  r"""A NetappProjectsLocationsVolumesReplicationsPatchRequest object.

  Fields:
    name: Identifier. The resource name of the Replication. Format: `projects/
      {project_id}/locations/{location}/volumes/{volume_id}/replications/{repl
      ication_id}`.
    replication: A Replication resource to be passed as the request body.
    updateMask: Required. Mask of fields to update. At least one path must be
      supplied in this field.
  """

  name = _messages.StringField(1, required=True)
  replication = _messages.MessageField('Replication', 2)
  updateMask = _messages.StringField(3)


class NetappProjectsLocationsVolumesReplicationsResumeRequest(_messages.Message):
  r"""A NetappProjectsLocationsVolumesReplicationsResumeRequest object.

  Fields:
    name: Required. The resource name of the replication, in the format of pro
      jects/{project_id}/locations/{location}/volumes/{volume_id}/replications
      /{replication_id}.
    resumeReplicationRequest: A ResumeReplicationRequest resource to be passed
      as the request body.
  """

  name = _messages.StringField(1, required=True)
  resumeReplicationRequest = _messages.MessageField('ResumeReplicationRequest', 2)


class NetappProjectsLocationsVolumesReplicationsReverseDirectionRequest(_messages.Message):
  r"""A NetappProjectsLocationsVolumesReplicationsReverseDirectionRequest
  object.

  Fields:
    name: Required. The resource name of the replication, in the format of pro
      jects/{project_id}/locations/{location}/volumes/{volume_id}/replications
      /{replication_id}.
    reverseReplicationDirectionRequest: A ReverseReplicationDirectionRequest
      resource to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  reverseReplicationDirectionRequest = _messages.MessageField('ReverseReplicationDirectionRequest', 2)


class NetappProjectsLocationsVolumesReplicationsStopRequest(_messages.Message):
  r"""A NetappProjectsLocationsVolumesReplicationsStopRequest object.

  Fields:
    name: Required. The resource name of the replication, in the format of pro
      jects/{project_id}/locations/{location}/volumes/{volume_id}/replications
      /{replication_id}.
    stopReplicationRequest: A StopReplicationRequest resource to be passed as
      the request body.
  """

  name = _messages.StringField(1, required=True)
  stopReplicationRequest = _messages.MessageField('StopReplicationRequest', 2)


class NetappProjectsLocationsVolumesReplicationsSyncRequest(_messages.Message):
  r"""A NetappProjectsLocationsVolumesReplicationsSyncRequest object.

  Fields:
    name: Required. The resource name of the replication, in the format of pro
      jects/{project_id}/locations/{location}/volumes/{volume_id}/replications
      /{replication_id}.
    syncReplicationRequest: A SyncReplicationRequest resource to be passed as
      the request body.
  """

  name = _messages.StringField(1, required=True)
  syncReplicationRequest = _messages.MessageField('SyncReplicationRequest', 2)


class NetappProjectsLocationsVolumesRestoreRequest(_messages.Message):
  r"""A NetappProjectsLocationsVolumesRestoreRequest object.

  Fields:
    name: Required. The volume resource name, in the format
      `projects/{project_id}/locations/{location}/volumes/{volume_id}`
    restoreBackupFilesRequest: A RestoreBackupFilesRequest resource to be
      passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  restoreBackupFilesRequest = _messages.MessageField('RestoreBackupFilesRequest', 2)


class NetappProjectsLocationsVolumesRevertRequest(_messages.Message):
  r"""A NetappProjectsLocationsVolumesRevertRequest object.

  Fields:
    name: Required. The resource name of the volume, in the format of
      projects/{project_id}/locations/{location}/volumes/{volume_id}.
    revertVolumeRequest: A RevertVolumeRequest resource to be passed as the
      request body.
  """

  name = _messages.StringField(1, required=True)
  revertVolumeRequest = _messages.MessageField('RevertVolumeRequest', 2)


class NetappProjectsLocationsVolumesSnapshotsCreateRequest(_messages.Message):
  r"""A NetappProjectsLocationsVolumesSnapshotsCreateRequest object.

  Fields:
    parent: Required. The NetApp volume to create the snapshots of, in the
      format `projects/{project_id}/locations/{location}/volumes/{volume_id}`
    snapshot: A Snapshot resource to be passed as the request body.
    snapshotId: Required. ID of the snapshot to create. Must be unique within
      the parent resource. Must contain only letters, numbers and hyphen, with
      the first character a letter, the last a letter or a number, and a 63
      character maximum.
  """

  parent = _messages.StringField(1, required=True)
  snapshot = _messages.MessageField('Snapshot', 2)
  snapshotId = _messages.StringField(3)


class NetappProjectsLocationsVolumesSnapshotsDeleteRequest(_messages.Message):
  r"""A NetappProjectsLocationsVolumesSnapshotsDeleteRequest object.

  Fields:
    name: Required. The snapshot resource name, in the format
      `projects/*/locations/*/volumes/*/snapshots/{snapshot_id}`
  """

  name = _messages.StringField(1, required=True)


class NetappProjectsLocationsVolumesSnapshotsGetRequest(_messages.Message):
  r"""A NetappProjectsLocationsVolumesSnapshotsGetRequest object.

  Fields:
    name: Required. The snapshot resource name, in the format `projects/{proje
      ct_id}/locations/{location}/volumes/{volume_id}/snapshots/{snapshot_id}`
  """

  name = _messages.StringField(1, required=True)


class NetappProjectsLocationsVolumesSnapshotsListRequest(_messages.Message):
  r"""A NetappProjectsLocationsVolumesSnapshotsListRequest object.

  Fields:
    filter: List filter.
    orderBy: Sort results. Supported values are "name", "name desc" or ""
      (unsorted).
    pageSize: The maximum number of items to return.
    pageToken: The next_page_token value to use if there are additional
      results to retrieve for this list request.
    parent: Required. The volume for which to retrieve snapshot information,
      in the format
      `projects/{project_id}/locations/{location}/volumes/{volume_id}`.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class NetappProjectsLocationsVolumesSnapshotsPatchRequest(_messages.Message):
  r"""A NetappProjectsLocationsVolumesSnapshotsPatchRequest object.

  Fields:
    name: Identifier. The resource name of the snapshot. Format: `projects/{pr
      oject_id}/locations/{location}/volumes/{volume_id}/snapshots/{snapshot_i
      d}`.
    snapshot: A Snapshot resource to be passed as the request body.
    updateMask: Required. Mask of fields to update. At least one path must be
      supplied in this field.
  """

  name = _messages.StringField(1, required=True)
  snapshot = _messages.MessageField('Snapshot', 2)
  updateMask = _messages.StringField(3)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have been
      canceled successfully have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class QuotaRule(_messages.Message):
  r"""QuotaRule specifies the maximum disk space a user or group can use
  within a volume. They can be used for creating default and individual quota
  rules.

  Enums:
    StateValueValuesEnum: Output only. State of the quota rule
    TypeValueValuesEnum: Required. The type of quota rule.

  Messages:
    LabelsValue: Optional. Labels of the quota rule

  Fields:
    createTime: Output only. Create time of the quota rule
    description: Optional. Description of the quota rule
    diskLimitMib: Required. The maximum allowed disk space in MiB.
    labels: Optional. Labels of the quota rule
    name: Identifier. The resource name of the quota rule. Format: `projects/{
      project_number}/locations/{location_id}/volumes/volumes/{volume_id}/quot
      aRules/{quota_rule_id}`.
    state: Output only. State of the quota rule
    stateDetails: Output only. State details of the quota rule
    target: Optional. The quota rule applies to the specified user or group,
      identified by a Unix UID/GID, Windows SID, or null for default.
    type: Required. The type of quota rule.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the quota rule

    Values:
      STATE_UNSPECIFIED: Unspecified state for quota rule
      CREATING: Quota rule is creating
      UPDATING: Quota rule is updating
      DELETING: Quota rule is deleting
      READY: Quota rule is ready
      ERROR: Quota rule is in error state.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    UPDATING = 2
    DELETING = 3
    READY = 4
    ERROR = 5

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. The type of quota rule.

    Values:
      TYPE_UNSPECIFIED: Unspecified type for quota rule
      INDIVIDUAL_USER_QUOTA: Individual user quota rule
      INDIVIDUAL_GROUP_QUOTA: Individual group quota rule
      DEFAULT_USER_QUOTA: Default user quota rule
      DEFAULT_GROUP_QUOTA: Default group quota rule
    """
    TYPE_UNSPECIFIED = 0
    INDIVIDUAL_USER_QUOTA = 1
    INDIVIDUAL_GROUP_QUOTA = 2
    DEFAULT_USER_QUOTA = 3
    DEFAULT_GROUP_QUOTA = 4

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels of the quota rule

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  diskLimitMib = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  state = _messages.EnumField('StateValueValuesEnum', 6)
  stateDetails = _messages.StringField(7)
  target = _messages.StringField(8)
  type = _messages.EnumField('TypeValueValuesEnum', 9)


class Replication(_messages.Message):
  r"""Replication is a nested resource under Volume, that describes a cross-
  region replication relationship between 2 volumes in different regions.

  Enums:
    HybridReplicationTypeValueValuesEnum: Output only. Type of the hybrid
      replication.
    MirrorStateValueValuesEnum: Output only. Indicates the state of mirroring.
    ReplicationScheduleValueValuesEnum: Required. Indicates the schedule for
      replication.
    RoleValueValuesEnum: Output only. Indicates whether this points to source
      or destination.
    StateValueValuesEnum: Output only. State of the replication.

  Messages:
    LabelsValue: Resource labels to represent user provided metadata.

  Fields:
    clusterLocation: Optional. Location of the user cluster.
    createTime: Output only. Replication create time.
    description: A description about this replication relationship.
    destinationVolume: Output only. Full name of destination volume resource.
      Example : "projects/{project}/locations/{location}/volumes/{volume_id}"
    destinationVolumeParameters: Required. Input only. Destination volume
      parameters
    healthy: Output only. Condition of the relationship. Can be one of the
      following: - true: The replication relationship is healthy. It has not
      missed the most recent scheduled transfer. - false: The replication
      relationship is not healthy. It has missed the most recent scheduled
      transfer.
    hybridPeeringDetails: Output only. Hybrid peering details.
    hybridReplicationType: Output only. Type of the hybrid replication.
    hybridReplicationUserCommands: Output only. Copy pastable snapmirror
      commands to be executed on onprem cluster by the customer.
    labels: Resource labels to represent user provided metadata.
    mirrorState: Output only. Indicates the state of mirroring.
    name: Identifier. The resource name of the Replication. Format: `projects/
      {project_id}/locations/{location}/volumes/{volume_id}/replications/{repl
      ication_id}`.
    replicationSchedule: Required. Indicates the schedule for replication.
    role: Output only. Indicates whether this points to source or destination.
    sourceVolume: Output only. Full name of source volume resource. Example :
      "projects/{project}/locations/{location}/volumes/{volume_id}"
    state: Output only. State of the replication.
    stateDetails: Output only. State details of the replication.
    transferStats: Output only. Replication transfer statistics.
  """

  class HybridReplicationTypeValueValuesEnum(_messages.Enum):
    r"""Output only. Type of the hybrid replication.

    Values:
      HYBRID_REPLICATION_TYPE_UNSPECIFIED: Unspecified hybrid replication
        type.
      MIGRATION: Hybrid replication type for migration.
      CONTINUOUS_REPLICATION: Hybrid replication type for continuous
        replication.
      ONPREM_REPLICATION: New field for reversible OnPrem replication, to be
        used for data protection.
      REVERSE_ONPREM_REPLICATION: Hybrid replication type for incremental
        Transfer in the reverse direction (GCNV is source and Onprem is
        destination)
    """
    HYBRID_REPLICATION_TYPE_UNSPECIFIED = 0
    MIGRATION = 1
    CONTINUOUS_REPLICATION = 2
    ONPREM_REPLICATION = 3
    REVERSE_ONPREM_REPLICATION = 4

  class MirrorStateValueValuesEnum(_messages.Enum):
    r"""Output only. Indicates the state of mirroring.

    Values:
      MIRROR_STATE_UNSPECIFIED: Unspecified MirrorState
      PREPARING: Destination volume is being prepared.
      MIRRORED: Destination volume has been initialized and is ready to
        receive replication transfers.
      STOPPED: Destination volume is not receiving replication transfers.
      TRANSFERRING: Incremental replication is in progress.
      BASELINE_TRANSFERRING: Baseline replication is in progress.
      ABORTED: Replication is aborted.
      EXTERNALLY_MANAGED: Replication is being managed from Onprem ONTAP.
      PENDING_PEERING: Peering is yet to be established.
    """
    MIRROR_STATE_UNSPECIFIED = 0
    PREPARING = 1
    MIRRORED = 2
    STOPPED = 3
    TRANSFERRING = 4
    BASELINE_TRANSFERRING = 5
    ABORTED = 6
    EXTERNALLY_MANAGED = 7
    PENDING_PEERING = 8

  class ReplicationScheduleValueValuesEnum(_messages.Enum):
    r"""Required. Indicates the schedule for replication.

    Values:
      REPLICATION_SCHEDULE_UNSPECIFIED: Unspecified ReplicationSchedule
      EVERY_10_MINUTES: Replication happens once every 10 minutes.
      HOURLY: Replication happens once every hour.
      DAILY: Replication happens once every day.
    """
    REPLICATION_SCHEDULE_UNSPECIFIED = 0
    EVERY_10_MINUTES = 1
    HOURLY = 2
    DAILY = 3

  class RoleValueValuesEnum(_messages.Enum):
    r"""Output only. Indicates whether this points to source or destination.

    Values:
      REPLICATION_ROLE_UNSPECIFIED: Unspecified replication role
      SOURCE: Indicates Source volume.
      DESTINATION: Indicates Destination volume.
    """
    REPLICATION_ROLE_UNSPECIFIED = 0
    SOURCE = 1
    DESTINATION = 2

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the replication.

    Values:
      STATE_UNSPECIFIED: Unspecified replication State
      CREATING: Replication is creating.
      READY: Replication is ready.
      UPDATING: Replication is updating.
      DELETING: Replication is deleting.
      ERROR: Replication is in error state.
      PENDING_CLUSTER_PEERING: Replication is waiting for cluster peering to
        be established.
      PENDING_SVM_PEERING: Replication is waiting for SVM peering to be
        established.
      PENDING_REMOTE_RESYNC: Replication is waiting for Commands to be
        executed on Onprem ONTAP.
      EXTERNALLY_MANAGED_REPLICATION: Onprem ONTAP is destination and
        Replication can only be managed from Onprem.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    READY = 2
    UPDATING = 3
    DELETING = 4
    ERROR = 5
    PENDING_CLUSTER_PEERING = 6
    PENDING_SVM_PEERING = 7
    PENDING_REMOTE_RESYNC = 8
    EXTERNALLY_MANAGED_REPLICATION = 9

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Resource labels to represent user provided metadata.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  clusterLocation = _messages.StringField(1)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  destinationVolume = _messages.StringField(4)
  destinationVolumeParameters = _messages.MessageField('DestinationVolumeParameters', 5)
  healthy = _messages.BooleanField(6)
  hybridPeeringDetails = _messages.MessageField('HybridPeeringDetails', 7)
  hybridReplicationType = _messages.EnumField('HybridReplicationTypeValueValuesEnum', 8)
  hybridReplicationUserCommands = _messages.MessageField('UserCommands', 9)
  labels = _messages.MessageField('LabelsValue', 10)
  mirrorState = _messages.EnumField('MirrorStateValueValuesEnum', 11)
  name = _messages.StringField(12)
  replicationSchedule = _messages.EnumField('ReplicationScheduleValueValuesEnum', 13)
  role = _messages.EnumField('RoleValueValuesEnum', 14)
  sourceVolume = _messages.StringField(15)
  state = _messages.EnumField('StateValueValuesEnum', 16)
  stateDetails = _messages.StringField(17)
  transferStats = _messages.MessageField('TransferStats', 18)


class RestoreBackupFilesRequest(_messages.Message):
  r"""RestoreBackupFilesRequest restores files from a backup to a volume.

  Fields:
    backup: Required. The backup resource name, in the format `projects/{proje
      ct_id}/locations/{location}/backupVaults/{backup_vault_id}/backups/{back
      up_id}`
    fileList: Required. List of files to be restored, specified by their
      absolute path in the source volume.
    restoreDestinationPath: Optional. Absolute directory path in the
      destination volume. This is required if the `file_list` is provided.
  """

  backup = _messages.StringField(1)
  fileList = _messages.StringField(2, repeated=True)
  restoreDestinationPath = _messages.StringField(3)


class RestoreParameters(_messages.Message):
  r"""The RestoreParameters if volume is created from a snapshot or backup.

  Fields:
    sourceBackup: Full name of the backup resource. Format: projects/{project}
      /locations/{location}/backupVaults/{backup_vault_id}/backups/{backup_id}
    sourceSnapshot: Full name of the snapshot resource. Format: projects/{proj
      ect}/locations/{location}/volumes/{volume}/snapshots/{snapshot}
  """

  sourceBackup = _messages.StringField(1)
  sourceSnapshot = _messages.StringField(2)


class ResumeReplicationRequest(_messages.Message):
  r"""ResumeReplicationRequest resumes a stopped replication."""


class ReverseReplicationDirectionRequest(_messages.Message):
  r"""ReverseReplicationDirectionRequest reverses direction of replication.
  Source becomes destination and destination becomes source.
  """



class RevertVolumeRequest(_messages.Message):
  r"""RevertVolumeRequest reverts the given volume to the specified snapshot.

  Fields:
    snapshotId: Required. The snapshot resource ID, in the format 'my-
      snapshot', where the specified ID is the {snapshot_id} of the fully
      qualified name like projects/{project_id}/locations/{location_id}/volume
      s/{volume_id}/snapshots/{snapshot_id}
  """

  snapshotId = _messages.StringField(1)


class SimpleExportPolicyRule(_messages.Message):
  r"""An export policy rule describing various export options.

  Enums:
    AccessTypeValueValuesEnum: Access type (ReadWrite, ReadOnly, None)
    SquashModeValueValuesEnum: Optional. Defines how user identity squashing
      is applied for this export rule. This field is the preferred way to
      configure squashing behavior and takes precedence over `has_root_access`
      if both are provided.

  Fields:
    accessType: Access type (ReadWrite, ReadOnly, None)
    allowedClients: Comma separated list of allowed clients IP addresses
    anonUid: Optional. An integer representing the anonymous user ID. Range is
      0 to `4294967295`. Required when `squash_mode` is `ROOT_SQUASH` or
      `ALL_SQUASH`.
    hasRootAccess: Whether Unix root access will be granted.
    kerberos5ReadOnly: If enabled (true) the rule defines a read only access
      for clients matching the 'allowedClients' specification. It enables nfs
      clients to mount using 'authentication' kerberos security mode.
    kerberos5ReadWrite: If enabled (true) the rule defines read and write
      access for clients matching the 'allowedClients' specification. It
      enables nfs clients to mount using 'authentication' kerberos security
      mode. The 'kerberos5ReadOnly' value be ignored if this is enabled.
    kerberos5iReadOnly: If enabled (true) the rule defines a read only access
      for clients matching the 'allowedClients' specification. It enables nfs
      clients to mount using 'integrity' kerberos security mode.
    kerberos5iReadWrite: If enabled (true) the rule defines read and write
      access for clients matching the 'allowedClients' specification. It
      enables nfs clients to mount using 'integrity' kerberos security mode.
      The 'kerberos5iReadOnly' value be ignored if this is enabled.
    kerberos5pReadOnly: If enabled (true) the rule defines a read only access
      for clients matching the 'allowedClients' specification. It enables nfs
      clients to mount using 'privacy' kerberos security mode.
    kerberos5pReadWrite: If enabled (true) the rule defines read and write
      access for clients matching the 'allowedClients' specification. It
      enables nfs clients to mount using 'privacy' kerberos security mode. The
      'kerberos5pReadOnly' value be ignored if this is enabled.
    nfsv3: NFS V3 protocol.
    nfsv4: NFS V4 protocol.
    squashMode: Optional. Defines how user identity squashing is applied for
      this export rule. This field is the preferred way to configure squashing
      behavior and takes precedence over `has_root_access` if both are
      provided.
  """

  class AccessTypeValueValuesEnum(_messages.Enum):
    r"""Access type (ReadWrite, ReadOnly, None)

    Values:
      ACCESS_TYPE_UNSPECIFIED: Unspecified Access Type
      READ_ONLY: Read Only
      READ_WRITE: Read Write
      READ_NONE: None
    """
    ACCESS_TYPE_UNSPECIFIED = 0
    READ_ONLY = 1
    READ_WRITE = 2
    READ_NONE = 3

  class SquashModeValueValuesEnum(_messages.Enum):
    r"""Optional. Defines how user identity squashing is applied for this
    export rule. This field is the preferred way to configure squashing
    behavior and takes precedence over `has_root_access` if both are provided.

    Values:
      SQUASH_MODE_UNSPECIFIED: Defaults to `NO_ROOT_SQUASH`.
      NO_ROOT_SQUASH: The root user (UID 0) retains full access. Other users
        are unaffected.
      ROOT_SQUASH: The root user (UID 0) is squashed to anonymous user ID.
        Other users are unaffected.
      ALL_SQUASH: All users are squashed to anonymous user ID.
    """
    SQUASH_MODE_UNSPECIFIED = 0
    NO_ROOT_SQUASH = 1
    ROOT_SQUASH = 2
    ALL_SQUASH = 3

  accessType = _messages.EnumField('AccessTypeValueValuesEnum', 1)
  allowedClients = _messages.StringField(2)
  anonUid = _messages.IntegerField(3)
  hasRootAccess = _messages.StringField(4)
  kerberos5ReadOnly = _messages.BooleanField(5)
  kerberos5ReadWrite = _messages.BooleanField(6)
  kerberos5iReadOnly = _messages.BooleanField(7)
  kerberos5iReadWrite = _messages.BooleanField(8)
  kerberos5pReadOnly = _messages.BooleanField(9)
  kerberos5pReadWrite = _messages.BooleanField(10)
  nfsv3 = _messages.BooleanField(11)
  nfsv4 = _messages.BooleanField(12)
  squashMode = _messages.EnumField('SquashModeValueValuesEnum', 13)


class Snapshot(_messages.Message):
  r"""Snapshot is a point-in-time version of a Volume's content.

  Enums:
    StateValueValuesEnum: Output only. The snapshot state.

  Messages:
    LabelsValue: Resource labels to represent user provided metadata.

  Fields:
    createTime: Output only. The time when the snapshot was created.
    description: A description of the snapshot with 2048 characters or less.
      Requests with longer descriptions will be rejected.
    labels: Resource labels to represent user provided metadata.
    name: Identifier. The resource name of the snapshot. Format: `projects/{pr
      oject_id}/locations/{location}/volumes/{volume_id}/snapshots/{snapshot_i
      d}`.
    state: Output only. The snapshot state.
    stateDetails: Output only. State details of the storage pool
    usedBytes: Output only. Current storage usage for the snapshot in bytes.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The snapshot state.

    Values:
      STATE_UNSPECIFIED: Unspecified Snapshot State
      READY: Snapshot State is Ready
      CREATING: Snapshot State is Creating
      DELETING: Snapshot State is Deleting
      UPDATING: Snapshot State is Updating
      DISABLED: Snapshot State is Disabled
      ERROR: Snapshot State is Error
    """
    STATE_UNSPECIFIED = 0
    READY = 1
    CREATING = 2
    DELETING = 3
    UPDATING = 4
    DISABLED = 5
    ERROR = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Resource labels to represent user provided metadata.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  name = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)
  stateDetails = _messages.StringField(6)
  usedBytes = _messages.FloatField(7)


class SnapshotPolicy(_messages.Message):
  r"""Snapshot Policy for a volume.

  Fields:
    dailySchedule: Daily schedule policy.
    enabled: If enabled, make snapshots automatically according to the
      schedules. Default is false.
    hourlySchedule: Hourly schedule policy.
    monthlySchedule: Monthly schedule policy.
    weeklySchedule: Weekly schedule policy.
  """

  dailySchedule = _messages.MessageField('DailySchedule', 1)
  enabled = _messages.BooleanField(2)
  hourlySchedule = _messages.MessageField('HourlySchedule', 3)
  monthlySchedule = _messages.MessageField('MonthlySchedule', 4)
  weeklySchedule = _messages.MessageField('WeeklySchedule', 5)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class StopReplicationRequest(_messages.Message):
  r"""StopReplicationRequest stops a replication until resumed.

  Fields:
    force: Indicates whether to stop replication forcefully while data
      transfer is in progress. Warning! if force is true, this will abort any
      current transfers and can lead to data loss due to partial transfer. If
      force is false, stop replication will fail while data transfer is in
      progress and you will need to retry later.
  """

  force = _messages.BooleanField(1)


class StoragePool(_messages.Message):
  r"""StoragePool is a container for volumes with a service level and
  capacity. Volumes can be created in a pool of sufficient available capacity.
  StoragePool capacity is what you are billed for.

  Enums:
    EncryptionTypeValueValuesEnum: Output only. Specifies the current pool
      encryption key source.
    ModeValueValuesEnum: Optional. Mode of the storage pool. This field is
      used to control whether the user can perform the ONTAP operations on the
      storage pool using the GCNV ONTAP Mode APIs. If not specified during
      creation, it defaults to `DEFAULT`.
    QosTypeValueValuesEnum: Optional. QoS (Quality of Service) Type of the
      storage pool
    ServiceLevelValueValuesEnum: Required. Service level of the storage pool
    StateValueValuesEnum: Output only. State of the storage pool
    TypeValueValuesEnum: Optional. Type of the storage pool. This field is
      used to control whether the pool supports `FILE` based volumes only or
      `UNIFIED` (both `FILE` and `BLOCK`) volumes or `UNIFIED_LARGE_CAPACITY`
      (both `FILE` and `BLOCK`) volumes with large capacity. If not specified
      during creation, it defaults to `FILE`.

  Messages:
    LabelsValue: Optional. Labels as key value pairs

  Fields:
    activeDirectory: Optional. Specifies the Active Directory to be used for
      creating a SMB volume.
    allowAutoTiering: Optional. True if the storage pool supports Auto Tiering
      enabled volumes. Default is false. Auto-tiering can be enabled after
      storage pool creation but it can't be disabled once enabled.
    availableThroughputMibps: Output only. Available throughput of the storage
      pool (in MiB/s).
    capacityGib: Required. Capacity in GIB of the pool
    coldTierSizeUsedGib: Output only. Total cold tier data rounded down to the
      nearest GiB used by the storage pool.
    createTime: Output only. Create time of the storage pool
    customPerformanceEnabled: Optional. True if using Independent Scaling of
      capacity and performance (Hyperdisk) By default set to false
    description: Optional. Description of the storage pool
    enableHotTierAutoResize: Optional. Flag indicating that the hot-tier
      threshold will be auto-increased by 10% of the hot-tier when it hits
      100%. Default is true. The increment will kick in only if the new size
      after increment is still less than or equal to storage pool size.
    encryptionType: Output only. Specifies the current pool encryption key
      source.
    globalAccessAllowed: Deprecated. Used to allow SO pool to access AD or DNS
      server from other regions.
    hotTierSizeGib: Optional. Total hot tier capacity for the Storage Pool. It
      is applicable only to Flex service level. It should be less than the
      minimum storage pool size and cannot be more than the current storage
      pool size. It cannot be decreased once set.
    hotTierSizeUsedGib: Output only. Total hot tier data rounded down to the
      nearest GiB used by the storage pool.
    kmsConfig: Optional. Specifies the KMS config to be used for volume
      encryption.
    labels: Optional. Labels as key value pairs
    ldapEnabled: Optional. Flag indicating if the pool is NFS LDAP enabled or
      not.
    mode: Optional. Mode of the storage pool. This field is used to control
      whether the user can perform the ONTAP operations on the storage pool
      using the GCNV ONTAP Mode APIs. If not specified during creation, it
      defaults to `DEFAULT`.
    name: Identifier. Name of the storage pool
    network: Required. VPC Network name. Format:
      projects/{project}/global/networks/{network}
    psaRange: Optional. This field is not implemented. The values provided in
      this field are ignored.
    qosType: Optional. QoS (Quality of Service) Type of the storage pool
    replicaZone: Optional. Specifies the replica zone for regional
      storagePool.
    satisfiesPzi: Output only. Reserved for future use
    satisfiesPzs: Output only. Reserved for future use
    serviceLevel: Required. Service level of the storage pool
    state: Output only. State of the storage pool
    stateDetails: Output only. State details of the storage pool
    totalIops: Optional. Custom Performance Total IOPS of the pool if not
      provided, it will be calculated based on the total_throughput_mibps
    totalThroughputMibps: Optional. Custom Performance Total Throughput of the
      pool (in MiBps)
    type: Optional. Type of the storage pool. This field is used to control
      whether the pool supports `FILE` based volumes only or `UNIFIED` (both
      `FILE` and `BLOCK`) volumes or `UNIFIED_LARGE_CAPACITY` (both `FILE` and
      `BLOCK`) volumes with large capacity. If not specified during creation,
      it defaults to `FILE`.
    unifiedPool: Optional. Flag indicating if the pool has unified storage.
    volumeCapacityGib: Output only. Allocated size of all volumes in GIB in
      the storage pool
    volumeCount: Output only. Volume count of the storage pool
    zone: Optional. Specifies the active zone for regional storagePool.
  """

  class EncryptionTypeValueValuesEnum(_messages.Enum):
    r"""Output only. Specifies the current pool encryption key source.

    Values:
      ENCRYPTION_TYPE_UNSPECIFIED: The source of the encryption key is not
        specified.
      SERVICE_MANAGED: Google managed encryption key.
      CLOUD_KMS: Customer managed encryption key, which is stored in KMS.
    """
    ENCRYPTION_TYPE_UNSPECIFIED = 0
    SERVICE_MANAGED = 1
    CLOUD_KMS = 2

  class ModeValueValuesEnum(_messages.Enum):
    r"""Optional. Mode of the storage pool. This field is used to control
    whether the user can perform the ONTAP operations on the storage pool
    using the GCNV ONTAP Mode APIs. If not specified during creation, it
    defaults to `DEFAULT`.

    Values:
      MODE_UNSPECIFIED: The `StoragePool` `Mode` is not specified.
      DEFAULT: The `StoragePool` and its resources are managed by the GCNV
        APIs.
      ONTAP: The `StoragePool` and its resources are managed by the GCNV ONTAP
        Mode APIs.
    """
    MODE_UNSPECIFIED = 0
    DEFAULT = 1
    ONTAP = 2

  class QosTypeValueValuesEnum(_messages.Enum):
    r"""Optional. QoS (Quality of Service) Type of the storage pool

    Values:
      QOS_TYPE_UNSPECIFIED: Unspecified QoS Type
      AUTO: QoS Type is Auto
      MANUAL: QoS Type is Manual
    """
    QOS_TYPE_UNSPECIFIED = 0
    AUTO = 1
    MANUAL = 2

  class ServiceLevelValueValuesEnum(_messages.Enum):
    r"""Required. Service level of the storage pool

    Values:
      SERVICE_LEVEL_UNSPECIFIED: Unspecified service level.
      PREMIUM: Premium service level.
      EXTREME: Extreme service level.
      STANDARD: Standard service level.
      FLEX: Flex service level.
    """
    SERVICE_LEVEL_UNSPECIFIED = 0
    PREMIUM = 1
    EXTREME = 2
    STANDARD = 3
    FLEX = 4

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the storage pool

    Values:
      STATE_UNSPECIFIED: Unspecified Storage Pool State
      READY: Storage Pool State is Ready
      CREATING: Storage Pool State is Creating
      DELETING: Storage Pool State is Deleting
      UPDATING: Storage Pool State is Updating
      RESTORING: Storage Pool State is Restoring
      DISABLED: Storage Pool State is Disabled
      ERROR: Storage Pool State is Error
      DEGRADED: Storage Pool State is Degraded The storage pool is
        operational, but with reduced performance.
    """
    STATE_UNSPECIFIED = 0
    READY = 1
    CREATING = 2
    DELETING = 3
    UPDATING = 4
    RESTORING = 5
    DISABLED = 6
    ERROR = 7
    DEGRADED = 8

  class TypeValueValuesEnum(_messages.Enum):
    r"""Optional. Type of the storage pool. This field is used to control
    whether the pool supports `FILE` based volumes only or `UNIFIED` (both
    `FILE` and `BLOCK`) volumes or `UNIFIED_LARGE_CAPACITY` (both `FILE` and
    `BLOCK`) volumes with large capacity. If not specified during creation, it
    defaults to `FILE`.

    Values:
      STORAGE_POOL_TYPE_UNSPECIFIED: Storage pool type is not specified.
      FILE: Storage pool type is file.
      UNIFIED: Storage pool type is unified.
      UNIFIED_LARGE_CAPACITY: Storage pool type is unified large capacity.
    """
    STORAGE_POOL_TYPE_UNSPECIFIED = 0
    FILE = 1
    UNIFIED = 2
    UNIFIED_LARGE_CAPACITY = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  activeDirectory = _messages.StringField(1)
  allowAutoTiering = _messages.BooleanField(2)
  availableThroughputMibps = _messages.FloatField(3)
  capacityGib = _messages.IntegerField(4)
  coldTierSizeUsedGib = _messages.IntegerField(5)
  createTime = _messages.StringField(6)
  customPerformanceEnabled = _messages.BooleanField(7)
  description = _messages.StringField(8)
  enableHotTierAutoResize = _messages.BooleanField(9)
  encryptionType = _messages.EnumField('EncryptionTypeValueValuesEnum', 10)
  globalAccessAllowed = _messages.BooleanField(11)
  hotTierSizeGib = _messages.IntegerField(12)
  hotTierSizeUsedGib = _messages.IntegerField(13)
  kmsConfig = _messages.StringField(14)
  labels = _messages.MessageField('LabelsValue', 15)
  ldapEnabled = _messages.BooleanField(16)
  mode = _messages.EnumField('ModeValueValuesEnum', 17)
  name = _messages.StringField(18)
  network = _messages.StringField(19)
  psaRange = _messages.StringField(20)
  qosType = _messages.EnumField('QosTypeValueValuesEnum', 21)
  replicaZone = _messages.StringField(22)
  satisfiesPzi = _messages.BooleanField(23)
  satisfiesPzs = _messages.BooleanField(24)
  serviceLevel = _messages.EnumField('ServiceLevelValueValuesEnum', 25)
  state = _messages.EnumField('StateValueValuesEnum', 26)
  stateDetails = _messages.StringField(27)
  totalIops = _messages.IntegerField(28)
  totalThroughputMibps = _messages.IntegerField(29)
  type = _messages.EnumField('TypeValueValuesEnum', 30)
  unifiedPool = _messages.BooleanField(31)
  volumeCapacityGib = _messages.IntegerField(32)
  volumeCount = _messages.IntegerField(33, variant=_messages.Variant.INT32)
  zone = _messages.StringField(34)


class SwitchActiveReplicaZoneRequest(_messages.Message):
  r"""SwitchActiveReplicaZoneRequest switch the active/replica zone for a
  regional storagePool.
  """



class SyncReplicationRequest(_messages.Message):
  r"""SyncReplicationRequest syncs the replication from source to destination.
  """



class TieringPolicy(_messages.Message):
  r"""Defines tiering policy for the volume.

  Enums:
    TierActionValueValuesEnum: Optional. Flag indicating if the volume has
      tiering policy enable/pause. Default is PAUSED.

  Fields:
    coolingThresholdDays: Optional. Time in days to mark the volume's data
      block as cold and make it eligible for tiering, can be range from 2-183.
      Default is 31.
    hotTierBypassModeEnabled: Optional. Flag indicating that the hot tier
      bypass mode is enabled. Default is false. This is only applicable to
      Flex service level.
    tierAction: Optional. Flag indicating if the volume has tiering policy
      enable/pause. Default is PAUSED.
  """

  class TierActionValueValuesEnum(_messages.Enum):
    r"""Optional. Flag indicating if the volume has tiering policy
    enable/pause. Default is PAUSED.

    Values:
      TIER_ACTION_UNSPECIFIED: Unspecified.
      ENABLED: When tiering is enabled, new cold data will be tiered.
      PAUSED: When paused, tiering won't be performed on new data. Existing
        data stays tiered until accessed.
    """
    TIER_ACTION_UNSPECIFIED = 0
    ENABLED = 1
    PAUSED = 2

  coolingThresholdDays = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  hotTierBypassModeEnabled = _messages.BooleanField(2)
  tierAction = _messages.EnumField('TierActionValueValuesEnum', 3)


class TransferStats(_messages.Message):
  r"""TransferStats reports all statistics related to replication transfer.

  Fields:
    lagDuration: Lag duration indicates the duration by which Destination
      region volume content lags behind the primary region volume content.
    lastTransferBytes: Last transfer size in bytes.
    lastTransferDuration: Time taken during last transfer.
    lastTransferEndTime: Time when last transfer completed.
    lastTransferError: A message describing the cause of the last transfer
      failure.
    totalTransferDuration: Cumulative time taken across all transfers for the
      replication relationship.
    transferBytes: Cumulative bytes transferred so far for the replication
      relationship.
    updateTime: Time when progress was updated last.
  """

  lagDuration = _messages.StringField(1)
  lastTransferBytes = _messages.IntegerField(2)
  lastTransferDuration = _messages.StringField(3)
  lastTransferEndTime = _messages.StringField(4)
  lastTransferError = _messages.StringField(5)
  totalTransferDuration = _messages.StringField(6)
  transferBytes = _messages.IntegerField(7)
  updateTime = _messages.StringField(8)


class UserCommands(_messages.Message):
  r"""UserCommands contains the commands to be executed by the customer.

  Fields:
    commands: Output only. List of commands to be executed by the customer.
  """

  commands = _messages.StringField(1, repeated=True)


class ValidateDirectoryServiceRequest(_messages.Message):
  r"""ValidateDirectoryServiceRequest validates the directory service policy
  attached to the storage pool.

  Enums:
    DirectoryServiceTypeValueValuesEnum: Type of directory service policy
      attached to the storage pool.

  Fields:
    directoryServiceType: Type of directory service policy attached to the
      storage pool.
  """

  class DirectoryServiceTypeValueValuesEnum(_messages.Enum):
    r"""Type of directory service policy attached to the storage pool.

    Values:
      DIRECTORY_SERVICE_TYPE_UNSPECIFIED: Directory service type is not
        specified.
      ACTIVE_DIRECTORY: Active directory policy attached to the storage pool.
    """
    DIRECTORY_SERVICE_TYPE_UNSPECIFIED = 0
    ACTIVE_DIRECTORY = 1

  directoryServiceType = _messages.EnumField('DirectoryServiceTypeValueValuesEnum', 1)


class VerifyKmsConfigRequest(_messages.Message):
  r"""VerifyKmsConfigRequest specifies the KMS config to be validated."""


class VerifyKmsConfigResponse(_messages.Message):
  r"""VerifyKmsConfigResponse contains the information if the config is
  correctly and error message.

  Fields:
    healthError: Output only. Error message if config is not healthy.
    healthy: Output only. If the customer key configured correctly to the
      encrypt volume.
    instructions: Output only. Instructions for the customers to provide the
      access to the encryption key.
  """

  healthError = _messages.StringField(1)
  healthy = _messages.BooleanField(2)
  instructions = _messages.StringField(3)


class Volume(_messages.Message):
  r"""Volume provides a filesystem that you can mount.

  Enums:
    EncryptionTypeValueValuesEnum: Output only. Specified the current volume
      encryption key source.
    ProtocolsValueListEntryValuesEnum:
    RestrictedActionsValueListEntryValuesEnum:
    SecurityStyleValueValuesEnum: Optional. Security Style of the Volume
    ServiceLevelValueValuesEnum: Output only. Service level of the volume
    SmbSettingsValueListEntryValuesEnum:
    StateValueValuesEnum: Output only. State of the volume

  Messages:
    LabelsValue: Optional. Labels as key value pairs

  Fields:
    activeDirectory: Output only. Specifies the ActiveDirectory name of a SMB
      volume.
    backupConfig: BackupConfig of the volume.
    blockDevices: Optional. Block devices for the volume. Currently, only one
      block device is permitted per Volume.
    blockProperties: Optional. Block properties for the volume.
    cacheParameters: Optional. Cache parameters for the volume.
    capacityGib: Required. Capacity in GIB of the volume
    cloneDetails: Output only. If this volume is a clone, this field contains
      details about the clone.
    coldTierSizeGib: Output only. Size of the volume cold tier data rounded
      down to the nearest GiB.
    createTime: Output only. Create time of the volume
    description: Optional. Description of the volume
    encryptionType: Output only. Specified the current volume encryption key
      source.
    exportPolicy: Optional. Export policy of the volume
    hasReplication: Output only. Indicates whether the volume is part of a
      replication relationship.
    hotTierSizeUsedGib: Output only. Total hot tier data rounded down to the
      nearest GiB used by the Volume. This field is only used for flex Service
      Level
    hybridReplicationParameters: Optional. The Hybrid Replication parameters
      for the volume.
    kerberosEnabled: Optional. Flag indicating if the volume is a kerberos
      volume or not, export policy rules control kerberos security modes
      (krb5, krb5i, krb5p).
    kmsConfig: Output only. Specifies the KMS config to be used for volume
      encryption.
    labels: Optional. Labels as key value pairs
    largeCapacity: Optional. Flag indicating if the volume will be a large
      capacity volume or a regular volume.
    largeCapacityConfig: Optional. Large capacity config for the volume.
    ldapEnabled: Output only. Flag indicating if the volume is NFS LDAP
      enabled or not.
    mountOptions: Output only. Mount options of this volume
    multipleEndpoints: Optional. Flag indicating if the volume will have an IP
      address per node for volumes supporting multiple IP endpoints. Only the
      volume with large_capacity will be allowed to have multiple endpoints.
    name: Identifier. Name of the volume
    network: Output only. VPC Network name. Format:
      projects/{project}/global/networks/{network}
    protocols: Required. Protocols required for the volume
    psaRange: Output only. This field is not implemented. The values provided
      in this field are ignored.
    replicaZone: Output only. Specifies the replica zone for regional volume.
    restoreParameters: Optional. Specifies the source of the volume to be
      created from.
    restrictedActions: Optional. List of actions that are restricted on this
      volume.
    securityStyle: Optional. Security Style of the Volume
    serviceLevel: Output only. Service level of the volume
    shareName: Required. Share name of the volume
    smbSettings: Optional. SMB share settings for the volume.
    snapReserve: Optional. Snap_reserve specifies percentage of volume storage
      reserved for snapshot storage. Default is 0 percent.
    snapshotDirectory: Optional. Snapshot_directory if enabled (true) the
      volume will contain a read-only .snapshot directory which provides
      access to each of the volume's snapshots.
    snapshotPolicy: Optional. SnapshotPolicy for a volume.
    state: Output only. State of the volume
    stateDetails: Output only. State details of the volume
    storagePool: Required. StoragePool name of the volume
    throughputMibps: Optional. Throughput of the volume (in MiB/s)
    tieringPolicy: Tiering policy for the volume.
    unixPermissions: Optional. Default unix style permission (e.g. 777) the
      mount point will be created with. Applicable for NFS protocol types
      only.
    usedGib: Output only. Used capacity in GIB of the volume. This is computed
      periodically and it does not represent the realtime usage.
    zone: Output only. Specifies the active zone for regional volume.
  """

  class EncryptionTypeValueValuesEnum(_messages.Enum):
    r"""Output only. Specified the current volume encryption key source.

    Values:
      ENCRYPTION_TYPE_UNSPECIFIED: The source of the encryption key is not
        specified.
      SERVICE_MANAGED: Google managed encryption key.
      CLOUD_KMS: Customer managed encryption key, which is stored in KMS.
    """
    ENCRYPTION_TYPE_UNSPECIFIED = 0
    SERVICE_MANAGED = 1
    CLOUD_KMS = 2

  class ProtocolsValueListEntryValuesEnum(_messages.Enum):
    r"""ProtocolsValueListEntryValuesEnum enum type.

    Values:
      PROTOCOLS_UNSPECIFIED: Unspecified protocol
      NFSV3: NFS V3 protocol
      NFSV4: NFS V4 protocol
      SMB: SMB protocol
      ISCSI: ISCSI protocol
    """
    PROTOCOLS_UNSPECIFIED = 0
    NFSV3 = 1
    NFSV4 = 2
    SMB = 3
    ISCSI = 4

  class RestrictedActionsValueListEntryValuesEnum(_messages.Enum):
    r"""RestrictedActionsValueListEntryValuesEnum enum type.

    Values:
      RESTRICTED_ACTION_UNSPECIFIED: Unspecified restricted action
      DELETE: Prevent volume from being deleted when mounted.
    """
    RESTRICTED_ACTION_UNSPECIFIED = 0
    DELETE = 1

  class SecurityStyleValueValuesEnum(_messages.Enum):
    r"""Optional. Security Style of the Volume

    Values:
      SECURITY_STYLE_UNSPECIFIED: SecurityStyle is unspecified
      NTFS: SecurityStyle uses NTFS
      UNIX: SecurityStyle uses UNIX
    """
    SECURITY_STYLE_UNSPECIFIED = 0
    NTFS = 1
    UNIX = 2

  class ServiceLevelValueValuesEnum(_messages.Enum):
    r"""Output only. Service level of the volume

    Values:
      SERVICE_LEVEL_UNSPECIFIED: Unspecified service level.
      PREMIUM: Premium service level.
      EXTREME: Extreme service level.
      STANDARD: Standard service level.
      FLEX: Flex service level.
    """
    SERVICE_LEVEL_UNSPECIFIED = 0
    PREMIUM = 1
    EXTREME = 2
    STANDARD = 3
    FLEX = 4

  class SmbSettingsValueListEntryValuesEnum(_messages.Enum):
    r"""SmbSettingsValueListEntryValuesEnum enum type.

    Values:
      SMB_SETTINGS_UNSPECIFIED: Unspecified default option
      ENCRYPT_DATA: SMB setting encrypt data
      BROWSABLE: SMB setting browsable
      CHANGE_NOTIFY: SMB setting notify change
      NON_BROWSABLE: SMB setting not to notify change
      OPLOCKS: SMB setting oplocks
      SHOW_SNAPSHOT: SMB setting to show snapshots
      SHOW_PREVIOUS_VERSIONS: SMB setting to show previous versions
      ACCESS_BASED_ENUMERATION: SMB setting to access volume based on
        enumerartion
      CONTINUOUSLY_AVAILABLE: Continuously available enumeration
    """
    SMB_SETTINGS_UNSPECIFIED = 0
    ENCRYPT_DATA = 1
    BROWSABLE = 2
    CHANGE_NOTIFY = 3
    NON_BROWSABLE = 4
    OPLOCKS = 5
    SHOW_SNAPSHOT = 6
    SHOW_PREVIOUS_VERSIONS = 7
    ACCESS_BASED_ENUMERATION = 8
    CONTINUOUSLY_AVAILABLE = 9

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the volume

    Values:
      STATE_UNSPECIFIED: Unspecified Volume State
      READY: Volume State is Ready
      CREATING: Volume State is Creating
      DELETING: Volume State is Deleting
      UPDATING: Volume State is Updating
      RESTORING: Volume State is Restoring
      DISABLED: Volume State is Disabled
      ERROR: Volume State is Error
      PREPARING: Volume State is Preparing. Note that this is different from
        CREATING where CREATING means the volume is being created, while
        PREPARING means the volume is created and now being prepared for the
        replication.
      READ_ONLY: Volume State is Read Only
    """
    STATE_UNSPECIFIED = 0
    READY = 1
    CREATING = 2
    DELETING = 3
    UPDATING = 4
    RESTORING = 5
    DISABLED = 6
    ERROR = 7
    PREPARING = 8
    READ_ONLY = 9

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  activeDirectory = _messages.StringField(1)
  backupConfig = _messages.MessageField('BackupConfig', 2)
  blockDevices = _messages.MessageField('BlockDevice', 3, repeated=True)
  blockProperties = _messages.MessageField('BlockProperties', 4)
  cacheParameters = _messages.MessageField('CacheParameters', 5)
  capacityGib = _messages.IntegerField(6)
  cloneDetails = _messages.MessageField('CloneDetails', 7)
  coldTierSizeGib = _messages.IntegerField(8)
  createTime = _messages.StringField(9)
  description = _messages.StringField(10)
  encryptionType = _messages.EnumField('EncryptionTypeValueValuesEnum', 11)
  exportPolicy = _messages.MessageField('ExportPolicy', 12)
  hasReplication = _messages.BooleanField(13)
  hotTierSizeUsedGib = _messages.IntegerField(14)
  hybridReplicationParameters = _messages.MessageField('HybridReplicationParameters', 15)
  kerberosEnabled = _messages.BooleanField(16)
  kmsConfig = _messages.StringField(17)
  labels = _messages.MessageField('LabelsValue', 18)
  largeCapacity = _messages.BooleanField(19)
  largeCapacityConfig = _messages.MessageField('LargeCapacityConfig', 20)
  ldapEnabled = _messages.BooleanField(21)
  mountOptions = _messages.MessageField('MountOption', 22, repeated=True)
  multipleEndpoints = _messages.BooleanField(23)
  name = _messages.StringField(24)
  network = _messages.StringField(25)
  protocols = _messages.EnumField('ProtocolsValueListEntryValuesEnum', 26, repeated=True)
  psaRange = _messages.StringField(27)
  replicaZone = _messages.StringField(28)
  restoreParameters = _messages.MessageField('RestoreParameters', 29)
  restrictedActions = _messages.EnumField('RestrictedActionsValueListEntryValuesEnum', 30, repeated=True)
  securityStyle = _messages.EnumField('SecurityStyleValueValuesEnum', 31)
  serviceLevel = _messages.EnumField('ServiceLevelValueValuesEnum', 32)
  shareName = _messages.StringField(33)
  smbSettings = _messages.EnumField('SmbSettingsValueListEntryValuesEnum', 34, repeated=True)
  snapReserve = _messages.FloatField(35)
  snapshotDirectory = _messages.BooleanField(36)
  snapshotPolicy = _messages.MessageField('SnapshotPolicy', 37)
  state = _messages.EnumField('StateValueValuesEnum', 38)
  stateDetails = _messages.StringField(39)
  storagePool = _messages.StringField(40)
  throughputMibps = _messages.FloatField(41)
  tieringPolicy = _messages.MessageField('TieringPolicy', 42)
  unixPermissions = _messages.StringField(43)
  usedGib = _messages.IntegerField(44)
  zone = _messages.StringField(45)


class WeeklySchedule(_messages.Message):
  r"""Make a snapshot every week e.g. at Monday 04:00, Wednesday 05:20, Sunday
  23:50

  Fields:
    day: Set the day or days of the week to make a snapshot. Accepts a comma
      separated days of the week. Defaults to 'Sunday'.
    hour: Set the hour to start the snapshot (0-23), defaults to midnight (0).
    minute: Set the minute of the hour to start the snapshot (0-59), defaults
      to the top of the hour (0).
    snapshotsToKeep: The maximum number of Snapshots to keep for the hourly
      schedule
  """

  day = _messages.StringField(1)
  hour = _messages.FloatField(2)
  minute = _messages.FloatField(3)
  snapshotsToKeep = _messages.FloatField(4)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
