/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui;

import ca.sqlpower.swingui.AbstractNoEditDataEntryPanel;
import ca.sqlpower.swingui.Messages;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Logger;

public class AboutPanel
extends AbstractNoEditDataEntryPanel {
    private static final long MEBIBYTE = 0x100000L;
    private final Logger logger = Logger.getLogger(AboutPanel.class);
    private JTextArea content;
    private static final JLabel sqlpLabel = new JLabel(new ImageIcon(AboutPanel.class.getClassLoader().getResource("ca/sqlpower/swingui/SQLP-90x80.png")));

    public AboutPanel(ImageIcon icon, String productName, String versionPropertiesPath, String defaultAppVersion) {
        JTabbedPane tabs = new JTabbedPane();
        tabs.add(Messages.getString("AboutPanel.aboutTab"), this.initAboutTab(icon, productName, versionPropertiesPath, defaultAppVersion));
        tabs.add(Messages.getString("AboutPanel.systemPropertiesTab"), new JScrollPane(this.initSysPropsTab()));
        tabs.setSelectedIndex(0);
        this.add(tabs);
    }

    private JComponent initAboutTab(ImageIcon icon, String productName, String versionPropertiesPath, String defaultAppVersion) {
        String version;
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        if (icon != null) {
            JPanel logoPanel = new JPanel((LayoutManager)new MigLayout("", "[center]"));
            logoPanel.add((Component)new JLabel(icon), "wrap, gapbottom 50");
            logoPanel.add(sqlpLabel);
            panel.add(logoPanel);
        }
        Properties properties = new Properties();
        try {
            properties.load(AboutPanel.class.getClassLoader().getResourceAsStream(versionPropertiesPath));
            version = properties.get("app.version").toString();
        }
        catch (Exception ex) {
            this.logger.error((Object)"Exception occured while trying to read version properties file. Falling back to default", (Throwable)ex);
            version = defaultAppVersion;
        }
        this.content = new JTextArea();
        this.content.setText(AboutPanel.createEnvironmentSynposis(productName, version));
        this.content.setEditable(false);
        this.content.setOpaque(false);
        panel.add(this.content);
        return panel;
    }

    public static String createEnvironmentSynposis(String productName, String productVersion) {
        String maxMemoryMiB = String.valueOf(Runtime.getRuntime().maxMemory() / 0x100000L);
        String totalMemoryMiB = String.valueOf(Runtime.getRuntime().totalMemory() / 0x100000L);
        String freeMemoryMiB = String.valueOf(Runtime.getRuntime().freeMemory() / 0x100000L);
        String versionInfo = productName + " " + productVersion + "\n" + Messages.getString("AboutPanel.copyright") + "\n" + "\n" + Messages.getString("AboutPanel.operatingSystem") + "\n" + System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")\n" + "\n" + Messages.getString("AboutPanel.runtimeEnvironment") + "\n" + System.getProperty("java.runtime.name") + "\n" + System.getProperty("java.runtime.version") + "\n" + "\n" + Messages.getString("AboutPanel.vmInfo") + "\n" + System.getProperty("java.vm.name") + "\n" + System.getProperty("java.vm.version") + "\n" + System.getProperty("java.vm.vendor") + "\n" + "\n" + Messages.getString("AboutPanel.memory") + "\n" + Messages.getString("AboutPanel.memoryAllocMaxFree", totalMemoryMiB, maxMemoryMiB, freeMemoryMiB);
        return versionInfo;
    }

    private JComponent initSysPropsTab() {
        JTable table = new JTable(new SystemPropertiesTableModel());
        table.getColumnModel().getColumn(0).setMinWidth(200);
        table.getColumnModel().getColumn(1).setMinWidth(2000);
        table.setSize(table.getPreferredSize());
        return table;
    }

    private class SystemPropertiesTableModel
    extends AbstractTableModel {
        private Properties props = System.getProperties();
        private String[] keys = this.props.keySet().toArray(new String[0]);

        SystemPropertiesTableModel() {
            Arrays.sort(this.keys);
        }

        @Override
        public int getRowCount() {
            return this.keys.length;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return this.keys[row];
                }
                case 1: {
                    return this.props.get(this.keys[row]);
                }
            }
            throw new IllegalArgumentException("Column count");
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return Messages.getString("AboutPanel.systemProperty");
                }
                case 1: {
                    return Messages.getString("AboutPanel.systemPropertyValue");
                }
            }
            throw new IllegalArgumentException("Column count");
        }
    }
}

