/*
 * Decompiled with CFR 0.152.
 */
package org.anywikidraw.any.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.anywikidraw.any.io.HtmlForm;

public class HttpRequest {
    private String requestMethod;
    private URL url;
    private HttpURLConnection connection;
    private States state = States.UNSENT;
    private int responseCode = -1;
    private String responseMessage;
    private byte[] responseData;

    public HttpRequest() {
    }

    public HttpRequest(String string, URL uRL) {
        this.open(string, uRL);
    }

    public void open(String string, URL uRL) {
        if (this.state != States.UNSENT) {
            throw new IllegalStateException("State must be UNSENT.");
        }
        this.requestMethod = string;
        this.url = uRL;
        try {
            this.connection = (HttpURLConnection)uRL.openConnection();
            this.connection.setDoOutput(true);
            this.connection.setDoInput(true);
            this.state = States.OPENED;
        }
        catch (IOException iOException) {
            this.state = States.DONE;
            this.responseCode = -1;
            this.responseMessage = iOException.toString();
            try {
                this.responseData = this.responseMessage.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new InternalError("UTF-8 not supported");
            }
        }
    }

    public void setRequestProperty(String string, String string2) {
        if (this.state != States.OPENED) {
            throw new IllegalStateException("State must be UNSENT.");
        }
        this.connection.setRequestProperty(string, string2);
    }

    public void send(HtmlForm htmlForm) {
        if (this.state != States.OPENED) {
            throw new IllegalStateException("State must be OPENED");
        }
        String string = HtmlForm.createBoundary();
        this.connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + string);
        try {
            OutputStream outputStream = this.connection.getOutputStream();
            htmlForm.writeForm(outputStream, string);
            outputStream.close();
            this.state = States.SENT;
        }
        catch (IOException iOException) {
            this.disconnect();
            this.state = States.DONE;
            this.responseMessage = iOException.toString();
            try {
                this.responseData = this.responseMessage.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new InternalError("UTF-8 not supported");
            }
        }
    }

    private void disconnect() {
        if (this.connection != null) {
            this.connection.disconnect();
            this.connection = null;
        }
        this.state = States.DONE;
    }

    private void read() {
        if (this.state == States.SENT) {
            try {
                this.responseCode = this.connection.getResponseCode();
                this.responseMessage = this.connection.getResponseMessage();
            }
            catch (IOException iOException) {
                this.responseMessage = iOException.toString();
                try {
                    this.responseData = this.responseMessage.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new InternalError("UTF-8 not supported");
                }
                this.disconnect();
                return;
            }
            InputStream inputStream = null;
            try {
                inputStream = this.connection.getInputStream();
            }
            catch (IOException iOException) {
                inputStream = this.connection.getErrorStream();
            }
            try {
                if (inputStream != null) {
                    byte[] byArray = new byte[512];
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    int n = 0;
                    while (n != -1) {
                        byteArrayOutputStream.write(byArray, 0, n);
                        n = inputStream.read(byArray);
                    }
                    this.responseData = byteArrayOutputStream.toByteArray();
                }
            }
            catch (IOException iOException) {
                this.responseMessage = iOException.toString();
                try {
                    this.responseData = this.responseMessage.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new InternalError("UTF-8 not supported");
                }
                this.disconnect();
                return;
            }
        }
        this.disconnect();
    }

    public int getResponseCode() {
        this.read();
        return this.responseCode;
    }

    public String getResponseMessage() {
        this.read();
        return this.responseMessage;
    }

    public String getResponseDataAsString() {
        this.read();
        try {
            return this.responseData == null ? null : new String(this.responseData, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError("UTF-8 not supported");
        }
    }

    public static enum States {
        UNSENT,
        OPENED,
        SENT,
        HEADERS_RECEIVED,
        LOADING,
        DONE;

    }
}

