// Licensed under the Apache License, Version 2.0
// <LICENSE-APACHE or http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your option.
// All files in the project carrying such notice may not be copied, modified, or distributed
// except according to those terms.
//! Constant definitions for the NTSTATUS values.
use shared::ntdef::NTSTATUS;
pub const STATUS_WAIT_0: NTSTATUS = 0x00000000;
pub const FACILITY_VSM: NTSTATUS = 0x45;
pub const FACILITY_VOLSNAP: NTSTATUS = 0x50;
pub const FACILITY_VOLMGR: NTSTATUS = 0x38;
pub const FACILITY_VIRTUALIZATION: NTSTATUS = 0x37;
pub const FACILITY_VIDEO: NTSTATUS = 0x1B;
pub const FACILITY_USB_ERROR_CODE: NTSTATUS = 0x10;
pub const FACILITY_TRANSACTION: NTSTATUS = 0x19;
pub const FACILITY_TPM: NTSTATUS = 0x29;
pub const FACILITY_TERMINAL_SERVER: NTSTATUS = 0xA;
pub const FACILITY_SXS_ERROR_CODE: NTSTATUS = 0x15;
pub const FACILITY_NTSSPI: NTSTATUS = 0x9;
pub const FACILITY_SPACES: NTSTATUS = 0xE7;
pub const FACILITY_SMB: NTSTATUS = 0x5D;
pub const FACILITY_SYSTEM_INTEGRITY: NTSTATUS = 0xE9;
pub const FACILITY_SHARED_VHDX: NTSTATUS = 0x5C;
pub const FACILITY_SECUREBOOT: NTSTATUS = 0x43;
pub const FACILITY_SECURITY_CORE: NTSTATUS = 0xE8;
pub const FACILITY_SDBUS: NTSTATUS = 0x51;
pub const FACILITY_RTPM: NTSTATUS = 0x2A;
pub const FACILITY_RPC_STUBS: NTSTATUS = 0x3;
pub const FACILITY_RPC_RUNTIME: NTSTATUS = 0x2;
pub const FACILITY_RESUME_KEY_FILTER: NTSTATUS = 0x40;
pub const FACILITY_RDBSS: NTSTATUS = 0x41;
pub const FACILITY_PLATFORM_MANIFEST: NTSTATUS = 0xEB;
pub const FACILITY_NTWIN32: NTSTATUS = 0x7;
pub const FACILITY_WIN32K_NTUSER: NTSTATUS = 0x3E;
pub const FACILITY_WIN32K_NTGDI: NTSTATUS = 0x3F;
pub const FACILITY_NDIS_ERROR_CODE: NTSTATUS = 0x23;
pub const FACILTIY_MUI_ERROR_CODE: NTSTATUS = 0xB;
pub const FACILITY_MONITOR: NTSTATUS = 0x1D;
pub const FACILITY_MAXIMUM_VALUE: NTSTATUS = 0xEC;
pub const FACILITY_LICENSING: NTSTATUS = 0xEA;
pub const FACILITY_IPSEC: NTSTATUS = 0x36;
pub const FACILITY_IO_ERROR_CODE: NTSTATUS = 0x4;
pub const FACILITY_INTERIX: NTSTATUS = 0x99;
pub const FACILITY_HYPERVISOR: NTSTATUS = 0x35;
pub const FACILITY_HID_ERROR_CODE: NTSTATUS = 0x11;
pub const FACILITY_GRAPHICS_KERNEL: NTSTATUS = 0x1E;
pub const FACILITY_FWP_ERROR_CODE: NTSTATUS = 0x22;
pub const FACILITY_FVE_ERROR_CODE: NTSTATUS = 0x21;
pub const FACILITY_FIREWIRE_ERROR_CODE: NTSTATUS = 0x12;
pub const FACILITY_FILTER_MANAGER: NTSTATUS = 0x1C;
pub const FACILITY_DRIVER_FRAMEWORK: NTSTATUS = 0x20;
pub const FACILITY_DEBUGGER: NTSTATUS = 0x1;
pub const FACILITY_COMMONLOG: NTSTATUS = 0x1A;
pub const FACILITY_CODCLASS_ERROR_CODE: NTSTATUS = 0x6;
pub const FACILITY_CLUSTER_ERROR_CODE: NTSTATUS = 0x13;
pub const FACILITY_NTCERT: NTSTATUS = 0x8;
pub const FACILITY_BTH_ATT: NTSTATUS = 0x42;
pub const FACILITY_BCD_ERROR_CODE: NTSTATUS = 0x39;
pub const FACILITY_AUDIO_KERNEL: NTSTATUS = 0x44;
pub const FACILITY_ACPI_ERROR_CODE: NTSTATUS = 0x14;
pub const STATUS_SEVERITY_WARNING: NTSTATUS = 0x2;
pub const STATUS_SEVERITY_SUCCESS: NTSTATUS = 0x0;
pub const STATUS_SEVERITY_INFORMATIONAL: NTSTATUS = 0x1;
pub const STATUS_SEVERITY_ERROR: NTSTATUS = 0x3;
pub const STATUS_SUCCESS: NTSTATUS = 0x00000000;
pub const STATUS_WAIT_1: NTSTATUS = 0x00000001;
pub const STATUS_WAIT_2: NTSTATUS = 0x00000002;
pub const STATUS_WAIT_3: NTSTATUS = 0x00000003;
pub const STATUS_WAIT_63: NTSTATUS = 0x0000003F;
pub const STATUS_ABANDONED: NTSTATUS = 0x00000080;
pub const STATUS_ABANDONED_WAIT_0: NTSTATUS = 0x00000080;
pub const STATUS_ABANDONED_WAIT_63: NTSTATUS = 0x000000BF;
pub const STATUS_USER_APC: NTSTATUS = 0x000000C0;
pub const STATUS_ALREADY_COMPLETE: NTSTATUS = 0x000000FF;
pub const STATUS_KERNEL_APC: NTSTATUS = 0x00000100;
pub const STATUS_ALERTED: NTSTATUS = 0x00000101;
pub const STATUS_TIMEOUT: NTSTATUS = 0x00000102;
pub const STATUS_PENDING: NTSTATUS = 0x00000103;
pub const STATUS_REPARSE: NTSTATUS = 0x00000104;
pub const STATUS_MORE_ENTRIES: NTSTATUS = 0x00000105;
pub const STATUS_NOT_ALL_ASSIGNED: NTSTATUS = 0x00000106;
pub const STATUS_SOME_NOT_MAPPED: NTSTATUS = 0x00000107;
pub const STATUS_OPLOCK_BREAK_IN_PROGRESS: NTSTATUS = 0x00000108;
pub const STATUS_VOLUME_MOUNTED: NTSTATUS = 0x00000109;
pub const STATUS_RXACT_COMMITTED: NTSTATUS = 0x0000010A;
pub const STATUS_NOTIFY_CLEANUP: NTSTATUS = 0x0000010B;
pub const STATUS_NOTIFY_ENUM_DIR: NTSTATUS = 0x0000010C;
pub const STATUS_NO_QUOTAS_FOR_ACCOUNT: NTSTATUS = 0x0000010D;
pub const STATUS_PRIMARY_TRANSPORT_CONNECT_FAILED: NTSTATUS = 0x0000010E;
pub const STATUS_PAGE_FAULT_TRANSITION: NTSTATUS = 0x00000110;
pub const STATUS_PAGE_FAULT_DEMAND_ZERO: NTSTATUS = 0x00000111;
pub const STATUS_PAGE_FAULT_COPY_ON_WRITE: NTSTATUS = 0x00000112;
pub const STATUS_PAGE_FAULT_GUARD_PAGE: NTSTATUS = 0x00000113;
pub const STATUS_PAGE_FAULT_PAGING_FILE: NTSTATUS = 0x00000114;
pub const STATUS_CACHE_PAGE_LOCKED: NTSTATUS = 0x00000115;
pub const STATUS_CRASH_DUMP: NTSTATUS = 0x00000116;
pub const STATUS_BUFFER_ALL_ZEROS: NTSTATUS = 0x00000117;
pub const STATUS_REPARSE_OBJECT: NTSTATUS = 0x00000118;
pub const STATUS_RESOURCE_REQUIREMENTS_CHANGED: NTSTATUS = 0x00000119;
pub const STATUS_TRANSLATION_COMPLETE: NTSTATUS = 0x00000120;
pub const STATUS_DS_MEMBERSHIP_EVALUATED_LOCALLY: NTSTATUS = 0x00000121;
pub const STATUS_NOTHING_TO_TERMINATE: NTSTATUS = 0x00000122;
pub const STATUS_PROCESS_NOT_IN_JOB: NTSTATUS = 0x00000123;
pub const STATUS_PROCESS_IN_JOB: NTSTATUS = 0x00000124;
pub const STATUS_VOLSNAP_HIBERNATE_READY: NTSTATUS = 0x00000125;
pub const STATUS_FSFILTER_OP_COMPLETED_SUCCESSFULLY: NTSTATUS = 0x00000126;
pub const STATUS_INTERRUPT_VECTOR_ALREADY_CONNECTED: NTSTATUS = 0x00000127;
pub const STATUS_INTERRUPT_STILL_CONNECTED: NTSTATUS = 0x00000128;
pub const STATUS_PROCESS_CLONED: NTSTATUS = 0x00000129;
pub const STATUS_FILE_LOCKED_WITH_ONLY_READERS: NTSTATUS = 0x0000012A;
pub const STATUS_FILE_LOCKED_WITH_WRITERS: NTSTATUS = 0x0000012B;
pub const STATUS_VALID_IMAGE_HASH: NTSTATUS = 0x0000012C;
pub const STATUS_VALID_CATALOG_HASH: NTSTATUS = 0x0000012D;
pub const STATUS_VALID_STRONG_CODE_HASH: NTSTATUS = 0x0000012E;
pub const STATUS_GHOSTED: NTSTATUS = 0x0000012F;
pub const STATUS_RESOURCEMANAGER_READ_ONLY: NTSTATUS = 0x00000202;
pub const STATUS_RING_PREVIOUSLY_EMPTY: NTSTATUS = 0x00000210;
pub const STATUS_RING_PREVIOUSLY_FULL: NTSTATUS = 0x00000211;
pub const STATUS_RING_PREVIOUSLY_ABOVE_QUOTA: NTSTATUS = 0x00000212;
pub const STATUS_RING_NEWLY_EMPTY: NTSTATUS = 0x00000213;
pub const STATUS_RING_SIGNAL_OPPOSITE_ENDPOINT: NTSTATUS = 0x00000214;
pub const STATUS_OPLOCK_SWITCHED_TO_NEW_HANDLE: NTSTATUS = 0x00000215;
pub const STATUS_OPLOCK_HANDLE_CLOSED: NTSTATUS = 0x00000216;
pub const STATUS_WAIT_FOR_OPLOCK: NTSTATUS = 0x00000367;
pub const STATUS_REPARSE_GLOBAL: NTSTATUS = 0x00000368;
pub const DBG_EXCEPTION_HANDLED: NTSTATUS = 0x00010001;
pub const DBG_CONTINUE: NTSTATUS = 0x00010002;
pub const STATUS_FLT_IO_COMPLETE: NTSTATUS = 0x001C0001;
pub const STATUS_OBJECT_NAME_EXISTS: NTSTATUS = 0x40000000;
pub const STATUS_THREAD_WAS_SUSPENDED: NTSTATUS = 0x40000001;
pub const STATUS_WORKING_SET_LIMIT_RANGE: NTSTATUS = 0x40000002;
pub const STATUS_IMAGE_NOT_AT_BASE: NTSTATUS = 0x40000003;
pub const STATUS_RXACT_STATE_CREATED: NTSTATUS = 0x40000004;
pub const STATUS_SEGMENT_NOTIFICATION: NTSTATUS = 0x40000005;
pub const STATUS_LOCAL_USER_SESSION_KEY: NTSTATUS = 0x40000006;
pub const STATUS_BAD_CURRENT_DIRECTORY: NTSTATUS = 0x40000007;
pub const STATUS_SERIAL_MORE_WRITES: NTSTATUS = 0x40000008;
pub const STATUS_REGISTRY_RECOVERED: NTSTATUS = 0x40000009;
pub const STATUS_FT_READ_RECOVERY_FROM_BACKUP: NTSTATUS = 0x4000000A;
pub const STATUS_FT_WRITE_RECOVERY: NTSTATUS = 0x4000000B;
pub const STATUS_SERIAL_COUNTER_TIMEOUT: NTSTATUS = 0x4000000C;
pub const STATUS_NULL_LM_PASSWORD: NTSTATUS = 0x4000000D;
pub const STATUS_IMAGE_MACHINE_TYPE_MISMATCH: NTSTATUS = 0x4000000E;
pub const STATUS_RECEIVE_PARTIAL: NTSTATUS = 0x4000000F;
pub const STATUS_RECEIVE_EXPEDITED: NTSTATUS = 0x40000010;
pub const STATUS_RECEIVE_PARTIAL_EXPEDITED: NTSTATUS = 0x40000011;
pub const STATUS_EVENT_DONE: NTSTATUS = 0x40000012;
pub const STATUS_EVENT_PENDING: NTSTATUS = 0x40000013;
pub const STATUS_CHECKING_FILE_SYSTEM: NTSTATUS = 0x40000014;
pub const STATUS_FATAL_APP_EXIT: NTSTATUS = 0x40000015;
pub const STATUS_PREDEFINED_HANDLE: NTSTATUS = 0x40000016;
pub const STATUS_WAS_UNLOCKED: NTSTATUS = 0x40000017;
pub const STATUS_SERVICE_NOTIFICATION: NTSTATUS = 0x40000018;
pub const STATUS_WAS_LOCKED: NTSTATUS = 0x40000019;
pub const STATUS_LOG_HARD_ERROR: NTSTATUS = 0x4000001A;
pub const STATUS_ALREADY_WIN32: NTSTATUS = 0x4000001B;
pub const STATUS_WX86_UNSIMULATE: NTSTATUS = 0x4000001C;
pub const STATUS_WX86_CONTINUE: NTSTATUS = 0x4000001D;
pub const STATUS_WX86_SINGLE_STEP: NTSTATUS = 0x4000001E;
pub const STATUS_WX86_BREAKPOINT: NTSTATUS = 0x4000001F;
pub const STATUS_WX86_EXCEPTION_CONTINUE: NTSTATUS = 0x40000020;
pub const STATUS_WX86_EXCEPTION_LASTCHANCE: NTSTATUS = 0x40000021;
pub const STATUS_WX86_EXCEPTION_CHAIN: NTSTATUS = 0x40000022;
pub const STATUS_IMAGE_MACHINE_TYPE_MISMATCH_EXE: NTSTATUS = 0x40000023;
pub const STATUS_NO_YIELD_PERFORMED: NTSTATUS = 0x40000024;
pub const STATUS_TIMER_RESUME_IGNORED: NTSTATUS = 0x40000025;
pub const STATUS_ARBITRATION_UNHANDLED: NTSTATUS = 0x40000026;
pub const STATUS_CARDBUS_NOT_SUPPORTED: NTSTATUS = 0x40000027;
pub const STATUS_WX86_CREATEWX86TIB: NTSTATUS = 0x40000028;
pub const STATUS_MP_PROCESSOR_MISMATCH: NTSTATUS = 0x40000029;
pub const STATUS_HIBERNATED: NTSTATUS = 0x4000002A;
pub const STATUS_RESUME_HIBERNATION: NTSTATUS = 0x4000002B;
pub const STATUS_FIRMWARE_UPDATED: NTSTATUS = 0x4000002C;
pub const STATUS_DRIVERS_LEAKING_LOCKED_PAGES: NTSTATUS = 0x4000002D;
pub const STATUS_MESSAGE_RETRIEVED: NTSTATUS = 0x4000002E;
pub const STATUS_SYSTEM_POWERSTATE_TRANSITION: NTSTATUS = 0x4000002F;
pub const STATUS_ALPC_CHECK_COMPLETION_LIST: NTSTATUS = 0x40000030;
pub const STATUS_SYSTEM_POWERSTATE_COMPLEX_TRANSITION: NTSTATUS = 0x40000031;
pub const STATUS_ACCESS_AUDIT_BY_POLICY: NTSTATUS = 0x40000032;
pub const STATUS_ABANDON_HIBERFILE: NTSTATUS = 0x40000033;
pub const STATUS_BIZRULES_NOT_ENABLED: NTSTATUS = 0x40000034;
pub const STATUS_FT_READ_FROM_COPY: NTSTATUS = 0x40000035;
pub const STATUS_IMAGE_AT_DIFFERENT_BASE: NTSTATUS = 0x40000036;
pub const DBG_REPLY_LATER: NTSTATUS = 0x40010001;
pub const DBG_UNABLE_TO_PROVIDE_HANDLE: NTSTATUS = 0x40010002;
pub const DBG_TERMINATE_THREAD: NTSTATUS = 0x40010003;
pub const DBG_TERMINATE_PROCESS: NTSTATUS = 0x40010004;
pub const DBG_CONTROL_C: NTSTATUS = 0x40010005;
pub const DBG_PRINTEXCEPTION_C: NTSTATUS = 0x40010006;
pub const DBG_RIPEXCEPTION: NTSTATUS = 0x40010007;
pub const DBG_CONTROL_BREAK: NTSTATUS = 0x40010008;
pub const DBG_COMMAND_EXCEPTION: NTSTATUS = 0x40010009;
pub const DBG_PRINTEXCEPTION_WIDE_C: NTSTATUS = 0x4001000A;
pub const STATUS_HEURISTIC_DAMAGE_POSSIBLE: NTSTATUS = 0x40190001;
pub const STATUS_GUARD_PAGE_VIOLATION: NTSTATUS = 0x80000001;
pub const STATUS_DATATYPE_MISALIGNMENT: NTSTATUS = 0x80000002;
pub const STATUS_BREAKPOINT: NTSTATUS = 0x80000003;
pub const STATUS_SINGLE_STEP: NTSTATUS = 0x80000004;
pub const STATUS_BUFFER_OVERFLOW: NTSTATUS = 0x80000005;
pub const STATUS_NO_MORE_FILES: NTSTATUS = 0x80000006;
pub const STATUS_WAKE_SYSTEM_DEBUGGER: NTSTATUS = 0x80000007;
pub const STATUS_HANDLES_CLOSED: NTSTATUS = 0x8000000A;
pub const STATUS_NO_INHERITANCE: NTSTATUS = 0x8000000B;
pub const STATUS_GUID_SUBSTITUTION_MADE: NTSTATUS = 0x8000000C;
pub const STATUS_PARTIAL_COPY: NTSTATUS = 0x8000000D;
pub const STATUS_DEVICE_PAPER_EMPTY: NTSTATUS = 0x8000000E;
pub const STATUS_DEVICE_POWERED_OFF: NTSTATUS = 0x8000000F;
pub const STATUS_DEVICE_OFF_LINE: NTSTATUS = 0x80000010;
pub const STATUS_DEVICE_BUSY: NTSTATUS = 0x80000011;
pub const STATUS_NO_MORE_EAS: NTSTATUS = 0x80000012;
pub const STATUS_INVALID_EA_NAME: NTSTATUS = 0x80000013;
pub const STATUS_EA_LIST_INCONSISTENT: NTSTATUS = 0x80000014;
pub const STATUS_INVALID_EA_FLAG: NTSTATUS = 0x80000015;
pub const STATUS_VERIFY_REQUIRED: NTSTATUS = 0x80000016;
pub const STATUS_EXTRANEOUS_INFORMATION: NTSTATUS = 0x80000017;
pub const STATUS_RXACT_COMMIT_NECESSARY: NTSTATUS = 0x80000018;
pub const STATUS_NO_MORE_ENTRIES: NTSTATUS = 0x8000001A;
pub const STATUS_FILEMARK_DETECTED: NTSTATUS = 0x8000001B;
pub const STATUS_MEDIA_CHANGED: NTSTATUS = 0x8000001C;
pub const STATUS_BUS_RESET: NTSTATUS = 0x8000001D;
pub const STATUS_END_OF_MEDIA: NTSTATUS = 0x8000001E;
pub const STATUS_BEGINNING_OF_MEDIA: NTSTATUS = 0x8000001F;
pub const STATUS_MEDIA_CHECK: NTSTATUS = 0x80000020;
pub const STATUS_SETMARK_DETECTED: NTSTATUS = 0x80000021;
pub const STATUS_NO_DATA_DETECTED: NTSTATUS = 0x80000022;
pub const STATUS_REDIRECTOR_HAS_OPEN_HANDLES: NTSTATUS = 0x80000023;
pub const STATUS_SERVER_HAS_OPEN_HANDLES: NTSTATUS = 0x80000024;
pub const STATUS_ALREADY_DISCONNECTED: NTSTATUS = 0x80000025;
pub const STATUS_LONGJUMP: NTSTATUS = 0x80000026;
pub const STATUS_CLEANER_CARTRIDGE_INSTALLED: NTSTATUS = 0x80000027;
pub const STATUS_PLUGPLAY_QUERY_VETOED: NTSTATUS = 0x80000028;
pub const STATUS_UNWIND_CONSOLIDATE: NTSTATUS = 0x80000029;
pub const STATUS_REGISTRY_HIVE_RECOVERED: NTSTATUS = 0x8000002A;
pub const STATUS_DLL_MIGHT_BE_INSECURE: NTSTATUS = 0x8000002B;
pub const STATUS_DLL_MIGHT_BE_INCOMPATIBLE: NTSTATUS = 0x8000002C;
pub const STATUS_STOPPED_ON_SYMLINK: NTSTATUS = 0x8000002D;
pub const STATUS_CANNOT_GRANT_REQUESTED_OPLOCK: NTSTATUS = 0x8000002E;
pub const STATUS_NO_ACE_CONDITION: NTSTATUS = 0x8000002F;
pub const STATUS_DEVICE_SUPPORT_IN_PROGRESS: NTSTATUS = 0x80000030;
pub const STATUS_DEVICE_POWER_CYCLE_REQUIRED: NTSTATUS = 0x80000031;
pub const STATUS_NO_WORK_DONE: NTSTATUS = 0x80000032;
pub const DBG_EXCEPTION_NOT_HANDLED: NTSTATUS = 0x80010001;
pub const STATUS_CLUSTER_NODE_ALREADY_UP: NTSTATUS = 0x80130001;
pub const STATUS_CLUSTER_NODE_ALREADY_DOWN: NTSTATUS = 0x80130002;
pub const STATUS_CLUSTER_NETWORK_ALREADY_ONLINE: NTSTATUS = 0x80130003;
pub const STATUS_CLUSTER_NETWORK_ALREADY_OFFLINE: NTSTATUS = 0x80130004;
pub const STATUS_CLUSTER_NODE_ALREADY_MEMBER: NTSTATUS = 0x80130005;
pub const STATUS_FLT_BUFFER_TOO_SMALL: NTSTATUS = 0x801C0001;
pub const STATUS_FVE_PARTIAL_METADATA: NTSTATUS = 0x80210001;
pub const STATUS_FVE_TRANSIENT_STATE: NTSTATUS = 0x80210002;
pub const STATUS_CLOUD_FILE_PROPERTY_BLOB_CHECKSUM_MISMATCH: NTSTATUS = 0x8000CF00;
pub const STATUS_UNSUCCESSFUL: NTSTATUS = 0xC0000001;
pub const STATUS_NOT_IMPLEMENTED: NTSTATUS = 0xC0000002;
pub const STATUS_INVALID_INFO_CLASS: NTSTATUS = 0xC0000003;
pub const STATUS_INFO_LENGTH_MISMATCH: NTSTATUS = 0xC0000004;
pub const STATUS_ACCESS_VIOLATION: NTSTATUS = 0xC0000005;
pub const STATUS_IN_PAGE_ERROR: NTSTATUS = 0xC0000006;
pub const STATUS_PAGEFILE_QUOTA: NTSTATUS = 0xC0000007;
pub const STATUS_INVALID_HANDLE: NTSTATUS = 0xC0000008;
pub const STATUS_BAD_INITIAL_STACK: NTSTATUS = 0xC0000009;
pub const STATUS_BAD_INITIAL_PC: NTSTATUS = 0xC000000A;
pub const STATUS_INVALID_CID: NTSTATUS = 0xC000000B;
pub const STATUS_TIMER_NOT_CANCELED: NTSTATUS = 0xC000000C;
pub const STATUS_INVALID_PARAMETER: NTSTATUS = 0xC000000D;
pub const STATUS_NO_SUCH_DEVICE: NTSTATUS = 0xC000000E;
pub const STATUS_NO_SUCH_FILE: NTSTATUS = 0xC000000F;
pub const STATUS_INVALID_DEVICE_REQUEST: NTSTATUS = 0xC0000010;
pub const STATUS_END_OF_FILE: NTSTATUS = 0xC0000011;
pub const STATUS_WRONG_VOLUME: NTSTATUS = 0xC0000012;
pub const STATUS_NO_MEDIA_IN_DEVICE: NTSTATUS = 0xC0000013;
pub const STATUS_UNRECOGNIZED_MEDIA: NTSTATUS = 0xC0000014;
pub const STATUS_NONEXISTENT_SECTOR: NTSTATUS = 0xC0000015;
pub const STATUS_MORE_PROCESSING_REQUIRED: NTSTATUS = 0xC0000016;
pub const STATUS_NO_MEMORY: NTSTATUS = 0xC0000017;
pub const STATUS_CONFLICTING_ADDRESSES: NTSTATUS = 0xC0000018;
pub const STATUS_NOT_MAPPED_VIEW: NTSTATUS = 0xC0000019;
pub const STATUS_UNABLE_TO_FREE_VM: NTSTATUS = 0xC000001A;
pub const STATUS_UNABLE_TO_DELETE_SECTION: NTSTATUS = 0xC000001B;
pub const STATUS_INVALID_SYSTEM_SERVICE: NTSTATUS = 0xC000001C;
pub const STATUS_ILLEGAL_INSTRUCTION: NTSTATUS = 0xC000001D;
pub const STATUS_INVALID_LOCK_SEQUENCE: NTSTATUS = 0xC000001E;
pub const STATUS_INVALID_VIEW_SIZE: NTSTATUS = 0xC000001F;
pub const STATUS_INVALID_FILE_FOR_SECTION: NTSTATUS = 0xC0000020;
pub const STATUS_ALREADY_COMMITTED: NTSTATUS = 0xC0000021;
pub const STATUS_ACCESS_DENIED: NTSTATUS = 0xC0000022;
pub const STATUS_BUFFER_TOO_SMALL: NTSTATUS = 0xC0000023;
pub const STATUS_OBJECT_TYPE_MISMATCH: NTSTATUS = 0xC0000024;
pub const STATUS_NONCONTINUABLE_EXCEPTION: NTSTATUS = 0xC0000025;
pub const STATUS_INVALID_DISPOSITION: NTSTATUS = 0xC0000026;
pub const STATUS_UNWIND: NTSTATUS = 0xC0000027;
pub const STATUS_BAD_STACK: NTSTATUS = 0xC0000028;
pub const STATUS_INVALID_UNWIND_TARGET: NTSTATUS = 0xC0000029;
pub const STATUS_NOT_LOCKED: NTSTATUS = 0xC000002A;
pub const STATUS_PARITY_ERROR: NTSTATUS = 0xC000002B;
pub const STATUS_UNABLE_TO_DECOMMIT_VM: NTSTATUS = 0xC000002C;
pub const STATUS_NOT_COMMITTED: NTSTATUS = 0xC000002D;
pub const STATUS_INVALID_PORT_ATTRIBUTES: NTSTATUS = 0xC000002E;
pub const STATUS_PORT_MESSAGE_TOO_LONG: NTSTATUS = 0xC000002F;
pub const STATUS_INVALID_PARAMETER_MIX: NTSTATUS = 0xC0000030;
pub const STATUS_INVALID_QUOTA_LOWER: NTSTATUS = 0xC0000031;
pub const STATUS_DISK_CORRUPT_ERROR: NTSTATUS = 0xC0000032;
pub const STATUS_OBJECT_NAME_INVALID: NTSTATUS = 0xC0000033;
pub const STATUS_OBJECT_NAME_NOT_FOUND: NTSTATUS = 0xC0000034;
pub const STATUS_OBJECT_NAME_COLLISION: NTSTATUS = 0xC0000035;
pub const STATUS_PORT_DO_NOT_DISTURB: NTSTATUS = 0xC0000036;
pub const STATUS_PORT_DISCONNECTED: NTSTATUS = 0xC0000037;
pub const STATUS_DEVICE_ALREADY_ATTACHED: NTSTATUS = 0xC0000038;
pub const STATUS_OBJECT_PATH_INVALID: NTSTATUS = 0xC0000039;
pub const STATUS_OBJECT_PATH_NOT_FOUND: NTSTATUS = 0xC000003A;
pub const STATUS_OBJECT_PATH_SYNTAX_BAD: NTSTATUS = 0xC000003B;
pub const STATUS_DATA_OVERRUN: NTSTATUS = 0xC000003C;
pub const STATUS_DATA_LATE_ERROR: NTSTATUS = 0xC000003D;
pub const STATUS_DATA_ERROR: NTSTATUS = 0xC000003E;
pub const STATUS_CRC_ERROR: NTSTATUS = 0xC000003F;
pub const STATUS_SECTION_TOO_BIG: NTSTATUS = 0xC0000040;
pub const STATUS_PORT_CONNECTION_REFUSED: NTSTATUS = 0xC0000041;
pub const STATUS_INVALID_PORT_HANDLE: NTSTATUS = 0xC0000042;
pub const STATUS_SHARING_VIOLATION: NTSTATUS = 0xC0000043;
pub const STATUS_QUOTA_EXCEEDED: NTSTATUS = 0xC0000044;
pub const STATUS_INVALID_PAGE_PROTECTION: NTSTATUS = 0xC0000045;
pub const STATUS_MUTANT_NOT_OWNED: NTSTATUS = 0xC0000046;
pub const STATUS_SEMAPHORE_LIMIT_EXCEEDED: NTSTATUS = 0xC0000047;
pub const STATUS_PORT_ALREADY_SET: NTSTATUS = 0xC0000048;
pub const STATUS_SECTION_NOT_IMAGE: NTSTATUS = 0xC0000049;
pub const STATUS_SUSPEND_COUNT_EXCEEDED: NTSTATUS = 0xC000004A;
pub const STATUS_THREAD_IS_TERMINATING: NTSTATUS = 0xC000004B;
pub const STATUS_BAD_WORKING_SET_LIMIT: NTSTATUS = 0xC000004C;
pub const STATUS_INCOMPATIBLE_FILE_MAP: NTSTATUS = 0xC000004D;
pub const STATUS_SECTION_PROTECTION: NTSTATUS = 0xC000004E;
pub const STATUS_EAS_NOT_SUPPORTED: NTSTATUS = 0xC000004F;
pub const STATUS_EA_TOO_LARGE: NTSTATUS = 0xC0000050;
pub const STATUS_NONEXISTENT_EA_ENTRY: NTSTATUS = 0xC0000051;
pub const STATUS_NO_EAS_ON_FILE: NTSTATUS = 0xC0000052;
pub const STATUS_EA_CORRUPT_ERROR: NTSTATUS = 0xC0000053;
pub const STATUS_FILE_LOCK_CONFLICT: NTSTATUS = 0xC0000054;
pub const STATUS_LOCK_NOT_GRANTED: NTSTATUS = 0xC0000055;
pub const STATUS_DELETE_PENDING: NTSTATUS = 0xC0000056;
pub const STATUS_CTL_FILE_NOT_SUPPORTED: NTSTATUS = 0xC0000057;
pub const STATUS_UNKNOWN_REVISION: NTSTATUS = 0xC0000058;
pub const STATUS_REVISION_MISMATCH: NTSTATUS = 0xC0000059;
pub const STATUS_INVALID_OWNER: NTSTATUS = 0xC000005A;
pub const STATUS_INVALID_PRIMARY_GROUP: NTSTATUS = 0xC000005B;
pub const STATUS_NO_IMPERSONATION_TOKEN: NTSTATUS = 0xC000005C;
pub const STATUS_CANT_DISABLE_MANDATORY: NTSTATUS = 0xC000005D;
pub const STATUS_NO_LOGON_SERVERS: NTSTATUS = 0xC000005E;
pub const STATUS_NO_SUCH_LOGON_SESSION: NTSTATUS = 0xC000005F;
pub const STATUS_NO_SUCH_PRIVILEGE: NTSTATUS = 0xC0000060;
pub const STATUS_PRIVILEGE_NOT_HELD: NTSTATUS = 0xC0000061;
pub const STATUS_INVALID_ACCOUNT_NAME: NTSTATUS = 0xC0000062;
pub const STATUS_USER_EXISTS: NTSTATUS = 0xC0000063;
pub const STATUS_NO_SUCH_USER: NTSTATUS = 0xC0000064;
pub const STATUS_GROUP_EXISTS: NTSTATUS = 0xC0000065;
pub const STATUS_NO_SUCH_GROUP: NTSTATUS = 0xC0000066;
pub const STATUS_MEMBER_IN_GROUP: NTSTATUS = 0xC0000067;
pub const STATUS_MEMBER_NOT_IN_GROUP: NTSTATUS = 0xC0000068;
pub const STATUS_LAST_ADMIN: NTSTATUS = 0xC0000069;
pub const STATUS_WRONG_PASSWORD: NTSTATUS = 0xC000006A;
pub const STATUS_ILL_FORMED_PASSWORD: NTSTATUS = 0xC000006B;
pub const STATUS_PASSWORD_RESTRICTION: NTSTATUS = 0xC000006C;
pub const STATUS_LOGON_FAILURE: NTSTATUS = 0xC000006D;
pub const STATUS_ACCOUNT_RESTRICTION: NTSTATUS = 0xC000006E;
pub const STATUS_INVALID_LOGON_HOURS: NTSTATUS = 0xC000006F;
pub const STATUS_INVALID_WORKSTATION: NTSTATUS = 0xC0000070;
pub const STATUS_PASSWORD_EXPIRED: NTSTATUS = 0xC0000071;
pub const STATUS_ACCOUNT_DISABLED: NTSTATUS = 0xC0000072;
pub const STATUS_NONE_MAPPED: NTSTATUS = 0xC0000073;
pub const STATUS_TOO_MANY_LUIDS_REQUESTED: NTSTATUS = 0xC0000074;
pub const STATUS_LUIDS_EXHAUSTED: NTSTATUS = 0xC0000075;
pub const STATUS_INVALID_SUB_AUTHORITY: NTSTATUS = 0xC0000076;
pub const STATUS_INVALID_ACL: NTSTATUS = 0xC0000077;
pub const STATUS_INVALID_SID: NTSTATUS = 0xC0000078;
pub const STATUS_INVALID_SECURITY_DESCR: NTSTATUS = 0xC0000079;
pub const STATUS_PROCEDURE_NOT_FOUND: NTSTATUS = 0xC000007A;
pub const STATUS_INVALID_IMAGE_FORMAT: NTSTATUS = 0xC000007B;
pub const STATUS_NO_TOKEN: NTSTATUS = 0xC000007C;
pub const STATUS_BAD_INHERITANCE_ACL: NTSTATUS = 0xC000007D;
pub const STATUS_RANGE_NOT_LOCKED: NTSTATUS = 0xC000007E;
pub const STATUS_DISK_FULL: NTSTATUS = 0xC000007F;
pub const STATUS_SERVER_DISABLED: NTSTATUS = 0xC0000080;
pub const STATUS_SERVER_NOT_DISABLED: NTSTATUS = 0xC0000081;
pub const STATUS_TOO_MANY_GUIDS_REQUESTED: NTSTATUS = 0xC0000082;
pub const STATUS_GUIDS_EXHAUSTED: NTSTATUS = 0xC0000083;
pub const STATUS_INVALID_ID_AUTHORITY: NTSTATUS = 0xC0000084;
pub const STATUS_AGENTS_EXHAUSTED: NTSTATUS = 0xC0000085;
pub const STATUS_INVALID_VOLUME_LABEL: NTSTATUS = 0xC0000086;
pub const STATUS_SECTION_NOT_EXTENDED: NTSTATUS = 0xC0000087;
pub const STATUS_NOT_MAPPED_DATA: NTSTATUS = 0xC0000088;
pub const STATUS_RESOURCE_DATA_NOT_FOUND: NTSTATUS = 0xC0000089;
pub const STATUS_RESOURCE_TYPE_NOT_FOUND: NTSTATUS = 0xC000008A;
pub const STATUS_RESOURCE_NAME_NOT_FOUND: NTSTATUS = 0xC000008B;
pub const STATUS_ARRAY_BOUNDS_EXCEEDED: NTSTATUS = 0xC000008C;
pub const STATUS_FLOAT_DENORMAL_OPERAND: NTSTATUS = 0xC000008D;
pub const STATUS_FLOAT_DIVIDE_BY_ZERO: NTSTATUS = 0xC000008E;
pub const STATUS_FLOAT_INEXACT_RESULT: NTSTATUS = 0xC000008F;
pub const STATUS_FLOAT_INVALID_OPERATION: NTSTATUS = 0xC0000090;
pub const STATUS_FLOAT_OVERFLOW: NTSTATUS = 0xC0000091;
pub const STATUS_FLOAT_STACK_CHECK: NTSTATUS = 0xC0000092;
pub const STATUS_FLOAT_UNDERFLOW: NTSTATUS = 0xC0000093;
pub const STATUS_INTEGER_DIVIDE_BY_ZERO: NTSTATUS = 0xC0000094;
pub const STATUS_INTEGER_OVERFLOW: NTSTATUS = 0xC0000095;
pub const STATUS_PRIVILEGED_INSTRUCTION: NTSTATUS = 0xC0000096;
pub const STATUS_TOO_MANY_PAGING_FILES: NTSTATUS = 0xC0000097;
pub const STATUS_FILE_INVALID: NTSTATUS = 0xC0000098;
pub const STATUS_ALLOTTED_SPACE_EXCEEDED: NTSTATUS = 0xC0000099;
pub const STATUS_INSUFFICIENT_RESOURCES: NTSTATUS = 0xC000009A;
pub const STATUS_DFS_EXIT_PATH_FOUND: NTSTATUS = 0xC000009B;
pub const STATUS_DEVICE_DATA_ERROR: NTSTATUS = 0xC000009C;
pub const STATUS_DEVICE_NOT_CONNECTED: NTSTATUS = 0xC000009D;
pub const STATUS_DEVICE_POWER_FAILURE: NTSTATUS = 0xC000009E;
pub const STATUS_FREE_VM_NOT_AT_BASE: NTSTATUS = 0xC000009F;
pub const STATUS_MEMORY_NOT_ALLOCATED: NTSTATUS = 0xC00000A0;
pub const STATUS_WORKING_SET_QUOTA: NTSTATUS = 0xC00000A1;
pub const STATUS_MEDIA_WRITE_PROTECTED: NTSTATUS = 0xC00000A2;
pub const STATUS_DEVICE_NOT_READY: NTSTATUS = 0xC00000A3;
pub const STATUS_INVALID_GROUP_ATTRIBUTES: NTSTATUS = 0xC00000A4;
pub const STATUS_BAD_IMPERSONATION_LEVEL: NTSTATUS = 0xC00000A5;
pub const STATUS_CANT_OPEN_ANONYMOUS: NTSTATUS = 0xC00000A6;
pub const STATUS_BAD_VALIDATION_CLASS: NTSTATUS = 0xC00000A7;
pub const STATUS_BAD_TOKEN_TYPE: NTSTATUS = 0xC00000A8;
pub const STATUS_BAD_MASTER_BOOT_RECORD: NTSTATUS = 0xC00000A9;
pub const STATUS_INSTRUCTION_MISALIGNMENT: NTSTATUS = 0xC00000AA;
pub const STATUS_INSTANCE_NOT_AVAILABLE: NTSTATUS = 0xC00000AB;
pub const STATUS_PIPE_NOT_AVAILABLE: NTSTATUS = 0xC00000AC;
pub const STATUS_INVALID_PIPE_STATE: NTSTATUS = 0xC00000AD;
pub const STATUS_PIPE_BUSY: NTSTATUS = 0xC00000AE;
pub const STATUS_ILLEGAL_FUNCTION: NTSTATUS = 0xC00000AF;
pub const STATUS_PIPE_DISCONNECTED: NTSTATUS = 0xC00000B0;
pub const STATUS_PIPE_CLOSING: NTSTATUS = 0xC00000B1;
pub const STATUS_PIPE_CONNECTED: NTSTATUS = 0xC00000B2;
pub const STATUS_PIPE_LISTENING: NTSTATUS = 0xC00000B3;
pub const STATUS_INVALID_READ_MODE: NTSTATUS = 0xC00000B4;
pub const STATUS_IO_TIMEOUT: NTSTATUS = 0xC00000B5;
pub const STATUS_FILE_FORCED_CLOSED: NTSTATUS = 0xC00000B6;
pub const STATUS_PROFILING_NOT_STARTED: NTSTATUS = 0xC00000B7;
pub const STATUS_PROFILING_NOT_STOPPED: NTSTATUS = 0xC00000B8;
pub const STATUS_COULD_NOT_INTERPRET: NTSTATUS = 0xC00000B9;
pub const STATUS_FILE_IS_A_DIRECTORY: NTSTATUS = 0xC00000BA;
pub const STATUS_NOT_SUPPORTED: NTSTATUS = 0xC00000BB;
pub const STATUS_REMOTE_NOT_LISTENING: NTSTATUS = 0xC00000BC;
pub const STATUS_DUPLICATE_NAME: NTSTATUS = 0xC00000BD;
pub const STATUS_BAD_NETWORK_PATH: NTSTATUS = 0xC00000BE;
pub const STATUS_NETWORK_BUSY: NTSTATUS = 0xC00000BF;
pub const STATUS_DEVICE_DOES_NOT_EXIST: NTSTATUS = 0xC00000C0;
pub const STATUS_TOO_MANY_COMMANDS: NTSTATUS = 0xC00000C1;
pub const STATUS_ADAPTER_HARDWARE_ERROR: NTSTATUS = 0xC00000C2;
pub const STATUS_INVALID_NETWORK_RESPONSE: NTSTATUS = 0xC00000C3;
pub const STATUS_UNEXPECTED_NETWORK_ERROR: NTSTATUS = 0xC00000C4;
pub const STATUS_BAD_REMOTE_ADAPTER: NTSTATUS = 0xC00000C5;
pub const STATUS_PRINT_QUEUE_FULL: NTSTATUS = 0xC00000C6;
pub const STATUS_NO_SPOOL_SPACE: NTSTATUS = 0xC00000C7;
pub const STATUS_PRINT_CANCELLED: NTSTATUS = 0xC00000C8;
pub const STATUS_NETWORK_NAME_DELETED: NTSTATUS = 0xC00000C9;
pub const STATUS_NETWORK_ACCESS_DENIED: NTSTATUS = 0xC00000CA;
pub const STATUS_BAD_DEVICE_TYPE: NTSTATUS = 0xC00000CB;
pub const STATUS_BAD_NETWORK_NAME: NTSTATUS = 0xC00000CC;
pub const STATUS_TOO_MANY_NAMES: NTSTATUS = 0xC00000CD;
pub const STATUS_TOO_MANY_SESSIONS: NTSTATUS = 0xC00000CE;
pub const STATUS_SHARING_PAUSED: NTSTATUS = 0xC00000CF;
pub const STATUS_REQUEST_NOT_ACCEPTED: NTSTATUS = 0xC00000D0;
pub const STATUS_REDIRECTOR_PAUSED: NTSTATUS = 0xC00000D1;
pub const STATUS_NET_WRITE_FAULT: NTSTATUS = 0xC00000D2;
pub const STATUS_PROFILING_AT_LIMIT: NTSTATUS = 0xC00000D3;
pub const STATUS_NOT_SAME_DEVICE: NTSTATUS = 0xC00000D4;
pub const STATUS_FILE_RENAMED: NTSTATUS = 0xC00000D5;
pub const STATUS_VIRTUAL_CIRCUIT_CLOSED: NTSTATUS = 0xC00000D6;
pub const STATUS_NO_SECURITY_ON_OBJECT: NTSTATUS = 0xC00000D7;
pub const STATUS_CANT_WAIT: NTSTATUS = 0xC00000D8;
pub const STATUS_PIPE_EMPTY: NTSTATUS = 0xC00000D9;
pub const STATUS_CANT_ACCESS_DOMAIN_INFO: NTSTATUS = 0xC00000DA;
pub const STATUS_CANT_TERMINATE_SELF: NTSTATUS = 0xC00000DB;
pub const STATUS_INVALID_SERVER_STATE: NTSTATUS = 0xC00000DC;
pub const STATUS_INVALID_DOMAIN_STATE: NTSTATUS = 0xC00000DD;
pub const STATUS_INVALID_DOMAIN_ROLE: NTSTATUS = 0xC00000DE;
pub const STATUS_NO_SUCH_DOMAIN: NTSTATUS = 0xC00000DF;
pub const STATUS_DOMAIN_EXISTS: NTSTATUS = 0xC00000E0;
pub const STATUS_DOMAIN_LIMIT_EXCEEDED: NTSTATUS = 0xC00000E1;
pub const STATUS_OPLOCK_NOT_GRANTED: NTSTATUS = 0xC00000E2;
pub const STATUS_INVALID_OPLOCK_PROTOCOL: NTSTATUS = 0xC00000E3;
pub const STATUS_INTERNAL_DB_CORRUPTION: NTSTATUS = 0xC00000E4;
pub const STATUS_INTERNAL_ERROR: NTSTATUS = 0xC00000E5;
pub const STATUS_GENERIC_NOT_MAPPED: NTSTATUS = 0xC00000E6;
pub const STATUS_BAD_DESCRIPTOR_FORMAT: NTSTATUS = 0xC00000E7;
pub const STATUS_INVALID_USER_BUFFER: NTSTATUS = 0xC00000E8;
pub const STATUS_UNEXPECTED_IO_ERROR: NTSTATUS = 0xC00000E9;
pub const STATUS_UNEXPECTED_MM_CREATE_ERR: NTSTATUS = 0xC00000EA;
pub const STATUS_UNEXPECTED_MM_MAP_ERROR: NTSTATUS = 0xC00000EB;
pub const STATUS_UNEXPECTED_MM_EXTEND_ERR: NTSTATUS = 0xC00000EC;
pub const STATUS_NOT_LOGON_PROCESS: NTSTATUS = 0xC00000ED;
pub const STATUS_LOGON_SESSION_EXISTS: NTSTATUS = 0xC00000EE;
pub const STATUS_INVALID_PARAMETER_1: NTSTATUS = 0xC00000EF;
pub const STATUS_INVALID_PARAMETER_2: NTSTATUS = 0xC00000F0;
pub const STATUS_INVALID_PARAMETER_3: NTSTATUS = 0xC00000F1;
pub const STATUS_INVALID_PARAMETER_4: NTSTATUS = 0xC00000F2;
pub const STATUS_INVALID_PARAMETER_5: NTSTATUS = 0xC00000F3;
pub const STATUS_INVALID_PARAMETER_6: NTSTATUS = 0xC00000F4;
pub const STATUS_INVALID_PARAMETER_7: NTSTATUS = 0xC00000F5;
pub const STATUS_INVALID_PARAMETER_8: NTSTATUS = 0xC00000F6;
pub const STATUS_INVALID_PARAMETER_9: NTSTATUS = 0xC00000F7;
pub const STATUS_INVALID_PARAMETER_10: NTSTATUS = 0xC00000F8;
pub const STATUS_INVALID_PARAMETER_11: NTSTATUS = 0xC00000F9;
pub const STATUS_INVALID_PARAMETER_12: NTSTATUS = 0xC00000FA;
pub const STATUS_REDIRECTOR_NOT_STARTED: NTSTATUS = 0xC00000FB;
pub const STATUS_REDIRECTOR_STARTED: NTSTATUS = 0xC00000FC;
pub const STATUS_STACK_OVERFLOW: NTSTATUS = 0xC00000FD;
pub const STATUS_NO_SUCH_PACKAGE: NTSTATUS = 0xC00000FE;
pub const STATUS_BAD_FUNCTION_TABLE: NTSTATUS = 0xC00000FF;
pub const STATUS_VARIABLE_NOT_FOUND: NTSTATUS = 0xC0000100;
pub const STATUS_DIRECTORY_NOT_EMPTY: NTSTATUS = 0xC0000101;
pub const STATUS_FILE_CORRUPT_ERROR: NTSTATUS = 0xC0000102;
pub const STATUS_NOT_A_DIRECTORY: NTSTATUS = 0xC0000103;
pub const STATUS_BAD_LOGON_SESSION_STATE: NTSTATUS = 0xC0000104;
pub const STATUS_LOGON_SESSION_COLLISION: NTSTATUS = 0xC0000105;
pub const STATUS_NAME_TOO_LONG: NTSTATUS = 0xC0000106;
pub const STATUS_FILES_OPEN: NTSTATUS = 0xC0000107;
pub const STATUS_CONNECTION_IN_USE: NTSTATUS = 0xC0000108;
pub const STATUS_MESSAGE_NOT_FOUND: NTSTATUS = 0xC0000109;
pub const STATUS_PROCESS_IS_TERMINATING: NTSTATUS = 0xC000010A;
pub const STATUS_INVALID_LOGON_TYPE: NTSTATUS = 0xC000010B;
pub const STATUS_NO_GUID_TRANSLATION: NTSTATUS = 0xC000010C;
pub const STATUS_CANNOT_IMPERSONATE: NTSTATUS = 0xC000010D;
pub const STATUS_IMAGE_ALREADY_LOADED: NTSTATUS = 0xC000010E;
pub const STATUS_ABIOS_NOT_PRESENT: NTSTATUS = 0xC000010F;
pub const STATUS_ABIOS_LID_NOT_EXIST: NTSTATUS = 0xC0000110;
pub const STATUS_ABIOS_LID_ALREADY_OWNED: NTSTATUS = 0xC0000111;
pub const STATUS_ABIOS_NOT_LID_OWNER: NTSTATUS = 0xC0000112;
pub const STATUS_ABIOS_INVALID_COMMAND: NTSTATUS = 0xC0000113;
pub const STATUS_ABIOS_INVALID_LID: NTSTATUS = 0xC0000114;
pub const STATUS_ABIOS_SELECTOR_NOT_AVAILABLE: NTSTATUS = 0xC0000115;
pub const STATUS_ABIOS_INVALID_SELECTOR: NTSTATUS = 0xC0000116;
pub const STATUS_NO_LDT: NTSTATUS = 0xC0000117;
pub const STATUS_INVALID_LDT_SIZE: NTSTATUS = 0xC0000118;
pub const STATUS_INVALID_LDT_OFFSET: NTSTATUS = 0xC0000119;
pub const STATUS_INVALID_LDT_DESCRIPTOR: NTSTATUS = 0xC000011A;
pub const STATUS_INVALID_IMAGE_NE_FORMAT: NTSTATUS = 0xC000011B;
pub const STATUS_RXACT_INVALID_STATE: NTSTATUS = 0xC000011C;
pub const STATUS_RXACT_COMMIT_FAILURE: NTSTATUS = 0xC000011D;
pub const STATUS_MAPPED_FILE_SIZE_ZERO: NTSTATUS = 0xC000011E;
pub const STATUS_TOO_MANY_OPENED_FILES: NTSTATUS = 0xC000011F;
pub const STATUS_CANCELLED: NTSTATUS = 0xC0000120;
pub const STATUS_CANNOT_DELETE: NTSTATUS = 0xC0000121;
pub const STATUS_INVALID_COMPUTER_NAME: NTSTATUS = 0xC0000122;
pub const STATUS_FILE_DELETED: NTSTATUS = 0xC0000123;
pub const STATUS_SPECIAL_ACCOUNT: NTSTATUS = 0xC0000124;
pub const STATUS_SPECIAL_GROUP: NTSTATUS = 0xC0000125;
pub const STATUS_SPECIAL_USER: NTSTATUS = 0xC0000126;
pub const STATUS_MEMBERS_PRIMARY_GROUP: NTSTATUS = 0xC0000127;
pub const STATUS_FILE_CLOSED: NTSTATUS = 0xC0000128;
pub const STATUS_TOO_MANY_THREADS: NTSTATUS = 0xC0000129;
pub const STATUS_THREAD_NOT_IN_PROCESS: NTSTATUS = 0xC000012A;
pub const STATUS_TOKEN_ALREADY_IN_USE: NTSTATUS = 0xC000012B;
pub const STATUS_PAGEFILE_QUOTA_EXCEEDED: NTSTATUS = 0xC000012C;
pub const STATUS_COMMITMENT_LIMIT: NTSTATUS = 0xC000012D;
pub const STATUS_INVALID_IMAGE_LE_FORMAT: NTSTATUS = 0xC000012E;
pub const STATUS_INVALID_IMAGE_NOT_MZ: NTSTATUS = 0xC000012F;
pub const STATUS_INVALID_IMAGE_PROTECT: NTSTATUS = 0xC0000130;
pub const STATUS_INVALID_IMAGE_WIN_16: NTSTATUS = 0xC0000131;
pub const STATUS_LOGON_SERVER_CONFLICT: NTSTATUS = 0xC0000132;
pub const STATUS_TIME_DIFFERENCE_AT_DC: NTSTATUS = 0xC0000133;
pub const STATUS_SYNCHRONIZATION_REQUIRED: NTSTATUS = 0xC0000134;
pub const STATUS_DLL_NOT_FOUND: NTSTATUS = 0xC0000135;
pub const STATUS_OPEN_FAILED: NTSTATUS = 0xC0000136;
pub const STATUS_IO_PRIVILEGE_FAILED: NTSTATUS = 0xC0000137;
pub const STATUS_ORDINAL_NOT_FOUND: NTSTATUS = 0xC0000138;
pub const STATUS_ENTRYPOINT_NOT_FOUND: NTSTATUS = 0xC0000139;
pub const STATUS_CONTROL_C_EXIT: NTSTATUS = 0xC000013A;
pub const STATUS_LOCAL_DISCONNECT: NTSTATUS = 0xC000013B;
pub const STATUS_REMOTE_DISCONNECT: NTSTATUS = 0xC000013C;
pub const STATUS_REMOTE_RESOURCES: NTSTATUS = 0xC000013D;
pub const STATUS_LINK_FAILED: NTSTATUS = 0xC000013E;
pub const STATUS_LINK_TIMEOUT: NTSTATUS = 0xC000013F;
pub const STATUS_INVALID_CONNECTION: NTSTATUS = 0xC0000140;
pub const STATUS_INVALID_ADDRESS: NTSTATUS = 0xC0000141;
pub const STATUS_DLL_INIT_FAILED: NTSTATUS = 0xC0000142;
pub const STATUS_MISSING_SYSTEMFILE: NTSTATUS = 0xC0000143;
pub const STATUS_UNHANDLED_EXCEPTION: NTSTATUS = 0xC0000144;
pub const STATUS_APP_INIT_FAILURE: NTSTATUS = 0xC0000145;
pub const STATUS_PAGEFILE_CREATE_FAILED: NTSTATUS = 0xC0000146;
pub const STATUS_NO_PAGEFILE: NTSTATUS = 0xC0000147;
pub const STATUS_INVALID_LEVEL: NTSTATUS = 0xC0000148;
pub const STATUS_WRONG_PASSWORD_CORE: NTSTATUS = 0xC0000149;
pub const STATUS_ILLEGAL_FLOAT_CONTEXT: NTSTATUS = 0xC000014A;
pub const STATUS_PIPE_BROKEN: NTSTATUS = 0xC000014B;
pub const STATUS_REGISTRY_CORRUPT: NTSTATUS = 0xC000014C;
pub const STATUS_REGISTRY_IO_FAILED: NTSTATUS = 0xC000014D;
pub const STATUS_NO_EVENT_PAIR: NTSTATUS = 0xC000014E;
pub const STATUS_UNRECOGNIZED_VOLUME: NTSTATUS = 0xC000014F;
pub const STATUS_SERIAL_NO_DEVICE_INITED: NTSTATUS = 0xC0000150;
pub const STATUS_NO_SUCH_ALIAS: NTSTATUS = 0xC0000151;
pub const STATUS_MEMBER_NOT_IN_ALIAS: NTSTATUS = 0xC0000152;
pub const STATUS_MEMBER_IN_ALIAS: NTSTATUS = 0xC0000153;
pub const STATUS_ALIAS_EXISTS: NTSTATUS = 0xC0000154;
pub const STATUS_LOGON_NOT_GRANTED: NTSTATUS = 0xC0000155;
pub const STATUS_TOO_MANY_SECRETS: NTSTATUS = 0xC0000156;
pub const STATUS_SECRET_TOO_LONG: NTSTATUS = 0xC0000157;
pub const STATUS_INTERNAL_DB_ERROR: NTSTATUS = 0xC0000158;
pub const STATUS_FULLSCREEN_MODE: NTSTATUS = 0xC0000159;
pub const STATUS_TOO_MANY_CONTEXT_IDS: NTSTATUS = 0xC000015A;
pub const STATUS_LOGON_TYPE_NOT_GRANTED: NTSTATUS = 0xC000015B;
pub const STATUS_NOT_REGISTRY_FILE: NTSTATUS = 0xC000015C;
pub const STATUS_NT_CROSS_ENCRYPTION_REQUIRED: NTSTATUS = 0xC000015D;
pub const STATUS_DOMAIN_CTRLR_CONFIG_ERROR: NTSTATUS = 0xC000015E;
pub const STATUS_FT_MISSING_MEMBER: NTSTATUS = 0xC000015F;
pub const STATUS_ILL_FORMED_SERVICE_ENTRY: NTSTATUS = 0xC0000160;
pub const STATUS_ILLEGAL_CHARACTER: NTSTATUS = 0xC0000161;
pub const STATUS_UNMAPPABLE_CHARACTER: NTSTATUS = 0xC0000162;
pub const STATUS_UNDEFINED_CHARACTER: NTSTATUS = 0xC0000163;
pub const STATUS_FLOPPY_VOLUME: NTSTATUS = 0xC0000164;
pub const STATUS_FLOPPY_ID_MARK_NOT_FOUND: NTSTATUS = 0xC0000165;
pub const STATUS_FLOPPY_WRONG_CYLINDER: NTSTATUS = 0xC0000166;
pub const STATUS_FLOPPY_UNKNOWN_ERROR: NTSTATUS = 0xC0000167;
pub const STATUS_FLOPPY_BAD_REGISTERS: NTSTATUS = 0xC0000168;
pub const STATUS_DISK_RECALIBRATE_FAILED: NTSTATUS = 0xC0000169;
pub const STATUS_DISK_OPERATION_FAILED: NTSTATUS = 0xC000016A;
pub const STATUS_DISK_RESET_FAILED: NTSTATUS = 0xC000016B;
pub const STATUS_SHARED_IRQ_BUSY: NTSTATUS = 0xC000016C;
pub const STATUS_FT_ORPHANING: NTSTATUS = 0xC000016D;
pub const STATUS_BIOS_FAILED_TO_CONNECT_INTERRUPT: NTSTATUS = 0xC000016E;
pub const STATUS_PARTITION_FAILURE: NTSTATUS = 0xC0000172;
pub const STATUS_INVALID_BLOCK_LENGTH: NTSTATUS = 0xC0000173;
pub const STATUS_DEVICE_NOT_PARTITIONED: NTSTATUS = 0xC0000174;
pub const STATUS_UNABLE_TO_LOCK_MEDIA: NTSTATUS = 0xC0000175;
pub const STATUS_UNABLE_TO_UNLOAD_MEDIA: NTSTATUS = 0xC0000176;
pub const STATUS_EOM_OVERFLOW: NTSTATUS = 0xC0000177;
pub const STATUS_NO_MEDIA: NTSTATUS = 0xC0000178;
pub const STATUS_NO_SUCH_MEMBER: NTSTATUS = 0xC000017A;
pub const STATUS_INVALID_MEMBER: NTSTATUS = 0xC000017B;
pub const STATUS_KEY_DELETED: NTSTATUS = 0xC000017C;
pub const STATUS_NO_LOG_SPACE: NTSTATUS = 0xC000017D;
pub const STATUS_TOO_MANY_SIDS: NTSTATUS = 0xC000017E;
pub const STATUS_LM_CROSS_ENCRYPTION_REQUIRED: NTSTATUS = 0xC000017F;
pub const STATUS_KEY_HAS_CHILDREN: NTSTATUS = 0xC0000180;
pub const STATUS_CHILD_MUST_BE_VOLATILE: NTSTATUS = 0xC0000181;
pub const STATUS_DEVICE_CONFIGURATION_ERROR: NTSTATUS = 0xC0000182;
pub const STATUS_DRIVER_INTERNAL_ERROR: NTSTATUS = 0xC0000183;
pub const STATUS_INVALID_DEVICE_STATE: NTSTATUS = 0xC0000184;
pub const STATUS_IO_DEVICE_ERROR: NTSTATUS = 0xC0000185;
pub const STATUS_DEVICE_PROTOCOL_ERROR: NTSTATUS = 0xC0000186;
pub const STATUS_BACKUP_CONTROLLER: NTSTATUS = 0xC0000187;
pub const STATUS_LOG_FILE_FULL: NTSTATUS = 0xC0000188;
pub const STATUS_TOO_LATE: NTSTATUS = 0xC0000189;
pub const STATUS_NO_TRUST_LSA_SECRET: NTSTATUS = 0xC000018A;
pub const STATUS_NO_TRUST_SAM_ACCOUNT: NTSTATUS = 0xC000018B;
pub const STATUS_TRUSTED_DOMAIN_FAILURE: NTSTATUS = 0xC000018C;
pub const STATUS_TRUSTED_RELATIONSHIP_FAILURE: NTSTATUS = 0xC000018D;
pub const STATUS_EVENTLOG_FILE_CORRUPT: NTSTATUS = 0xC000018E;
pub const STATUS_EVENTLOG_CANT_START: NTSTATUS = 0xC000018F;
pub const STATUS_TRUST_FAILURE: NTSTATUS = 0xC0000190;
pub const STATUS_MUTANT_LIMIT_EXCEEDED: NTSTATUS = 0xC0000191;
pub const STATUS_NETLOGON_NOT_STARTED: NTSTATUS = 0xC0000192;
pub const STATUS_ACCOUNT_EXPIRED: NTSTATUS = 0xC0000193;
pub const STATUS_POSSIBLE_DEADLOCK: NTSTATUS = 0xC0000194;
pub const STATUS_NETWORK_CREDENTIAL_CONFLICT: NTSTATUS = 0xC0000195;
pub const STATUS_REMOTE_SESSION_LIMIT: NTSTATUS = 0xC0000196;
pub const STATUS_EVENTLOG_FILE_CHANGED: NTSTATUS = 0xC0000197;
pub const STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT: NTSTATUS = 0xC0000198;
pub const STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT: NTSTATUS = 0xC0000199;
pub const STATUS_NOLOGON_SERVER_TRUST_ACCOUNT: NTSTATUS = 0xC000019A;
pub const STATUS_DOMAIN_TRUST_INCONSISTENT: NTSTATUS = 0xC000019B;
pub const STATUS_FS_DRIVER_REQUIRED: NTSTATUS = 0xC000019C;
pub const STATUS_IMAGE_ALREADY_LOADED_AS_DLL: NTSTATUS = 0xC000019D;
pub const STATUS_INCOMPATIBLE_WITH_GLOBAL_SHORT_NAME_REGISTRY_SETTING: NTSTATUS
    = 0xC000019E;
pub const STATUS_SHORT_NAMES_NOT_ENABLED_ON_VOLUME: NTSTATUS = 0xC000019F;
pub const STATUS_SECURITY_STREAM_IS_INCONSISTENT: NTSTATUS = 0xC00001A0;
pub const STATUS_INVALID_LOCK_RANGE: NTSTATUS = 0xC00001A1;
pub const STATUS_INVALID_ACE_CONDITION: NTSTATUS = 0xC00001A2;
pub const STATUS_IMAGE_SUBSYSTEM_NOT_PRESENT: NTSTATUS = 0xC00001A3;
pub const STATUS_NOTIFICATION_GUID_ALREADY_DEFINED: NTSTATUS = 0xC00001A4;
pub const STATUS_INVALID_EXCEPTION_HANDLER: NTSTATUS = 0xC00001A5;
pub const STATUS_DUPLICATE_PRIVILEGES: NTSTATUS = 0xC00001A6;
pub const STATUS_NOT_ALLOWED_ON_SYSTEM_FILE: NTSTATUS = 0xC00001A7;
pub const STATUS_REPAIR_NEEDED: NTSTATUS = 0xC00001A8;
pub const STATUS_QUOTA_NOT_ENABLED: NTSTATUS = 0xC00001A9;
pub const STATUS_NO_APPLICATION_PACKAGE: NTSTATUS = 0xC00001AA;
pub const STATUS_FILE_METADATA_OPTIMIZATION_IN_PROGRESS: NTSTATUS = 0xC00001AB;
pub const STATUS_NOT_SAME_OBJECT: NTSTATUS = 0xC00001AC;
pub const STATUS_FATAL_MEMORY_EXHAUSTION: NTSTATUS = 0xC00001AD;
pub const STATUS_ERROR_PROCESS_NOT_IN_JOB: NTSTATUS = 0xC00001AE;
pub const STATUS_CPU_SET_INVALID: NTSTATUS = 0xC00001AF;
pub const STATUS_NETWORK_OPEN_RESTRICTION: NTSTATUS = 0xC0000201;
pub const STATUS_NO_USER_SESSION_KEY: NTSTATUS = 0xC0000202;
pub const STATUS_USER_SESSION_DELETED: NTSTATUS = 0xC0000203;
pub const STATUS_RESOURCE_LANG_NOT_FOUND: NTSTATUS = 0xC0000204;
pub const STATUS_INSUFF_SERVER_RESOURCES: NTSTATUS = 0xC0000205;
pub const STATUS_INVALID_BUFFER_SIZE: NTSTATUS = 0xC0000206;
pub const STATUS_INVALID_ADDRESS_COMPONENT: NTSTATUS = 0xC0000207;
pub const STATUS_INVALID_ADDRESS_WILDCARD: NTSTATUS = 0xC0000208;
pub const STATUS_TOO_MANY_ADDRESSES: NTSTATUS = 0xC0000209;
pub const STATUS_ADDRESS_ALREADY_EXISTS: NTSTATUS = 0xC000020A;
pub const STATUS_ADDRESS_CLOSED: NTSTATUS = 0xC000020B;
pub const STATUS_CONNECTION_DISCONNECTED: NTSTATUS = 0xC000020C;
pub const STATUS_CONNECTION_RESET: NTSTATUS = 0xC000020D;
pub const STATUS_TOO_MANY_NODES: NTSTATUS = 0xC000020E;
pub const STATUS_TRANSACTION_ABORTED: NTSTATUS = 0xC000020F;
pub const STATUS_TRANSACTION_TIMED_OUT: NTSTATUS = 0xC0000210;
pub const STATUS_TRANSACTION_NO_RELEASE: NTSTATUS = 0xC0000211;
pub const STATUS_TRANSACTION_NO_MATCH: NTSTATUS = 0xC0000212;
pub const STATUS_TRANSACTION_RESPONDED: NTSTATUS = 0xC0000213;
pub const STATUS_TRANSACTION_INVALID_ID: NTSTATUS = 0xC0000214;
pub const STATUS_TRANSACTION_INVALID_TYPE: NTSTATUS = 0xC0000215;
pub const STATUS_NOT_SERVER_SESSION: NTSTATUS = 0xC0000216;
pub const STATUS_NOT_CLIENT_SESSION: NTSTATUS = 0xC0000217;
pub const STATUS_CANNOT_LOAD_REGISTRY_FILE: NTSTATUS = 0xC0000218;
pub const STATUS_DEBUG_ATTACH_FAILED: NTSTATUS = 0xC0000219;
pub const STATUS_SYSTEM_PROCESS_TERMINATED: NTSTATUS = 0xC000021A;
pub const STATUS_DATA_NOT_ACCEPTED: NTSTATUS = 0xC000021B;
pub const STATUS_NO_BROWSER_SERVERS_FOUND: NTSTATUS = 0xC000021C;
pub const STATUS_VDM_HARD_ERROR: NTSTATUS = 0xC000021D;
pub const STATUS_DRIVER_CANCEL_TIMEOUT: NTSTATUS = 0xC000021E;
pub const STATUS_REPLY_MESSAGE_MISMATCH: NTSTATUS = 0xC000021F;
pub const STATUS_MAPPED_ALIGNMENT: NTSTATUS = 0xC0000220;
pub const STATUS_IMAGE_CHECKSUM_MISMATCH: NTSTATUS = 0xC0000221;
pub const STATUS_LOST_WRITEBEHIND_DATA: NTSTATUS = 0xC0000222;
pub const STATUS_CLIENT_SERVER_PARAMETERS_INVALID: NTSTATUS = 0xC0000223;
pub const STATUS_PASSWORD_MUST_CHANGE: NTSTATUS = 0xC0000224;
pub const STATUS_NOT_FOUND: NTSTATUS = 0xC0000225;
pub const STATUS_NOT_TINY_STREAM: NTSTATUS = 0xC0000226;
pub const STATUS_RECOVERY_FAILURE: NTSTATUS = 0xC0000227;
pub const STATUS_STACK_OVERFLOW_READ: NTSTATUS = 0xC0000228;
pub const STATUS_FAIL_CHECK: NTSTATUS = 0xC0000229;
pub const STATUS_DUPLICATE_OBJECTID: NTSTATUS = 0xC000022A;
pub const STATUS_OBJECTID_EXISTS: NTSTATUS = 0xC000022B;
pub const STATUS_CONVERT_TO_LARGE: NTSTATUS = 0xC000022C;
pub const STATUS_RETRY: NTSTATUS = 0xC000022D;
pub const STATUS_FOUND_OUT_OF_SCOPE: NTSTATUS = 0xC000022E;
pub const STATUS_ALLOCATE_BUCKET: NTSTATUS = 0xC000022F;
pub const STATUS_PROPSET_NOT_FOUND: NTSTATUS = 0xC0000230;
pub const STATUS_MARSHALL_OVERFLOW: NTSTATUS = 0xC0000231;
pub const STATUS_INVALID_VARIANT: NTSTATUS = 0xC0000232;
pub const STATUS_DOMAIN_CONTROLLER_NOT_FOUND: NTSTATUS = 0xC0000233;
pub const STATUS_ACCOUNT_LOCKED_OUT: NTSTATUS = 0xC0000234;
pub const STATUS_HANDLE_NOT_CLOSABLE: NTSTATUS = 0xC0000235;
pub const STATUS_CONNECTION_REFUSED: NTSTATUS = 0xC0000236;
pub const STATUS_GRACEFUL_DISCONNECT: NTSTATUS = 0xC0000237;
pub const STATUS_ADDRESS_ALREADY_ASSOCIATED: NTSTATUS = 0xC0000238;
pub const STATUS_ADDRESS_NOT_ASSOCIATED: NTSTATUS = 0xC0000239;
pub const STATUS_CONNECTION_INVALID: NTSTATUS = 0xC000023A;
pub const STATUS_CONNECTION_ACTIVE: NTSTATUS = 0xC000023B;
pub const STATUS_NETWORK_UNREACHABLE: NTSTATUS = 0xC000023C;
pub const STATUS_HOST_UNREACHABLE: NTSTATUS = 0xC000023D;
pub const STATUS_PROTOCOL_UNREACHABLE: NTSTATUS = 0xC000023E;
pub const STATUS_PORT_UNREACHABLE: NTSTATUS = 0xC000023F;
pub const STATUS_REQUEST_ABORTED: NTSTATUS = 0xC0000240;
pub const STATUS_CONNECTION_ABORTED: NTSTATUS = 0xC0000241;
pub const STATUS_BAD_COMPRESSION_BUFFER: NTSTATUS = 0xC0000242;
pub const STATUS_USER_MAPPED_FILE: NTSTATUS = 0xC0000243;
pub const STATUS_AUDIT_FAILED: NTSTATUS = 0xC0000244;
pub const STATUS_TIMER_RESOLUTION_NOT_SET: NTSTATUS = 0xC0000245;
pub const STATUS_CONNECTION_COUNT_LIMIT: NTSTATUS = 0xC0000246;
pub const STATUS_LOGIN_TIME_RESTRICTION: NTSTATUS = 0xC0000247;
pub const STATUS_LOGIN_WKSTA_RESTRICTION: NTSTATUS = 0xC0000248;
pub const STATUS_IMAGE_MP_UP_MISMATCH: NTSTATUS = 0xC0000249;
pub const STATUS_INSUFFICIENT_LOGON_INFO: NTSTATUS = 0xC0000250;
pub const STATUS_BAD_DLL_ENTRYPOINT: NTSTATUS = 0xC0000251;
pub const STATUS_BAD_SERVICE_ENTRYPOINT: NTSTATUS = 0xC0000252;
pub const STATUS_LPC_REPLY_LOST: NTSTATUS = 0xC0000253;
pub const STATUS_IP_ADDRESS_CONFLICT1: NTSTATUS = 0xC0000254;
pub const STATUS_IP_ADDRESS_CONFLICT2: NTSTATUS = 0xC0000255;
pub const STATUS_REGISTRY_QUOTA_LIMIT: NTSTATUS = 0xC0000256;
pub const STATUS_PATH_NOT_COVERED: NTSTATUS = 0xC0000257;
pub const STATUS_NO_CALLBACK_ACTIVE: NTSTATUS = 0xC0000258;
pub const STATUS_LICENSE_QUOTA_EXCEEDED: NTSTATUS = 0xC0000259;
pub const STATUS_PWD_TOO_SHORT: NTSTATUS = 0xC000025A;
pub const STATUS_PWD_TOO_RECENT: NTSTATUS = 0xC000025B;
pub const STATUS_PWD_HISTORY_CONFLICT: NTSTATUS = 0xC000025C;
pub const STATUS_PLUGPLAY_NO_DEVICE: NTSTATUS = 0xC000025E;
pub const STATUS_UNSUPPORTED_COMPRESSION: NTSTATUS = 0xC000025F;
pub const STATUS_INVALID_HW_PROFILE: NTSTATUS = 0xC0000260;
pub const STATUS_INVALID_PLUGPLAY_DEVICE_PATH: NTSTATUS = 0xC0000261;
pub const STATUS_DRIVER_ORDINAL_NOT_FOUND: NTSTATUS = 0xC0000262;
pub const STATUS_DRIVER_ENTRYPOINT_NOT_FOUND: NTSTATUS = 0xC0000263;
pub const STATUS_RESOURCE_NOT_OWNED: NTSTATUS = 0xC0000264;
pub const STATUS_TOO_MANY_LINKS: NTSTATUS = 0xC0000265;
pub const STATUS_QUOTA_LIST_INCONSISTENT: NTSTATUS = 0xC0000266;
pub const STATUS_FILE_IS_OFFLINE: NTSTATUS = 0xC0000267;
pub const STATUS_EVALUATION_EXPIRATION: NTSTATUS = 0xC0000268;
pub const STATUS_ILLEGAL_DLL_RELOCATION: NTSTATUS = 0xC0000269;
pub const STATUS_LICENSE_VIOLATION: NTSTATUS = 0xC000026A;
pub const STATUS_DLL_INIT_FAILED_LOGOFF: NTSTATUS = 0xC000026B;
pub const STATUS_DRIVER_UNABLE_TO_LOAD: NTSTATUS = 0xC000026C;
pub const STATUS_DFS_UNAVAILABLE: NTSTATUS = 0xC000026D;
pub const STATUS_VOLUME_DISMOUNTED: NTSTATUS = 0xC000026E;
pub const STATUS_WX86_INTERNAL_ERROR: NTSTATUS = 0xC000026F;
pub const STATUS_WX86_FLOAT_STACK_CHECK: NTSTATUS = 0xC0000270;
pub const STATUS_VALIDATE_CONTINUE: NTSTATUS = 0xC0000271;
pub const STATUS_NO_MATCH: NTSTATUS = 0xC0000272;
pub const STATUS_NO_MORE_MATCHES: NTSTATUS = 0xC0000273;
pub const STATUS_NOT_A_REPARSE_POINT: NTSTATUS = 0xC0000275;
pub const STATUS_IO_REPARSE_TAG_INVALID: NTSTATUS = 0xC0000276;
pub const STATUS_IO_REPARSE_TAG_MISMATCH: NTSTATUS = 0xC0000277;
pub const STATUS_IO_REPARSE_DATA_INVALID: NTSTATUS = 0xC0000278;
pub const STATUS_IO_REPARSE_TAG_NOT_HANDLED: NTSTATUS = 0xC0000279;
pub const STATUS_PWD_TOO_LONG: NTSTATUS = 0xC000027A;
pub const STATUS_STOWED_EXCEPTION: NTSTATUS = 0xC000027B;
pub const STATUS_REPARSE_POINT_NOT_RESOLVED: NTSTATUS = 0xC0000280;
pub const STATUS_DIRECTORY_IS_A_REPARSE_POINT: NTSTATUS = 0xC0000281;
pub const STATUS_RANGE_LIST_CONFLICT: NTSTATUS = 0xC0000282;
pub const STATUS_SOURCE_ELEMENT_EMPTY: NTSTATUS = 0xC0000283;
pub const STATUS_DESTINATION_ELEMENT_FULL: NTSTATUS = 0xC0000284;
pub const STATUS_ILLEGAL_ELEMENT_ADDRESS: NTSTATUS = 0xC0000285;
pub const STATUS_MAGAZINE_NOT_PRESENT: NTSTATUS = 0xC0000286;
pub const STATUS_REINITIALIZATION_NEEDED: NTSTATUS = 0xC0000287;
pub const STATUS_DEVICE_REQUIRES_CLEANING: NTSTATUS = 0x80000288;
pub const STATUS_DEVICE_DOOR_OPEN: NTSTATUS = 0x80000289;
pub const STATUS_ENCRYPTION_FAILED: NTSTATUS = 0xC000028A;
pub const STATUS_DECRYPTION_FAILED: NTSTATUS = 0xC000028B;
pub const STATUS_RANGE_NOT_FOUND: NTSTATUS = 0xC000028C;
pub const STATUS_NO_RECOVERY_POLICY: NTSTATUS = 0xC000028D;
pub const STATUS_NO_EFS: NTSTATUS = 0xC000028E;
pub const STATUS_WRONG_EFS: NTSTATUS = 0xC000028F;
pub const STATUS_NO_USER_KEYS: NTSTATUS = 0xC0000290;
pub const STATUS_FILE_NOT_ENCRYPTED: NTSTATUS = 0xC0000291;
pub const STATUS_NOT_EXPORT_FORMAT: NTSTATUS = 0xC0000292;
pub const STATUS_FILE_ENCRYPTED: NTSTATUS = 0xC0000293;
pub const STATUS_WAKE_SYSTEM: NTSTATUS = 0x40000294;
pub const STATUS_WMI_GUID_NOT_FOUND: NTSTATUS = 0xC0000295;
pub const STATUS_WMI_INSTANCE_NOT_FOUND: NTSTATUS = 0xC0000296;
pub const STATUS_WMI_ITEMID_NOT_FOUND: NTSTATUS = 0xC0000297;
pub const STATUS_WMI_TRY_AGAIN: NTSTATUS = 0xC0000298;
pub const STATUS_SHARED_POLICY: NTSTATUS = 0xC0000299;
pub const STATUS_POLICY_OBJECT_NOT_FOUND: NTSTATUS = 0xC000029A;
pub const STATUS_POLICY_ONLY_IN_DS: NTSTATUS = 0xC000029B;
pub const STATUS_VOLUME_NOT_UPGRADED: NTSTATUS = 0xC000029C;
pub const STATUS_REMOTE_STORAGE_NOT_ACTIVE: NTSTATUS = 0xC000029D;
pub const STATUS_REMOTE_STORAGE_MEDIA_ERROR: NTSTATUS = 0xC000029E;
pub const STATUS_NO_TRACKING_SERVICE: NTSTATUS = 0xC000029F;
pub const STATUS_SERVER_SID_MISMATCH: NTSTATUS = 0xC00002A0;
pub const STATUS_DS_NO_ATTRIBUTE_OR_VALUE: NTSTATUS = 0xC00002A1;
pub const STATUS_DS_INVALID_ATTRIBUTE_SYNTAX: NTSTATUS = 0xC00002A2;
pub const STATUS_DS_ATTRIBUTE_TYPE_UNDEFINED: NTSTATUS = 0xC00002A3;
pub const STATUS_DS_ATTRIBUTE_OR_VALUE_EXISTS: NTSTATUS = 0xC00002A4;
pub const STATUS_DS_BUSY: NTSTATUS = 0xC00002A5;
pub const STATUS_DS_UNAVAILABLE: NTSTATUS = 0xC00002A6;
pub const STATUS_DS_NO_RIDS_ALLOCATED: NTSTATUS = 0xC00002A7;
pub const STATUS_DS_NO_MORE_RIDS: NTSTATUS = 0xC00002A8;
pub const STATUS_DS_INCORRECT_ROLE_OWNER: NTSTATUS = 0xC00002A9;
pub const STATUS_DS_RIDMGR_INIT_ERROR: NTSTATUS = 0xC00002AA;
pub const STATUS_DS_OBJ_CLASS_VIOLATION: NTSTATUS = 0xC00002AB;
pub const STATUS_DS_CANT_ON_NON_LEAF: NTSTATUS = 0xC00002AC;
pub const STATUS_DS_CANT_ON_RDN: NTSTATUS = 0xC00002AD;
pub const STATUS_DS_CANT_MOD_OBJ_CLASS: NTSTATUS = 0xC00002AE;
pub const STATUS_DS_CROSS_DOM_MOVE_FAILED: NTSTATUS = 0xC00002AF;
pub const STATUS_DS_GC_NOT_AVAILABLE: NTSTATUS = 0xC00002B0;
pub const STATUS_DIRECTORY_SERVICE_REQUIRED: NTSTATUS = 0xC00002B1;
pub const STATUS_REPARSE_ATTRIBUTE_CONFLICT: NTSTATUS = 0xC00002B2;
pub const STATUS_CANT_ENABLE_DENY_ONLY: NTSTATUS = 0xC00002B3;
pub const STATUS_FLOAT_MULTIPLE_FAULTS: NTSTATUS = 0xC00002B4;
pub const STATUS_FLOAT_MULTIPLE_TRAPS: NTSTATUS = 0xC00002B5;
pub const STATUS_DEVICE_REMOVED: NTSTATUS = 0xC00002B6;
pub const STATUS_JOURNAL_DELETE_IN_PROGRESS: NTSTATUS = 0xC00002B7;
pub const STATUS_JOURNAL_NOT_ACTIVE: NTSTATUS = 0xC00002B8;
pub const STATUS_NOINTERFACE: NTSTATUS = 0xC00002B9;
pub const STATUS_DS_RIDMGR_DISABLED: NTSTATUS = 0xC00002BA;
pub const STATUS_DS_ADMIN_LIMIT_EXCEEDED: NTSTATUS = 0xC00002C1;
pub const STATUS_DRIVER_FAILED_SLEEP: NTSTATUS = 0xC00002C2;
pub const STATUS_MUTUAL_AUTHENTICATION_FAILED: NTSTATUS = 0xC00002C3;
pub const STATUS_CORRUPT_SYSTEM_FILE: NTSTATUS = 0xC00002C4;
pub const STATUS_DATATYPE_MISALIGNMENT_ERROR: NTSTATUS = 0xC00002C5;
pub const STATUS_WMI_READ_ONLY: NTSTATUS = 0xC00002C6;
pub const STATUS_WMI_SET_FAILURE: NTSTATUS = 0xC00002C7;
pub const STATUS_COMMITMENT_MINIMUM: NTSTATUS = 0xC00002C8;
pub const STATUS_REG_NAT_CONSUMPTION: NTSTATUS = 0xC00002C9;
pub const STATUS_TRANSPORT_FULL: NTSTATUS = 0xC00002CA;
pub const STATUS_DS_SAM_INIT_FAILURE: NTSTATUS = 0xC00002CB;
pub const STATUS_ONLY_IF_CONNECTED: NTSTATUS = 0xC00002CC;
pub const STATUS_DS_SENSITIVE_GROUP_VIOLATION: NTSTATUS = 0xC00002CD;
pub const STATUS_PNP_RESTART_ENUMERATION: NTSTATUS = 0xC00002CE;
pub const STATUS_JOURNAL_ENTRY_DELETED: NTSTATUS = 0xC00002CF;
pub const STATUS_DS_CANT_MOD_PRIMARYGROUPID: NTSTATUS = 0xC00002D0;
pub const STATUS_SYSTEM_IMAGE_BAD_SIGNATURE: NTSTATUS = 0xC00002D1;
pub const STATUS_PNP_REBOOT_REQUIRED: NTSTATUS = 0xC00002D2;
pub const STATUS_POWER_STATE_INVALID: NTSTATUS = 0xC00002D3;
pub const STATUS_DS_INVALID_GROUP_TYPE: NTSTATUS = 0xC00002D4;
pub const STATUS_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN: NTSTATUS = 0xC00002D5;
pub const STATUS_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN: NTSTATUS = 0xC00002D6;
pub const STATUS_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER: NTSTATUS = 0xC00002D7;
pub const STATUS_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER: NTSTATUS = 0xC00002D8;
pub const STATUS_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER: NTSTATUS = 0xC00002D9;
pub const STATUS_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER: NTSTATUS = 0xC00002DA;
pub const STATUS_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER: NTSTATUS = 0xC00002DB;
pub const STATUS_DS_HAVE_PRIMARY_MEMBERS: NTSTATUS = 0xC00002DC;
pub const STATUS_WMI_NOT_SUPPORTED: NTSTATUS = 0xC00002DD;
pub const STATUS_INSUFFICIENT_POWER: NTSTATUS = 0xC00002DE;
pub const STATUS_SAM_NEED_BOOTKEY_PASSWORD: NTSTATUS = 0xC00002DF;
pub const STATUS_SAM_NEED_BOOTKEY_FLOPPY: NTSTATUS = 0xC00002E0;
pub const STATUS_DS_CANT_START: NTSTATUS = 0xC00002E1;
pub const STATUS_DS_INIT_FAILURE: NTSTATUS = 0xC00002E2;
pub const STATUS_SAM_INIT_FAILURE: NTSTATUS = 0xC00002E3;
pub const STATUS_DS_GC_REQUIRED: NTSTATUS = 0xC00002E4;
pub const STATUS_DS_LOCAL_MEMBER_OF_LOCAL_ONLY: NTSTATUS = 0xC00002E5;
pub const STATUS_DS_NO_FPO_IN_UNIVERSAL_GROUPS: NTSTATUS = 0xC00002E6;
pub const STATUS_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED: NTSTATUS = 0xC00002E7;
pub const STATUS_MULTIPLE_FAULT_VIOLATION: NTSTATUS = 0xC00002E8;
pub const STATUS_CURRENT_DOMAIN_NOT_ALLOWED: NTSTATUS = 0xC00002E9;
pub const STATUS_CANNOT_MAKE: NTSTATUS = 0xC00002EA;
pub const STATUS_SYSTEM_SHUTDOWN: NTSTATUS = 0xC00002EB;
pub const STATUS_DS_INIT_FAILURE_CONSOLE: NTSTATUS = 0xC00002EC;
pub const STATUS_DS_SAM_INIT_FAILURE_CONSOLE: NTSTATUS = 0xC00002ED;
pub const STATUS_UNFINISHED_CONTEXT_DELETED: NTSTATUS = 0xC00002EE;
pub const STATUS_NO_TGT_REPLY: NTSTATUS = 0xC00002EF;
pub const STATUS_OBJECTID_NOT_FOUND: NTSTATUS = 0xC00002F0;
pub const STATUS_NO_IP_ADDRESSES: NTSTATUS = 0xC00002F1;
pub const STATUS_WRONG_CREDENTIAL_HANDLE: NTSTATUS = 0xC00002F2;
pub const STATUS_CRYPTO_SYSTEM_INVALID: NTSTATUS = 0xC00002F3;
pub const STATUS_MAX_REFERRALS_EXCEEDED: NTSTATUS = 0xC00002F4;
pub const STATUS_MUST_BE_KDC: NTSTATUS = 0xC00002F5;
pub const STATUS_STRONG_CRYPTO_NOT_SUPPORTED: NTSTATUS = 0xC00002F6;
pub const STATUS_TOO_MANY_PRINCIPALS: NTSTATUS = 0xC00002F7;
pub const STATUS_NO_PA_DATA: NTSTATUS = 0xC00002F8;
pub const STATUS_PKINIT_NAME_MISMATCH: NTSTATUS = 0xC00002F9;
pub const STATUS_SMARTCARD_LOGON_REQUIRED: NTSTATUS = 0xC00002FA;
pub const STATUS_KDC_INVALID_REQUEST: NTSTATUS = 0xC00002FB;
pub const STATUS_KDC_UNABLE_TO_REFER: NTSTATUS = 0xC00002FC;
pub const STATUS_KDC_UNKNOWN_ETYPE: NTSTATUS = 0xC00002FD;
pub const STATUS_SHUTDOWN_IN_PROGRESS: NTSTATUS = 0xC00002FE;
pub const STATUS_SERVER_SHUTDOWN_IN_PROGRESS: NTSTATUS = 0xC00002FF;
pub const STATUS_NOT_SUPPORTED_ON_SBS: NTSTATUS = 0xC0000300;
pub const STATUS_WMI_GUID_DISCONNECTED: NTSTATUS = 0xC0000301;
pub const STATUS_WMI_ALREADY_DISABLED: NTSTATUS = 0xC0000302;
pub const STATUS_WMI_ALREADY_ENABLED: NTSTATUS = 0xC0000303;
pub const STATUS_MFT_TOO_FRAGMENTED: NTSTATUS = 0xC0000304;
pub const STATUS_COPY_PROTECTION_FAILURE: NTSTATUS = 0xC0000305;
pub const STATUS_CSS_AUTHENTICATION_FAILURE: NTSTATUS = 0xC0000306;
pub const STATUS_CSS_KEY_NOT_PRESENT: NTSTATUS = 0xC0000307;
pub const STATUS_CSS_KEY_NOT_ESTABLISHED: NTSTATUS = 0xC0000308;
pub const STATUS_CSS_SCRAMBLED_SECTOR: NTSTATUS = 0xC0000309;
pub const STATUS_CSS_REGION_MISMATCH: NTSTATUS = 0xC000030A;
pub const STATUS_CSS_RESETS_EXHAUSTED: NTSTATUS = 0xC000030B;
pub const STATUS_PASSWORD_CHANGE_REQUIRED: NTSTATUS = 0xC000030C;
pub const STATUS_PKINIT_FAILURE: NTSTATUS = 0xC0000320;
pub const STATUS_SMARTCARD_SUBSYSTEM_FAILURE: NTSTATUS = 0xC0000321;
pub const STATUS_NO_KERB_KEY: NTSTATUS = 0xC0000322;
pub const STATUS_HOST_DOWN: NTSTATUS = 0xC0000350;
pub const STATUS_UNSUPPORTED_PREAUTH: NTSTATUS = 0xC0000351;
pub const STATUS_EFS_ALG_BLOB_TOO_BIG: NTSTATUS = 0xC0000352;
pub const STATUS_PORT_NOT_SET: NTSTATUS = 0xC0000353;
pub const STATUS_DEBUGGER_INACTIVE: NTSTATUS = 0xC0000354;
pub const STATUS_DS_VERSION_CHECK_FAILURE: NTSTATUS = 0xC0000355;
pub const STATUS_AUDITING_DISABLED: NTSTATUS = 0xC0000356;
pub const STATUS_PRENT4_MACHINE_ACCOUNT: NTSTATUS = 0xC0000357;
pub const STATUS_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER: NTSTATUS = 0xC0000358;
pub const STATUS_INVALID_IMAGE_WIN_32: NTSTATUS = 0xC0000359;
pub const STATUS_INVALID_IMAGE_WIN_64: NTSTATUS = 0xC000035A;
pub const STATUS_BAD_BINDINGS: NTSTATUS = 0xC000035B;
pub const STATUS_NETWORK_SESSION_EXPIRED: NTSTATUS = 0xC000035C;
pub const STATUS_APPHELP_BLOCK: NTSTATUS = 0xC000035D;
pub const STATUS_ALL_SIDS_FILTERED: NTSTATUS = 0xC000035E;
pub const STATUS_NOT_SAFE_MODE_DRIVER: NTSTATUS = 0xC000035F;
pub const STATUS_ACCESS_DISABLED_BY_POLICY_DEFAULT: NTSTATUS = 0xC0000361;
pub const STATUS_ACCESS_DISABLED_BY_POLICY_PATH: NTSTATUS = 0xC0000362;
pub const STATUS_ACCESS_DISABLED_BY_POLICY_PUBLISHER: NTSTATUS = 0xC0000363;
pub const STATUS_ACCESS_DISABLED_BY_POLICY_OTHER: NTSTATUS = 0xC0000364;
pub const STATUS_FAILED_DRIVER_ENTRY: NTSTATUS = 0xC0000365;
pub const STATUS_DEVICE_ENUMERATION_ERROR: NTSTATUS = 0xC0000366;
pub const STATUS_MOUNT_POINT_NOT_RESOLVED: NTSTATUS = 0xC0000368;
pub const STATUS_INVALID_DEVICE_OBJECT_PARAMETER: NTSTATUS = 0xC0000369;
pub const STATUS_MCA_OCCURED: NTSTATUS = 0xC000036A;
pub const STATUS_DRIVER_BLOCKED_CRITICAL: NTSTATUS = 0xC000036B;
pub const STATUS_DRIVER_BLOCKED: NTSTATUS = 0xC000036C;
pub const STATUS_DRIVER_DATABASE_ERROR: NTSTATUS = 0xC000036D;
pub const STATUS_SYSTEM_HIVE_TOO_LARGE: NTSTATUS = 0xC000036E;
pub const STATUS_INVALID_IMPORT_OF_NON_DLL: NTSTATUS = 0xC000036F;
pub const STATUS_DS_SHUTTING_DOWN: NTSTATUS = 0x40000370;
pub const STATUS_NO_SECRETS: NTSTATUS = 0xC0000371;
pub const STATUS_ACCESS_DISABLED_NO_SAFER_UI_BY_POLICY: NTSTATUS = 0xC0000372;
pub const STATUS_FAILED_STACK_SWITCH: NTSTATUS = 0xC0000373;
pub const STATUS_HEAP_CORRUPTION: NTSTATUS = 0xC0000374;
pub const STATUS_SMARTCARD_WRONG_PIN: NTSTATUS = 0xC0000380;
pub const STATUS_SMARTCARD_CARD_BLOCKED: NTSTATUS = 0xC0000381;
pub const STATUS_SMARTCARD_CARD_NOT_AUTHENTICATED: NTSTATUS = 0xC0000382;
pub const STATUS_SMARTCARD_NO_CARD: NTSTATUS = 0xC0000383;
pub const STATUS_SMARTCARD_NO_KEY_CONTAINER: NTSTATUS = 0xC0000384;
pub const STATUS_SMARTCARD_NO_CERTIFICATE: NTSTATUS = 0xC0000385;
pub const STATUS_SMARTCARD_NO_KEYSET: NTSTATUS = 0xC0000386;
pub const STATUS_SMARTCARD_IO_ERROR: NTSTATUS = 0xC0000387;
pub const STATUS_DOWNGRADE_DETECTED: NTSTATUS = 0xC0000388;
pub const STATUS_SMARTCARD_CERT_REVOKED: NTSTATUS = 0xC0000389;
pub const STATUS_ISSUING_CA_UNTRUSTED: NTSTATUS = 0xC000038A;
pub const STATUS_REVOCATION_OFFLINE_C: NTSTATUS = 0xC000038B;
pub const STATUS_PKINIT_CLIENT_FAILURE: NTSTATUS = 0xC000038C;
pub const STATUS_SMARTCARD_CERT_EXPIRED: NTSTATUS = 0xC000038D;
pub const STATUS_DRIVER_FAILED_PRIOR_UNLOAD: NTSTATUS = 0xC000038E;
pub const STATUS_SMARTCARD_SILENT_CONTEXT: NTSTATUS = 0xC000038F;
pub const STATUS_PER_USER_TRUST_QUOTA_EXCEEDED: NTSTATUS = 0xC0000401;
pub const STATUS_ALL_USER_TRUST_QUOTA_EXCEEDED: NTSTATUS = 0xC0000402;
pub const STATUS_USER_DELETE_TRUST_QUOTA_EXCEEDED: NTSTATUS = 0xC0000403;
pub const STATUS_DS_NAME_NOT_UNIQUE: NTSTATUS = 0xC0000404;
pub const STATUS_DS_DUPLICATE_ID_FOUND: NTSTATUS = 0xC0000405;
pub const STATUS_DS_GROUP_CONVERSION_ERROR: NTSTATUS = 0xC0000406;
pub const STATUS_VOLSNAP_PREPARE_HIBERNATE: NTSTATUS = 0xC0000407;
pub const STATUS_USER2USER_REQUIRED: NTSTATUS = 0xC0000408;
pub const STATUS_STACK_BUFFER_OVERRUN: NTSTATUS = 0xC0000409;
pub const STATUS_NO_S4U_PROT_SUPPORT: NTSTATUS = 0xC000040A;
pub const STATUS_CROSSREALM_DELEGATION_FAILURE: NTSTATUS = 0xC000040B;
pub const STATUS_REVOCATION_OFFLINE_KDC: NTSTATUS = 0xC000040C;
pub const STATUS_ISSUING_CA_UNTRUSTED_KDC: NTSTATUS = 0xC000040D;
pub const STATUS_KDC_CERT_EXPIRED: NTSTATUS = 0xC000040E;
pub const STATUS_KDC_CERT_REVOKED: NTSTATUS = 0xC000040F;
pub const STATUS_PARAMETER_QUOTA_EXCEEDED: NTSTATUS = 0xC0000410;
pub const STATUS_HIBERNATION_FAILURE: NTSTATUS = 0xC0000411;
pub const STATUS_DELAY_LOAD_FAILED: NTSTATUS = 0xC0000412;
pub const STATUS_AUTHENTICATION_FIREWALL_FAILED: NTSTATUS = 0xC0000413;
pub const STATUS_VDM_DISALLOWED: NTSTATUS = 0xC0000414;
pub const STATUS_HUNG_DISPLAY_DRIVER_THREAD: NTSTATUS = 0xC0000415;
pub const STATUS_INSUFFICIENT_RESOURCE_FOR_SPECIFIED_SHARED_SECTION_SIZE: NTSTATUS
    = 0xC0000416;
pub const STATUS_INVALID_CRUNTIME_PARAMETER: NTSTATUS = 0xC0000417;
pub const STATUS_NTLM_BLOCKED: NTSTATUS = 0xC0000418;
pub const STATUS_DS_SRC_SID_EXISTS_IN_FOREST: NTSTATUS = 0xC0000419;
pub const STATUS_DS_DOMAIN_NAME_EXISTS_IN_FOREST: NTSTATUS = 0xC000041A;
pub const STATUS_DS_FLAT_NAME_EXISTS_IN_FOREST: NTSTATUS = 0xC000041B;
pub const STATUS_INVALID_USER_PRINCIPAL_NAME: NTSTATUS = 0xC000041C;
pub const STATUS_FATAL_USER_CALLBACK_EXCEPTION: NTSTATUS = 0xC000041D;
pub const STATUS_ASSERTION_FAILURE: NTSTATUS = 0xC0000420;
pub const STATUS_VERIFIER_STOP: NTSTATUS = 0xC0000421;
pub const STATUS_CALLBACK_POP_STACK: NTSTATUS = 0xC0000423;
pub const STATUS_INCOMPATIBLE_DRIVER_BLOCKED: NTSTATUS = 0xC0000424;
pub const STATUS_HIVE_UNLOADED: NTSTATUS = 0xC0000425;
pub const STATUS_COMPRESSION_DISABLED: NTSTATUS = 0xC0000426;
pub const STATUS_FILE_SYSTEM_LIMITATION: NTSTATUS = 0xC0000427;
pub const STATUS_INVALID_IMAGE_HASH: NTSTATUS = 0xC0000428;
pub const STATUS_NOT_CAPABLE: NTSTATUS = 0xC0000429;
pub const STATUS_REQUEST_OUT_OF_SEQUENCE: NTSTATUS = 0xC000042A;
pub const STATUS_IMPLEMENTATION_LIMIT: NTSTATUS = 0xC000042B;
pub const STATUS_ELEVATION_REQUIRED: NTSTATUS = 0xC000042C;
pub const STATUS_NO_SECURITY_CONTEXT: NTSTATUS = 0xC000042D;
pub const STATUS_PKU2U_CERT_FAILURE: NTSTATUS = 0xC000042F;
pub const STATUS_BEYOND_VDL: NTSTATUS = 0xC0000432;
pub const STATUS_ENCOUNTERED_WRITE_IN_PROGRESS: NTSTATUS = 0xC0000433;
pub const STATUS_PTE_CHANGED: NTSTATUS = 0xC0000434;
pub const STATUS_PURGE_FAILED: NTSTATUS = 0xC0000435;
pub const STATUS_CRED_REQUIRES_CONFIRMATION: NTSTATUS = 0xC0000440;
pub const STATUS_CS_ENCRYPTION_INVALID_SERVER_RESPONSE: NTSTATUS = 0xC0000441;
pub const STATUS_CS_ENCRYPTION_UNSUPPORTED_SERVER: NTSTATUS = 0xC0000442;
pub const STATUS_CS_ENCRYPTION_EXISTING_ENCRYPTED_FILE: NTSTATUS = 0xC0000443;
pub const STATUS_CS_ENCRYPTION_NEW_ENCRYPTED_FILE: NTSTATUS = 0xC0000444;
pub const STATUS_CS_ENCRYPTION_FILE_NOT_CSE: NTSTATUS = 0xC0000445;
pub const STATUS_INVALID_LABEL: NTSTATUS = 0xC0000446;
pub const STATUS_DRIVER_PROCESS_TERMINATED: NTSTATUS = 0xC0000450;
pub const STATUS_AMBIGUOUS_SYSTEM_DEVICE: NTSTATUS = 0xC0000451;
pub const STATUS_SYSTEM_DEVICE_NOT_FOUND: NTSTATUS = 0xC0000452;
pub const STATUS_RESTART_BOOT_APPLICATION: NTSTATUS = 0xC0000453;
pub const STATUS_INSUFFICIENT_NVRAM_RESOURCES: NTSTATUS = 0xC0000454;
pub const STATUS_INVALID_SESSION: NTSTATUS = 0xC0000455;
pub const STATUS_THREAD_ALREADY_IN_SESSION: NTSTATUS = 0xC0000456;
pub const STATUS_THREAD_NOT_IN_SESSION: NTSTATUS = 0xC0000457;
pub const STATUS_INVALID_WEIGHT: NTSTATUS = 0xC0000458;
pub const STATUS_REQUEST_PAUSED: NTSTATUS = 0xC0000459;
pub const STATUS_NO_RANGES_PROCESSED: NTSTATUS = 0xC0000460;
pub const STATUS_DISK_RESOURCES_EXHAUSTED: NTSTATUS = 0xC0000461;
pub const STATUS_NEEDS_REMEDIATION: NTSTATUS = 0xC0000462;
pub const STATUS_DEVICE_FEATURE_NOT_SUPPORTED: NTSTATUS = 0xC0000463;
pub const STATUS_DEVICE_UNREACHABLE: NTSTATUS = 0xC0000464;
pub const STATUS_INVALID_TOKEN: NTSTATUS = 0xC0000465;
pub const STATUS_SERVER_UNAVAILABLE: NTSTATUS = 0xC0000466;
pub const STATUS_FILE_NOT_AVAILABLE: NTSTATUS = 0xC0000467;
pub const STATUS_DEVICE_INSUFFICIENT_RESOURCES: NTSTATUS = 0xC0000468;
pub const STATUS_PACKAGE_UPDATING: NTSTATUS = 0xC0000469;
pub const STATUS_NOT_READ_FROM_COPY: NTSTATUS = 0xC000046A;
pub const STATUS_FT_WRITE_FAILURE: NTSTATUS = 0xC000046B;
pub const STATUS_FT_DI_SCAN_REQUIRED: NTSTATUS = 0xC000046C;
pub const STATUS_OBJECT_NOT_EXTERNALLY_BACKED: NTSTATUS = 0xC000046D;
pub const STATUS_EXTERNAL_BACKING_PROVIDER_UNKNOWN: NTSTATUS = 0xC000046E;
pub const STATUS_COMPRESSION_NOT_BENEFICIAL: NTSTATUS = 0xC000046F;
pub const STATUS_DATA_CHECKSUM_ERROR: NTSTATUS = 0xC0000470;
pub const STATUS_INTERMIXED_KERNEL_EA_OPERATION: NTSTATUS = 0xC0000471;
pub const STATUS_TRIM_READ_ZERO_NOT_SUPPORTED: NTSTATUS = 0xC0000472;
pub const STATUS_TOO_MANY_SEGMENT_DESCRIPTORS: NTSTATUS = 0xC0000473;
pub const STATUS_INVALID_OFFSET_ALIGNMENT: NTSTATUS = 0xC0000474;
pub const STATUS_INVALID_FIELD_IN_PARAMETER_LIST: NTSTATUS = 0xC0000475;
pub const STATUS_OPERATION_IN_PROGRESS: NTSTATUS = 0xC0000476;
pub const STATUS_INVALID_INITIATOR_TARGET_PATH: NTSTATUS = 0xC0000477;
pub const STATUS_SCRUB_DATA_DISABLED: NTSTATUS = 0xC0000478;
pub const STATUS_NOT_REDUNDANT_STORAGE: NTSTATUS = 0xC0000479;
pub const STATUS_RESIDENT_FILE_NOT_SUPPORTED: NTSTATUS = 0xC000047A;
pub const STATUS_COMPRESSED_FILE_NOT_SUPPORTED: NTSTATUS = 0xC000047B;
pub const STATUS_DIRECTORY_NOT_SUPPORTED: NTSTATUS = 0xC000047C;
pub const STATUS_IO_OPERATION_TIMEOUT: NTSTATUS = 0xC000047D;
pub const STATUS_SYSTEM_NEEDS_REMEDIATION: NTSTATUS = 0xC000047E;
pub const STATUS_APPX_INTEGRITY_FAILURE_CLR_NGEN: NTSTATUS = 0xC000047F;
pub const STATUS_SHARE_UNAVAILABLE: NTSTATUS = 0xC0000480;
pub const STATUS_APISET_NOT_HOSTED: NTSTATUS = 0xC0000481;
pub const STATUS_APISET_NOT_PRESENT: NTSTATUS = 0xC0000482;
pub const STATUS_DEVICE_HARDWARE_ERROR: NTSTATUS = 0xC0000483;
pub const STATUS_FIRMWARE_SLOT_INVALID: NTSTATUS = 0xC0000484;
pub const STATUS_FIRMWARE_IMAGE_INVALID: NTSTATUS = 0xC0000485;
pub const STATUS_STORAGE_TOPOLOGY_ID_MISMATCH: NTSTATUS = 0xC0000486;
pub const STATUS_WIM_NOT_BOOTABLE: NTSTATUS = 0xC0000487;
pub const STATUS_BLOCKED_BY_PARENTAL_CONTROLS: NTSTATUS = 0xC0000488;
pub const STATUS_NEEDS_REGISTRATION: NTSTATUS = 0xC0000489;
pub const STATUS_QUOTA_ACTIVITY: NTSTATUS = 0xC000048A;
pub const STATUS_CALLBACK_INVOKE_INLINE: NTSTATUS = 0xC000048B;
pub const STATUS_BLOCK_TOO_MANY_REFERENCES: NTSTATUS = 0xC000048C;
pub const STATUS_MARKED_TO_DISALLOW_WRITES: NTSTATUS = 0xC000048D;
pub const STATUS_NETWORK_ACCESS_DENIED_EDP: NTSTATUS = 0xC000048E;
pub const STATUS_ENCLAVE_FAILURE: NTSTATUS = 0xC000048F;
pub const STATUS_PNP_NO_COMPAT_DRIVERS: NTSTATUS = 0xC0000490;
pub const STATUS_PNP_DRIVER_PACKAGE_NOT_FOUND: NTSTATUS = 0xC0000491;
pub const STATUS_PNP_DRIVER_CONFIGURATION_NOT_FOUND: NTSTATUS = 0xC0000492;
pub const STATUS_PNP_DRIVER_CONFIGURATION_INCOMPLETE: NTSTATUS = 0xC0000493;
pub const STATUS_PNP_FUNCTION_DRIVER_REQUIRED: NTSTATUS = 0xC0000494;
pub const STATUS_PNP_DEVICE_CONFIGURATION_PENDING: NTSTATUS = 0xC0000495;
pub const STATUS_DEVICE_HINT_NAME_BUFFER_TOO_SMALL: NTSTATUS = 0xC0000496;
pub const STATUS_PACKAGE_NOT_AVAILABLE: NTSTATUS = 0xC0000497;
pub const STATUS_DEVICE_IN_MAINTENANCE: NTSTATUS = 0xC0000499;
pub const STATUS_NOT_SUPPORTED_ON_DAX: NTSTATUS = 0xC000049A;
pub const STATUS_FREE_SPACE_TOO_FRAGMENTED: NTSTATUS = 0xC000049B;
pub const STATUS_DAX_MAPPING_EXISTS: NTSTATUS = 0xC000049C;
pub const STATUS_CHILD_PROCESS_BLOCKED: NTSTATUS = 0xC000049D;
pub const STATUS_STORAGE_LOST_DATA_PERSISTENCE: NTSTATUS = 0xC000049E;
pub const STATUS_INVALID_TASK_NAME: NTSTATUS = 0xC0000500;
pub const STATUS_INVALID_TASK_INDEX: NTSTATUS = 0xC0000501;
pub const STATUS_THREAD_ALREADY_IN_TASK: NTSTATUS = 0xC0000502;
pub const STATUS_CALLBACK_BYPASS: NTSTATUS = 0xC0000503;
pub const STATUS_UNDEFINED_SCOPE: NTSTATUS = 0xC0000504;
pub const STATUS_INVALID_CAP: NTSTATUS = 0xC0000505;
pub const STATUS_NOT_GUI_PROCESS: NTSTATUS = 0xC0000506;
pub const STATUS_DEVICE_HUNG: NTSTATUS = 0xC0000507;
pub const STATUS_CONTAINER_ASSIGNED: NTSTATUS = 0xC0000508;
pub const STATUS_JOB_NO_CONTAINER: NTSTATUS = 0xC0000509;
pub const STATUS_DEVICE_UNRESPONSIVE: NTSTATUS = 0xC000050A;
pub const STATUS_REPARSE_POINT_ENCOUNTERED: NTSTATUS = 0xC000050B;
pub const STATUS_FAIL_FAST_EXCEPTION: NTSTATUS = 0xC0000602;
pub const STATUS_IMAGE_CERT_REVOKED: NTSTATUS = 0xC0000603;
pub const STATUS_DYNAMIC_CODE_BLOCKED: NTSTATUS = 0xC0000604;
pub const STATUS_IMAGE_CERT_EXPIRED: NTSTATUS = 0xC0000605;
pub const STATUS_PORT_CLOSED: NTSTATUS = 0xC0000700;
pub const STATUS_MESSAGE_LOST: NTSTATUS = 0xC0000701;
pub const STATUS_INVALID_MESSAGE: NTSTATUS = 0xC0000702;
pub const STATUS_REQUEST_CANCELED: NTSTATUS = 0xC0000703;
pub const STATUS_RECURSIVE_DISPATCH: NTSTATUS = 0xC0000704;
pub const STATUS_LPC_RECEIVE_BUFFER_EXPECTED: NTSTATUS = 0xC0000705;
pub const STATUS_LPC_INVALID_CONNECTION_USAGE: NTSTATUS = 0xC0000706;
pub const STATUS_LPC_REQUESTS_NOT_ALLOWED: NTSTATUS = 0xC0000707;
pub const STATUS_RESOURCE_IN_USE: NTSTATUS = 0xC0000708;
pub const STATUS_HARDWARE_MEMORY_ERROR: NTSTATUS = 0xC0000709;
pub const STATUS_THREADPOOL_HANDLE_EXCEPTION: NTSTATUS = 0xC000070A;
pub const STATUS_THREADPOOL_SET_EVENT_ON_COMPLETION_FAILED: NTSTATUS = 0xC000070B;
pub const STATUS_THREADPOOL_RELEASE_SEMAPHORE_ON_COMPLETION_FAILED: NTSTATUS
    = 0xC000070C;
pub const STATUS_THREADPOOL_RELEASE_MUTEX_ON_COMPLETION_FAILED: NTSTATUS = 0xC000070D;
pub const STATUS_THREADPOOL_FREE_LIBRARY_ON_COMPLETION_FAILED: NTSTATUS = 0xC000070E;
pub const STATUS_THREADPOOL_RELEASED_DURING_OPERATION: NTSTATUS = 0xC000070F;
pub const STATUS_CALLBACK_RETURNED_WHILE_IMPERSONATING: NTSTATUS = 0xC0000710;
pub const STATUS_APC_RETURNED_WHILE_IMPERSONATING: NTSTATUS = 0xC0000711;
pub const STATUS_PROCESS_IS_PROTECTED: NTSTATUS = 0xC0000712;
pub const STATUS_MCA_EXCEPTION: NTSTATUS = 0xC0000713;
pub const STATUS_CERTIFICATE_MAPPING_NOT_UNIQUE: NTSTATUS = 0xC0000714;
pub const STATUS_SYMLINK_CLASS_DISABLED: NTSTATUS = 0xC0000715;
pub const STATUS_INVALID_IDN_NORMALIZATION: NTSTATUS = 0xC0000716;
pub const STATUS_NO_UNICODE_TRANSLATION: NTSTATUS = 0xC0000717;
pub const STATUS_ALREADY_REGISTERED: NTSTATUS = 0xC0000718;
pub const STATUS_CONTEXT_MISMATCH: NTSTATUS = 0xC0000719;
pub const STATUS_PORT_ALREADY_HAS_COMPLETION_LIST: NTSTATUS = 0xC000071A;
pub const STATUS_CALLBACK_RETURNED_THREAD_PRIORITY: NTSTATUS = 0xC000071B;
pub const STATUS_INVALID_THREAD: NTSTATUS = 0xC000071C;
pub const STATUS_CALLBACK_RETURNED_TRANSACTION: NTSTATUS = 0xC000071D;
pub const STATUS_CALLBACK_RETURNED_LDR_LOCK: NTSTATUS = 0xC000071E;
pub const STATUS_CALLBACK_RETURNED_LANG: NTSTATUS = 0xC000071F;
pub const STATUS_CALLBACK_RETURNED_PRI_BACK: NTSTATUS = 0xC0000720;
pub const STATUS_CALLBACK_RETURNED_THREAD_AFFINITY: NTSTATUS = 0xC0000721;
pub const STATUS_LPC_HANDLE_COUNT_EXCEEDED: NTSTATUS = 0xC0000722;
pub const STATUS_DISK_REPAIR_DISABLED: NTSTATUS = 0xC0000800;
pub const STATUS_DS_DOMAIN_RENAME_IN_PROGRESS: NTSTATUS = 0xC0000801;
pub const STATUS_DISK_QUOTA_EXCEEDED: NTSTATUS = 0xC0000802;
pub const STATUS_DATA_LOST_REPAIR: NTSTATUS = 0x80000803;
pub const STATUS_CONTENT_BLOCKED: NTSTATUS = 0xC0000804;
pub const STATUS_BAD_CLUSTERS: NTSTATUS = 0xC0000805;
pub const STATUS_VOLUME_DIRTY: NTSTATUS = 0xC0000806;
pub const STATUS_DISK_REPAIR_REDIRECTED: NTSTATUS = 0x40000807;
pub const STATUS_DISK_REPAIR_UNSUCCESSFUL: NTSTATUS = 0xC0000808;
pub const STATUS_CORRUPT_LOG_OVERFULL: NTSTATUS = 0xC0000809;
pub const STATUS_CORRUPT_LOG_CORRUPTED: NTSTATUS = 0xC000080A;
pub const STATUS_CORRUPT_LOG_UNAVAILABLE: NTSTATUS = 0xC000080B;
pub const STATUS_CORRUPT_LOG_DELETED_FULL: NTSTATUS = 0xC000080C;
pub const STATUS_CORRUPT_LOG_CLEARED: NTSTATUS = 0xC000080D;
pub const STATUS_ORPHAN_NAME_EXHAUSTED: NTSTATUS = 0xC000080E;
pub const STATUS_PROACTIVE_SCAN_IN_PROGRESS: NTSTATUS = 0xC000080F;
pub const STATUS_ENCRYPTED_IO_NOT_POSSIBLE: NTSTATUS = 0xC0000810;
pub const STATUS_CORRUPT_LOG_UPLEVEL_RECORDS: NTSTATUS = 0xC0000811;
pub const STATUS_FILE_CHECKED_OUT: NTSTATUS = 0xC0000901;
pub const STATUS_CHECKOUT_REQUIRED: NTSTATUS = 0xC0000902;
pub const STATUS_BAD_FILE_TYPE: NTSTATUS = 0xC0000903;
pub const STATUS_FILE_TOO_LARGE: NTSTATUS = 0xC0000904;
pub const STATUS_FORMS_AUTH_REQUIRED: NTSTATUS = 0xC0000905;
pub const STATUS_VIRUS_INFECTED: NTSTATUS = 0xC0000906;
pub const STATUS_VIRUS_DELETED: NTSTATUS = 0xC0000907;
pub const STATUS_BAD_MCFG_TABLE: NTSTATUS = 0xC0000908;
pub const STATUS_CANNOT_BREAK_OPLOCK: NTSTATUS = 0xC0000909;
pub const STATUS_BAD_KEY: NTSTATUS = 0xC000090A;
pub const STATUS_BAD_DATA: NTSTATUS = 0xC000090B;
pub const STATUS_NO_KEY: NTSTATUS = 0xC000090C;
pub const STATUS_FILE_HANDLE_REVOKED: NTSTATUS = 0xC0000910;
pub const STATUS_WOW_ASSERTION: NTSTATUS = 0xC0009898;
pub const STATUS_INVALID_SIGNATURE: NTSTATUS = 0xC000A000;
pub const STATUS_HMAC_NOT_SUPPORTED: NTSTATUS = 0xC000A001;
pub const STATUS_AUTH_TAG_MISMATCH: NTSTATUS = 0xC000A002;
pub const STATUS_INVALID_STATE_TRANSITION: NTSTATUS = 0xC000A003;
pub const STATUS_INVALID_KERNEL_INFO_VERSION: NTSTATUS = 0xC000A004;
pub const STATUS_INVALID_PEP_INFO_VERSION: NTSTATUS = 0xC000A005;
pub const STATUS_HANDLE_REVOKED: NTSTATUS = 0xC000A006;
pub const STATUS_EOF_ON_GHOSTED_RANGE: NTSTATUS = 0xC000A007;
pub const STATUS_IPSEC_QUEUE_OVERFLOW: NTSTATUS = 0xC000A010;
pub const STATUS_ND_QUEUE_OVERFLOW: NTSTATUS = 0xC000A011;
pub const STATUS_HOPLIMIT_EXCEEDED: NTSTATUS = 0xC000A012;
pub const STATUS_PROTOCOL_NOT_SUPPORTED: NTSTATUS = 0xC000A013;
pub const STATUS_FASTPATH_REJECTED: NTSTATUS = 0xC000A014;
pub const STATUS_LOST_WRITEBEHIND_DATA_NETWORK_DISCONNECTED: NTSTATUS = 0xC000A080;
pub const STATUS_LOST_WRITEBEHIND_DATA_NETWORK_SERVER_ERROR: NTSTATUS = 0xC000A081;
pub const STATUS_LOST_WRITEBEHIND_DATA_LOCAL_DISK_ERROR: NTSTATUS = 0xC000A082;
pub const STATUS_XML_PARSE_ERROR: NTSTATUS = 0xC000A083;
pub const STATUS_XMLDSIG_ERROR: NTSTATUS = 0xC000A084;
pub const STATUS_WRONG_COMPARTMENT: NTSTATUS = 0xC000A085;
pub const STATUS_AUTHIP_FAILURE: NTSTATUS = 0xC000A086;
pub const STATUS_DS_OID_MAPPED_GROUP_CANT_HAVE_MEMBERS: NTSTATUS = 0xC000A087;
pub const STATUS_DS_OID_NOT_FOUND: NTSTATUS = 0xC000A088;
pub const STATUS_INCORRECT_ACCOUNT_TYPE: NTSTATUS = 0xC000A089;
pub const STATUS_HASH_NOT_SUPPORTED: NTSTATUS = 0xC000A100;
pub const STATUS_HASH_NOT_PRESENT: NTSTATUS = 0xC000A101;
pub const STATUS_SECONDARY_IC_PROVIDER_NOT_REGISTERED: NTSTATUS = 0xC000A121;
pub const STATUS_GPIO_CLIENT_INFORMATION_INVALID: NTSTATUS = 0xC000A122;
pub const STATUS_GPIO_VERSION_NOT_SUPPORTED: NTSTATUS = 0xC000A123;
pub const STATUS_GPIO_INVALID_REGISTRATION_PACKET: NTSTATUS = 0xC000A124;
pub const STATUS_GPIO_OPERATION_DENIED: NTSTATUS = 0xC000A125;
pub const STATUS_GPIO_INCOMPATIBLE_CONNECT_MODE: NTSTATUS = 0xC000A126;
pub const STATUS_GPIO_INTERRUPT_ALREADY_UNMASKED: NTSTATUS = 0x8000A127;
pub const STATUS_CANNOT_SWITCH_RUNLEVEL: NTSTATUS = 0xC000A141;
pub const STATUS_INVALID_RUNLEVEL_SETTING: NTSTATUS = 0xC000A142;
pub const STATUS_RUNLEVEL_SWITCH_TIMEOUT: NTSTATUS = 0xC000A143;
pub const STATUS_SERVICES_FAILED_AUTOSTART: NTSTATUS = 0x4000A144;
pub const STATUS_RUNLEVEL_SWITCH_AGENT_TIMEOUT: NTSTATUS = 0xC000A145;
pub const STATUS_RUNLEVEL_SWITCH_IN_PROGRESS: NTSTATUS = 0xC000A146;
pub const STATUS_NOT_APPCONTAINER: NTSTATUS = 0xC000A200;
pub const STATUS_NOT_SUPPORTED_IN_APPCONTAINER: NTSTATUS = 0xC000A201;
pub const STATUS_INVALID_PACKAGE_SID_LENGTH: NTSTATUS = 0xC000A202;
pub const STATUS_APP_DATA_NOT_FOUND: NTSTATUS = 0xC000A281;
pub const STATUS_APP_DATA_EXPIRED: NTSTATUS = 0xC000A282;
pub const STATUS_APP_DATA_CORRUPT: NTSTATUS = 0xC000A283;
pub const STATUS_APP_DATA_LIMIT_EXCEEDED: NTSTATUS = 0xC000A284;
pub const STATUS_APP_DATA_REBOOT_REQUIRED: NTSTATUS = 0xC000A285;
pub const STATUS_OFFLOAD_READ_FLT_NOT_SUPPORTED: NTSTATUS = 0xC000A2A1;
pub const STATUS_OFFLOAD_WRITE_FLT_NOT_SUPPORTED: NTSTATUS = 0xC000A2A2;
pub const STATUS_OFFLOAD_READ_FILE_NOT_SUPPORTED: NTSTATUS = 0xC000A2A3;
pub const STATUS_OFFLOAD_WRITE_FILE_NOT_SUPPORTED: NTSTATUS = 0xC000A2A4;
pub const STATUS_CLOUD_FILE_PROVIDER_UNKNOWN: NTSTATUS = 0xC000CF00;
pub const STATUS_CLOUD_FILE_PROVIDER_NOT_RUNNING: NTSTATUS = 0xC000CF01;
pub const STATUS_CLOUD_FILE_METADATA_CORRUPT: NTSTATUS = 0xC000CF02;
pub const STATUS_CLOUD_FILE_METADATA_TOO_LARGE: NTSTATUS = 0xC000CF03;
pub const STATUS_CLOUD_FILE_PROPERTY_BLOB_TOO_LARGE: NTSTATUS = 0x8000CF04;
pub const DBG_NO_STATE_CHANGE: NTSTATUS = 0xC0010001;
pub const DBG_APP_NOT_IDLE: NTSTATUS = 0xC0010002;
pub const RPC_NT_INVALID_STRING_BINDING: NTSTATUS = 0xC0020001;
pub const RPC_NT_WRONG_KIND_OF_BINDING: NTSTATUS = 0xC0020002;
pub const RPC_NT_INVALID_BINDING: NTSTATUS = 0xC0020003;
pub const RPC_NT_PROTSEQ_NOT_SUPPORTED: NTSTATUS = 0xC0020004;
pub const RPC_NT_INVALID_RPC_PROTSEQ: NTSTATUS = 0xC0020005;
pub const RPC_NT_INVALID_STRING_UUID: NTSTATUS = 0xC0020006;
pub const RPC_NT_INVALID_ENDPOINT_FORMAT: NTSTATUS = 0xC0020007;
pub const RPC_NT_INVALID_NET_ADDR: NTSTATUS = 0xC0020008;
pub const RPC_NT_NO_ENDPOINT_FOUND: NTSTATUS = 0xC0020009;
pub const RPC_NT_INVALID_TIMEOUT: NTSTATUS = 0xC002000A;
pub const RPC_NT_OBJECT_NOT_FOUND: NTSTATUS = 0xC002000B;
pub const RPC_NT_ALREADY_REGISTERED: NTSTATUS = 0xC002000C;
pub const RPC_NT_TYPE_ALREADY_REGISTERED: NTSTATUS = 0xC002000D;
pub const RPC_NT_ALREADY_LISTENING: NTSTATUS = 0xC002000E;
pub const RPC_NT_NO_PROTSEQS_REGISTERED: NTSTATUS = 0xC002000F;
pub const RPC_NT_NOT_LISTENING: NTSTATUS = 0xC0020010;
pub const RPC_NT_UNKNOWN_MGR_TYPE: NTSTATUS = 0xC0020011;
pub const RPC_NT_UNKNOWN_IF: NTSTATUS = 0xC0020012;
pub const RPC_NT_NO_BINDINGS: NTSTATUS = 0xC0020013;
pub const RPC_NT_NO_PROTSEQS: NTSTATUS = 0xC0020014;
pub const RPC_NT_CANT_CREATE_ENDPOINT: NTSTATUS = 0xC0020015;
pub const RPC_NT_OUT_OF_RESOURCES: NTSTATUS = 0xC0020016;
pub const RPC_NT_SERVER_UNAVAILABLE: NTSTATUS = 0xC0020017;
pub const RPC_NT_SERVER_TOO_BUSY: NTSTATUS = 0xC0020018;
pub const RPC_NT_INVALID_NETWORK_OPTIONS: NTSTATUS = 0xC0020019;
pub const RPC_NT_NO_CALL_ACTIVE: NTSTATUS = 0xC002001A;
pub const RPC_NT_CALL_FAILED: NTSTATUS = 0xC002001B;
pub const RPC_NT_CALL_FAILED_DNE: NTSTATUS = 0xC002001C;
pub const RPC_NT_PROTOCOL_ERROR: NTSTATUS = 0xC002001D;
pub const RPC_NT_UNSUPPORTED_TRANS_SYN: NTSTATUS = 0xC002001F;
pub const RPC_NT_UNSUPPORTED_TYPE: NTSTATUS = 0xC0020021;
pub const RPC_NT_INVALID_TAG: NTSTATUS = 0xC0020022;
pub const RPC_NT_INVALID_BOUND: NTSTATUS = 0xC0020023;
pub const RPC_NT_NO_ENTRY_NAME: NTSTATUS = 0xC0020024;
pub const RPC_NT_INVALID_NAME_SYNTAX: NTSTATUS = 0xC0020025;
pub const RPC_NT_UNSUPPORTED_NAME_SYNTAX: NTSTATUS = 0xC0020026;
pub const RPC_NT_UUID_NO_ADDRESS: NTSTATUS = 0xC0020028;
pub const RPC_NT_DUPLICATE_ENDPOINT: NTSTATUS = 0xC0020029;
pub const RPC_NT_UNKNOWN_AUTHN_TYPE: NTSTATUS = 0xC002002A;
pub const RPC_NT_MAX_CALLS_TOO_SMALL: NTSTATUS = 0xC002002B;
pub const RPC_NT_STRING_TOO_LONG: NTSTATUS = 0xC002002C;
pub const RPC_NT_PROTSEQ_NOT_FOUND: NTSTATUS = 0xC002002D;
pub const RPC_NT_PROCNUM_OUT_OF_RANGE: NTSTATUS = 0xC002002E;
pub const RPC_NT_BINDING_HAS_NO_AUTH: NTSTATUS = 0xC002002F;
pub const RPC_NT_UNKNOWN_AUTHN_SERVICE: NTSTATUS = 0xC0020030;
pub const RPC_NT_UNKNOWN_AUTHN_LEVEL: NTSTATUS = 0xC0020031;
pub const RPC_NT_INVALID_AUTH_IDENTITY: NTSTATUS = 0xC0020032;
pub const RPC_NT_UNKNOWN_AUTHZ_SERVICE: NTSTATUS = 0xC0020033;
pub const EPT_NT_INVALID_ENTRY: NTSTATUS = 0xC0020034;
pub const EPT_NT_CANT_PERFORM_OP: NTSTATUS = 0xC0020035;
pub const EPT_NT_NOT_REGISTERED: NTSTATUS = 0xC0020036;
pub const RPC_NT_NOTHING_TO_EXPORT: NTSTATUS = 0xC0020037;
pub const RPC_NT_INCOMPLETE_NAME: NTSTATUS = 0xC0020038;
pub const RPC_NT_INVALID_VERS_OPTION: NTSTATUS = 0xC0020039;
pub const RPC_NT_NO_MORE_MEMBERS: NTSTATUS = 0xC002003A;
pub const RPC_NT_NOT_ALL_OBJS_UNEXPORTED: NTSTATUS = 0xC002003B;
pub const RPC_NT_INTERFACE_NOT_FOUND: NTSTATUS = 0xC002003C;
pub const RPC_NT_ENTRY_ALREADY_EXISTS: NTSTATUS = 0xC002003D;
pub const RPC_NT_ENTRY_NOT_FOUND: NTSTATUS = 0xC002003E;
pub const RPC_NT_NAME_SERVICE_UNAVAILABLE: NTSTATUS = 0xC002003F;
pub const RPC_NT_INVALID_NAF_ID: NTSTATUS = 0xC0020040;
pub const RPC_NT_CANNOT_SUPPORT: NTSTATUS = 0xC0020041;
pub const RPC_NT_NO_CONTEXT_AVAILABLE: NTSTATUS = 0xC0020042;
pub const RPC_NT_INTERNAL_ERROR: NTSTATUS = 0xC0020043;
pub const RPC_NT_ZERO_DIVIDE: NTSTATUS = 0xC0020044;
pub const RPC_NT_ADDRESS_ERROR: NTSTATUS = 0xC0020045;
pub const RPC_NT_FP_DIV_ZERO: NTSTATUS = 0xC0020046;
pub const RPC_NT_FP_UNDERFLOW: NTSTATUS = 0xC0020047;
pub const RPC_NT_FP_OVERFLOW: NTSTATUS = 0xC0020048;
pub const RPC_NT_NO_MORE_ENTRIES: NTSTATUS = 0xC0030001;
pub const RPC_NT_SS_CHAR_TRANS_OPEN_FAIL: NTSTATUS = 0xC0030002;
pub const RPC_NT_SS_CHAR_TRANS_SHORT_FILE: NTSTATUS = 0xC0030003;
pub const RPC_NT_SS_IN_NULL_CONTEXT: NTSTATUS = 0xC0030004;
pub const RPC_NT_SS_CONTEXT_MISMATCH: NTSTATUS = 0xC0030005;
pub const RPC_NT_SS_CONTEXT_DAMAGED: NTSTATUS = 0xC0030006;
pub const RPC_NT_SS_HANDLES_MISMATCH: NTSTATUS = 0xC0030007;
pub const RPC_NT_SS_CANNOT_GET_CALL_HANDLE: NTSTATUS = 0xC0030008;
pub const RPC_NT_NULL_REF_POINTER: NTSTATUS = 0xC0030009;
pub const RPC_NT_ENUM_VALUE_OUT_OF_RANGE: NTSTATUS = 0xC003000A;
pub const RPC_NT_BYTE_COUNT_TOO_SMALL: NTSTATUS = 0xC003000B;
pub const RPC_NT_BAD_STUB_DATA: NTSTATUS = 0xC003000C;
pub const RPC_NT_CALL_IN_PROGRESS: NTSTATUS = 0xC0020049;
pub const RPC_NT_NO_MORE_BINDINGS: NTSTATUS = 0xC002004A;
pub const RPC_NT_GROUP_MEMBER_NOT_FOUND: NTSTATUS = 0xC002004B;
pub const EPT_NT_CANT_CREATE: NTSTATUS = 0xC002004C;
pub const RPC_NT_INVALID_OBJECT: NTSTATUS = 0xC002004D;
pub const RPC_NT_NO_INTERFACES: NTSTATUS = 0xC002004F;
pub const RPC_NT_CALL_CANCELLED: NTSTATUS = 0xC0020050;
pub const RPC_NT_BINDING_INCOMPLETE: NTSTATUS = 0xC0020051;
pub const RPC_NT_COMM_FAILURE: NTSTATUS = 0xC0020052;
pub const RPC_NT_UNSUPPORTED_AUTHN_LEVEL: NTSTATUS = 0xC0020053;
pub const RPC_NT_NO_PRINC_NAME: NTSTATUS = 0xC0020054;
pub const RPC_NT_NOT_RPC_ERROR: NTSTATUS = 0xC0020055;
pub const RPC_NT_UUID_LOCAL_ONLY: NTSTATUS = 0x40020056;
pub const RPC_NT_SEC_PKG_ERROR: NTSTATUS = 0xC0020057;
pub const RPC_NT_NOT_CANCELLED: NTSTATUS = 0xC0020058;
pub const RPC_NT_INVALID_ES_ACTION: NTSTATUS = 0xC0030059;
pub const RPC_NT_WRONG_ES_VERSION: NTSTATUS = 0xC003005A;
pub const RPC_NT_WRONG_STUB_VERSION: NTSTATUS = 0xC003005B;
pub const RPC_NT_INVALID_PIPE_OBJECT: NTSTATUS = 0xC003005C;
pub const RPC_NT_INVALID_PIPE_OPERATION: NTSTATUS = 0xC003005D;
pub const RPC_NT_WRONG_PIPE_VERSION: NTSTATUS = 0xC003005E;
pub const RPC_NT_PIPE_CLOSED: NTSTATUS = 0xC003005F;
pub const RPC_NT_PIPE_DISCIPLINE_ERROR: NTSTATUS = 0xC0030060;
pub const RPC_NT_PIPE_EMPTY: NTSTATUS = 0xC0030061;
pub const RPC_NT_INVALID_ASYNC_HANDLE: NTSTATUS = 0xC0020062;
pub const RPC_NT_INVALID_ASYNC_CALL: NTSTATUS = 0xC0020063;
pub const RPC_NT_PROXY_ACCESS_DENIED: NTSTATUS = 0xC0020064;
pub const RPC_NT_COOKIE_AUTH_FAILED: NTSTATUS = 0xC0020065;
pub const RPC_NT_SEND_INCOMPLETE: NTSTATUS = 0x400200AF;
pub const STATUS_ACPI_INVALID_OPCODE: NTSTATUS = 0xC0140001;
pub const STATUS_ACPI_STACK_OVERFLOW: NTSTATUS = 0xC0140002;
pub const STATUS_ACPI_ASSERT_FAILED: NTSTATUS = 0xC0140003;
pub const STATUS_ACPI_INVALID_INDEX: NTSTATUS = 0xC0140004;
pub const STATUS_ACPI_INVALID_ARGUMENT: NTSTATUS = 0xC0140005;
pub const STATUS_ACPI_FATAL: NTSTATUS = 0xC0140006;
pub const STATUS_ACPI_INVALID_SUPERNAME: NTSTATUS = 0xC0140007;
pub const STATUS_ACPI_INVALID_ARGTYPE: NTSTATUS = 0xC0140008;
pub const STATUS_ACPI_INVALID_OBJTYPE: NTSTATUS = 0xC0140009;
pub const STATUS_ACPI_INVALID_TARGETTYPE: NTSTATUS = 0xC014000A;
pub const STATUS_ACPI_INCORRECT_ARGUMENT_COUNT: NTSTATUS = 0xC014000B;
pub const STATUS_ACPI_ADDRESS_NOT_MAPPED: NTSTATUS = 0xC014000C;
pub const STATUS_ACPI_INVALID_EVENTTYPE: NTSTATUS = 0xC014000D;
pub const STATUS_ACPI_HANDLER_COLLISION: NTSTATUS = 0xC014000E;
pub const STATUS_ACPI_INVALID_DATA: NTSTATUS = 0xC014000F;
pub const STATUS_ACPI_INVALID_REGION: NTSTATUS = 0xC0140010;
pub const STATUS_ACPI_INVALID_ACCESS_SIZE: NTSTATUS = 0xC0140011;
pub const STATUS_ACPI_ACQUIRE_GLOBAL_LOCK: NTSTATUS = 0xC0140012;
pub const STATUS_ACPI_ALREADY_INITIALIZED: NTSTATUS = 0xC0140013;
pub const STATUS_ACPI_NOT_INITIALIZED: NTSTATUS = 0xC0140014;
pub const STATUS_ACPI_INVALID_MUTEX_LEVEL: NTSTATUS = 0xC0140015;
pub const STATUS_ACPI_MUTEX_NOT_OWNED: NTSTATUS = 0xC0140016;
pub const STATUS_ACPI_MUTEX_NOT_OWNER: NTSTATUS = 0xC0140017;
pub const STATUS_ACPI_RS_ACCESS: NTSTATUS = 0xC0140018;
pub const STATUS_ACPI_INVALID_TABLE: NTSTATUS = 0xC0140019;
pub const STATUS_ACPI_REG_HANDLER_FAILED: NTSTATUS = 0xC0140020;
pub const STATUS_ACPI_POWER_REQUEST_FAILED: NTSTATUS = 0xC0140021;
pub const STATUS_CTX_WINSTATION_NAME_INVALID: NTSTATUS = 0xC00A0001;
pub const STATUS_CTX_INVALID_PD: NTSTATUS = 0xC00A0002;
pub const STATUS_CTX_PD_NOT_FOUND: NTSTATUS = 0xC00A0003;
pub const STATUS_CTX_CDM_CONNECT: NTSTATUS = 0x400A0004;
pub const STATUS_CTX_CDM_DISCONNECT: NTSTATUS = 0x400A0005;
pub const STATUS_CTX_CLOSE_PENDING: NTSTATUS = 0xC00A0006;
pub const STATUS_CTX_NO_OUTBUF: NTSTATUS = 0xC00A0007;
pub const STATUS_CTX_MODEM_INF_NOT_FOUND: NTSTATUS = 0xC00A0008;
pub const STATUS_CTX_INVALID_MODEMNAME: NTSTATUS = 0xC00A0009;
pub const STATUS_CTX_RESPONSE_ERROR: NTSTATUS = 0xC00A000A;
pub const STATUS_CTX_MODEM_RESPONSE_TIMEOUT: NTSTATUS = 0xC00A000B;
pub const STATUS_CTX_MODEM_RESPONSE_NO_CARRIER: NTSTATUS = 0xC00A000C;
pub const STATUS_CTX_MODEM_RESPONSE_NO_DIALTONE: NTSTATUS = 0xC00A000D;
pub const STATUS_CTX_MODEM_RESPONSE_BUSY: NTSTATUS = 0xC00A000E;
pub const STATUS_CTX_MODEM_RESPONSE_VOICE: NTSTATUS = 0xC00A000F;
pub const STATUS_CTX_TD_ERROR: NTSTATUS = 0xC00A0010;
pub const STATUS_CTX_LICENSE_CLIENT_INVALID: NTSTATUS = 0xC00A0012;
pub const STATUS_CTX_LICENSE_NOT_AVAILABLE: NTSTATUS = 0xC00A0013;
pub const STATUS_CTX_LICENSE_EXPIRED: NTSTATUS = 0xC00A0014;
pub const STATUS_CTX_WINSTATION_NOT_FOUND: NTSTATUS = 0xC00A0015;
pub const STATUS_CTX_WINSTATION_NAME_COLLISION: NTSTATUS = 0xC00A0016;
pub const STATUS_CTX_WINSTATION_BUSY: NTSTATUS = 0xC00A0017;
pub const STATUS_CTX_BAD_VIDEO_MODE: NTSTATUS = 0xC00A0018;
pub const STATUS_CTX_GRAPHICS_INVALID: NTSTATUS = 0xC00A0022;
pub const STATUS_CTX_NOT_CONSOLE: NTSTATUS = 0xC00A0024;
pub const STATUS_CTX_CLIENT_QUERY_TIMEOUT: NTSTATUS = 0xC00A0026;
pub const STATUS_CTX_CONSOLE_DISCONNECT: NTSTATUS = 0xC00A0027;
pub const STATUS_CTX_CONSOLE_CONNECT: NTSTATUS = 0xC00A0028;
pub const STATUS_CTX_SHADOW_DENIED: NTSTATUS = 0xC00A002A;
pub const STATUS_CTX_WINSTATION_ACCESS_DENIED: NTSTATUS = 0xC00A002B;
pub const STATUS_CTX_INVALID_WD: NTSTATUS = 0xC00A002E;
pub const STATUS_CTX_WD_NOT_FOUND: NTSTATUS = 0xC00A002F;
pub const STATUS_CTX_SHADOW_INVALID: NTSTATUS = 0xC00A0030;
pub const STATUS_CTX_SHADOW_DISABLED: NTSTATUS = 0xC00A0031;
pub const STATUS_RDP_PROTOCOL_ERROR: NTSTATUS = 0xC00A0032;
pub const STATUS_CTX_CLIENT_LICENSE_NOT_SET: NTSTATUS = 0xC00A0033;
pub const STATUS_CTX_CLIENT_LICENSE_IN_USE: NTSTATUS = 0xC00A0034;
pub const STATUS_CTX_SHADOW_ENDED_BY_MODE_CHANGE: NTSTATUS = 0xC00A0035;
pub const STATUS_CTX_SHADOW_NOT_RUNNING: NTSTATUS = 0xC00A0036;
pub const STATUS_CTX_LOGON_DISABLED: NTSTATUS = 0xC00A0037;
pub const STATUS_CTX_SECURITY_LAYER_ERROR: NTSTATUS = 0xC00A0038;
pub const STATUS_TS_INCOMPATIBLE_SESSIONS: NTSTATUS = 0xC00A0039;
pub const STATUS_TS_VIDEO_SUBSYSTEM_ERROR: NTSTATUS = 0xC00A003A;
pub const STATUS_PNP_BAD_MPS_TABLE: NTSTATUS = 0xC0040035;
pub const STATUS_PNP_TRANSLATION_FAILED: NTSTATUS = 0xC0040036;
pub const STATUS_PNP_IRQ_TRANSLATION_FAILED: NTSTATUS = 0xC0040037;
pub const STATUS_PNP_INVALID_ID: NTSTATUS = 0xC0040038;
pub const STATUS_IO_REISSUE_AS_CACHED: NTSTATUS = 0xC0040039;
pub const STATUS_MUI_FILE_NOT_FOUND: NTSTATUS = 0xC00B0001;
pub const STATUS_MUI_INVALID_FILE: NTSTATUS = 0xC00B0002;
pub const STATUS_MUI_INVALID_RC_CONFIG: NTSTATUS = 0xC00B0003;
pub const STATUS_MUI_INVALID_LOCALE_NAME: NTSTATUS = 0xC00B0004;
pub const STATUS_MUI_INVALID_ULTIMATEFALLBACK_NAME: NTSTATUS = 0xC00B0005;
pub const STATUS_MUI_FILE_NOT_LOADED: NTSTATUS = 0xC00B0006;
pub const STATUS_RESOURCE_ENUM_USER_STOP: NTSTATUS = 0xC00B0007;
//FILTER_FLT_NTSTATUS_FROM_HRESULT
pub const STATUS_FLT_NO_HANDLER_DEFINED: NTSTATUS = 0xC01C0001;
pub const STATUS_FLT_CONTEXT_ALREADY_DEFINED: NTSTATUS = 0xC01C0002;
pub const STATUS_FLT_INVALID_ASYNCHRONOUS_REQUEST: NTSTATUS = 0xC01C0003;
pub const STATUS_FLT_DISALLOW_FAST_IO: NTSTATUS = 0xC01C0004;
pub const STATUS_FLT_INVALID_NAME_REQUEST: NTSTATUS = 0xC01C0005;
pub const STATUS_FLT_NOT_SAFE_TO_POST_OPERATION: NTSTATUS = 0xC01C0006;
pub const STATUS_FLT_NOT_INITIALIZED: NTSTATUS = 0xC01C0007;
pub const STATUS_FLT_FILTER_NOT_READY: NTSTATUS = 0xC01C0008;
pub const STATUS_FLT_POST_OPERATION_CLEANUP: NTSTATUS = 0xC01C0009;
pub const STATUS_FLT_INTERNAL_ERROR: NTSTATUS = 0xC01C000A;
pub const STATUS_FLT_DELETING_OBJECT: NTSTATUS = 0xC01C000B;
pub const STATUS_FLT_MUST_BE_NONPAGED_POOL: NTSTATUS = 0xC01C000C;
pub const STATUS_FLT_DUPLICATE_ENTRY: NTSTATUS = 0xC01C000D;
pub const STATUS_FLT_CBDQ_DISABLED: NTSTATUS = 0xC01C000E;
pub const STATUS_FLT_DO_NOT_ATTACH: NTSTATUS = 0xC01C000F;
pub const STATUS_FLT_DO_NOT_DETACH: NTSTATUS = 0xC01C0010;
pub const STATUS_FLT_INSTANCE_ALTITUDE_COLLISION: NTSTATUS = 0xC01C0011;
pub const STATUS_FLT_INSTANCE_NAME_COLLISION: NTSTATUS = 0xC01C0012;
pub const STATUS_FLT_FILTER_NOT_FOUND: NTSTATUS = 0xC01C0013;
pub const STATUS_FLT_VOLUME_NOT_FOUND: NTSTATUS = 0xC01C0014;
pub const STATUS_FLT_INSTANCE_NOT_FOUND: NTSTATUS = 0xC01C0015;
pub const STATUS_FLT_CONTEXT_ALLOCATION_NOT_FOUND: NTSTATUS = 0xC01C0016;
pub const STATUS_FLT_INVALID_CONTEXT_REGISTRATION: NTSTATUS = 0xC01C0017;
pub const STATUS_FLT_NAME_CACHE_MISS: NTSTATUS = 0xC01C0018;
pub const STATUS_FLT_NO_DEVICE_OBJECT: NTSTATUS = 0xC01C0019;
pub const STATUS_FLT_VOLUME_ALREADY_MOUNTED: NTSTATUS = 0xC01C001A;
pub const STATUS_FLT_ALREADY_ENLISTED: NTSTATUS = 0xC01C001B;
pub const STATUS_FLT_CONTEXT_ALREADY_LINKED: NTSTATUS = 0xC01C001C;
pub const STATUS_FLT_NO_WAITER_FOR_REPLY: NTSTATUS = 0xC01C0020;
pub const STATUS_FLT_REGISTRATION_BUSY: NTSTATUS = 0xC01C0023;
pub const STATUS_SXS_SECTION_NOT_FOUND: NTSTATUS = 0xC0150001;
pub const STATUS_SXS_CANT_GEN_ACTCTX: NTSTATUS = 0xC0150002;
pub const STATUS_SXS_INVALID_ACTCTXDATA_FORMAT: NTSTATUS = 0xC0150003;
pub const STATUS_SXS_ASSEMBLY_NOT_FOUND: NTSTATUS = 0xC0150004;
pub const STATUS_SXS_MANIFEST_FORMAT_ERROR: NTSTATUS = 0xC0150005;
pub const STATUS_SXS_MANIFEST_PARSE_ERROR: NTSTATUS = 0xC0150006;
pub const STATUS_SXS_ACTIVATION_CONTEXT_DISABLED: NTSTATUS = 0xC0150007;
pub const STATUS_SXS_KEY_NOT_FOUND: NTSTATUS = 0xC0150008;
pub const STATUS_SXS_VERSION_CONFLICT: NTSTATUS = 0xC0150009;
pub const STATUS_SXS_WRONG_SECTION_TYPE: NTSTATUS = 0xC015000A;
pub const STATUS_SXS_THREAD_QUERIES_DISABLED: NTSTATUS = 0xC015000B;
pub const STATUS_SXS_ASSEMBLY_MISSING: NTSTATUS = 0xC015000C;
pub const STATUS_SXS_RELEASE_ACTIVATION_CONTEXT: NTSTATUS = 0x4015000D;
pub const STATUS_SXS_PROCESS_DEFAULT_ALREADY_SET: NTSTATUS = 0xC015000E;
pub const STATUS_SXS_EARLY_DEACTIVATION: NTSTATUS = 0xC015000F;
pub const STATUS_SXS_INVALID_DEACTIVATION: NTSTATUS = 0xC0150010;
pub const STATUS_SXS_MULTIPLE_DEACTIVATION: NTSTATUS = 0xC0150011;
pub const STATUS_SXS_SYSTEM_DEFAULT_ACTIVATION_CONTEXT_EMPTY: NTSTATUS = 0xC0150012;
pub const STATUS_SXS_PROCESS_TERMINATION_REQUESTED: NTSTATUS = 0xC0150013;
pub const STATUS_SXS_CORRUPT_ACTIVATION_STACK: NTSTATUS = 0xC0150014;
pub const STATUS_SXS_CORRUPTION: NTSTATUS = 0xC0150015;
pub const STATUS_SXS_INVALID_IDENTITY_ATTRIBUTE_VALUE: NTSTATUS = 0xC0150016;
pub const STATUS_SXS_INVALID_IDENTITY_ATTRIBUTE_NAME: NTSTATUS = 0xC0150017;
pub const STATUS_SXS_IDENTITY_DUPLICATE_ATTRIBUTE: NTSTATUS = 0xC0150018;
pub const STATUS_SXS_IDENTITY_PARSE_ERROR: NTSTATUS = 0xC0150019;
pub const STATUS_SXS_COMPONENT_STORE_CORRUPT: NTSTATUS = 0xC015001A;
pub const STATUS_SXS_FILE_HASH_MISMATCH: NTSTATUS = 0xC015001B;
pub const STATUS_SXS_MANIFEST_IDENTITY_SAME_BUT_CONTENTS_DIFFERENT: NTSTATUS
    = 0xC015001C;
pub const STATUS_SXS_IDENTITIES_DIFFERENT: NTSTATUS = 0xC015001D;
pub const STATUS_SXS_ASSEMBLY_IS_NOT_A_DEPLOYMENT: NTSTATUS = 0xC015001E;
pub const STATUS_SXS_FILE_NOT_PART_OF_ASSEMBLY: NTSTATUS = 0xC015001F;
pub const STATUS_ADVANCED_INSTALLER_FAILED: NTSTATUS = 0xC0150020;
pub const STATUS_XML_ENCODING_MISMATCH: NTSTATUS = 0xC0150021;
pub const STATUS_SXS_MANIFEST_TOO_BIG: NTSTATUS = 0xC0150022;
pub const STATUS_SXS_SETTING_NOT_REGISTERED: NTSTATUS = 0xC0150023;
pub const STATUS_SXS_TRANSACTION_CLOSURE_INCOMPLETE: NTSTATUS = 0xC0150024;
pub const STATUS_SMI_PRIMITIVE_INSTALLER_FAILED: NTSTATUS = 0xC0150025;
pub const STATUS_GENERIC_COMMAND_FAILED: NTSTATUS = 0xC0150026;
pub const STATUS_SXS_FILE_HASH_MISSING: NTSTATUS = 0xC0150027;
pub const STATUS_CLUSTER_INVALID_NODE: NTSTATUS = 0xC0130001;
pub const STATUS_CLUSTER_NODE_EXISTS: NTSTATUS = 0xC0130002;
pub const STATUS_CLUSTER_JOIN_IN_PROGRESS: NTSTATUS = 0xC0130003;
pub const STATUS_CLUSTER_NODE_NOT_FOUND: NTSTATUS = 0xC0130004;
pub const STATUS_CLUSTER_LOCAL_NODE_NOT_FOUND: NTSTATUS = 0xC0130005;
pub const STATUS_CLUSTER_NETWORK_EXISTS: NTSTATUS = 0xC0130006;
pub const STATUS_CLUSTER_NETWORK_NOT_FOUND: NTSTATUS = 0xC0130007;
pub const STATUS_CLUSTER_NETINTERFACE_EXISTS: NTSTATUS = 0xC0130008;
pub const STATUS_CLUSTER_NETINTERFACE_NOT_FOUND: NTSTATUS = 0xC0130009;
pub const STATUS_CLUSTER_INVALID_REQUEST: NTSTATUS = 0xC013000A;
pub const STATUS_CLUSTER_INVALID_NETWORK_PROVIDER: NTSTATUS = 0xC013000B;
pub const STATUS_CLUSTER_NODE_DOWN: NTSTATUS = 0xC013000C;
pub const STATUS_CLUSTER_NODE_UNREACHABLE: NTSTATUS = 0xC013000D;
pub const STATUS_CLUSTER_NODE_NOT_MEMBER: NTSTATUS = 0xC013000E;
pub const STATUS_CLUSTER_JOIN_NOT_IN_PROGRESS: NTSTATUS = 0xC013000F;
pub const STATUS_CLUSTER_INVALID_NETWORK: NTSTATUS = 0xC0130010;
pub const STATUS_CLUSTER_NO_NET_ADAPTERS: NTSTATUS = 0xC0130011;
pub const STATUS_CLUSTER_NODE_UP: NTSTATUS = 0xC0130012;
pub const STATUS_CLUSTER_NODE_PAUSED: NTSTATUS = 0xC0130013;
pub const STATUS_CLUSTER_NODE_NOT_PAUSED: NTSTATUS = 0xC0130014;
pub const STATUS_CLUSTER_NO_SECURITY_CONTEXT: NTSTATUS = 0xC0130015;
pub const STATUS_CLUSTER_NETWORK_NOT_INTERNAL: NTSTATUS = 0xC0130016;
pub const STATUS_CLUSTER_POISONED: NTSTATUS = 0xC0130017;
pub const STATUS_CLUSTER_NON_CSV_PATH: NTSTATUS = 0xC0130018;
pub const STATUS_CLUSTER_CSV_VOLUME_NOT_LOCAL: NTSTATUS = 0xC0130019;
pub const STATUS_CLUSTER_CSV_READ_OPLOCK_BREAK_IN_PROGRESS: NTSTATUS = 0xC0130020;
pub const STATUS_CLUSTER_CSV_AUTO_PAUSE_ERROR: NTSTATUS = 0xC0130021;
pub const STATUS_CLUSTER_CSV_REDIRECTED: NTSTATUS = 0xC0130022;
pub const STATUS_CLUSTER_CSV_NOT_REDIRECTED: NTSTATUS = 0xC0130023;
pub const STATUS_CLUSTER_CSV_VOLUME_DRAINING: NTSTATUS = 0xC0130024;
pub const STATUS_CLUSTER_CSV_SNAPSHOT_CREATION_IN_PROGRESS: NTSTATUS = 0xC0130025;
pub const STATUS_CLUSTER_CSV_VOLUME_DRAINING_SUCCEEDED_DOWNLEVEL: NTSTATUS = 0xC0130026;
pub const STATUS_CLUSTER_CSV_NO_SNAPSHOTS: NTSTATUS = 0xC0130027;
pub const STATUS_CSV_IO_PAUSE_TIMEOUT: NTSTATUS = 0xC0130028;
pub const STATUS_CLUSTER_CSV_INVALID_HANDLE: NTSTATUS = 0xC0130029;
pub const STATUS_CLUSTER_CSV_SUPPORTED_ONLY_ON_COORDINATOR: NTSTATUS = 0xC0130030;
pub const STATUS_TRANSACTIONAL_CONFLICT: NTSTATUS = 0xC0190001;
pub const STATUS_INVALID_TRANSACTION: NTSTATUS = 0xC0190002;
pub const STATUS_TRANSACTION_NOT_ACTIVE: NTSTATUS = 0xC0190003;
pub const STATUS_TM_INITIALIZATION_FAILED: NTSTATUS = 0xC0190004;
pub const STATUS_RM_NOT_ACTIVE: NTSTATUS = 0xC0190005;
pub const STATUS_RM_METADATA_CORRUPT: NTSTATUS = 0xC0190006;
pub const STATUS_TRANSACTION_NOT_JOINED: NTSTATUS = 0xC0190007;
pub const STATUS_DIRECTORY_NOT_RM: NTSTATUS = 0xC0190008;
pub const STATUS_COULD_NOT_RESIZE_LOG: NTSTATUS = 0x80190009;
pub const STATUS_TRANSACTIONS_UNSUPPORTED_REMOTE: NTSTATUS = 0xC019000A;
pub const STATUS_LOG_RESIZE_INVALID_SIZE: NTSTATUS = 0xC019000B;
pub const STATUS_REMOTE_FILE_VERSION_MISMATCH: NTSTATUS = 0xC019000C;
pub const STATUS_CRM_PROTOCOL_ALREADY_EXISTS: NTSTATUS = 0xC019000F;
pub const STATUS_TRANSACTION_PROPAGATION_FAILED: NTSTATUS = 0xC0190010;
pub const STATUS_CRM_PROTOCOL_NOT_FOUND: NTSTATUS = 0xC0190011;
pub const STATUS_TRANSACTION_SUPERIOR_EXISTS: NTSTATUS = 0xC0190012;
pub const STATUS_TRANSACTION_REQUEST_NOT_VALID: NTSTATUS = 0xC0190013;
pub const STATUS_TRANSACTION_NOT_REQUESTED: NTSTATUS = 0xC0190014;
pub const STATUS_TRANSACTION_ALREADY_ABORTED: NTSTATUS = 0xC0190015;
pub const STATUS_TRANSACTION_ALREADY_COMMITTED: NTSTATUS = 0xC0190016;
pub const STATUS_TRANSACTION_INVALID_MARSHALL_BUFFER: NTSTATUS = 0xC0190017;
pub const STATUS_CURRENT_TRANSACTION_NOT_VALID: NTSTATUS = 0xC0190018;
pub const STATUS_LOG_GROWTH_FAILED: NTSTATUS = 0xC0190019;
pub const STATUS_OBJECT_NO_LONGER_EXISTS: NTSTATUS = 0xC0190021;
pub const STATUS_STREAM_MINIVERSION_NOT_FOUND: NTSTATUS = 0xC0190022;
pub const STATUS_STREAM_MINIVERSION_NOT_VALID: NTSTATUS = 0xC0190023;
pub const STATUS_MINIVERSION_INACCESSIBLE_FROM_SPECIFIED_TRANSACTION: NTSTATUS
    = 0xC0190024;
pub const STATUS_CANT_OPEN_MINIVERSION_WITH_MODIFY_INTENT: NTSTATUS = 0xC0190025;
pub const STATUS_CANT_CREATE_MORE_STREAM_MINIVERSIONS: NTSTATUS = 0xC0190026;
pub const STATUS_HANDLE_NO_LONGER_VALID: NTSTATUS = 0xC0190028;
pub const STATUS_NO_TXF_METADATA: NTSTATUS = 0x80190029;
pub const STATUS_LOG_CORRUPTION_DETECTED: NTSTATUS = 0xC0190030;
pub const STATUS_CANT_RECOVER_WITH_HANDLE_OPEN: NTSTATUS = 0x80190031;
pub const STATUS_RM_DISCONNECTED: NTSTATUS = 0xC0190032;
pub const STATUS_ENLISTMENT_NOT_SUPERIOR: NTSTATUS = 0xC0190033;
pub const STATUS_RECOVERY_NOT_NEEDED: NTSTATUS = 0x40190034;
pub const STATUS_RM_ALREADY_STARTED: NTSTATUS = 0x40190035;
pub const STATUS_FILE_IDENTITY_NOT_PERSISTENT: NTSTATUS = 0xC0190036;
pub const STATUS_CANT_BREAK_TRANSACTIONAL_DEPENDENCY: NTSTATUS = 0xC0190037;
pub const STATUS_CANT_CROSS_RM_BOUNDARY: NTSTATUS = 0xC0190038;
pub const STATUS_TXF_DIR_NOT_EMPTY: NTSTATUS = 0xC0190039;
pub const STATUS_INDOUBT_TRANSACTIONS_EXIST: NTSTATUS = 0xC019003A;
pub const STATUS_TM_VOLATILE: NTSTATUS = 0xC019003B;
pub const STATUS_ROLLBACK_TIMER_EXPIRED: NTSTATUS = 0xC019003C;
pub const STATUS_TXF_ATTRIBUTE_CORRUPT: NTSTATUS = 0xC019003D;
pub const STATUS_EFS_NOT_ALLOWED_IN_TRANSACTION: NTSTATUS = 0xC019003E;
pub const STATUS_TRANSACTIONAL_OPEN_NOT_ALLOWED: NTSTATUS = 0xC019003F;
pub const STATUS_TRANSACTED_MAPPING_UNSUPPORTED_REMOTE: NTSTATUS = 0xC0190040;
pub const STATUS_TXF_METADATA_ALREADY_PRESENT: NTSTATUS = 0x80190041;
pub const STATUS_TRANSACTION_SCOPE_CALLBACKS_NOT_SET: NTSTATUS = 0x80190042;
pub const STATUS_TRANSACTION_REQUIRED_PROMOTION: NTSTATUS = 0xC0190043;
pub const STATUS_CANNOT_EXECUTE_FILE_IN_TRANSACTION: NTSTATUS = 0xC0190044;
pub const STATUS_TRANSACTIONS_NOT_FROZEN: NTSTATUS = 0xC0190045;
pub const STATUS_TRANSACTION_FREEZE_IN_PROGRESS: NTSTATUS = 0xC0190046;
pub const STATUS_NOT_SNAPSHOT_VOLUME: NTSTATUS = 0xC0190047;
pub const STATUS_NO_SAVEPOINT_WITH_OPEN_FILES: NTSTATUS = 0xC0190048;
pub const STATUS_SPARSE_NOT_ALLOWED_IN_TRANSACTION: NTSTATUS = 0xC0190049;
pub const STATUS_TM_IDENTITY_MISMATCH: NTSTATUS = 0xC019004A;
pub const STATUS_FLOATED_SECTION: NTSTATUS = 0xC019004B;
pub const STATUS_CANNOT_ACCEPT_TRANSACTED_WORK: NTSTATUS = 0xC019004C;
pub const STATUS_CANNOT_ABORT_TRANSACTIONS: NTSTATUS = 0xC019004D;
pub const STATUS_TRANSACTION_NOT_FOUND: NTSTATUS = 0xC019004E;
pub const STATUS_RESOURCEMANAGER_NOT_FOUND: NTSTATUS = 0xC019004F;
pub const STATUS_ENLISTMENT_NOT_FOUND: NTSTATUS = 0xC0190050;
pub const STATUS_TRANSACTIONMANAGER_NOT_FOUND: NTSTATUS = 0xC0190051;
pub const STATUS_TRANSACTIONMANAGER_NOT_ONLINE: NTSTATUS = 0xC0190052;
pub const STATUS_TRANSACTIONMANAGER_RECOVERY_NAME_COLLISION: NTSTATUS = 0xC0190053;
pub const STATUS_TRANSACTION_NOT_ROOT: NTSTATUS = 0xC0190054;
pub const STATUS_TRANSACTION_OBJECT_EXPIRED: NTSTATUS = 0xC0190055;
pub const STATUS_COMPRESSION_NOT_ALLOWED_IN_TRANSACTION: NTSTATUS = 0xC0190056;
pub const STATUS_TRANSACTION_RESPONSE_NOT_ENLISTED: NTSTATUS = 0xC0190057;
pub const STATUS_TRANSACTION_RECORD_TOO_LONG: NTSTATUS = 0xC0190058;
pub const STATUS_NO_LINK_TRACKING_IN_TRANSACTION: NTSTATUS = 0xC0190059;
pub const STATUS_OPERATION_NOT_SUPPORTED_IN_TRANSACTION: NTSTATUS = 0xC019005A;
pub const STATUS_TRANSACTION_INTEGRITY_VIOLATED: NTSTATUS = 0xC019005B;
pub const STATUS_TRANSACTIONMANAGER_IDENTITY_MISMATCH: NTSTATUS = 0xC019005C;
pub const STATUS_RM_CANNOT_BE_FROZEN_FOR_SNAPSHOT: NTSTATUS = 0xC019005D;
pub const STATUS_TRANSACTION_MUST_WRITETHROUGH: NTSTATUS = 0xC019005E;
pub const STATUS_TRANSACTION_NO_SUPERIOR: NTSTATUS = 0xC019005F;
pub const STATUS_EXPIRED_HANDLE: NTSTATUS = 0xC0190060;
pub const STATUS_TRANSACTION_NOT_ENLISTED: NTSTATUS = 0xC0190061;
pub const STATUS_LOG_SECTOR_INVALID: NTSTATUS = 0xC01A0001;
pub const STATUS_LOG_SECTOR_PARITY_INVALID: NTSTATUS = 0xC01A0002;
pub const STATUS_LOG_SECTOR_REMAPPED: NTSTATUS = 0xC01A0003;
pub const STATUS_LOG_BLOCK_INCOMPLETE: NTSTATUS = 0xC01A0004;
pub const STATUS_LOG_INVALID_RANGE: NTSTATUS = 0xC01A0005;
pub const STATUS_LOG_BLOCKS_EXHAUSTED: NTSTATUS = 0xC01A0006;
pub const STATUS_LOG_READ_CONTEXT_INVALID: NTSTATUS = 0xC01A0007;
pub const STATUS_LOG_RESTART_INVALID: NTSTATUS = 0xC01A0008;
pub const STATUS_LOG_BLOCK_VERSION: NTSTATUS = 0xC01A0009;
pub const STATUS_LOG_BLOCK_INVALID: NTSTATUS = 0xC01A000A;
pub const STATUS_LOG_READ_MODE_INVALID: NTSTATUS = 0xC01A000B;
pub const STATUS_LOG_NO_RESTART: NTSTATUS = 0x401A000C;
pub const STATUS_LOG_METADATA_CORRUPT: NTSTATUS = 0xC01A000D;
pub const STATUS_LOG_METADATA_INVALID: NTSTATUS = 0xC01A000E;
pub const STATUS_LOG_METADATA_INCONSISTENT: NTSTATUS = 0xC01A000F;
pub const STATUS_LOG_RESERVATION_INVALID: NTSTATUS = 0xC01A0010;
pub const STATUS_LOG_CANT_DELETE: NTSTATUS = 0xC01A0011;
pub const STATUS_LOG_CONTAINER_LIMIT_EXCEEDED: NTSTATUS = 0xC01A0012;
pub const STATUS_LOG_START_OF_LOG: NTSTATUS = 0xC01A0013;
pub const STATUS_LOG_POLICY_ALREADY_INSTALLED: NTSTATUS = 0xC01A0014;
pub const STATUS_LOG_POLICY_NOT_INSTALLED: NTSTATUS = 0xC01A0015;
pub const STATUS_LOG_POLICY_INVALID: NTSTATUS = 0xC01A0016;
pub const STATUS_LOG_POLICY_CONFLICT: NTSTATUS = 0xC01A0017;
pub const STATUS_LOG_PINNED_ARCHIVE_TAIL: NTSTATUS = 0xC01A0018;
pub const STATUS_LOG_RECORD_NONEXISTENT: NTSTATUS = 0xC01A0019;
pub const STATUS_LOG_RECORDS_RESERVED_INVALID: NTSTATUS = 0xC01A001A;
pub const STATUS_LOG_SPACE_RESERVED_INVALID: NTSTATUS = 0xC01A001B;
pub const STATUS_LOG_TAIL_INVALID: NTSTATUS = 0xC01A001C;
pub const STATUS_LOG_FULL: NTSTATUS = 0xC01A001D;
pub const STATUS_LOG_MULTIPLEXED: NTSTATUS = 0xC01A001E;
pub const STATUS_LOG_DEDICATED: NTSTATUS = 0xC01A001F;
pub const STATUS_LOG_ARCHIVE_NOT_IN_PROGRESS: NTSTATUS = 0xC01A0020;
pub const STATUS_LOG_ARCHIVE_IN_PROGRESS: NTSTATUS = 0xC01A0021;
pub const STATUS_LOG_EPHEMERAL: NTSTATUS = 0xC01A0022;
pub const STATUS_LOG_NOT_ENOUGH_CONTAINERS: NTSTATUS = 0xC01A0023;
pub const STATUS_LOG_CLIENT_ALREADY_REGISTERED: NTSTATUS = 0xC01A0024;
pub const STATUS_LOG_CLIENT_NOT_REGISTERED: NTSTATUS = 0xC01A0025;
pub const STATUS_LOG_FULL_HANDLER_IN_PROGRESS: NTSTATUS = 0xC01A0026;
pub const STATUS_LOG_CONTAINER_READ_FAILED: NTSTATUS = 0xC01A0027;
pub const STATUS_LOG_CONTAINER_WRITE_FAILED: NTSTATUS = 0xC01A0028;
pub const STATUS_LOG_CONTAINER_OPEN_FAILED: NTSTATUS = 0xC01A0029;
pub const STATUS_LOG_CONTAINER_STATE_INVALID: NTSTATUS = 0xC01A002A;
pub const STATUS_LOG_STATE_INVALID: NTSTATUS = 0xC01A002B;
pub const STATUS_LOG_PINNED: NTSTATUS = 0xC01A002C;
pub const STATUS_LOG_METADATA_FLUSH_FAILED: NTSTATUS = 0xC01A002D;
pub const STATUS_LOG_INCONSISTENT_SECURITY: NTSTATUS = 0xC01A002E;
pub const STATUS_LOG_APPENDED_FLUSH_FAILED: NTSTATUS = 0xC01A002F;
pub const STATUS_LOG_PINNED_RESERVATION: NTSTATUS = 0xC01A0030;
pub const STATUS_VIDEO_HUNG_DISPLAY_DRIVER_THREAD: NTSTATUS = 0xC01B00EA;
pub const STATUS_VIDEO_HUNG_DISPLAY_DRIVER_THREAD_RECOVERED: NTSTATUS = 0x801B00EB;
pub const STATUS_VIDEO_DRIVER_DEBUG_REPORT_REQUEST: NTSTATUS = 0x401B00EC;
pub const STATUS_MONITOR_NO_DESCRIPTOR: NTSTATUS = 0xC01D0001;
pub const STATUS_MONITOR_UNKNOWN_DESCRIPTOR_FORMAT: NTSTATUS = 0xC01D0002;
pub const STATUS_MONITOR_INVALID_DESCRIPTOR_CHECKSUM: NTSTATUS = 0xC01D0003;
pub const STATUS_MONITOR_INVALID_STANDARD_TIMING_BLOCK: NTSTATUS = 0xC01D0004;
pub const STATUS_MONITOR_WMI_DATABLOCK_REGISTRATION_FAILED: NTSTATUS = 0xC01D0005;
pub const STATUS_MONITOR_INVALID_SERIAL_NUMBER_MONDSC_BLOCK: NTSTATUS = 0xC01D0006;
pub const STATUS_MONITOR_INVALID_USER_FRIENDLY_MONDSC_BLOCK: NTSTATUS = 0xC01D0007;
pub const STATUS_MONITOR_NO_MORE_DESCRIPTOR_DATA: NTSTATUS = 0xC01D0008;
pub const STATUS_MONITOR_INVALID_DETAILED_TIMING_BLOCK: NTSTATUS = 0xC01D0009;
pub const STATUS_MONITOR_INVALID_MANUFACTURE_DATE: NTSTATUS = 0xC01D000A;
pub const STATUS_GRAPHICS_NOT_EXCLUSIVE_MODE_OWNER: NTSTATUS = 0xC01E0000;
pub const STATUS_GRAPHICS_INSUFFICIENT_DMA_BUFFER: NTSTATUS = 0xC01E0001;
pub const STATUS_GRAPHICS_INVALID_DISPLAY_ADAPTER: NTSTATUS = 0xC01E0002;
pub const STATUS_GRAPHICS_ADAPTER_WAS_RESET: NTSTATUS = 0xC01E0003;
pub const STATUS_GRAPHICS_INVALID_DRIVER_MODEL: NTSTATUS = 0xC01E0004;
pub const STATUS_GRAPHICS_PRESENT_MODE_CHANGED: NTSTATUS = 0xC01E0005;
pub const STATUS_GRAPHICS_PRESENT_OCCLUDED: NTSTATUS = 0xC01E0006;
pub const STATUS_GRAPHICS_PRESENT_DENIED: NTSTATUS = 0xC01E0007;
pub const STATUS_GRAPHICS_CANNOTCOLORCONVERT: NTSTATUS = 0xC01E0008;
pub const STATUS_GRAPHICS_DRIVER_MISMATCH: NTSTATUS = 0xC01E0009;
pub const STATUS_GRAPHICS_PARTIAL_DATA_POPULATED: NTSTATUS = 0x401E000A;
pub const STATUS_GRAPHICS_PRESENT_REDIRECTION_DISABLED: NTSTATUS = 0xC01E000B;
pub const STATUS_GRAPHICS_PRESENT_UNOCCLUDED: NTSTATUS = 0xC01E000C;
pub const STATUS_GRAPHICS_WINDOWDC_NOT_AVAILABLE: NTSTATUS = 0xC01E000D;
pub const STATUS_GRAPHICS_WINDOWLESS_PRESENT_DISABLED: NTSTATUS = 0xC01E000E;
pub const STATUS_GRAPHICS_NO_VIDEO_MEMORY: NTSTATUS = 0xC01E0100;
pub const STATUS_GRAPHICS_CANT_LOCK_MEMORY: NTSTATUS = 0xC01E0101;
pub const STATUS_GRAPHICS_ALLOCATION_BUSY: NTSTATUS = 0xC01E0102;
pub const STATUS_GRAPHICS_TOO_MANY_REFERENCES: NTSTATUS = 0xC01E0103;
pub const STATUS_GRAPHICS_TRY_AGAIN_LATER: NTSTATUS = 0xC01E0104;
pub const STATUS_GRAPHICS_TRY_AGAIN_NOW: NTSTATUS = 0xC01E0105;
pub const STATUS_GRAPHICS_ALLOCATION_INVALID: NTSTATUS = 0xC01E0106;
pub const STATUS_GRAPHICS_UNSWIZZLING_APERTURE_UNAVAILABLE: NTSTATUS = 0xC01E0107;
pub const STATUS_GRAPHICS_UNSWIZZLING_APERTURE_UNSUPPORTED: NTSTATUS = 0xC01E0108;
pub const STATUS_GRAPHICS_CANT_EVICT_PINNED_ALLOCATION: NTSTATUS = 0xC01E0109;
pub const STATUS_GRAPHICS_INVALID_ALLOCATION_USAGE: NTSTATUS = 0xC01E0110;
pub const STATUS_GRAPHICS_CANT_RENDER_LOCKED_ALLOCATION: NTSTATUS = 0xC01E0111;
pub const STATUS_GRAPHICS_ALLOCATION_CLOSED: NTSTATUS = 0xC01E0112;
pub const STATUS_GRAPHICS_INVALID_ALLOCATION_INSTANCE: NTSTATUS = 0xC01E0113;
pub const STATUS_GRAPHICS_INVALID_ALLOCATION_HANDLE: NTSTATUS = 0xC01E0114;
pub const STATUS_GRAPHICS_WRONG_ALLOCATION_DEVICE: NTSTATUS = 0xC01E0115;
pub const STATUS_GRAPHICS_ALLOCATION_CONTENT_LOST: NTSTATUS = 0xC01E0116;
pub const STATUS_GRAPHICS_GPU_EXCEPTION_ON_DEVICE: NTSTATUS = 0xC01E0200;
pub const STATUS_GRAPHICS_SKIP_ALLOCATION_PREPARATION: NTSTATUS = 0x401E0201;
pub const STATUS_GRAPHICS_INVALID_VIDPN_TOPOLOGY: NTSTATUS = 0xC01E0300;
pub const STATUS_GRAPHICS_VIDPN_TOPOLOGY_NOT_SUPPORTED: NTSTATUS = 0xC01E0301;
pub const STATUS_GRAPHICS_VIDPN_TOPOLOGY_CURRENTLY_NOT_SUPPORTED: NTSTATUS = 0xC01E0302;
pub const STATUS_GRAPHICS_INVALID_VIDPN: NTSTATUS = 0xC01E0303;
pub const STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE: NTSTATUS = 0xC01E0304;
pub const STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET: NTSTATUS = 0xC01E0305;
pub const STATUS_GRAPHICS_VIDPN_MODALITY_NOT_SUPPORTED: NTSTATUS = 0xC01E0306;
pub const STATUS_GRAPHICS_MODE_NOT_PINNED: NTSTATUS = 0x401E0307;
pub const STATUS_GRAPHICS_INVALID_VIDPN_SOURCEMODESET: NTSTATUS = 0xC01E0308;
pub const STATUS_GRAPHICS_INVALID_VIDPN_TARGETMODESET: NTSTATUS = 0xC01E0309;
pub const STATUS_GRAPHICS_INVALID_FREQUENCY: NTSTATUS = 0xC01E030A;
pub const STATUS_GRAPHICS_INVALID_ACTIVE_REGION: NTSTATUS = 0xC01E030B;
pub const STATUS_GRAPHICS_INVALID_TOTAL_REGION: NTSTATUS = 0xC01E030C;
pub const STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE_MODE: NTSTATUS = 0xC01E0310;
pub const STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET_MODE: NTSTATUS = 0xC01E0311;
pub const STATUS_GRAPHICS_PINNED_MODE_MUST_REMAIN_IN_SET: NTSTATUS = 0xC01E0312;
pub const STATUS_GRAPHICS_PATH_ALREADY_IN_TOPOLOGY: NTSTATUS = 0xC01E0313;
pub const STATUS_GRAPHICS_MODE_ALREADY_IN_MODESET: NTSTATUS = 0xC01E0314;
pub const STATUS_GRAPHICS_INVALID_VIDEOPRESENTSOURCESET: NTSTATUS = 0xC01E0315;
pub const STATUS_GRAPHICS_INVALID_VIDEOPRESENTTARGETSET: NTSTATUS = 0xC01E0316;
pub const STATUS_GRAPHICS_SOURCE_ALREADY_IN_SET: NTSTATUS = 0xC01E0317;
pub const STATUS_GRAPHICS_TARGET_ALREADY_IN_SET: NTSTATUS = 0xC01E0318;
pub const STATUS_GRAPHICS_INVALID_VIDPN_PRESENT_PATH: NTSTATUS = 0xC01E0319;
pub const STATUS_GRAPHICS_NO_RECOMMENDED_VIDPN_TOPOLOGY: NTSTATUS = 0xC01E031A;
pub const STATUS_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGESET: NTSTATUS = 0xC01E031B;
pub const STATUS_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE: NTSTATUS = 0xC01E031C;
pub const STATUS_GRAPHICS_FREQUENCYRANGE_NOT_IN_SET: NTSTATUS = 0xC01E031D;
pub const STATUS_GRAPHICS_NO_PREFERRED_MODE: NTSTATUS = 0x401E031E;
pub const STATUS_GRAPHICS_FREQUENCYRANGE_ALREADY_IN_SET: NTSTATUS = 0xC01E031F;
pub const STATUS_GRAPHICS_STALE_MODESET: NTSTATUS = 0xC01E0320;
pub const STATUS_GRAPHICS_INVALID_MONITOR_SOURCEMODESET: NTSTATUS = 0xC01E0321;
pub const STATUS_GRAPHICS_INVALID_MONITOR_SOURCE_MODE: NTSTATUS = 0xC01E0322;
pub const STATUS_GRAPHICS_NO_RECOMMENDED_FUNCTIONAL_VIDPN: NTSTATUS = 0xC01E0323;
pub const STATUS_GRAPHICS_MODE_ID_MUST_BE_UNIQUE: NTSTATUS = 0xC01E0324;
pub const STATUS_GRAPHICS_EMPTY_ADAPTER_MONITOR_MODE_SUPPORT_INTERSECTION: NTSTATUS
    = 0xC01E0325;
pub const STATUS_GRAPHICS_VIDEO_PRESENT_TARGETS_LESS_THAN_SOURCES: NTSTATUS = 0xC01E0326;
pub const STATUS_GRAPHICS_PATH_NOT_IN_TOPOLOGY: NTSTATUS = 0xC01E0327;
pub const STATUS_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_SOURCE: NTSTATUS = 0xC01E0328;
pub const STATUS_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_TARGET: NTSTATUS = 0xC01E0329;
pub const STATUS_GRAPHICS_INVALID_MONITORDESCRIPTORSET: NTSTATUS = 0xC01E032A;
pub const STATUS_GRAPHICS_INVALID_MONITORDESCRIPTOR: NTSTATUS = 0xC01E032B;
pub const STATUS_GRAPHICS_MONITORDESCRIPTOR_NOT_IN_SET: NTSTATUS = 0xC01E032C;
pub const STATUS_GRAPHICS_MONITORDESCRIPTOR_ALREADY_IN_SET: NTSTATUS = 0xC01E032D;
pub const STATUS_GRAPHICS_MONITORDESCRIPTOR_ID_MUST_BE_UNIQUE: NTSTATUS = 0xC01E032E;
pub const STATUS_GRAPHICS_INVALID_VIDPN_TARGET_SUBSET_TYPE: NTSTATUS = 0xC01E032F;
pub const STATUS_GRAPHICS_RESOURCES_NOT_RELATED: NTSTATUS = 0xC01E0330;
pub const STATUS_GRAPHICS_SOURCE_ID_MUST_BE_UNIQUE: NTSTATUS = 0xC01E0331;
pub const STATUS_GRAPHICS_TARGET_ID_MUST_BE_UNIQUE: NTSTATUS = 0xC01E0332;
pub const STATUS_GRAPHICS_NO_AVAILABLE_VIDPN_TARGET: NTSTATUS = 0xC01E0333;
pub const STATUS_GRAPHICS_MONITOR_COULD_NOT_BE_ASSOCIATED_WITH_ADAPTER: NTSTATUS
    = 0xC01E0334;
pub const STATUS_GRAPHICS_NO_VIDPNMGR: NTSTATUS = 0xC01E0335;
pub const STATUS_GRAPHICS_NO_ACTIVE_VIDPN: NTSTATUS = 0xC01E0336;
pub const STATUS_GRAPHICS_STALE_VIDPN_TOPOLOGY: NTSTATUS = 0xC01E0337;
pub const STATUS_GRAPHICS_MONITOR_NOT_CONNECTED: NTSTATUS = 0xC01E0338;
pub const STATUS_GRAPHICS_SOURCE_NOT_IN_TOPOLOGY: NTSTATUS = 0xC01E0339;
pub const STATUS_GRAPHICS_INVALID_PRIMARYSURFACE_SIZE: NTSTATUS = 0xC01E033A;
pub const STATUS_GRAPHICS_INVALID_VISIBLEREGION_SIZE: NTSTATUS = 0xC01E033B;
pub const STATUS_GRAPHICS_INVALID_STRIDE: NTSTATUS = 0xC01E033C;
pub const STATUS_GRAPHICS_INVALID_PIXELFORMAT: NTSTATUS = 0xC01E033D;
pub const STATUS_GRAPHICS_INVALID_COLORBASIS: NTSTATUS = 0xC01E033E;
pub const STATUS_GRAPHICS_INVALID_PIXELVALUEACCESSMODE: NTSTATUS = 0xC01E033F;
pub const STATUS_GRAPHICS_TARGET_NOT_IN_TOPOLOGY: NTSTATUS = 0xC01E0340;
pub const STATUS_GRAPHICS_NO_DISPLAY_MODE_MANAGEMENT_SUPPORT: NTSTATUS = 0xC01E0341;
pub const STATUS_GRAPHICS_VIDPN_SOURCE_IN_USE: NTSTATUS = 0xC01E0342;
pub const STATUS_GRAPHICS_CANT_ACCESS_ACTIVE_VIDPN: NTSTATUS = 0xC01E0343;
pub const STATUS_GRAPHICS_INVALID_PATH_IMPORTANCE_ORDINAL: NTSTATUS = 0xC01E0344;
pub const STATUS_GRAPHICS_INVALID_PATH_CONTENT_GEOMETRY_TRANSFORMATION: NTSTATUS
    = 0xC01E0345;
pub const STATUS_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_SUPPORTED: NTSTATUS
    = 0xC01E0346;
pub const STATUS_GRAPHICS_INVALID_GAMMA_RAMP: NTSTATUS = 0xC01E0347;
pub const STATUS_GRAPHICS_GAMMA_RAMP_NOT_SUPPORTED: NTSTATUS = 0xC01E0348;
pub const STATUS_GRAPHICS_MULTISAMPLING_NOT_SUPPORTED: NTSTATUS = 0xC01E0349;
pub const STATUS_GRAPHICS_MODE_NOT_IN_MODESET: NTSTATUS = 0xC01E034A;
pub const STATUS_GRAPHICS_DATASET_IS_EMPTY: NTSTATUS = 0x401E034B;
pub const STATUS_GRAPHICS_NO_MORE_ELEMENTS_IN_DATASET: NTSTATUS = 0x401E034C;
pub const STATUS_GRAPHICS_INVALID_VIDPN_TOPOLOGY_RECOMMENDATION_REASON: NTSTATUS
    = 0xC01E034D;
pub const STATUS_GRAPHICS_INVALID_PATH_CONTENT_TYPE: NTSTATUS = 0xC01E034E;
pub const STATUS_GRAPHICS_INVALID_COPYPROTECTION_TYPE: NTSTATUS = 0xC01E034F;
pub const STATUS_GRAPHICS_UNASSIGNED_MODESET_ALREADY_EXISTS: NTSTATUS = 0xC01E0350;
pub const STATUS_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_PINNED: NTSTATUS = 0x401E0351;
pub const STATUS_GRAPHICS_INVALID_SCANLINE_ORDERING: NTSTATUS = 0xC01E0352;
pub const STATUS_GRAPHICS_TOPOLOGY_CHANGES_NOT_ALLOWED: NTSTATUS = 0xC01E0353;
pub const STATUS_GRAPHICS_NO_AVAILABLE_IMPORTANCE_ORDINALS: NTSTATUS = 0xC01E0354;
pub const STATUS_GRAPHICS_INCOMPATIBLE_PRIVATE_FORMAT: NTSTATUS = 0xC01E0355;
pub const STATUS_GRAPHICS_INVALID_MODE_PRUNING_ALGORITHM: NTSTATUS = 0xC01E0356;
pub const STATUS_GRAPHICS_INVALID_MONITOR_CAPABILITY_ORIGIN: NTSTATUS = 0xC01E0357;
pub const STATUS_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE_CONSTRAINT: NTSTATUS
    = 0xC01E0358;
pub const STATUS_GRAPHICS_MAX_NUM_PATHS_REACHED: NTSTATUS = 0xC01E0359;
pub const STATUS_GRAPHICS_CANCEL_VIDPN_TOPOLOGY_AUGMENTATION: NTSTATUS = 0xC01E035A;
pub const STATUS_GRAPHICS_INVALID_CLIENT_TYPE: NTSTATUS = 0xC01E035B;
pub const STATUS_GRAPHICS_CLIENTVIDPN_NOT_SET: NTSTATUS = 0xC01E035C;
pub const STATUS_GRAPHICS_SPECIFIED_CHILD_ALREADY_CONNECTED: NTSTATUS = 0xC01E0400;
pub const STATUS_GRAPHICS_CHILD_DESCRIPTOR_NOT_SUPPORTED: NTSTATUS = 0xC01E0401;
pub const STATUS_GRAPHICS_UNKNOWN_CHILD_STATUS: NTSTATUS = 0x401E042F;
pub const STATUS_GRAPHICS_NOT_A_LINKED_ADAPTER: NTSTATUS = 0xC01E0430;
pub const STATUS_GRAPHICS_LEADLINK_NOT_ENUMERATED: NTSTATUS = 0xC01E0431;
pub const STATUS_GRAPHICS_CHAINLINKS_NOT_ENUMERATED: NTSTATUS = 0xC01E0432;
pub const STATUS_GRAPHICS_ADAPTER_CHAIN_NOT_READY: NTSTATUS = 0xC01E0433;
pub const STATUS_GRAPHICS_CHAINLINKS_NOT_STARTED: NTSTATUS = 0xC01E0434;
pub const STATUS_GRAPHICS_CHAINLINKS_NOT_POWERED_ON: NTSTATUS = 0xC01E0435;
pub const STATUS_GRAPHICS_INCONSISTENT_DEVICE_LINK_STATE: NTSTATUS = 0xC01E0436;
pub const STATUS_GRAPHICS_LEADLINK_START_DEFERRED: NTSTATUS = 0x401E0437;
pub const STATUS_GRAPHICS_NOT_POST_DEVICE_DRIVER: NTSTATUS = 0xC01E0438;
pub const STATUS_GRAPHICS_POLLING_TOO_FREQUENTLY: NTSTATUS = 0x401E0439;
pub const STATUS_GRAPHICS_START_DEFERRED: NTSTATUS = 0x401E043A;
pub const STATUS_GRAPHICS_ADAPTER_ACCESS_NOT_EXCLUDED: NTSTATUS = 0xC01E043B;
pub const STATUS_GRAPHICS_DEPENDABLE_CHILD_STATUS: NTSTATUS = 0x401E043C;
pub const STATUS_GRAPHICS_OPM_NOT_SUPPORTED: NTSTATUS = 0xC01E0500;
pub const STATUS_GRAPHICS_COPP_NOT_SUPPORTED: NTSTATUS = 0xC01E0501;
pub const STATUS_GRAPHICS_UAB_NOT_SUPPORTED: NTSTATUS = 0xC01E0502;
pub const STATUS_GRAPHICS_OPM_INVALID_ENCRYPTED_PARAMETERS: NTSTATUS = 0xC01E0503;
pub const STATUS_GRAPHICS_OPM_NO_PROTECTED_OUTPUTS_EXIST: NTSTATUS = 0xC01E0505;
pub const STATUS_GRAPHICS_OPM_INTERNAL_ERROR: NTSTATUS = 0xC01E050B;
pub const STATUS_GRAPHICS_OPM_INVALID_HANDLE: NTSTATUS = 0xC01E050C;
pub const STATUS_GRAPHICS_PVP_INVALID_CERTIFICATE_LENGTH: NTSTATUS = 0xC01E050E;
pub const STATUS_GRAPHICS_OPM_SPANNING_MODE_ENABLED: NTSTATUS = 0xC01E050F;
pub const STATUS_GRAPHICS_OPM_THEATER_MODE_ENABLED: NTSTATUS = 0xC01E0510;
pub const STATUS_GRAPHICS_PVP_HFS_FAILED: NTSTATUS = 0xC01E0511;
pub const STATUS_GRAPHICS_OPM_INVALID_SRM: NTSTATUS = 0xC01E0512;
pub const STATUS_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_HDCP: NTSTATUS = 0xC01E0513;
pub const STATUS_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_ACP: NTSTATUS = 0xC01E0514;
pub const STATUS_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_CGMSA: NTSTATUS = 0xC01E0515;
pub const STATUS_GRAPHICS_OPM_HDCP_SRM_NEVER_SET: NTSTATUS = 0xC01E0516;
pub const STATUS_GRAPHICS_OPM_RESOLUTION_TOO_HIGH: NTSTATUS = 0xC01E0517;
pub const STATUS_GRAPHICS_OPM_ALL_HDCP_HARDWARE_ALREADY_IN_USE: NTSTATUS = 0xC01E0518;
pub const STATUS_GRAPHICS_OPM_PROTECTED_OUTPUT_NO_LONGER_EXISTS: NTSTATUS = 0xC01E051A;
pub const STATUS_GRAPHICS_OPM_PROTECTED_OUTPUT_DOES_NOT_HAVE_COPP_SEMANTICS: NTSTATUS
    = 0xC01E051C;
pub const STATUS_GRAPHICS_OPM_INVALID_INFORMATION_REQUEST: NTSTATUS = 0xC01E051D;
pub const STATUS_GRAPHICS_OPM_DRIVER_INTERNAL_ERROR: NTSTATUS = 0xC01E051E;
pub const STATUS_GRAPHICS_OPM_PROTECTED_OUTPUT_DOES_NOT_HAVE_OPM_SEMANTICS: NTSTATUS
    = 0xC01E051F;
pub const STATUS_GRAPHICS_OPM_SIGNALING_NOT_SUPPORTED: NTSTATUS = 0xC01E0520;
pub const STATUS_GRAPHICS_OPM_INVALID_CONFIGURATION_REQUEST: NTSTATUS = 0xC01E0521;
pub const STATUS_GRAPHICS_I2C_NOT_SUPPORTED: NTSTATUS = 0xC01E0580;
pub const STATUS_GRAPHICS_I2C_DEVICE_DOES_NOT_EXIST: NTSTATUS = 0xC01E0581;
pub const STATUS_GRAPHICS_I2C_ERROR_TRANSMITTING_DATA: NTSTATUS = 0xC01E0582;
pub const STATUS_GRAPHICS_I2C_ERROR_RECEIVING_DATA: NTSTATUS = 0xC01E0583;
pub const STATUS_GRAPHICS_DDCCI_VCP_NOT_SUPPORTED: NTSTATUS = 0xC01E0584;
pub const STATUS_GRAPHICS_DDCCI_INVALID_DATA: NTSTATUS = 0xC01E0585;
pub const STATUS_GRAPHICS_DDCCI_MONITOR_RETURNED_INVALID_TIMING_STATUS_BYTE: NTSTATUS
    = 0xC01E0586;
pub const STATUS_GRAPHICS_DDCCI_INVALID_CAPABILITIES_STRING: NTSTATUS = 0xC01E0587;
pub const STATUS_GRAPHICS_MCA_INTERNAL_ERROR: NTSTATUS = 0xC01E0588;
pub const STATUS_GRAPHICS_DDCCI_INVALID_MESSAGE_COMMAND: NTSTATUS = 0xC01E0589;
pub const STATUS_GRAPHICS_DDCCI_INVALID_MESSAGE_LENGTH: NTSTATUS = 0xC01E058A;
pub const STATUS_GRAPHICS_DDCCI_INVALID_MESSAGE_CHECKSUM: NTSTATUS = 0xC01E058B;
pub const STATUS_GRAPHICS_INVALID_PHYSICAL_MONITOR_HANDLE: NTSTATUS = 0xC01E058C;
pub const STATUS_GRAPHICS_MONITOR_NO_LONGER_EXISTS: NTSTATUS = 0xC01E058D;
pub const STATUS_GRAPHICS_ONLY_CONSOLE_SESSION_SUPPORTED: NTSTATUS = 0xC01E05E0;
pub const STATUS_GRAPHICS_NO_DISPLAY_DEVICE_CORRESPONDS_TO_NAME: NTSTATUS = 0xC01E05E1;
pub const STATUS_GRAPHICS_DISPLAY_DEVICE_NOT_ATTACHED_TO_DESKTOP: NTSTATUS = 0xC01E05E2;
pub const STATUS_GRAPHICS_MIRRORING_DEVICES_NOT_SUPPORTED: NTSTATUS = 0xC01E05E3;
pub const STATUS_GRAPHICS_INVALID_POINTER: NTSTATUS = 0xC01E05E4;
pub const STATUS_GRAPHICS_NO_MONITORS_CORRESPOND_TO_DISPLAY_DEVICE: NTSTATUS
    = 0xC01E05E5;
pub const STATUS_GRAPHICS_PARAMETER_ARRAY_TOO_SMALL: NTSTATUS = 0xC01E05E6;
pub const STATUS_GRAPHICS_INTERNAL_ERROR: NTSTATUS = 0xC01E05E7;
pub const STATUS_GRAPHICS_SESSION_TYPE_CHANGE_IN_PROGRESS: NTSTATUS = 0xC01E05E8;
pub const STATUS_FVE_LOCKED_VOLUME: NTSTATUS = 0xC0210000;
pub const STATUS_FVE_NOT_ENCRYPTED: NTSTATUS = 0xC0210001;
pub const STATUS_FVE_BAD_INFORMATION: NTSTATUS = 0xC0210002;
pub const STATUS_FVE_TOO_SMALL: NTSTATUS = 0xC0210003;
pub const STATUS_FVE_FAILED_WRONG_FS: NTSTATUS = 0xC0210004;
pub const STATUS_FVE_BAD_PARTITION_SIZE: NTSTATUS = 0xC0210005;
pub const STATUS_FVE_FS_NOT_EXTENDED: NTSTATUS = 0xC0210006;
pub const STATUS_FVE_FS_MOUNTED: NTSTATUS = 0xC0210007;
pub const STATUS_FVE_NO_LICENSE: NTSTATUS = 0xC0210008;
pub const STATUS_FVE_ACTION_NOT_ALLOWED: NTSTATUS = 0xC0210009;
pub const STATUS_FVE_BAD_DATA: NTSTATUS = 0xC021000A;
pub const STATUS_FVE_VOLUME_NOT_BOUND: NTSTATUS = 0xC021000B;
pub const STATUS_FVE_NOT_DATA_VOLUME: NTSTATUS = 0xC021000C;
pub const STATUS_FVE_CONV_READ_ERROR: NTSTATUS = 0xC021000D;
pub const STATUS_FVE_CONV_WRITE_ERROR: NTSTATUS = 0xC021000E;
pub const STATUS_FVE_OVERLAPPED_UPDATE: NTSTATUS = 0xC021000F;
pub const STATUS_FVE_FAILED_SECTOR_SIZE: NTSTATUS = 0xC0210010;
pub const STATUS_FVE_FAILED_AUTHENTICATION: NTSTATUS = 0xC0210011;
pub const STATUS_FVE_NOT_OS_VOLUME: NTSTATUS = 0xC0210012;
pub const STATUS_FVE_KEYFILE_NOT_FOUND: NTSTATUS = 0xC0210013;
pub const STATUS_FVE_KEYFILE_INVALID: NTSTATUS = 0xC0210014;
pub const STATUS_FVE_KEYFILE_NO_VMK: NTSTATUS = 0xC0210015;
pub const STATUS_FVE_TPM_DISABLED: NTSTATUS = 0xC0210016;
pub const STATUS_FVE_TPM_SRK_AUTH_NOT_ZERO: NTSTATUS = 0xC0210017;
pub const STATUS_FVE_TPM_INVALID_PCR: NTSTATUS = 0xC0210018;
pub const STATUS_FVE_TPM_NO_VMK: NTSTATUS = 0xC0210019;
pub const STATUS_FVE_PIN_INVALID: NTSTATUS = 0xC021001A;
pub const STATUS_FVE_AUTH_INVALID_APPLICATION: NTSTATUS = 0xC021001B;
pub const STATUS_FVE_AUTH_INVALID_CONFIG: NTSTATUS = 0xC021001C;
pub const STATUS_FVE_DEBUGGER_ENABLED: NTSTATUS = 0xC021001D;
pub const STATUS_FVE_DRY_RUN_FAILED: NTSTATUS = 0xC021001E;
pub const STATUS_FVE_BAD_METADATA_POINTER: NTSTATUS = 0xC021001F;
pub const STATUS_FVE_OLD_METADATA_COPY: NTSTATUS = 0xC0210020;
pub const STATUS_FVE_REBOOT_REQUIRED: NTSTATUS = 0xC0210021;
pub const STATUS_FVE_RAW_ACCESS: NTSTATUS = 0xC0210022;
pub const STATUS_FVE_RAW_BLOCKED: NTSTATUS = 0xC0210023;
pub const STATUS_FVE_NO_AUTOUNLOCK_MASTER_KEY: NTSTATUS = 0xC0210024;
pub const STATUS_FVE_MOR_FAILED: NTSTATUS = 0xC0210025;
pub const STATUS_FVE_NO_FEATURE_LICENSE: NTSTATUS = 0xC0210026;
pub const STATUS_FVE_POLICY_USER_DISABLE_RDV_NOT_ALLOWED: NTSTATUS = 0xC0210027;
pub const STATUS_FVE_CONV_RECOVERY_FAILED: NTSTATUS = 0xC0210028;
pub const STATUS_FVE_VIRTUALIZED_SPACE_TOO_BIG: NTSTATUS = 0xC0210029;
pub const STATUS_FVE_INVALID_DATUM_TYPE: NTSTATUS = 0xC021002A;
pub const STATUS_FVE_VOLUME_TOO_SMALL: NTSTATUS = 0xC0210030;
pub const STATUS_FVE_ENH_PIN_INVALID: NTSTATUS = 0xC0210031;
pub const STATUS_FVE_FULL_ENCRYPTION_NOT_ALLOWED_ON_TP_STORAGE: NTSTATUS = 0xC0210032;
pub const STATUS_FVE_WIPE_NOT_ALLOWED_ON_TP_STORAGE: NTSTATUS = 0xC0210033;
pub const STATUS_FVE_NOT_ALLOWED_ON_CSV_STACK: NTSTATUS = 0xC0210034;
pub const STATUS_FVE_NOT_ALLOWED_ON_CLUSTER: NTSTATUS = 0xC0210035;
pub const STATUS_FVE_NOT_ALLOWED_TO_UPGRADE_WHILE_CONVERTING: NTSTATUS = 0xC0210036;
pub const STATUS_FVE_WIPE_CANCEL_NOT_APPLICABLE: NTSTATUS = 0xC0210037;
pub const STATUS_FVE_EDRIVE_DRY_RUN_FAILED: NTSTATUS = 0xC0210038;
pub const STATUS_FVE_SECUREBOOT_DISABLED: NTSTATUS = 0xC0210039;
pub const STATUS_FVE_SECUREBOOT_CONFIG_CHANGE: NTSTATUS = 0xC021003A;
pub const STATUS_FVE_DEVICE_LOCKEDOUT: NTSTATUS = 0xC021003B;
pub const STATUS_FVE_VOLUME_EXTEND_PREVENTS_EOW_DECRYPT: NTSTATUS = 0xC021003C;
pub const STATUS_FVE_NOT_DE_VOLUME: NTSTATUS = 0xC021003D;
pub const STATUS_FVE_PROTECTION_DISABLED: NTSTATUS = 0xC021003E;
pub const STATUS_FVE_PROTECTION_CANNOT_BE_DISABLED: NTSTATUS = 0xC021003F;
pub const STATUS_FWP_CALLOUT_NOT_FOUND: NTSTATUS = 0xC0220001;
pub const STATUS_FWP_CONDITION_NOT_FOUND: NTSTATUS = 0xC0220002;
pub const STATUS_FWP_FILTER_NOT_FOUND: NTSTATUS = 0xC0220003;
pub const STATUS_FWP_LAYER_NOT_FOUND: NTSTATUS = 0xC0220004;
pub const STATUS_FWP_PROVIDER_NOT_FOUND: NTSTATUS = 0xC0220005;
pub const STATUS_FWP_PROVIDER_CONTEXT_NOT_FOUND: NTSTATUS = 0xC0220006;
pub const STATUS_FWP_SUBLAYER_NOT_FOUND: NTSTATUS = 0xC0220007;
pub const STATUS_FWP_NOT_FOUND: NTSTATUS = 0xC0220008;
pub const STATUS_FWP_ALREADY_EXISTS: NTSTATUS = 0xC0220009;
pub const STATUS_FWP_IN_USE: NTSTATUS = 0xC022000A;
pub const STATUS_FWP_DYNAMIC_SESSION_IN_PROGRESS: NTSTATUS = 0xC022000B;
pub const STATUS_FWP_WRONG_SESSION: NTSTATUS = 0xC022000C;
pub const STATUS_FWP_NO_TXN_IN_PROGRESS: NTSTATUS = 0xC022000D;
pub const STATUS_FWP_TXN_IN_PROGRESS: NTSTATUS = 0xC022000E;
pub const STATUS_FWP_TXN_ABORTED: NTSTATUS = 0xC022000F;
pub const STATUS_FWP_SESSION_ABORTED: NTSTATUS = 0xC0220010;
pub const STATUS_FWP_INCOMPATIBLE_TXN: NTSTATUS = 0xC0220011;
pub const STATUS_FWP_TIMEOUT: NTSTATUS = 0xC0220012;
pub const STATUS_FWP_NET_EVENTS_DISABLED: NTSTATUS = 0xC0220013;
pub const STATUS_FWP_INCOMPATIBLE_LAYER: NTSTATUS = 0xC0220014;
pub const STATUS_FWP_KM_CLIENTS_ONLY: NTSTATUS = 0xC0220015;
pub const STATUS_FWP_LIFETIME_MISMATCH: NTSTATUS = 0xC0220016;
pub const STATUS_FWP_BUILTIN_OBJECT: NTSTATUS = 0xC0220017;
pub const STATUS_FWP_TOO_MANY_CALLOUTS: NTSTATUS = 0xC0220018;
pub const STATUS_FWP_NOTIFICATION_DROPPED: NTSTATUS = 0xC0220019;
pub const STATUS_FWP_TRAFFIC_MISMATCH: NTSTATUS = 0xC022001A;
pub const STATUS_FWP_INCOMPATIBLE_SA_STATE: NTSTATUS = 0xC022001B;
pub const STATUS_FWP_NULL_POINTER: NTSTATUS = 0xC022001C;
pub const STATUS_FWP_INVALID_ENUMERATOR: NTSTATUS = 0xC022001D;
pub const STATUS_FWP_INVALID_FLAGS: NTSTATUS = 0xC022001E;
pub const STATUS_FWP_INVALID_NET_MASK: NTSTATUS = 0xC022001F;
pub const STATUS_FWP_INVALID_RANGE: NTSTATUS = 0xC0220020;
pub const STATUS_FWP_INVALID_INTERVAL: NTSTATUS = 0xC0220021;
pub const STATUS_FWP_ZERO_LENGTH_ARRAY: NTSTATUS = 0xC0220022;
pub const STATUS_FWP_NULL_DISPLAY_NAME: NTSTATUS = 0xC0220023;
pub const STATUS_FWP_INVALID_ACTION_TYPE: NTSTATUS = 0xC0220024;
pub const STATUS_FWP_INVALID_WEIGHT: NTSTATUS = 0xC0220025;
pub const STATUS_FWP_MATCH_TYPE_MISMATCH: NTSTATUS = 0xC0220026;
pub const STATUS_FWP_TYPE_MISMATCH: NTSTATUS = 0xC0220027;
pub const STATUS_FWP_OUT_OF_BOUNDS: NTSTATUS = 0xC0220028;
pub const STATUS_FWP_RESERVED: NTSTATUS = 0xC0220029;
pub const STATUS_FWP_DUPLICATE_CONDITION: NTSTATUS = 0xC022002A;
pub const STATUS_FWP_DUPLICATE_KEYMOD: NTSTATUS = 0xC022002B;
pub const STATUS_FWP_ACTION_INCOMPATIBLE_WITH_LAYER: NTSTATUS = 0xC022002C;
pub const STATUS_FWP_ACTION_INCOMPATIBLE_WITH_SUBLAYER: NTSTATUS = 0xC022002D;
pub const STATUS_FWP_CONTEXT_INCOMPATIBLE_WITH_LAYER: NTSTATUS = 0xC022002E;
pub const STATUS_FWP_CONTEXT_INCOMPATIBLE_WITH_CALLOUT: NTSTATUS = 0xC022002F;
pub const STATUS_FWP_INCOMPATIBLE_AUTH_METHOD: NTSTATUS = 0xC0220030;
pub const STATUS_FWP_INCOMPATIBLE_DH_GROUP: NTSTATUS = 0xC0220031;
pub const STATUS_FWP_EM_NOT_SUPPORTED: NTSTATUS = 0xC0220032;
pub const STATUS_FWP_NEVER_MATCH: NTSTATUS = 0xC0220033;
pub const STATUS_FWP_PROVIDER_CONTEXT_MISMATCH: NTSTATUS = 0xC0220034;
pub const STATUS_FWP_INVALID_PARAMETER: NTSTATUS = 0xC0220035;
pub const STATUS_FWP_TOO_MANY_SUBLAYERS: NTSTATUS = 0xC0220036;
pub const STATUS_FWP_CALLOUT_NOTIFICATION_FAILED: NTSTATUS = 0xC0220037;
pub const STATUS_FWP_INVALID_AUTH_TRANSFORM: NTSTATUS = 0xC0220038;
pub const STATUS_FWP_INVALID_CIPHER_TRANSFORM: NTSTATUS = 0xC0220039;
pub const STATUS_FWP_INCOMPATIBLE_CIPHER_TRANSFORM: NTSTATUS = 0xC022003A;
pub const STATUS_FWP_INVALID_TRANSFORM_COMBINATION: NTSTATUS = 0xC022003B;
pub const STATUS_FWP_DUPLICATE_AUTH_METHOD: NTSTATUS = 0xC022003C;
pub const STATUS_FWP_INVALID_TUNNEL_ENDPOINT: NTSTATUS = 0xC022003D;
pub const STATUS_FWP_L2_DRIVER_NOT_READY: NTSTATUS = 0xC022003E;
pub const STATUS_FWP_KEY_DICTATOR_ALREADY_REGISTERED: NTSTATUS = 0xC022003F;
pub const STATUS_FWP_KEY_DICTATION_INVALID_KEYING_MATERIAL: NTSTATUS = 0xC0220040;
pub const STATUS_FWP_CONNECTIONS_DISABLED: NTSTATUS = 0xC0220041;
pub const STATUS_FWP_INVALID_DNS_NAME: NTSTATUS = 0xC0220042;
pub const STATUS_FWP_STILL_ON: NTSTATUS = 0xC0220043;
pub const STATUS_FWP_IKEEXT_NOT_RUNNING: NTSTATUS = 0xC0220044;
pub const STATUS_FWP_TCPIP_NOT_READY: NTSTATUS = 0xC0220100;
pub const STATUS_FWP_INJECT_HANDLE_CLOSING: NTSTATUS = 0xC0220101;
pub const STATUS_FWP_INJECT_HANDLE_STALE: NTSTATUS = 0xC0220102;
pub const STATUS_FWP_CANNOT_PEND: NTSTATUS = 0xC0220103;
pub const STATUS_FWP_DROP_NOICMP: NTSTATUS = 0xC0220104;
pub const STATUS_NDIS_CLOSING: NTSTATUS = 0xC0230002;
pub const STATUS_NDIS_BAD_VERSION: NTSTATUS = 0xC0230004;
pub const STATUS_NDIS_BAD_CHARACTERISTICS: NTSTATUS = 0xC0230005;
pub const STATUS_NDIS_ADAPTER_NOT_FOUND: NTSTATUS = 0xC0230006;
pub const STATUS_NDIS_OPEN_FAILED: NTSTATUS = 0xC0230007;
pub const STATUS_NDIS_DEVICE_FAILED: NTSTATUS = 0xC0230008;
pub const STATUS_NDIS_MULTICAST_FULL: NTSTATUS = 0xC0230009;
pub const STATUS_NDIS_MULTICAST_EXISTS: NTSTATUS = 0xC023000A;
pub const STATUS_NDIS_MULTICAST_NOT_FOUND: NTSTATUS = 0xC023000B;
pub const STATUS_NDIS_REQUEST_ABORTED: NTSTATUS = 0xC023000C;
pub const STATUS_NDIS_RESET_IN_PROGRESS: NTSTATUS = 0xC023000D;
pub const STATUS_NDIS_NOT_SUPPORTED: NTSTATUS = 0xC02300BB;
pub const STATUS_NDIS_INVALID_PACKET: NTSTATUS = 0xC023000F;
pub const STATUS_NDIS_ADAPTER_NOT_READY: NTSTATUS = 0xC0230011;
pub const STATUS_NDIS_INVALID_LENGTH: NTSTATUS = 0xC0230014;
pub const STATUS_NDIS_INVALID_DATA: NTSTATUS = 0xC0230015;
pub const STATUS_NDIS_BUFFER_TOO_SHORT: NTSTATUS = 0xC0230016;
pub const STATUS_NDIS_INVALID_OID: NTSTATUS = 0xC0230017;
pub const STATUS_NDIS_ADAPTER_REMOVED: NTSTATUS = 0xC0230018;
pub const STATUS_NDIS_UNSUPPORTED_MEDIA: NTSTATUS = 0xC0230019;
pub const STATUS_NDIS_GROUP_ADDRESS_IN_USE: NTSTATUS = 0xC023001A;
pub const STATUS_NDIS_FILE_NOT_FOUND: NTSTATUS = 0xC023001B;
pub const STATUS_NDIS_ERROR_READING_FILE: NTSTATUS = 0xC023001C;
pub const STATUS_NDIS_ALREADY_MAPPED: NTSTATUS = 0xC023001D;
pub const STATUS_NDIS_RESOURCE_CONFLICT: NTSTATUS = 0xC023001E;
pub const STATUS_NDIS_MEDIA_DISCONNECTED: NTSTATUS = 0xC023001F;
pub const STATUS_NDIS_INVALID_ADDRESS: NTSTATUS = 0xC0230022;
pub const STATUS_NDIS_INVALID_DEVICE_REQUEST: NTSTATUS = 0xC0230010;
pub const STATUS_NDIS_PAUSED: NTSTATUS = 0xC023002A;
pub const STATUS_NDIS_INTERFACE_NOT_FOUND: NTSTATUS = 0xC023002B;
pub const STATUS_NDIS_UNSUPPORTED_REVISION: NTSTATUS = 0xC023002C;
pub const STATUS_NDIS_INVALID_PORT: NTSTATUS = 0xC023002D;
pub const STATUS_NDIS_INVALID_PORT_STATE: NTSTATUS = 0xC023002E;
pub const STATUS_NDIS_LOW_POWER_STATE: NTSTATUS = 0xC023002F;
pub const STATUS_NDIS_REINIT_REQUIRED: NTSTATUS = 0xC0230030;
pub const STATUS_NDIS_DOT11_AUTO_CONFIG_ENABLED: NTSTATUS = 0xC0232000;
pub const STATUS_NDIS_DOT11_MEDIA_IN_USE: NTSTATUS = 0xC0232001;
pub const STATUS_NDIS_DOT11_POWER_STATE_INVALID: NTSTATUS = 0xC0232002;
pub const STATUS_NDIS_PM_WOL_PATTERN_LIST_FULL: NTSTATUS = 0xC0232003;
pub const STATUS_NDIS_PM_PROTOCOL_OFFLOAD_LIST_FULL: NTSTATUS = 0xC0232004;
pub const STATUS_NDIS_DOT11_AP_CHANNEL_CURRENTLY_NOT_AVAILABLE: NTSTATUS = 0xC0232005;
pub const STATUS_NDIS_DOT11_AP_BAND_CURRENTLY_NOT_AVAILABLE: NTSTATUS = 0xC0232006;
pub const STATUS_NDIS_DOT11_AP_CHANNEL_NOT_ALLOWED: NTSTATUS = 0xC0232007;
pub const STATUS_NDIS_DOT11_AP_BAND_NOT_ALLOWED: NTSTATUS = 0xC0232008;
pub const STATUS_NDIS_INDICATION_REQUIRED: NTSTATUS = 0x40230001;
pub const STATUS_NDIS_OFFLOAD_POLICY: NTSTATUS = 0xC023100F;
pub const STATUS_NDIS_OFFLOAD_CONNECTION_REJECTED: NTSTATUS = 0xC0231012;
pub const STATUS_NDIS_OFFLOAD_PATH_REJECTED: NTSTATUS = 0xC0231013;
pub const STATUS_TPM_ERROR_MASK: NTSTATUS = 0xC0290000;
pub const STATUS_TPM_AUTHFAIL: NTSTATUS = 0xC0290001;
pub const STATUS_TPM_BADINDEX: NTSTATUS = 0xC0290002;
pub const STATUS_TPM_BAD_PARAMETER: NTSTATUS = 0xC0290003;
pub const STATUS_TPM_AUDITFAILURE: NTSTATUS = 0xC0290004;
pub const STATUS_TPM_CLEAR_DISABLED: NTSTATUS = 0xC0290005;
pub const STATUS_TPM_DEACTIVATED: NTSTATUS = 0xC0290006;
pub const STATUS_TPM_DISABLED: NTSTATUS = 0xC0290007;
pub const STATUS_TPM_DISABLED_CMD: NTSTATUS = 0xC0290008;
pub const STATUS_TPM_FAIL: NTSTATUS = 0xC0290009;
pub const STATUS_TPM_BAD_ORDINAL: NTSTATUS = 0xC029000A;
pub const STATUS_TPM_INSTALL_DISABLED: NTSTATUS = 0xC029000B;
pub const STATUS_TPM_INVALID_KEYHANDLE: NTSTATUS = 0xC029000C;
pub const STATUS_TPM_KEYNOTFOUND: NTSTATUS = 0xC029000D;
pub const STATUS_TPM_INAPPROPRIATE_ENC: NTSTATUS = 0xC029000E;
pub const STATUS_TPM_MIGRATEFAIL: NTSTATUS = 0xC029000F;
pub const STATUS_TPM_INVALID_PCR_INFO: NTSTATUS = 0xC0290010;
pub const STATUS_TPM_NOSPACE: NTSTATUS = 0xC0290011;
pub const STATUS_TPM_NOSRK: NTSTATUS = 0xC0290012;
pub const STATUS_TPM_NOTSEALED_BLOB: NTSTATUS = 0xC0290013;
pub const STATUS_TPM_OWNER_SET: NTSTATUS = 0xC0290014;
pub const STATUS_TPM_RESOURCES: NTSTATUS = 0xC0290015;
pub const STATUS_TPM_SHORTRANDOM: NTSTATUS = 0xC0290016;
pub const STATUS_TPM_SIZE: NTSTATUS = 0xC0290017;
pub const STATUS_TPM_WRONGPCRVAL: NTSTATUS = 0xC0290018;
pub const STATUS_TPM_BAD_PARAM_SIZE: NTSTATUS = 0xC0290019;
pub const STATUS_TPM_SHA_THREAD: NTSTATUS = 0xC029001A;
pub const STATUS_TPM_SHA_ERROR: NTSTATUS = 0xC029001B;
pub const STATUS_TPM_FAILEDSELFTEST: NTSTATUS = 0xC029001C;
pub const STATUS_TPM_AUTH2FAIL: NTSTATUS = 0xC029001D;
pub const STATUS_TPM_BADTAG: NTSTATUS = 0xC029001E;
pub const STATUS_TPM_IOERROR: NTSTATUS = 0xC029001F;
pub const STATUS_TPM_ENCRYPT_ERROR: NTSTATUS = 0xC0290020;
pub const STATUS_TPM_DECRYPT_ERROR: NTSTATUS = 0xC0290021;
pub const STATUS_TPM_INVALID_AUTHHANDLE: NTSTATUS = 0xC0290022;
pub const STATUS_TPM_NO_ENDORSEMENT: NTSTATUS = 0xC0290023;
pub const STATUS_TPM_INVALID_KEYUSAGE: NTSTATUS = 0xC0290024;
pub const STATUS_TPM_WRONG_ENTITYTYPE: NTSTATUS = 0xC0290025;
pub const STATUS_TPM_INVALID_POSTINIT: NTSTATUS = 0xC0290026;
pub const STATUS_TPM_INAPPROPRIATE_SIG: NTSTATUS = 0xC0290027;
pub const STATUS_TPM_BAD_KEY_PROPERTY: NTSTATUS = 0xC0290028;
pub const STATUS_TPM_BAD_MIGRATION: NTSTATUS = 0xC0290029;
pub const STATUS_TPM_BAD_SCHEME: NTSTATUS = 0xC029002A;
pub const STATUS_TPM_BAD_DATASIZE: NTSTATUS = 0xC029002B;
pub const STATUS_TPM_BAD_MODE: NTSTATUS = 0xC029002C;
pub const STATUS_TPM_BAD_PRESENCE: NTSTATUS = 0xC029002D;
pub const STATUS_TPM_BAD_VERSION: NTSTATUS = 0xC029002E;
pub const STATUS_TPM_NO_WRAP_TRANSPORT: NTSTATUS = 0xC029002F;
pub const STATUS_TPM_AUDITFAIL_UNSUCCESSFUL: NTSTATUS = 0xC0290030;
pub const STATUS_TPM_AUDITFAIL_SUCCESSFUL: NTSTATUS = 0xC0290031;
pub const STATUS_TPM_NOTRESETABLE: NTSTATUS = 0xC0290032;
pub const STATUS_TPM_NOTLOCAL: NTSTATUS = 0xC0290033;
pub const STATUS_TPM_BAD_TYPE: NTSTATUS = 0xC0290034;
pub const STATUS_TPM_INVALID_RESOURCE: NTSTATUS = 0xC0290035;
pub const STATUS_TPM_NOTFIPS: NTSTATUS = 0xC0290036;
pub const STATUS_TPM_INVALID_FAMILY: NTSTATUS = 0xC0290037;
pub const STATUS_TPM_NO_NV_PERMISSION: NTSTATUS = 0xC0290038;
pub const STATUS_TPM_REQUIRES_SIGN: NTSTATUS = 0xC0290039;
pub const STATUS_TPM_KEY_NOTSUPPORTED: NTSTATUS = 0xC029003A;
pub const STATUS_TPM_AUTH_CONFLICT: NTSTATUS = 0xC029003B;
pub const STATUS_TPM_AREA_LOCKED: NTSTATUS = 0xC029003C;
pub const STATUS_TPM_BAD_LOCALITY: NTSTATUS = 0xC029003D;
pub const STATUS_TPM_READ_ONLY: NTSTATUS = 0xC029003E;
pub const STATUS_TPM_PER_NOWRITE: NTSTATUS = 0xC029003F;
pub const STATUS_TPM_FAMILYCOUNT: NTSTATUS = 0xC0290040;
pub const STATUS_TPM_WRITE_LOCKED: NTSTATUS = 0xC0290041;
pub const STATUS_TPM_BAD_ATTRIBUTES: NTSTATUS = 0xC0290042;
pub const STATUS_TPM_INVALID_STRUCTURE: NTSTATUS = 0xC0290043;
pub const STATUS_TPM_KEY_OWNER_CONTROL: NTSTATUS = 0xC0290044;
pub const STATUS_TPM_BAD_COUNTER: NTSTATUS = 0xC0290045;
pub const STATUS_TPM_NOT_FULLWRITE: NTSTATUS = 0xC0290046;
pub const STATUS_TPM_CONTEXT_GAP: NTSTATUS = 0xC0290047;
pub const STATUS_TPM_MAXNVWRITES: NTSTATUS = 0xC0290048;
pub const STATUS_TPM_NOOPERATOR: NTSTATUS = 0xC0290049;
pub const STATUS_TPM_RESOURCEMISSING: NTSTATUS = 0xC029004A;
pub const STATUS_TPM_DELEGATE_LOCK: NTSTATUS = 0xC029004B;
pub const STATUS_TPM_DELEGATE_FAMILY: NTSTATUS = 0xC029004C;
pub const STATUS_TPM_DELEGATE_ADMIN: NTSTATUS = 0xC029004D;
pub const STATUS_TPM_TRANSPORT_NOTEXCLUSIVE: NTSTATUS = 0xC029004E;
pub const STATUS_TPM_OWNER_CONTROL: NTSTATUS = 0xC029004F;
pub const STATUS_TPM_DAA_RESOURCES: NTSTATUS = 0xC0290050;
pub const STATUS_TPM_DAA_INPUT_DATA0: NTSTATUS = 0xC0290051;
pub const STATUS_TPM_DAA_INPUT_DATA1: NTSTATUS = 0xC0290052;
pub const STATUS_TPM_DAA_ISSUER_SETTINGS: NTSTATUS = 0xC0290053;
pub const STATUS_TPM_DAA_TPM_SETTINGS: NTSTATUS = 0xC0290054;
pub const STATUS_TPM_DAA_STAGE: NTSTATUS = 0xC0290055;
pub const STATUS_TPM_DAA_ISSUER_VALIDITY: NTSTATUS = 0xC0290056;
pub const STATUS_TPM_DAA_WRONG_W: NTSTATUS = 0xC0290057;
pub const STATUS_TPM_BAD_HANDLE: NTSTATUS = 0xC0290058;
pub const STATUS_TPM_BAD_DELEGATE: NTSTATUS = 0xC0290059;
pub const STATUS_TPM_BADCONTEXT: NTSTATUS = 0xC029005A;
pub const STATUS_TPM_TOOMANYCONTEXTS: NTSTATUS = 0xC029005B;
pub const STATUS_TPM_MA_TICKET_SIGNATURE: NTSTATUS = 0xC029005C;
pub const STATUS_TPM_MA_DESTINATION: NTSTATUS = 0xC029005D;
pub const STATUS_TPM_MA_SOURCE: NTSTATUS = 0xC029005E;
pub const STATUS_TPM_MA_AUTHORITY: NTSTATUS = 0xC029005F;
pub const STATUS_TPM_PERMANENTEK: NTSTATUS = 0xC0290061;
pub const STATUS_TPM_BAD_SIGNATURE: NTSTATUS = 0xC0290062;
pub const STATUS_TPM_NOCONTEXTSPACE: NTSTATUS = 0xC0290063;
pub const STATUS_TPM_COMMAND_BLOCKED: NTSTATUS = 0xC0290400;
pub const STATUS_TPM_INVALID_HANDLE: NTSTATUS = 0xC0290401;
pub const STATUS_TPM_DUPLICATE_VHANDLE: NTSTATUS = 0xC0290402;
pub const STATUS_TPM_EMBEDDED_COMMAND_BLOCKED: NTSTATUS = 0xC0290403;
pub const STATUS_TPM_EMBEDDED_COMMAND_UNSUPPORTED: NTSTATUS = 0xC0290404;
pub const STATUS_TPM_RETRY: NTSTATUS = 0xC0290800;
pub const STATUS_TPM_NEEDS_SELFTEST: NTSTATUS = 0xC0290801;
pub const STATUS_TPM_DOING_SELFTEST: NTSTATUS = 0xC0290802;
pub const STATUS_TPM_DEFEND_LOCK_RUNNING: NTSTATUS = 0xC0290803;
pub const STATUS_TPM_COMMAND_CANCELED: NTSTATUS = 0xC0291001;
pub const STATUS_TPM_TOO_MANY_CONTEXTS: NTSTATUS = 0xC0291002;
pub const STATUS_TPM_NOT_FOUND: NTSTATUS = 0xC0291003;
pub const STATUS_TPM_ACCESS_DENIED: NTSTATUS = 0xC0291004;
pub const STATUS_TPM_INSUFFICIENT_BUFFER: NTSTATUS = 0xC0291005;
pub const STATUS_TPM_PPI_FUNCTION_UNSUPPORTED: NTSTATUS = 0xC0291006;
pub const STATUS_PCP_ERROR_MASK: NTSTATUS = 0xC0292000;
pub const STATUS_PCP_DEVICE_NOT_READY: NTSTATUS = 0xC0292001;
pub const STATUS_PCP_INVALID_HANDLE: NTSTATUS = 0xC0292002;
pub const STATUS_PCP_INVALID_PARAMETER: NTSTATUS = 0xC0292003;
pub const STATUS_PCP_FLAG_NOT_SUPPORTED: NTSTATUS = 0xC0292004;
pub const STATUS_PCP_NOT_SUPPORTED: NTSTATUS = 0xC0292005;
pub const STATUS_PCP_BUFFER_TOO_SMALL: NTSTATUS = 0xC0292006;
pub const STATUS_PCP_INTERNAL_ERROR: NTSTATUS = 0xC0292007;
pub const STATUS_PCP_AUTHENTICATION_FAILED: NTSTATUS = 0xC0292008;
pub const STATUS_PCP_AUTHENTICATION_IGNORED: NTSTATUS = 0xC0292009;
pub const STATUS_PCP_POLICY_NOT_FOUND: NTSTATUS = 0xC029200A;
pub const STATUS_PCP_PROFILE_NOT_FOUND: NTSTATUS = 0xC029200B;
pub const STATUS_PCP_VALIDATION_FAILED: NTSTATUS = 0xC029200C;
pub const STATUS_PCP_DEVICE_NOT_FOUND: NTSTATUS = 0xC029200D;
pub const STATUS_RTPM_CONTEXT_CONTINUE: NTSTATUS = 0x00293000;
pub const STATUS_RTPM_CONTEXT_COMPLETE: NTSTATUS = 0x00293001;
pub const STATUS_RTPM_NO_RESULT: NTSTATUS = 0xC0293002;
pub const STATUS_RTPM_PCR_READ_INCOMPLETE: NTSTATUS = 0xC0293003;
pub const STATUS_RTPM_INVALID_CONTEXT: NTSTATUS = 0xC0293004;
pub const STATUS_RTPM_UNSUPPORTED_CMD: NTSTATUS = 0xC0293005;
pub const STATUS_HV_INVALID_HYPERCALL_CODE: NTSTATUS = 0xC0350002;
pub const STATUS_HV_INVALID_HYPERCALL_INPUT: NTSTATUS = 0xC0350003;
pub const STATUS_HV_INVALID_ALIGNMENT: NTSTATUS = 0xC0350004;
pub const STATUS_HV_INVALID_PARAMETER: NTSTATUS = 0xC0350005;
pub const STATUS_HV_ACCESS_DENIED: NTSTATUS = 0xC0350006;
pub const STATUS_HV_INVALID_PARTITION_STATE: NTSTATUS = 0xC0350007;
pub const STATUS_HV_OPERATION_DENIED: NTSTATUS = 0xC0350008;
pub const STATUS_HV_UNKNOWN_PROPERTY: NTSTATUS = 0xC0350009;
pub const STATUS_HV_PROPERTY_VALUE_OUT_OF_RANGE: NTSTATUS = 0xC035000A;
pub const STATUS_HV_INSUFFICIENT_MEMORY: NTSTATUS = 0xC035000B;
pub const STATUS_HV_PARTITION_TOO_DEEP: NTSTATUS = 0xC035000C;
pub const STATUS_HV_INVALID_PARTITION_ID: NTSTATUS = 0xC035000D;
pub const STATUS_HV_INVALID_VP_INDEX: NTSTATUS = 0xC035000E;
pub const STATUS_HV_INVALID_PORT_ID: NTSTATUS = 0xC0350011;
pub const STATUS_HV_INVALID_CONNECTION_ID: NTSTATUS = 0xC0350012;
pub const STATUS_HV_INSUFFICIENT_BUFFERS: NTSTATUS = 0xC0350013;
pub const STATUS_HV_NOT_ACKNOWLEDGED: NTSTATUS = 0xC0350014;
pub const STATUS_HV_INVALID_VP_STATE: NTSTATUS = 0xC0350015;
pub const STATUS_HV_ACKNOWLEDGED: NTSTATUS = 0xC0350016;
pub const STATUS_HV_INVALID_SAVE_RESTORE_STATE: NTSTATUS = 0xC0350017;
pub const STATUS_HV_INVALID_SYNIC_STATE: NTSTATUS = 0xC0350018;
pub const STATUS_HV_OBJECT_IN_USE: NTSTATUS = 0xC0350019;
pub const STATUS_HV_INVALID_PROXIMITY_DOMAIN_INFO: NTSTATUS = 0xC035001A;
pub const STATUS_HV_NO_DATA: NTSTATUS = 0xC035001B;
pub const STATUS_HV_INACTIVE: NTSTATUS = 0xC035001C;
pub const STATUS_HV_NO_RESOURCES: NTSTATUS = 0xC035001D;
pub const STATUS_HV_FEATURE_UNAVAILABLE: NTSTATUS = 0xC035001E;
pub const STATUS_HV_INSUFFICIENT_BUFFER: NTSTATUS = 0xC0350033;
pub const STATUS_HV_INSUFFICIENT_DEVICE_DOMAINS: NTSTATUS = 0xC0350038;
pub const STATUS_HV_CPUID_FEATURE_VALIDATION_ERROR: NTSTATUS = 0xC035003C;
pub const STATUS_HV_CPUID_XSAVE_FEATURE_VALIDATION_ERROR: NTSTATUS = 0xC035003D;
pub const STATUS_HV_PROCESSOR_STARTUP_TIMEOUT: NTSTATUS = 0xC035003E;
pub const STATUS_HV_SMX_ENABLED: NTSTATUS = 0xC035003F;
pub const STATUS_HV_INVALID_LP_INDEX: NTSTATUS = 0xC0350041;
pub const STATUS_HV_INVALID_REGISTER_VALUE: NTSTATUS = 0xC0350050;
pub const STATUS_HV_INVALID_VTL_STATE: NTSTATUS = 0xC0350051;
pub const STATUS_HV_NX_NOT_DETECTED: NTSTATUS = 0xC0350055;
pub const STATUS_HV_INVALID_DEVICE_ID: NTSTATUS = 0xC0350057;
pub const STATUS_HV_INVALID_DEVICE_STATE: NTSTATUS = 0xC0350058;
pub const STATUS_HV_PENDING_PAGE_REQUESTS: NTSTATUS = 0x00350059;
pub const STATUS_HV_PAGE_REQUEST_INVALID: NTSTATUS = 0xC0350060;
pub const STATUS_HV_INVALID_CPU_GROUP_ID: NTSTATUS = 0xC035006F;
pub const STATUS_HV_INVALID_CPU_GROUP_STATE: NTSTATUS = 0xC0350070;
pub const STATUS_HV_NOT_ALLOWED_WITH_NESTED_VIRT_ACTIVE: NTSTATUS = 0xC0350071;
pub const STATUS_HV_NOT_PRESENT: NTSTATUS = 0xC0351000;
pub const STATUS_VID_DUPLICATE_HANDLER: NTSTATUS = 0xC0370001;
pub const STATUS_VID_TOO_MANY_HANDLERS: NTSTATUS = 0xC0370002;
pub const STATUS_VID_QUEUE_FULL: NTSTATUS = 0xC0370003;
pub const STATUS_VID_HANDLER_NOT_PRESENT: NTSTATUS = 0xC0370004;
pub const STATUS_VID_INVALID_OBJECT_NAME: NTSTATUS = 0xC0370005;
pub const STATUS_VID_PARTITION_NAME_TOO_LONG: NTSTATUS = 0xC0370006;
pub const STATUS_VID_MESSAGE_QUEUE_NAME_TOO_LONG: NTSTATUS = 0xC0370007;
pub const STATUS_VID_PARTITION_ALREADY_EXISTS: NTSTATUS = 0xC0370008;
pub const STATUS_VID_PARTITION_DOES_NOT_EXIST: NTSTATUS = 0xC0370009;
pub const STATUS_VID_PARTITION_NAME_NOT_FOUND: NTSTATUS = 0xC037000A;
pub const STATUS_VID_MESSAGE_QUEUE_ALREADY_EXISTS: NTSTATUS = 0xC037000B;
pub const STATUS_VID_EXCEEDED_MBP_ENTRY_MAP_LIMIT: NTSTATUS = 0xC037000C;
pub const STATUS_VID_MB_STILL_REFERENCED: NTSTATUS = 0xC037000D;
pub const STATUS_VID_CHILD_GPA_PAGE_SET_CORRUPTED: NTSTATUS = 0xC037000E;
pub const STATUS_VID_INVALID_NUMA_SETTINGS: NTSTATUS = 0xC037000F;
pub const STATUS_VID_INVALID_NUMA_NODE_INDEX: NTSTATUS = 0xC0370010;
pub const STATUS_VID_NOTIFICATION_QUEUE_ALREADY_ASSOCIATED: NTSTATUS = 0xC0370011;
pub const STATUS_VID_INVALID_MEMORY_BLOCK_HANDLE: NTSTATUS = 0xC0370012;
pub const STATUS_VID_PAGE_RANGE_OVERFLOW: NTSTATUS = 0xC0370013;
pub const STATUS_VID_INVALID_MESSAGE_QUEUE_HANDLE: NTSTATUS = 0xC0370014;
pub const STATUS_VID_INVALID_GPA_RANGE_HANDLE: NTSTATUS = 0xC0370015;
pub const STATUS_VID_NO_MEMORY_BLOCK_NOTIFICATION_QUEUE: NTSTATUS = 0xC0370016;
pub const STATUS_VID_MEMORY_BLOCK_LOCK_COUNT_EXCEEDED: NTSTATUS = 0xC0370017;
pub const STATUS_VID_INVALID_PPM_HANDLE: NTSTATUS = 0xC0370018;
pub const STATUS_VID_MBPS_ARE_LOCKED: NTSTATUS = 0xC0370019;
pub const STATUS_VID_MESSAGE_QUEUE_CLOSED: NTSTATUS = 0xC037001A;
pub const STATUS_VID_VIRTUAL_PROCESSOR_LIMIT_EXCEEDED: NTSTATUS = 0xC037001B;
pub const STATUS_VID_STOP_PENDING: NTSTATUS = 0xC037001C;
pub const STATUS_VID_INVALID_PROCESSOR_STATE: NTSTATUS = 0xC037001D;
pub const STATUS_VID_EXCEEDED_KM_CONTEXT_COUNT_LIMIT: NTSTATUS = 0xC037001E;
pub const STATUS_VID_KM_INTERFACE_ALREADY_INITIALIZED: NTSTATUS = 0xC037001F;
pub const STATUS_VID_MB_PROPERTY_ALREADY_SET_RESET: NTSTATUS = 0xC0370020;
pub const STATUS_VID_MMIO_RANGE_DESTROYED: NTSTATUS = 0xC0370021;
pub const STATUS_VID_INVALID_CHILD_GPA_PAGE_SET: NTSTATUS = 0xC0370022;
pub const STATUS_VID_RESERVE_PAGE_SET_IS_BEING_USED: NTSTATUS = 0xC0370023;
pub const STATUS_VID_RESERVE_PAGE_SET_TOO_SMALL: NTSTATUS = 0xC0370024;
pub const STATUS_VID_MBP_ALREADY_LOCKED_USING_RESERVED_PAGE: NTSTATUS = 0xC0370025;
pub const STATUS_VID_MBP_COUNT_EXCEEDED_LIMIT: NTSTATUS = 0xC0370026;
pub const STATUS_VID_SAVED_STATE_CORRUPT: NTSTATUS = 0xC0370027;
pub const STATUS_VID_SAVED_STATE_UNRECOGNIZED_ITEM: NTSTATUS = 0xC0370028;
pub const STATUS_VID_SAVED_STATE_INCOMPATIBLE: NTSTATUS = 0xC0370029;
pub const STATUS_VID_VTL_ACCESS_DENIED: NTSTATUS = 0xC037002A;
pub const STATUS_VID_REMOTE_NODE_PARENT_GPA_PAGES_USED: NTSTATUS = 0x80370001;
pub const STATUS_IPSEC_BAD_SPI: NTSTATUS = 0xC0360001;
pub const STATUS_IPSEC_SA_LIFETIME_EXPIRED: NTSTATUS = 0xC0360002;
pub const STATUS_IPSEC_WRONG_SA: NTSTATUS = 0xC0360003;
pub const STATUS_IPSEC_REPLAY_CHECK_FAILED: NTSTATUS = 0xC0360004;
pub const STATUS_IPSEC_INVALID_PACKET: NTSTATUS = 0xC0360005;
pub const STATUS_IPSEC_INTEGRITY_CHECK_FAILED: NTSTATUS = 0xC0360006;
pub const STATUS_IPSEC_CLEAR_TEXT_DROP: NTSTATUS = 0xC0360007;
pub const STATUS_IPSEC_AUTH_FIREWALL_DROP: NTSTATUS = 0xC0360008;
pub const STATUS_IPSEC_THROTTLE_DROP: NTSTATUS = 0xC0360009;
pub const STATUS_IPSEC_DOSP_BLOCK: NTSTATUS = 0xC0368000;
pub const STATUS_IPSEC_DOSP_RECEIVED_MULTICAST: NTSTATUS = 0xC0368001;
pub const STATUS_IPSEC_DOSP_INVALID_PACKET: NTSTATUS = 0xC0368002;
pub const STATUS_IPSEC_DOSP_STATE_LOOKUP_FAILED: NTSTATUS = 0xC0368003;
pub const STATUS_IPSEC_DOSP_MAX_ENTRIES: NTSTATUS = 0xC0368004;
pub const STATUS_IPSEC_DOSP_KEYMOD_NOT_ALLOWED: NTSTATUS = 0xC0368005;
pub const STATUS_IPSEC_DOSP_MAX_PER_IP_RATELIMIT_QUEUES: NTSTATUS = 0xC0368006;
pub const STATUS_VOLMGR_INCOMPLETE_REGENERATION: NTSTATUS = 0x80380001;
pub const STATUS_VOLMGR_INCOMPLETE_DISK_MIGRATION: NTSTATUS = 0x80380002;
pub const STATUS_VOLMGR_DATABASE_FULL: NTSTATUS = 0xC0380001;
pub const STATUS_VOLMGR_DISK_CONFIGURATION_CORRUPTED: NTSTATUS = 0xC0380002;
pub const STATUS_VOLMGR_DISK_CONFIGURATION_NOT_IN_SYNC: NTSTATUS = 0xC0380003;
pub const STATUS_VOLMGR_PACK_CONFIG_UPDATE_FAILED: NTSTATUS = 0xC0380004;
pub const STATUS_VOLMGR_DISK_CONTAINS_NON_SIMPLE_VOLUME: NTSTATUS = 0xC0380005;
pub const STATUS_VOLMGR_DISK_DUPLICATE: NTSTATUS = 0xC0380006;
pub const STATUS_VOLMGR_DISK_DYNAMIC: NTSTATUS = 0xC0380007;
pub const STATUS_VOLMGR_DISK_ID_INVALID: NTSTATUS = 0xC0380008;
pub const STATUS_VOLMGR_DISK_INVALID: NTSTATUS = 0xC0380009;
pub const STATUS_VOLMGR_DISK_LAST_VOTER: NTSTATUS = 0xC038000A;
pub const STATUS_VOLMGR_DISK_LAYOUT_INVALID: NTSTATUS = 0xC038000B;
pub const STATUS_VOLMGR_DISK_LAYOUT_NON_BASIC_BETWEEN_BASIC_PARTITIONS: NTSTATUS
    = 0xC038000C;
pub const STATUS_VOLMGR_DISK_LAYOUT_NOT_CYLINDER_ALIGNED: NTSTATUS = 0xC038000D;
pub const STATUS_VOLMGR_DISK_LAYOUT_PARTITIONS_TOO_SMALL: NTSTATUS = 0xC038000E;
pub const STATUS_VOLMGR_DISK_LAYOUT_PRIMARY_BETWEEN_LOGICAL_PARTITIONS: NTSTATUS
    = 0xC038000F;
pub const STATUS_VOLMGR_DISK_LAYOUT_TOO_MANY_PARTITIONS: NTSTATUS = 0xC0380010;
pub const STATUS_VOLMGR_DISK_MISSING: NTSTATUS = 0xC0380011;
pub const STATUS_VOLMGR_DISK_NOT_EMPTY: NTSTATUS = 0xC0380012;
pub const STATUS_VOLMGR_DISK_NOT_ENOUGH_SPACE: NTSTATUS = 0xC0380013;
pub const STATUS_VOLMGR_DISK_REVECTORING_FAILED: NTSTATUS = 0xC0380014;
pub const STATUS_VOLMGR_DISK_SECTOR_SIZE_INVALID: NTSTATUS = 0xC0380015;
pub const STATUS_VOLMGR_DISK_SET_NOT_CONTAINED: NTSTATUS = 0xC0380016;
pub const STATUS_VOLMGR_DISK_USED_BY_MULTIPLE_MEMBERS: NTSTATUS = 0xC0380017;
pub const STATUS_VOLMGR_DISK_USED_BY_MULTIPLE_PLEXES: NTSTATUS = 0xC0380018;
pub const STATUS_VOLMGR_DYNAMIC_DISK_NOT_SUPPORTED: NTSTATUS = 0xC0380019;
pub const STATUS_VOLMGR_EXTENT_ALREADY_USED: NTSTATUS = 0xC038001A;
pub const STATUS_VOLMGR_EXTENT_NOT_CONTIGUOUS: NTSTATUS = 0xC038001B;
pub const STATUS_VOLMGR_EXTENT_NOT_IN_PUBLIC_REGION: NTSTATUS = 0xC038001C;
pub const STATUS_VOLMGR_EXTENT_NOT_SECTOR_ALIGNED: NTSTATUS = 0xC038001D;
pub const STATUS_VOLMGR_EXTENT_OVERLAPS_EBR_PARTITION: NTSTATUS = 0xC038001E;
pub const STATUS_VOLMGR_EXTENT_VOLUME_LENGTHS_DO_NOT_MATCH: NTSTATUS = 0xC038001F;
pub const STATUS_VOLMGR_FAULT_TOLERANT_NOT_SUPPORTED: NTSTATUS = 0xC0380020;
pub const STATUS_VOLMGR_INTERLEAVE_LENGTH_INVALID: NTSTATUS = 0xC0380021;
pub const STATUS_VOLMGR_MAXIMUM_REGISTERED_USERS: NTSTATUS = 0xC0380022;
pub const STATUS_VOLMGR_MEMBER_IN_SYNC: NTSTATUS = 0xC0380023;
pub const STATUS_VOLMGR_MEMBER_INDEX_DUPLICATE: NTSTATUS = 0xC0380024;
pub const STATUS_VOLMGR_MEMBER_INDEX_INVALID: NTSTATUS = 0xC0380025;
pub const STATUS_VOLMGR_MEMBER_MISSING: NTSTATUS = 0xC0380026;
pub const STATUS_VOLMGR_MEMBER_NOT_DETACHED: NTSTATUS = 0xC0380027;
pub const STATUS_VOLMGR_MEMBER_REGENERATING: NTSTATUS = 0xC0380028;
pub const STATUS_VOLMGR_ALL_DISKS_FAILED: NTSTATUS = 0xC0380029;
pub const STATUS_VOLMGR_NO_REGISTERED_USERS: NTSTATUS = 0xC038002A;
pub const STATUS_VOLMGR_NO_SUCH_USER: NTSTATUS = 0xC038002B;
pub const STATUS_VOLMGR_NOTIFICATION_RESET: NTSTATUS = 0xC038002C;
pub const STATUS_VOLMGR_NUMBER_OF_MEMBERS_INVALID: NTSTATUS = 0xC038002D;
pub const STATUS_VOLMGR_NUMBER_OF_PLEXES_INVALID: NTSTATUS = 0xC038002E;
pub const STATUS_VOLMGR_PACK_DUPLICATE: NTSTATUS = 0xC038002F;
pub const STATUS_VOLMGR_PACK_ID_INVALID: NTSTATUS = 0xC0380030;
pub const STATUS_VOLMGR_PACK_INVALID: NTSTATUS = 0xC0380031;
pub const STATUS_VOLMGR_PACK_NAME_INVALID: NTSTATUS = 0xC0380032;
pub const STATUS_VOLMGR_PACK_OFFLINE: NTSTATUS = 0xC0380033;
pub const STATUS_VOLMGR_PACK_HAS_QUORUM: NTSTATUS = 0xC0380034;
pub const STATUS_VOLMGR_PACK_WITHOUT_QUORUM: NTSTATUS = 0xC0380035;
pub const STATUS_VOLMGR_PARTITION_STYLE_INVALID: NTSTATUS = 0xC0380036;
pub const STATUS_VOLMGR_PARTITION_UPDATE_FAILED: NTSTATUS = 0xC0380037;
pub const STATUS_VOLMGR_PLEX_IN_SYNC: NTSTATUS = 0xC0380038;
pub const STATUS_VOLMGR_PLEX_INDEX_DUPLICATE: NTSTATUS = 0xC0380039;
pub const STATUS_VOLMGR_PLEX_INDEX_INVALID: NTSTATUS = 0xC038003A;
pub const STATUS_VOLMGR_PLEX_LAST_ACTIVE: NTSTATUS = 0xC038003B;
pub const STATUS_VOLMGR_PLEX_MISSING: NTSTATUS = 0xC038003C;
pub const STATUS_VOLMGR_PLEX_REGENERATING: NTSTATUS = 0xC038003D;
pub const STATUS_VOLMGR_PLEX_TYPE_INVALID: NTSTATUS = 0xC038003E;
pub const STATUS_VOLMGR_PLEX_NOT_RAID5: NTSTATUS = 0xC038003F;
pub const STATUS_VOLMGR_PLEX_NOT_SIMPLE: NTSTATUS = 0xC0380040;
pub const STATUS_VOLMGR_STRUCTURE_SIZE_INVALID: NTSTATUS = 0xC0380041;
pub const STATUS_VOLMGR_TOO_MANY_NOTIFICATION_REQUESTS: NTSTATUS = 0xC0380042;
pub const STATUS_VOLMGR_TRANSACTION_IN_PROGRESS: NTSTATUS = 0xC0380043;
pub const STATUS_VOLMGR_UNEXPECTED_DISK_LAYOUT_CHANGE: NTSTATUS = 0xC0380044;
pub const STATUS_VOLMGR_VOLUME_CONTAINS_MISSING_DISK: NTSTATUS = 0xC0380045;
pub const STATUS_VOLMGR_VOLUME_ID_INVALID: NTSTATUS = 0xC0380046;
pub const STATUS_VOLMGR_VOLUME_LENGTH_INVALID: NTSTATUS = 0xC0380047;
pub const STATUS_VOLMGR_VOLUME_LENGTH_NOT_SECTOR_SIZE_MULTIPLE: NTSTATUS = 0xC0380048;
pub const STATUS_VOLMGR_VOLUME_NOT_MIRRORED: NTSTATUS = 0xC0380049;
pub const STATUS_VOLMGR_VOLUME_NOT_RETAINED: NTSTATUS = 0xC038004A;
pub const STATUS_VOLMGR_VOLUME_OFFLINE: NTSTATUS = 0xC038004B;
pub const STATUS_VOLMGR_VOLUME_RETAINED: NTSTATUS = 0xC038004C;
pub const STATUS_VOLMGR_NUMBER_OF_EXTENTS_INVALID: NTSTATUS = 0xC038004D;
pub const STATUS_VOLMGR_DIFFERENT_SECTOR_SIZE: NTSTATUS = 0xC038004E;
pub const STATUS_VOLMGR_BAD_BOOT_DISK: NTSTATUS = 0xC038004F;
pub const STATUS_VOLMGR_PACK_CONFIG_OFFLINE: NTSTATUS = 0xC0380050;
pub const STATUS_VOLMGR_PACK_CONFIG_ONLINE: NTSTATUS = 0xC0380051;
pub const STATUS_VOLMGR_NOT_PRIMARY_PACK: NTSTATUS = 0xC0380052;
pub const STATUS_VOLMGR_PACK_LOG_UPDATE_FAILED: NTSTATUS = 0xC0380053;
pub const STATUS_VOLMGR_NUMBER_OF_DISKS_IN_PLEX_INVALID: NTSTATUS = 0xC0380054;
pub const STATUS_VOLMGR_NUMBER_OF_DISKS_IN_MEMBER_INVALID: NTSTATUS = 0xC0380055;
pub const STATUS_VOLMGR_VOLUME_MIRRORED: NTSTATUS = 0xC0380056;
pub const STATUS_VOLMGR_PLEX_NOT_SIMPLE_SPANNED: NTSTATUS = 0xC0380057;
pub const STATUS_VOLMGR_NO_VALID_LOG_COPIES: NTSTATUS = 0xC0380058;
pub const STATUS_VOLMGR_PRIMARY_PACK_PRESENT: NTSTATUS = 0xC0380059;
pub const STATUS_VOLMGR_NUMBER_OF_DISKS_INVALID: NTSTATUS = 0xC038005A;
pub const STATUS_VOLMGR_MIRROR_NOT_SUPPORTED: NTSTATUS = 0xC038005B;
pub const STATUS_VOLMGR_RAID5_NOT_SUPPORTED: NTSTATUS = 0xC038005C;
pub const STATUS_BCD_NOT_ALL_ENTRIES_IMPORTED: NTSTATUS = 0x80390001;
pub const STATUS_BCD_TOO_MANY_ELEMENTS: NTSTATUS = 0xC0390002;
pub const STATUS_BCD_NOT_ALL_ENTRIES_SYNCHRONIZED: NTSTATUS = 0x80390003;
pub const STATUS_VHD_DRIVE_FOOTER_MISSING: NTSTATUS = 0xC03A0001;
pub const STATUS_VHD_DRIVE_FOOTER_CHECKSUM_MISMATCH: NTSTATUS = 0xC03A0002;
pub const STATUS_VHD_DRIVE_FOOTER_CORRUPT: NTSTATUS = 0xC03A0003;
pub const STATUS_VHD_FORMAT_UNKNOWN: NTSTATUS = 0xC03A0004;
pub const STATUS_VHD_FORMAT_UNSUPPORTED_VERSION: NTSTATUS = 0xC03A0005;
pub const STATUS_VHD_SPARSE_HEADER_CHECKSUM_MISMATCH: NTSTATUS = 0xC03A0006;
pub const STATUS_VHD_SPARSE_HEADER_UNSUPPORTED_VERSION: NTSTATUS = 0xC03A0007;
pub const STATUS_VHD_SPARSE_HEADER_CORRUPT: NTSTATUS = 0xC03A0008;
pub const STATUS_VHD_BLOCK_ALLOCATION_FAILURE: NTSTATUS = 0xC03A0009;
pub const STATUS_VHD_BLOCK_ALLOCATION_TABLE_CORRUPT: NTSTATUS = 0xC03A000A;
pub const STATUS_VHD_INVALID_BLOCK_SIZE: NTSTATUS = 0xC03A000B;
pub const STATUS_VHD_BITMAP_MISMATCH: NTSTATUS = 0xC03A000C;
pub const STATUS_VHD_PARENT_VHD_NOT_FOUND: NTSTATUS = 0xC03A000D;
pub const STATUS_VHD_CHILD_PARENT_ID_MISMATCH: NTSTATUS = 0xC03A000E;
pub const STATUS_VHD_CHILD_PARENT_TIMESTAMP_MISMATCH: NTSTATUS = 0xC03A000F;
pub const STATUS_VHD_METADATA_READ_FAILURE: NTSTATUS = 0xC03A0010;
pub const STATUS_VHD_METADATA_WRITE_FAILURE: NTSTATUS = 0xC03A0011;
pub const STATUS_VHD_INVALID_SIZE: NTSTATUS = 0xC03A0012;
pub const STATUS_VHD_INVALID_FILE_SIZE: NTSTATUS = 0xC03A0013;
pub const STATUS_VIRTDISK_PROVIDER_NOT_FOUND: NTSTATUS = 0xC03A0014;
pub const STATUS_VIRTDISK_NOT_VIRTUAL_DISK: NTSTATUS = 0xC03A0015;
pub const STATUS_VHD_PARENT_VHD_ACCESS_DENIED: NTSTATUS = 0xC03A0016;
pub const STATUS_VHD_CHILD_PARENT_SIZE_MISMATCH: NTSTATUS = 0xC03A0017;
pub const STATUS_VHD_DIFFERENCING_CHAIN_CYCLE_DETECTED: NTSTATUS = 0xC03A0018;
pub const STATUS_VHD_DIFFERENCING_CHAIN_ERROR_IN_PARENT: NTSTATUS = 0xC03A0019;
pub const STATUS_VIRTUAL_DISK_LIMITATION: NTSTATUS = 0xC03A001A;
pub const STATUS_VHD_INVALID_TYPE: NTSTATUS = 0xC03A001B;
pub const STATUS_VHD_INVALID_STATE: NTSTATUS = 0xC03A001C;
pub const STATUS_VIRTDISK_UNSUPPORTED_DISK_SECTOR_SIZE: NTSTATUS = 0xC03A001D;
pub const STATUS_VIRTDISK_DISK_ALREADY_OWNED: NTSTATUS = 0xC03A001E;
pub const STATUS_VIRTDISK_DISK_ONLINE_AND_WRITABLE: NTSTATUS = 0xC03A001F;
pub const STATUS_CTLOG_TRACKING_NOT_INITIALIZED: NTSTATUS = 0xC03A0020;
pub const STATUS_CTLOG_LOGFILE_SIZE_EXCEEDED_MAXSIZE: NTSTATUS = 0xC03A0021;
pub const STATUS_CTLOG_VHD_CHANGED_OFFLINE: NTSTATUS = 0xC03A0022;
pub const STATUS_CTLOG_INVALID_TRACKING_STATE: NTSTATUS = 0xC03A0023;
pub const STATUS_CTLOG_INCONSISTENT_TRACKING_FILE: NTSTATUS = 0xC03A0024;
pub const STATUS_VHD_METADATA_FULL: NTSTATUS = 0xC03A0028;
pub const STATUS_VHD_INVALID_CHANGE_TRACKING_ID: NTSTATUS = 0xC03A0029;
pub const STATUS_VHD_CHANGE_TRACKING_DISABLED: NTSTATUS = 0xC03A002A;
pub const STATUS_VHD_MISSING_CHANGE_TRACKING_INFORMATION: NTSTATUS = 0xC03A0030;
pub const STATUS_VHD_RESIZE_WOULD_TRUNCATE_DATA: NTSTATUS = 0xC03A0031;
pub const STATUS_VHD_COULD_NOT_COMPUTE_MINIMUM_VIRTUAL_SIZE: NTSTATUS = 0xC03A0032;
pub const STATUS_VHD_ALREADY_AT_OR_BELOW_MINIMUM_VIRTUAL_SIZE: NTSTATUS = 0xC03A0033;
pub const STATUS_QUERY_STORAGE_ERROR: NTSTATUS = 0x803A0001;
pub const STATUS_RKF_KEY_NOT_FOUND: NTSTATUS = 0xC0400001;
pub const STATUS_RKF_DUPLICATE_KEY: NTSTATUS = 0xC0400002;
pub const STATUS_RKF_BLOB_FULL: NTSTATUS = 0xC0400003;
pub const STATUS_RKF_STORE_FULL: NTSTATUS = 0xC0400004;
pub const STATUS_RKF_FILE_BLOCKED: NTSTATUS = 0xC0400005;
pub const STATUS_RKF_ACTIVE_KEY: NTSTATUS = 0xC0400006;
pub const STATUS_RDBSS_RESTART_OPERATION: NTSTATUS = 0xC0410001;
pub const STATUS_RDBSS_CONTINUE_OPERATION: NTSTATUS = 0xC0410002;
pub const STATUS_RDBSS_POST_OPERATION: NTSTATUS = 0xC0410003;
pub const STATUS_BTH_ATT_INVALID_HANDLE: NTSTATUS = 0xC0420001;
pub const STATUS_BTH_ATT_READ_NOT_PERMITTED: NTSTATUS = 0xC0420002;
pub const STATUS_BTH_ATT_WRITE_NOT_PERMITTED: NTSTATUS = 0xC0420003;
pub const STATUS_BTH_ATT_INVALID_PDU: NTSTATUS = 0xC0420004;
pub const STATUS_BTH_ATT_INSUFFICIENT_AUTHENTICATION: NTSTATUS = 0xC0420005;
pub const STATUS_BTH_ATT_REQUEST_NOT_SUPPORTED: NTSTATUS = 0xC0420006;
pub const STATUS_BTH_ATT_INVALID_OFFSET: NTSTATUS = 0xC0420007;
pub const STATUS_BTH_ATT_INSUFFICIENT_AUTHORIZATION: NTSTATUS = 0xC0420008;
pub const STATUS_BTH_ATT_PREPARE_QUEUE_FULL: NTSTATUS = 0xC0420009;
pub const STATUS_BTH_ATT_ATTRIBUTE_NOT_FOUND: NTSTATUS = 0xC042000A;
pub const STATUS_BTH_ATT_ATTRIBUTE_NOT_LONG: NTSTATUS = 0xC042000B;
pub const STATUS_BTH_ATT_INSUFFICIENT_ENCRYPTION_KEY_SIZE: NTSTATUS = 0xC042000C;
pub const STATUS_BTH_ATT_INVALID_ATTRIBUTE_VALUE_LENGTH: NTSTATUS = 0xC042000D;
pub const STATUS_BTH_ATT_UNLIKELY: NTSTATUS = 0xC042000E;
pub const STATUS_BTH_ATT_INSUFFICIENT_ENCRYPTION: NTSTATUS = 0xC042000F;
pub const STATUS_BTH_ATT_UNSUPPORTED_GROUP_TYPE: NTSTATUS = 0xC0420010;
pub const STATUS_BTH_ATT_INSUFFICIENT_RESOURCES: NTSTATUS = 0xC0420011;
pub const STATUS_BTH_ATT_UNKNOWN_ERROR: NTSTATUS = 0xC0421000;
pub const STATUS_SECUREBOOT_ROLLBACK_DETECTED: NTSTATUS = 0xC0430001;
pub const STATUS_SECUREBOOT_POLICY_VIOLATION: NTSTATUS = 0xC0430002;
pub const STATUS_SECUREBOOT_INVALID_POLICY: NTSTATUS = 0xC0430003;
pub const STATUS_SECUREBOOT_POLICY_PUBLISHER_NOT_FOUND: NTSTATUS = 0xC0430004;
pub const STATUS_SECUREBOOT_POLICY_NOT_SIGNED: NTSTATUS = 0xC0430005;
pub const STATUS_SECUREBOOT_NOT_ENABLED: NTSTATUS = 0x80430006;
pub const STATUS_SECUREBOOT_FILE_REPLACED: NTSTATUS = 0xC0430007;
pub const STATUS_SECUREBOOT_POLICY_NOT_AUTHORIZED: NTSTATUS = 0xC0430008;
pub const STATUS_SECUREBOOT_POLICY_UNKNOWN: NTSTATUS = 0xC0430009;
pub const STATUS_SECUREBOOT_POLICY_MISSING_ANTIROLLBACKVERSION: NTSTATUS = 0xC043000A;
pub const STATUS_SECUREBOOT_PLATFORM_ID_MISMATCH: NTSTATUS = 0xC043000B;
pub const STATUS_SECUREBOOT_POLICY_ROLLBACK_DETECTED: NTSTATUS = 0xC043000C;
pub const STATUS_SECUREBOOT_POLICY_UPGRADE_MISMATCH: NTSTATUS = 0xC043000D;
pub const STATUS_SECUREBOOT_REQUIRED_POLICY_FILE_MISSING: NTSTATUS = 0xC043000E;
pub const STATUS_SECUREBOOT_NOT_BASE_POLICY: NTSTATUS = 0xC043000F;
pub const STATUS_SECUREBOOT_NOT_SUPPLEMENTAL_POLICY: NTSTATUS = 0xC0430010;
pub const STATUS_PLATFORM_MANIFEST_NOT_AUTHORIZED: NTSTATUS = 0xC0EB0001;
pub const STATUS_PLATFORM_MANIFEST_INVALID: NTSTATUS = 0xC0EB0002;
pub const STATUS_PLATFORM_MANIFEST_FILE_NOT_AUTHORIZED: NTSTATUS = 0xC0EB0003;
pub const STATUS_PLATFORM_MANIFEST_CATALOG_NOT_AUTHORIZED: NTSTATUS = 0xC0EB0004;
pub const STATUS_PLATFORM_MANIFEST_BINARY_ID_NOT_FOUND: NTSTATUS = 0xC0EB0005;
pub const STATUS_PLATFORM_MANIFEST_NOT_ACTIVE: NTSTATUS = 0xC0EB0006;
pub const STATUS_PLATFORM_MANIFEST_NOT_SIGNED: NTSTATUS = 0xC0EB0007;
pub const STATUS_SYSTEM_INTEGRITY_ROLLBACK_DETECTED: NTSTATUS = 0xC0E90001;
pub const STATUS_SYSTEM_INTEGRITY_POLICY_VIOLATION: NTSTATUS = 0xC0E90002;
pub const STATUS_SYSTEM_INTEGRITY_INVALID_POLICY: NTSTATUS = 0xC0E90003;
pub const STATUS_SYSTEM_INTEGRITY_POLICY_NOT_SIGNED: NTSTATUS = 0xC0E90004;
pub const STATUS_NO_APPLICABLE_APP_LICENSES_FOUND: NTSTATUS = 0xC0EA0001;
pub const STATUS_CLIP_LICENSE_NOT_FOUND: NTSTATUS = 0xC0EA0002;
pub const STATUS_CLIP_DEVICE_LICENSE_MISSING: NTSTATUS = 0xC0EA0003;
pub const STATUS_CLIP_LICENSE_INVALID_SIGNATURE: NTSTATUS = 0xC0EA0004;
pub const STATUS_CLIP_KEYHOLDER_LICENSE_MISSING_OR_INVALID: NTSTATUS = 0xC0EA0005;
pub const STATUS_CLIP_LICENSE_EXPIRED: NTSTATUS = 0xC0EA0006;
pub const STATUS_CLIP_LICENSE_SIGNED_BY_UNKNOWN_SOURCE: NTSTATUS = 0xC0EA0007;
pub const STATUS_CLIP_LICENSE_NOT_SIGNED: NTSTATUS = 0xC0EA0008;
pub const STATUS_CLIP_LICENSE_HARDWARE_ID_OUT_OF_TOLERANCE: NTSTATUS = 0xC0EA0009;
pub const STATUS_CLIP_LICENSE_DEVICE_ID_MISMATCH: NTSTATUS = 0xC0EA000A;
pub const STATUS_AUDIO_ENGINE_NODE_NOT_FOUND: NTSTATUS = 0xC0440001;
pub const STATUS_HDAUDIO_EMPTY_CONNECTION_LIST: NTSTATUS = 0xC0440002;
pub const STATUS_HDAUDIO_CONNECTION_LIST_NOT_SUPPORTED: NTSTATUS = 0xC0440003;
pub const STATUS_HDAUDIO_NO_LOGICAL_DEVICES_CREATED: NTSTATUS = 0xC0440004;
pub const STATUS_HDAUDIO_NULL_LINKED_LIST_ENTRY: NTSTATUS = 0xC0440005;
pub const STATUS_SPACES_REPAIRED: NTSTATUS = 0x00E70000;
pub const STATUS_SPACES_PAUSE: NTSTATUS = 0x00E70001;
pub const STATUS_SPACES_COMPLETE: NTSTATUS = 0x00E70002;
pub const STATUS_SPACES_FAULT_DOMAIN_TYPE_INVALID: NTSTATUS = 0xC0E70001;
pub const STATUS_SPACES_RESILIENCY_TYPE_INVALID: NTSTATUS = 0xC0E70003;
pub const STATUS_SPACES_DRIVE_SECTOR_SIZE_INVALID: NTSTATUS = 0xC0E70004;
pub const STATUS_SPACES_DRIVE_REDUNDANCY_INVALID: NTSTATUS = 0xC0E70006;
pub const STATUS_SPACES_NUMBER_OF_DATA_COPIES_INVALID: NTSTATUS = 0xC0E70007;
pub const STATUS_SPACES_INTERLEAVE_LENGTH_INVALID: NTSTATUS = 0xC0E70009;
pub const STATUS_SPACES_NUMBER_OF_COLUMNS_INVALID: NTSTATUS = 0xC0E7000A;
pub const STATUS_SPACES_NOT_ENOUGH_DRIVES: NTSTATUS = 0xC0E7000B;
pub const STATUS_SPACES_EXTENDED_ERROR: NTSTATUS = 0xC0E7000C;
pub const STATUS_SPACES_PROVISIONING_TYPE_INVALID: NTSTATUS = 0xC0E7000D;
pub const STATUS_SPACES_ALLOCATION_SIZE_INVALID: NTSTATUS = 0xC0E7000E;
pub const STATUS_SPACES_ENCLOSURE_AWARE_INVALID: NTSTATUS = 0xC0E7000F;
pub const STATUS_SPACES_WRITE_CACHE_SIZE_INVALID: NTSTATUS = 0xC0E70010;
pub const STATUS_SPACES_NUMBER_OF_GROUPS_INVALID: NTSTATUS = 0xC0E70011;
pub const STATUS_SPACES_DRIVE_OPERATIONAL_STATE_INVALID: NTSTATUS = 0xC0E70012;
pub const STATUS_SPACES_UPDATE_COLUMN_STATE: NTSTATUS = 0xC0E70013;
pub const STATUS_SPACES_MAP_REQUIRED: NTSTATUS = 0xC0E70014;
pub const STATUS_SPACES_UNSUPPORTED_VERSION: NTSTATUS = 0xC0E70015;
pub const STATUS_SPACES_CORRUPT_METADATA: NTSTATUS = 0xC0E70016;
pub const STATUS_SPACES_DRT_FULL: NTSTATUS = 0xC0E70017;
pub const STATUS_SPACES_INCONSISTENCY: NTSTATUS = 0xC0E70018;
pub const STATUS_SPACES_LOG_NOT_READY: NTSTATUS = 0xC0E70019;
pub const STATUS_SPACES_NO_REDUNDANCY: NTSTATUS = 0xC0E7001A;
pub const STATUS_SPACES_DRIVE_NOT_READY: NTSTATUS = 0xC0E7001B;
pub const STATUS_SPACES_DRIVE_SPLIT: NTSTATUS = 0xC0E7001C;
pub const STATUS_SPACES_DRIVE_LOST_DATA: NTSTATUS = 0xC0E7001D;
pub const STATUS_VOLSNAP_BOOTFILE_NOT_VALID: NTSTATUS = 0xC0500003;
pub const STATUS_VOLSNAP_ACTIVATION_TIMEOUT: NTSTATUS = 0xC0500004;
pub const STATUS_IO_PREEMPTED: NTSTATUS = 0xC0510001;
pub const STATUS_SVHDX_ERROR_STORED: NTSTATUS = 0xC05C0000;
pub const STATUS_SVHDX_ERROR_NOT_AVAILABLE: NTSTATUS = 0xC05CFF00;
pub const STATUS_SVHDX_UNIT_ATTENTION_AVAILABLE: NTSTATUS = 0xC05CFF01;
pub const STATUS_SVHDX_UNIT_ATTENTION_CAPACITY_DATA_CHANGED: NTSTATUS = 0xC05CFF02;
pub const STATUS_SVHDX_UNIT_ATTENTION_RESERVATIONS_PREEMPTED: NTSTATUS = 0xC05CFF03;
pub const STATUS_SVHDX_UNIT_ATTENTION_RESERVATIONS_RELEASED: NTSTATUS = 0xC05CFF04;
pub const STATUS_SVHDX_UNIT_ATTENTION_REGISTRATIONS_PREEMPTED: NTSTATUS = 0xC05CFF05;
pub const STATUS_SVHDX_UNIT_ATTENTION_OPERATING_DEFINITION_CHANGED: NTSTATUS
    = 0xC05CFF06;
pub const STATUS_SVHDX_RESERVATION_CONFLICT: NTSTATUS = 0xC05CFF07;
pub const STATUS_SVHDX_WRONG_FILE_TYPE: NTSTATUS = 0xC05CFF08;
pub const STATUS_SVHDX_VERSION_MISMATCH: NTSTATUS = 0xC05CFF09;
pub const STATUS_VHD_SHARED: NTSTATUS = 0xC05CFF0A;
pub const STATUS_SVHDX_NO_INITIATOR: NTSTATUS = 0xC05CFF0B;
pub const STATUS_VHDSET_BACKING_STORAGE_NOT_FOUND: NTSTATUS = 0xC05CFF0C;
pub const STATUS_SMB_NO_PREAUTH_INTEGRITY_HASH_OVERLAP: NTSTATUS = 0xC05D0000;
pub const STATUS_SMB_BAD_CLUSTER_DIALECT: NTSTATUS = 0xC05D0001;
pub const STATUS_SMB_GUEST_LOGON_BLOCKED: NTSTATUS = 0xC05D0002;
pub const STATUS_SECCORE_INVALID_COMMAND: NTSTATUS = 0xC0E80000;
pub const STATUS_VSM_NOT_INITIALIZED: NTSTATUS = 0xC0450000;
pub const STATUS_VSM_DMA_PROTECTION_NOT_IN_USE: NTSTATUS = 0xC0450001;
