/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.oid4vci.CredentialScopeModel;
import org.keycloak.protocol.oid4vc.model.Claims;
import org.keycloak.protocol.oid4vc.model.DisplayObject;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CredentialMetadata {
    @JsonProperty(value="display")
    private List<DisplayObject> display;
    @JsonProperty(value="claims")
    private Claims claims;

    public static CredentialMetadata parse(KeycloakSession keycloakSession, CredentialScopeModel credentialScope) {
        Claims formatSpecificClaims;
        CredentialMetadata metadata = new CredentialMetadata();
        List<DisplayObject> formatSpecificDisplay = DisplayObject.parse(credentialScope);
        if (formatSpecificDisplay != null && !formatSpecificDisplay.isEmpty()) {
            metadata.setDisplay(formatSpecificDisplay);
        }
        if ((formatSpecificClaims = Claims.parse(keycloakSession, credentialScope)) != null && !formatSpecificClaims.isEmpty()) {
            metadata.setClaims(formatSpecificClaims);
        }
        if (metadata.getDisplay() != null || metadata.getClaims() != null) {
            return metadata;
        }
        return null;
    }

    public List<DisplayObject> getDisplay() {
        return this.display;
    }

    public CredentialMetadata setDisplay(List<DisplayObject> display) {
        this.display = display;
        return this;
    }

    public Claims getClaims() {
        return this.claims;
    }

    public CredentialMetadata setClaims(Claims claims) {
        this.claims = claims;
        return this;
    }
}

