/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Objects;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.commons.util.Util;
import org.infinispan.remoting.transport.raft.RaftStateMachine;
import org.jgroups.raft.StateMachine;

class JGroupsStateMachineAdapter<T extends RaftStateMachine>
implements StateMachine {
    private final T stateMachine;

    JGroupsStateMachineAdapter(T stateMachine) {
        this.stateMachine = (RaftStateMachine)Objects.requireNonNull(stateMachine);
    }

    public byte[] apply(byte[] data, int offset, int length, boolean serialize_response) throws Exception {
        ByteBuffer buffer = this.stateMachine.apply((ByteBuffer)ByteBufferImpl.create((byte[])data, (int)offset, (int)length));
        return buffer == null ? Util.EMPTY_BYTE_ARRAY : buffer.trim();
    }

    public void readContentFrom(DataInput in) throws Exception {
        this.stateMachine.readStateFrom(in);
    }

    public void writeContentTo(DataOutput out) throws Exception {
        this.stateMachine.writeStateTo(out);
    }

    T getStateMachine() {
        return this.stateMachine;
    }
}

