/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispClass;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.StandardClass;
import org.armedbear.lisp.StandardObject;
import org.armedbear.lisp.Symbol;

public class ArithmeticError
extends LispError {
    private static final Primitive ARITHMETIC_ERROR_OPERATION = new Primitive("arithmetic-error-operation", "condition"){

        @Override
        public LispObject execute(LispObject arg) {
            if (arg.typep(Symbol.ARITHMETIC_ERROR) == Lisp.NIL) {
                return Lisp.type_error(arg, Symbol.ARITHMETIC_ERROR);
            }
            StandardObject obj = (StandardObject)arg;
            return obj.getInstanceSlotValue(Symbol.OPERATION);
        }
    };
    private static final Primitive ARITHMETIC_ERROR_OPERANDS = new Primitive("arithmetic-error-operands", "condition"){

        @Override
        public LispObject execute(LispObject arg) {
            if (arg.typep(Symbol.ARITHMETIC_ERROR) == Lisp.NIL) {
                return Lisp.type_error(arg, Symbol.ARITHMETIC_ERROR);
            }
            StandardObject obj = (StandardObject)arg;
            return obj.getInstanceSlotValue(Symbol.OPERANDS);
        }
    };

    protected ArithmeticError(LispClass cls) {
        super(cls);
    }

    public ArithmeticError(LispObject initArgs) {
        super(StandardClass.ARITHMETIC_ERROR);
        this.initialize(initArgs);
    }

    @Override
    protected void initialize(LispObject initArgs) {
        super.initialize(initArgs);
        LispObject operation = Lisp.NIL;
        LispObject operands = Lisp.NIL;
        while (initArgs != Lisp.NIL) {
            LispObject first = initArgs.car();
            initArgs = initArgs.cdr();
            LispObject second = initArgs.car();
            initArgs = initArgs.cdr();
            if (first == Keyword.OPERATION) {
                operation = second;
                continue;
            }
            if (first != Keyword.OPERANDS) continue;
            operands = second;
        }
        this.setOperation(operation);
        this.setOperands(operands);
    }

    public ArithmeticError(String message) {
        super(StandardClass.ARITHMETIC_ERROR);
        this.setFormatControl(message.replaceAll("~", "~~"));
        this.setFormatArguments(Lisp.NIL);
        this.setOperation(Lisp.NIL);
        this.setOperands(Lisp.NIL);
    }

    @Override
    public LispObject typeOf() {
        return Symbol.ARITHMETIC_ERROR;
    }

    @Override
    public LispObject classOf() {
        return StandardClass.ARITHMETIC_ERROR;
    }

    @Override
    public LispObject typep(LispObject type) {
        if (type == Symbol.ARITHMETIC_ERROR) {
            return Lisp.T;
        }
        if (type == StandardClass.ARITHMETIC_ERROR) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    final LispObject getOperation() {
        return this.getInstanceSlotValue(Symbol.OPERATION);
    }

    private final void setOperation(LispObject operation) {
        this.setInstanceSlotValue(Symbol.OPERATION, operation);
    }

    final LispObject getOperands() {
        return this.getInstanceSlotValue(Symbol.OPERANDS);
    }

    private final void setOperands(LispObject operands) {
        this.setInstanceSlotValue(Symbol.OPERANDS, operands);
    }
}

