/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.bbox;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.spatial.ShapeValues;
import org.apache.lucene.spatial.ShapeValuesSource;
import org.apache.lucene.spatial.bbox.BBoxStrategy;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;

class BBoxValueSource
extends ShapeValuesSource {
    private final BBoxStrategy strategy;

    public BBoxValueSource(BBoxStrategy strategy) {
        this.strategy = strategy;
    }

    public String toString() {
        return "bboxShape(" + this.strategy.getFieldName() + ")";
    }

    @Override
    public ShapeValues getValues(LeafReaderContext readerContext) throws IOException {
        LeafReader reader = readerContext.reader();
        final NumericDocValues minX = DocValues.getNumeric((LeafReader)reader, (String)this.strategy.field_minX);
        final NumericDocValues minY = DocValues.getNumeric((LeafReader)reader, (String)this.strategy.field_minY);
        final NumericDocValues maxX = DocValues.getNumeric((LeafReader)reader, (String)this.strategy.field_maxX);
        final NumericDocValues maxY = DocValues.getNumeric((LeafReader)reader, (String)this.strategy.field_maxY);
        final Rectangle rect = this.strategy.getSpatialContext().getShapeFactory().rect(0.0, 0.0, 0.0, 0.0);
        return new ShapeValues(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return minX.advanceExact(doc) && minY.advanceExact(doc) && maxX.advanceExact(doc) && maxY.advanceExact(doc);
            }

            @Override
            public Shape value() throws IOException {
                double minXValue = Double.longBitsToDouble(minX.longValue());
                double minYValue = Double.longBitsToDouble(minY.longValue());
                double maxXValue = Double.longBitsToDouble(maxX.longValue());
                double maxYValue = Double.longBitsToDouble(maxY.longValue());
                rect.reset(minXValue, maxXValue, minYValue, maxYValue);
                return rect;
            }
        };
    }

    public boolean isCacheable(LeafReaderContext ctx) {
        return DocValues.isCacheable((LeafReaderContext)ctx, (String[])new String[]{this.strategy.field_minX, this.strategy.field_minY, this.strategy.field_maxX, this.strategy.field_maxY});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BBoxValueSource that = (BBoxValueSource)o;
        return this.strategy.equals(that.strategy);
    }

    public int hashCode() {
        return this.strategy.hashCode();
    }
}

