/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response.transform;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrException;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.transform.DocTransformer;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SolrIndexSearcher;

public class ValueSourceAugmenter
extends DocTransformer {
    public final String name;
    public final QParser qparser;
    public final ValueSource valueSource;
    Map<Object, Object> fcontext;
    SolrIndexSearcher searcher;
    List<LeafReaderContext> readerContexts;

    public ValueSourceAugmenter(String name, QParser qparser, ValueSource valueSource) {
        this.name = name;
        this.qparser = qparser;
        this.valueSource = valueSource;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setContext(ResultContext context) {
        super.setContext(context);
        try {
            this.searcher = context.getSearcher();
            this.readerContexts = this.searcher.getIndexReader().leaves();
            this.fcontext = ValueSource.newContext((IndexSearcher)this.searcher);
            this.valueSource.createWeight(this.fcontext, (IndexSearcher)this.searcher);
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    @Override
    public void transform(SolrDocument doc, int docid) {
        try {
            int idx = ReaderUtil.subIndex((int)docid, this.readerContexts);
            LeafReaderContext rcontext = this.readerContexts.get(idx);
            FunctionValues values = this.valueSource.getValues(this.fcontext, rcontext);
            int localId = docid - rcontext.docBase;
            this.setValue(doc, values.objectVal(localId));
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "exception at docid " + docid + " for valuesource " + this.valueSource, (Throwable)e);
        }
    }

    @Override
    public boolean needsSolrIndexSearcher() {
        return true;
    }

    protected void setValue(SolrDocument doc, Object val) {
        if (val != null) {
            doc.setField(this.name, val);
        }
    }
}

