/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.crossdc.handler;

import com.google.common.annotations.VisibleForTesting;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.crossdc.common.ConfUtil;
import org.apache.solr.crossdc.common.KafkaCrossDcConf;
import org.apache.solr.crossdc.common.KafkaMirroringSink;
import org.apache.solr.crossdc.common.MirroredSolrRequest;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.processor.DistributedUpdateProcessorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MirroringCollectionsHandler
extends CollectionsHandler {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Set<String> collections = new HashSet<String>();
    private KafkaMirroringSink sink;

    public MirroringCollectionsHandler(CoreContainer coreContainer) {
        this(coreContainer, null);
    }

    public MirroringCollectionsHandler(CoreContainer coreContainer, KafkaMirroringSink sink) {
        super(coreContainer);
        log.info("Using MirroringCollectionsHandler.");
        HashMap<String, Object> properties = new HashMap<String, Object>();
        try {
            SolrZkClient solrClient = coreContainer.getZkController() != null ? coreContainer.getZkController().getZkClient() : null;
            ConfUtil.fillProperties(solrClient, properties);
            ConfUtil.verifyProperties(properties);
            KafkaCrossDcConf conf = new KafkaCrossDcConf(properties);
            String mirrorCollections = conf.get("solr.crossdc.mirrorCollections");
            if (mirrorCollections != null && !mirrorCollections.isBlank()) {
                List list = StrUtils.splitSmart((String)mirrorCollections, (char)',');
                this.collections.addAll(list);
            }
            this.sink = sink == null ? new KafkaMirroringSink(conf) : sink;
        }
        catch (Exception e) {
            log.error("Exception configuring Kafka sink - mirroring disabled!", (Throwable)e);
            this.sink = null;
        }
    }

    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        String collection;
        DistributedUpdateProcessorFactory.addParamToDistributedRequestWhitelist((SolrQueryRequest)req, (String[])new String[]{"shouldMirror"});
        this.baseHandleRequestBody(req, rsp);
        if (rsp.getException() != null) {
            return;
        }
        if (this.sink == null) {
            return;
        }
        boolean doMirroring = req.getParams().getBool("shouldMirror", true);
        if (!doMirroring) {
            log.debug("doMirroring=false, skipping...");
            return;
        }
        CollectionParams.CollectionAction action = CollectionParams.CollectionAction.get((String)req.getParams().get("action"));
        if (action == null) {
            if (log.isDebugEnabled()) {
                log.debug("unrecognized action, skipping mirroring. Params: {}", (Object)req.getParams());
            }
            return;
        }
        if (!this.collections.isEmpty() && !this.collections.contains(collection = action == CollectionParams.CollectionAction.CREATE ? req.getParams().get("name") : req.getParams().get("collection"))) {
            log.debug("collection {} not enabled for mirroring, skipping...", (Object)collection);
            return;
        }
        ModifiableSolrParams mirrorParams = ModifiableSolrParams.of((SolrParams)req.getParams());
        mirrorParams.set("shouldMirror", new String[]{Boolean.FALSE.toString()});
        if (log.isDebugEnabled()) {
            log.debug("mirroring mirrorParams={}, original responseHeader={}, responseValues={}", new Object[]{mirrorParams, rsp.getResponseHeader(), rsp.getValues()});
        }
        MirroredSolrRequest.MirroredAdminRequest solrRequest = new MirroredSolrRequest.MirroredAdminRequest(action, mirrorParams);
        MirroredSolrRequest mirror = new MirroredSolrRequest(MirroredSolrRequest.Type.ADMIN, solrRequest);
        this.sink.submit(mirror);
    }

    @VisibleForTesting
    public void baseHandleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        super.handleRequestBody(req, rsp);
    }
}

