/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * mod(-1.9lf, -2.0lf) => -1.9lf
 * mod(-1.9lf, -0.6666666666666667lf) => -0.5666666666666664lf
 * mod(-1.9lf, 0.6666666666666665lf) => 0.09999999999999964lf
 * mod(-1.9lf, 2.0lf) => 0.10000000000000009lf
 * mod(-0.6333333333333333lf, -2.0lf) => -0.6333333333333333lf
 * mod(-0.6333333333333333lf, -0.6666666666666667lf) => -0.6333333333333333lf
 * mod(-0.6333333333333333lf, 0.6666666666666665lf) => 0.033333333333333215lf
 * mod(-0.6333333333333333lf, 2.0lf) => 1.3666666666666667lf
 * mod(0.6333333333333333lf, -2.0lf) => -1.3666666666666667lf
 * mod(0.6333333333333333lf, -0.6666666666666667lf) => -0.03333333333333344lf
 * mod(0.6333333333333333lf, 0.6666666666666665lf) => 0.6333333333333333lf
 * mod(0.6333333333333333lf, 2.0lf) => 0.6333333333333333lf
 * mod(1.9lf, -2.0lf) => -0.10000000000000009lf
 * mod(1.9lf, -0.6666666666666667lf) => -0.10000000000000009lf
 * mod(1.9lf, 0.6666666666666665lf) => 0.5666666666666669lf
 * mod(1.9lf, 2.0lf) => 1.9lf
 */
#version 400

void main()
{
  double[distance(mod(-1.9lf, -2.0lf), -1.9lf) <= 1.9e-05lf ? 1 : -1] array0;
  double[distance(mod(-1.9lf, -0.6666666666666667lf), -0.5666666666666664lf) <= 5.666666666666664e-06lf ? 1 : -1] array1;
  double[distance(mod(-1.9lf, 0.6666666666666665lf), 0.09999999999999964lf) <= 9.999999999999966e-07lf ? 1 : -1] array2;
  double[distance(mod(-1.9lf, 2.0lf), 0.10000000000000009lf) <= 1.000000000000001e-06lf ? 1 : -1] array3;
  double[distance(mod(-0.6333333333333333lf, -2.0lf), -0.6333333333333333lf) <= 6.333333333333333e-06lf ? 1 : -1] array4;
  double[distance(mod(-0.6333333333333333lf, -0.6666666666666667lf), -0.6333333333333333lf) <= 6.333333333333333e-06lf ? 1 : -1] array5;
  double[distance(mod(-0.6333333333333333lf, 0.6666666666666665lf), 0.033333333333333215lf) <= 3.333333333333322e-07lf ? 1 : -1] array6;
  double[distance(mod(-0.6333333333333333lf, 2.0lf), 1.3666666666666667lf) <= 1.3666666666666667e-05lf ? 1 : -1] array7;
  double[distance(mod(0.6333333333333333lf, -2.0lf), -1.3666666666666667lf) <= 1.3666666666666667e-05lf ? 1 : -1] array8;
  double[distance(mod(0.6333333333333333lf, -0.6666666666666667lf), -0.03333333333333344lf) <= 3.333333333333344e-07lf ? 1 : -1] array9;
  double[distance(mod(0.6333333333333333lf, 0.6666666666666665lf), 0.6333333333333333lf) <= 6.333333333333333e-06lf ? 1 : -1] array10;
  double[distance(mod(0.6333333333333333lf, 2.0lf), 0.6333333333333333lf) <= 6.333333333333333e-06lf ? 1 : -1] array11;
  double[distance(mod(1.9lf, -2.0lf), -0.10000000000000009lf) <= 1.000000000000001e-06lf ? 1 : -1] array12;
  double[distance(mod(1.9lf, -0.6666666666666667lf), -0.10000000000000009lf) <= 1.000000000000001e-06lf ? 1 : -1] array13;
  double[distance(mod(1.9lf, 0.6666666666666665lf), 0.5666666666666669lf) <= 5.6666666666666694e-06lf ? 1 : -1] array14;
  double[distance(mod(1.9lf, 2.0lf), 1.9lf) <= 1.9e-05lf ? 1 : -1] array15;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length());
}
