/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * max(u64vec4(20ul, 20ul, 20ul, 20ul), u64vec4(20ul, 43ul, 66ul, 90ul)) => u64vec4(20ul, 43ul, 66ul, 90ul)
 * max(u64vec4(43ul, 43ul, 43ul, 43ul), u64vec4(20ul, 43ul, 66ul, 90ul)) => u64vec4(43ul, 43ul, 66ul, 90ul)
 * max(u64vec4(66ul, 66ul, 66ul, 66ul), u64vec4(20ul, 43ul, 66ul, 90ul)) => u64vec4(66ul, 66ul, 66ul, 90ul)
 * max(u64vec4(90ul, 90ul, 90ul, 90ul), u64vec4(20ul, 43ul, 66ul, 90ul)) => u64vec4(90ul, 90ul, 90ul, 90ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal(max(u64vec4(20ul, 20ul, 20ul, 20ul), u64vec4(20ul, 43ul, 66ul, 90ul)), u64vec4(20ul, 43ul, 66ul, 90ul))) ? 1 : -1] array0;
  float[all(equal(max(u64vec4(43ul, 43ul, 43ul, 43ul), u64vec4(20ul, 43ul, 66ul, 90ul)), u64vec4(43ul, 43ul, 66ul, 90ul))) ? 1 : -1] array1;
  float[all(equal(max(u64vec4(66ul, 66ul, 66ul, 66ul), u64vec4(20ul, 43ul, 66ul, 90ul)), u64vec4(66ul, 66ul, 66ul, 90ul))) ? 1 : -1] array2;
  float[all(equal(max(u64vec4(90ul, 90ul, 90ul, 90ul), u64vec4(20ul, 43ul, 66ul, 90ul)), u64vec4(90ul, 90ul, 90ul, 90ul))) ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
