/*
 * Decompiled with CFR 0.152.
 */
package lucee.debug;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CatchBlockModifier {
    private static int totalCount = 0;
    private static long count = 0L;

    public static void main(String[] args) throws IOException {
        CatchBlockModifier.processDirectory(Paths.get("/Users/mic/Projects/Lucee/Lucee6/loader", new String[0]));
        CatchBlockModifier.processDirectory(Paths.get("/Users/mic/Projects/Lucee/Lucee6/core", new String[0]));
    }

    public static void processDirectory(Path directory) throws IOException {
        Files.walk(directory, new FileVisitOption[0]).filter(path -> path.toString().endsWith(".java")).forEach(file -> {
            try {
                CatchBlockModifier.processFile(file);
            }
            catch (IOException e) {
                CatchBlockModifier.log(e);
                System.err.println("Error processing file:" + file);
                e.printStackTrace();
            }
        });
        System.out.println("Total catch blocks found: " + totalCount);
    }

    public static void processFile(Path file) throws IOException {
        String content = new String(Files.readAllBytes(file));
        Pattern pattern = Pattern.compile("catch\\s*\\(\\s*(?:[\\w.$]+)\\s+(\\w+)\\s*\\)\\s*\\{", 8);
        Matcher matcher = pattern.matcher(content);
        StringBuffer newContent = new StringBuffer();
        int fileCount = 0;
        while (matcher.find()) {
            ++fileCount;
            String exceptionVar = matcher.group(1);
            matcher.appendReplacement(newContent, matcher.group(0) + " lucee.debug.CatchBlockModifier.log(" + exceptionVar + ");");
        }
        matcher.appendTail(newContent);
        totalCount += fileCount;
        if (fileCount > 0) {
            System.out.println(file + ": " + fileCount + " catch blocks found");
            Files.write(file, newContent.toString().getBytes(), new OpenOption[0]);
        }
    }

    public static void logConsole(Throwable t) {
        if (t == null) {
            return;
        }
        System.err.println(count++ + " -> " + t.getMessage());
        if (t != null) {
            t.printStackTrace();
        }
    }

    public static void log(Throwable t) {
        if (t == null) {
            return;
        }
        try (PrintWriter writer = new PrintWriter(new FileWriter("/Users/mic/tmp9/errors.log", true));){
            writer.println(count++ + " -> " + t.getMessage());
            t.printStackTrace(writer);
        }
        catch (IOException e) {
            CatchBlockModifier.log(e);
            System.err.println("Error writing to log file:");
            e.printStackTrace();
            System.err.println("Original error:");
            t.printStackTrace();
        }
    }
}

