/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derby.shared.common.util.ArrayUtil;

public class PasswordHasher {
    private static final String ENCODING = "UTF-8";
    public static final String ID_PATTERN_SHA1_SCHEME = "3b60";
    public static final String ID_PATTERN_CONFIGURABLE_HASH_SCHEME = "3b61";
    public static final String ID_PATTERN_CONFIGURABLE_STRETCHED_SCHEME = "3b62";
    private static final char SEPARATOR_CHAR = ':';
    private String _messageDigestAlgorithm;
    private byte[] _salt;
    private int _iterations;

    public PasswordHasher(String messageDigestAlgorithm, byte[] salt, int iterations) {
        this._messageDigestAlgorithm = messageDigestAlgorithm;
        this._salt = ArrayUtil.copy((byte[])salt);
        this._iterations = iterations;
    }

    public PasswordHasher(String hashingScheme) {
        if (hashingScheme.startsWith(ID_PATTERN_CONFIGURABLE_HASH_SCHEME)) {
            this._messageDigestAlgorithm = hashingScheme.substring(hashingScheme.indexOf(58) + 1);
            this._salt = null;
            this._iterations = 1;
        } else if (hashingScheme.startsWith(ID_PATTERN_CONFIGURABLE_STRETCHED_SCHEME)) {
            int saltPos = hashingScheme.indexOf(58) + 1;
            int iterPos = hashingScheme.indexOf(58, saltPos) + 1;
            int algoPos = hashingScheme.indexOf(58, iterPos) + 1;
            this._salt = StringUtil.fromHexString(hashingScheme, saltPos, iterPos - saltPos - 1);
            this._iterations = Integer.parseInt(hashingScheme.substring(iterPos, algoPos - 1));
            this._messageDigestAlgorithm = hashingScheme.substring(algoPos);
        } else {
            SanityManager.THROWASSERT((String)("Unknown authentication scheme for token " + hashingScheme));
        }
    }

    public String hashPasswordIntoString(String userName, String password) throws StandardException {
        byte[] passwordBytes;
        byte[] userBytes;
        if (password == null) {
            return null;
        }
        try {
            userBytes = userName.getBytes(ENCODING);
            passwordBytes = password.getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException uee) {
            throw StandardException.plainWrapException((Throwable)uee);
        }
        MessageDigest md = this.getEmptyMessageDigest();
        byte[] digest = null;
        for (int i = 0; i < this._iterations; ++i) {
            md.reset();
            if (digest != null) {
                md.update(digest);
            }
            md.update(userBytes);
            md.update(passwordBytes);
            if (this._salt != null) {
                md.update(this._salt);
            }
            digest = md.digest();
        }
        return StringUtil.toHexString(digest, 0, digest.length);
    }

    private MessageDigest getEmptyMessageDigest() throws StandardException {
        if (this._messageDigestAlgorithm == null) {
            throw this.badMessageDigest(null);
        }
        try {
            return MessageDigest.getInstance(this._messageDigestAlgorithm);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw this.badMessageDigest(nsae);
        }
    }

    private StandardException badMessageDigest(Throwable t) {
        String digestName = this._messageDigestAlgorithm == null ? "NULL" : this._messageDigestAlgorithm;
        return StandardException.newException((String)"XBCXW.S", (Throwable)t, (Object[])new Object[]{digestName});
    }

    public String encodeHashingScheme() {
        return this.hashAndEncode("");
    }

    public String hashAndEncode(String userName, String password) throws StandardException {
        String stringDigest = this.hashPasswordIntoString(userName, password);
        return this.hashAndEncode(stringDigest);
    }

    private String hashAndEncode(String stringDigest) {
        if ((this._salt == null || this._salt.length == 0) && this._iterations == 1) {
            return ID_PATTERN_CONFIGURABLE_HASH_SCHEME + stringDigest + ":" + this._messageDigestAlgorithm;
        }
        return ID_PATTERN_CONFIGURABLE_STRETCHED_SCHEME + stringDigest + ":" + StringUtil.toHexString(this._salt, 0, this._salt.length) + ":" + this._iterations + ":" + this._messageDigestAlgorithm;
    }
}

