/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BuildExclusionsBuildItem;
import io.quarkus.arc.deployment.BuildTimeConditionBuildItem;
import io.quarkus.arc.deployment.BuildTimeEnabledStereotypesBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.arc.profile.IfBuildProfile;
import io.quarkus.arc.profile.UnlessBuildProfile;
import io.quarkus.arc.properties.IfBuildProperty;
import io.quarkus.arc.properties.UnlessBuildProperty;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.EquivalenceKey;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

public class BuildTimeEnabledProcessor {
    private static final Logger LOGGER = Logger.getLogger(BuildTimeEnabledProcessor.class);
    private static final DotName IF_BUILD_PROFILE = DotName.createSimple((String)IfBuildProfile.class.getName());
    private static final DotName UNLESS_BUILD_PROFILE = DotName.createSimple((String)UnlessBuildProfile.class.getName());
    private static final DotName IF_BUILD_PROPERTY = DotName.createSimple((String)IfBuildProperty.class.getName());
    private static final DotName IF_BUILD_PROPERTY_CONTAINER = DotName.createSimple((String)IfBuildProperty.List.class.getName());
    private static final DotName UNLESS_BUILD_PROPERTY = DotName.createSimple((String)UnlessBuildProperty.class.getName());
    private static final DotName UNLESS_BUILD_PROPERTY_CONTAINER = DotName.createSimple((String)UnlessBuildProperty.List.class.getName());
    public static final Set<DotName> BUILD_TIME_ENABLED_BEAN_ANNOTATIONS = Set.of(IF_BUILD_PROFILE, UNLESS_BUILD_PROFILE, IF_BUILD_PROPERTY, IF_BUILD_PROPERTY_CONTAINER, UNLESS_BUILD_PROPERTY, UNLESS_BUILD_PROPERTY_CONTAINER);

    @BuildStep
    BuildTimeEnabledStereotypesBuildItem findEnablementStereotypes(CombinedIndexBuildItem combinedIndex) {
        IndexView index = combinedIndex.getIndex();
        HashSet<DotName> stereotypeNames = new HashSet<DotName>();
        for (AnnotationInstance annotation : index.getAnnotations(DotNames.STEREOTYPE)) {
            if (annotation.target() == null || annotation.target().kind() != AnnotationTarget.Kind.CLASS || !annotation.target().asClass().isAnnotation()) continue;
            stereotypeNames.add(annotation.target().asClass().name());
        }
        ArrayList<BuildTimeEnabledStereotypesBuildItem.BuildTimeEnabledStereotype> buildTimeEnabledStereotypes = new ArrayList<BuildTimeEnabledStereotypesBuildItem.BuildTimeEnabledStereotype>();
        for (DotName stereotypeToScan : stereotypeNames) {
            HashMap<DotName, List<AnnotationInstance>> result = new HashMap<DotName, List<AnnotationInstance>>();
            HashSet<DotName> alreadySeen = new HashSet<DotName>();
            ArrayDeque<DotName> worklist = new ArrayDeque<DotName>();
            worklist.add(stereotypeToScan);
            while (!worklist.isEmpty()) {
                DotName stereotype = (DotName)worklist.poll();
                if (alreadySeen.contains(stereotype)) continue;
                alreadySeen.add(stereotype);
                ClassInfo stereotypeClass = index.getClassByName(stereotype);
                if (stereotypeClass == null) continue;
                for (DotName dotName : List.of(IF_BUILD_PROFILE, UNLESS_BUILD_PROFILE, IF_BUILD_PROPERTY, UNLESS_BUILD_PROPERTY)) {
                    AnnotationInstance ann = stereotypeClass.declaredAnnotation(dotName);
                    if (ann == null) continue;
                    result.computeIfAbsent(dotName, ignored -> new ArrayList()).add(ann);
                }
                for (Map.Entry entry : Map.of(IF_BUILD_PROPERTY_CONTAINER, IF_BUILD_PROPERTY, UNLESS_BUILD_PROPERTY_CONTAINER, UNLESS_BUILD_PROPERTY).entrySet()) {
                    DotName enablementContainerAnnotation = (DotName)entry.getKey();
                    DotName enablementAnnotation = (DotName)entry.getValue();
                    AnnotationInstance containerAnn = stereotypeClass.declaredAnnotation(enablementContainerAnnotation);
                    if (containerAnn == null) continue;
                    for (AnnotationInstance ann : containerAnn.value().asNestedArray()) {
                        result.computeIfAbsent(enablementAnnotation, ignored -> new ArrayList()).add(ann);
                    }
                }
                for (AnnotationInstance annotationInstance : stereotypeClass.declaredAnnotations()) {
                    if (!stereotypeNames.contains(annotationInstance.name())) continue;
                    worklist.add(annotationInstance.name());
                }
            }
            if (result.isEmpty()) continue;
            ClassInfo stereotypeClass = index.getClassByName(stereotypeToScan);
            boolean inheritable = stereotypeClass != null && stereotypeClass.hasDeclaredAnnotation(DotNames.INHERITED);
            buildTimeEnabledStereotypes.add(new BuildTimeEnabledStereotypesBuildItem.BuildTimeEnabledStereotype(stereotypeToScan, inheritable, result));
        }
        return new BuildTimeEnabledStereotypesBuildItem(buildTimeEnabledStereotypes);
    }

    @BuildStep
    void ifBuildProfile(CombinedIndexBuildItem index, BuildTimeEnabledStereotypesBuildItem stereotypes, BuildProducer<BuildTimeConditionBuildItem> producer) {
        this.enablementAnnotations(IF_BUILD_PROFILE, null, index.getIndex(), stereotypes, producer, new Function<AnnotationInstance, Boolean>(){

            @Override
            public Boolean apply(AnnotationInstance annotation) {
                return BuildProfile.from(annotation).enabled();
            }
        });
    }

    @BuildStep
    void unlessBuildProfile(CombinedIndexBuildItem index, BuildTimeEnabledStereotypesBuildItem stereotypes, BuildProducer<BuildTimeConditionBuildItem> producer) {
        this.enablementAnnotations(UNLESS_BUILD_PROFILE, null, index.getIndex(), stereotypes, producer, new Function<AnnotationInstance, Boolean>(){

            @Override
            public Boolean apply(AnnotationInstance annotation) {
                return BuildProfile.from(annotation).disabled();
            }
        });
    }

    @BuildStep
    void ifBuildProperty(CombinedIndexBuildItem index, BuildTimeEnabledStereotypesBuildItem stereotypes, BuildProducer<BuildTimeConditionBuildItem> conditions) {
        final Config config = ConfigProviderResolver.instance().getConfig();
        this.enablementAnnotations(IF_BUILD_PROPERTY, IF_BUILD_PROPERTY_CONTAINER, index.getIndex(), stereotypes, conditions, new Function<AnnotationInstance, Boolean>(){

            @Override
            public Boolean apply(AnnotationInstance annotation) {
                return BuildProperty.from(annotation).enabled(config);
            }
        });
    }

    @BuildStep
    void unlessBuildProperty(CombinedIndexBuildItem index, BuildTimeEnabledStereotypesBuildItem stereotypes, BuildProducer<BuildTimeConditionBuildItem> conditions) {
        final Config config = ConfigProviderResolver.instance().getConfig();
        this.enablementAnnotations(UNLESS_BUILD_PROPERTY, UNLESS_BUILD_PROPERTY_CONTAINER, index.getIndex(), stereotypes, conditions, new Function<AnnotationInstance, Boolean>(){

            @Override
            public Boolean apply(AnnotationInstance annotation) {
                return BuildProperty.from(annotation).disabled(config);
            }
        });
    }

    private void enablementAnnotations(DotName annotationName, DotName containingAnnotationName, IndexView index, BuildTimeEnabledStereotypesBuildItem stereotypes, BuildProducer<BuildTimeConditionBuildItem> producer, Function<AnnotationInstance, Boolean> test) {
        List<AnnotationInstance> annotationInstances = BuildTimeEnabledProcessor.getAnnotations(index, annotationName, containingAnnotationName);
        for (AnnotationInstance annotation : annotationInstances) {
            AnnotationTarget target = annotation.target();
            boolean enabled = test.apply(annotation);
            if (enabled) {
                LOGGER.debugf("Enabling %s due to %s", (Object)target, (Object)annotation);
            } else {
                LOGGER.debugf("Disabling %s due to %s", (Object)target, (Object)annotation);
            }
            producer.produce((BuildItem)new BuildTimeConditionBuildItem(target, enabled));
        }
        HashSet<DotName> processedClasses = new HashSet<DotName>();
        ArrayList classesWithPossiblyInheritedStereotype = new ArrayList();
        for (BuildTimeEnabledStereotypesBuildItem.BuildTimeEnabledStereotype stereotype : stereotypes.all()) {
            for (AnnotationInstance stereotypeUsage : BuildTimeEnabledProcessor.getAnnotations(index, stereotype.name)) {
                AnnotationTarget target = stereotypeUsage.target();
                for (AnnotationInstance annotation : stereotype.getEnablementAnnotations(annotationName)) {
                    boolean enabled = test.apply(annotation);
                    if (enabled) {
                        LOGGER.debugf("Enabling %s  due to %s on stereotype %s", (Object)target, (Object)annotation, (Object)stereotype.name);
                    } else {
                        LOGGER.debugf("Disabling %s due to %s on stereotype %s", (Object)target, (Object)annotation, (Object)stereotype.name);
                    }
                    producer.produce((BuildItem)new BuildTimeConditionBuildItem(target, enabled));
                }
                if (target.kind() != AnnotationTarget.Kind.CLASS) continue;
                ClassInfo clazz = target.asClass();
                processedClasses.add(clazz.name());
                if (!stereotype.inheritable || clazz.isInterface()) continue;
                classesWithPossiblyInheritedStereotype.addAll(index.getAllKnownSubclasses(clazz.name()));
            }
        }
        for (ClassInfo clazz : classesWithPossiblyInheritedStereotype) {
            if (processedClasses.contains(clazz.name())) continue;
            processedClasses.add(clazz.name());
            ClassInfo superclass = index.getClassByName(clazz.superName());
            HashSet<DotName> seenStereotypes = new HashSet<DotName>();
            while (superclass != null && !DotNames.OBJECT.equals((Object)superclass.name())) {
                for (AnnotationInstance ann : superclass.declaredAnnotations()) {
                    BuildTimeEnabledStereotypesBuildItem.BuildTimeEnabledStereotype stereotype;
                    if (!stereotypes.isStereotype(ann.name()) || seenStereotypes.contains(ann.name()) || (stereotype = stereotypes.getStereotype(ann.name())) == null) continue;
                    for (AnnotationInstance annotation : stereotype.getEnablementAnnotations(annotationName)) {
                        boolean enabled = test.apply(annotation);
                        if (enabled) {
                            LOGGER.debugf("Enabling %s due to %s on stereotype %s inherited from %s", new Object[]{clazz, annotation, stereotype.name, superclass.name()});
                        } else {
                            LOGGER.debugf("Disabling %s due to %s on stereotype %s inherited from %s", new Object[]{clazz, annotation, stereotype.name, superclass.name()});
                        }
                        producer.produce((BuildItem)new BuildTimeConditionBuildItem((AnnotationTarget)clazz, enabled));
                    }
                    seenStereotypes.add(ann.name());
                }
                superclass = index.getClassByName(superclass.superName());
            }
        }
    }

    @BuildStep
    void conditionTransformer(List<BuildTimeConditionBuildItem> buildTimeConditions, BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformer) {
        if (buildTimeConditions.isEmpty()) {
            return;
        }
        final HashMap<EquivalenceKey, Boolean> enabled = new HashMap<EquivalenceKey, Boolean>();
        for (BuildTimeConditionBuildItem buildTimeCondition : buildTimeConditions) {
            EquivalenceKey key;
            AnnotationTarget target = buildTimeCondition.getTarget();
            Boolean allPreviousConditionsTrue = enabled.getOrDefault(key = EquivalenceKey.of((AnnotationTarget)target), true);
            enabled.put(key, allPreviousConditionsTrue != false && buildTimeCondition.isEnabled());
        }
        annotationsTransformer.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public void transform(AnnotationsTransformer.TransformationContext ctx) {
                AnnotationTarget target = ctx.getTarget();
                if (!enabled.getOrDefault(EquivalenceKey.of((AnnotationTarget)target), Boolean.TRUE).booleanValue()) {
                    Transformation transform = ctx.transform();
                    if (target.kind() == AnnotationTarget.Kind.CLASS) {
                        transform.add(DotNames.VETOED, new AnnotationValue[0]);
                    } else {
                        transform.add(DotNames.VETOED_PRODUCER, new AnnotationValue[0]);
                    }
                    transform.done();
                }
            }
        }));
    }

    @BuildStep
    BuildExclusionsBuildItem buildExclusions(List<BuildTimeConditionBuildItem> buildTimeConditions) {
        Map map = buildTimeConditions.stream().filter(Predicate.not(BuildTimeConditionBuildItem::isEnabled)).map(BuildTimeConditionBuildItem::getTarget).collect(Collectors.groupingBy(AnnotationTarget::kind, Collectors.mapping(BuildExclusionsBuildItem::targetMapper, Collectors.toSet())));
        return new BuildExclusionsBuildItem(map.getOrDefault(AnnotationTarget.Kind.CLASS, Collections.emptySet()), map.getOrDefault(AnnotationTarget.Kind.METHOD, Collections.emptySet()), map.getOrDefault(AnnotationTarget.Kind.FIELD, Collections.emptySet()));
    }

    private static List<AnnotationInstance> getAnnotations(IndexView index, DotName annotationName) {
        ArrayList<AnnotationInstance> result = new ArrayList<AnnotationInstance>();
        for (AnnotationInstance annotation : index.getAnnotations(annotationName)) {
            AnnotationTarget target = annotation.target();
            if (target == null || target.kind() == AnnotationTarget.Kind.CLASS && target.asClass().isAnnotation()) continue;
            result.add(annotation);
        }
        return result;
    }

    private static List<AnnotationInstance> getAnnotations(IndexView index, DotName annotationName, DotName containingAnnotationName) {
        List<AnnotationInstance> annotationInstances = BuildTimeEnabledProcessor.getAnnotations(index, annotationName);
        if (containingAnnotationName == null) {
            return annotationInstances;
        }
        for (AnnotationInstance containingInstance : index.getAnnotations(containingAnnotationName)) {
            AnnotationTarget target = containingInstance.target();
            if (target == null || target.kind() == AnnotationTarget.Kind.CLASS && target.asClass().isAnnotation()) continue;
            for (AnnotationInstance nestedInstance : containingInstance.value().asNestedArray()) {
                annotationInstances.add(AnnotationInstance.create((DotName)nestedInstance.name(), (AnnotationTarget)target, (List)nestedInstance.values()));
            }
        }
        return annotationInstances;
    }

    static class BuildProperty {
        private final String propertyName;
        private final String expectedStringValue;
        private final boolean enableIfMissing;

        private BuildProperty(String propertyName, String expectedStringValue, boolean enableIfMissing) {
            this.propertyName = propertyName;
            this.expectedStringValue = expectedStringValue;
            this.enableIfMissing = enableIfMissing;
        }

        boolean enabled(Config config) {
            Optional optionalValue = config.getOptionalValue(this.propertyName, String.class);
            if (optionalValue.isPresent()) {
                return this.expectedStringValue.equalsIgnoreCase((String)optionalValue.get());
            }
            return this.enableIfMissing;
        }

        boolean disabled(Config config) {
            Optional optionalValue = config.getOptionalValue(this.propertyName, String.class);
            if (optionalValue.isPresent()) {
                return !this.expectedStringValue.equalsIgnoreCase((String)optionalValue.get());
            }
            return this.enableIfMissing;
        }

        static BuildProperty from(AnnotationInstance instance) {
            String propertyName = instance.value("name").asString();
            String expectedStringValue = instance.value("stringValue").asString();
            AnnotationValue enableIfMissingValue = instance.value("enableIfMissing");
            boolean enableIfMissing = enableIfMissingValue != null && enableIfMissingValue.asBoolean();
            return new BuildProperty(propertyName, expectedStringValue, enableIfMissing);
        }
    }

    private static class BuildProfile {
        private final Set<String> allOf;
        private final Set<String> anyOf;

        BuildProfile(Set<String> allOf, Set<String> anyOf) {
            this.allOf = allOf;
            this.anyOf = anyOf;
        }

        boolean allMatch() {
            if (this.allOf.isEmpty()) {
                return true;
            }
            for (String profile : this.allOf) {
                if (ConfigUtils.isProfileActive((String)profile)) continue;
                return false;
            }
            return true;
        }

        boolean anyMatch() {
            if (this.anyOf.isEmpty()) {
                return true;
            }
            for (String profile : this.anyOf) {
                if (!ConfigUtils.isProfileActive((String)profile)) continue;
                return true;
            }
            return false;
        }

        boolean enabled() {
            return this.allMatch() && this.anyMatch();
        }

        boolean disabled() {
            return !this.enabled();
        }

        private static BuildProfile from(AnnotationInstance instance) {
            AnnotationValue value = instance.value();
            AnnotationValue allOfValue = instance.value("allOf");
            HashSet<String> allOf = allOfValue != null ? new HashSet<String>(Arrays.asList(allOfValue.asStringArray())) : Collections.emptySet();
            AnnotationValue anyOfValue = instance.value("anyOf");
            HashSet<String> anyOf = new HashSet<String>();
            if (value != null) {
                anyOf.add(value.asString());
            }
            if (anyOfValue != null) {
                Collections.addAll(anyOf, anyOfValue.asStringArray());
            }
            return new BuildProfile(allOf, anyOf);
        }
    }
}

