/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.spec;

import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import org.wildfly.common.Assert;

public final class MaskedPasswordAlgorithmSpec
implements AlgorithmParameterSpec {
    private final char[] initialKeyMaterial;
    private final int iterationCount;
    private final byte[] salt;
    private final byte[] initializationVector;

    public MaskedPasswordAlgorithmSpec(char[] initialKeyMaterial, int iterationCount, byte[] salt) {
        Assert.checkNotNullParam((String)"initialKeyMaterial", (Object)initialKeyMaterial);
        Assert.checkNotNullParam((String)"salt", (Object)salt);
        this.initialKeyMaterial = initialKeyMaterial;
        this.iterationCount = iterationCount;
        this.salt = salt;
        this.initializationVector = null;
    }

    public MaskedPasswordAlgorithmSpec(char[] initialKeyMaterial, int iterationCount, byte[] salt, byte[] initializationVector) {
        Assert.checkNotNullParam((String)"initialKeyMaterial", (Object)initialKeyMaterial);
        Assert.checkNotNullParam((String)"salt", (Object)salt);
        this.initialKeyMaterial = initialKeyMaterial;
        this.iterationCount = iterationCount;
        this.salt = salt;
        this.initializationVector = initializationVector;
    }

    public char[] getInitialKeyMaterial() {
        return this.initialKeyMaterial;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public byte[] getInitializationVector() {
        return this.initializationVector;
    }

    public boolean equals(Object other) {
        if (!(other instanceof MaskedPasswordAlgorithmSpec)) {
            return false;
        }
        MaskedPasswordAlgorithmSpec otherSpec = (MaskedPasswordAlgorithmSpec)other;
        return otherSpec == this || Arrays.equals(this.initialKeyMaterial, otherSpec.initialKeyMaterial) && Arrays.equals(this.salt, otherSpec.salt) && this.iterationCount == otherSpec.iterationCount && Arrays.equals(this.initializationVector, otherSpec.initializationVector);
    }

    public int hashCode() {
        return ((Arrays.hashCode(this.initialKeyMaterial) * 13 + this.iterationCount) * 13 + Arrays.hashCode(this.salt)) * 13 + Arrays.hashCode(this.initializationVector);
    }
}

