/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.imageio.ImageIO;
import org.apache.commons.jcs.access.behavior.ICacheAccess;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.cache.JCSCacheManager;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageDisplay;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.ExifReader;
import org.openstreetmap.josm.tools.Logging;

public class ThumbsLoader
implements Runnable {
    public static final int maxSize = 120;
    public static final int minSize = 22;
    public volatile boolean stop;
    private final Collection<ImageEntry> data;
    private final GeoImageLayer layer;
    private MediaTracker tracker;
    private ICacheAccess<String, BufferedImageCacheEntry> cache;
    private final boolean cacheOff = Config.getPref().getBoolean("geoimage.noThumbnailCache", false);

    private ThumbsLoader(Collection<ImageEntry> data, GeoImageLayer layer) {
        this.data = data;
        this.layer = layer;
        this.initCache();
    }

    public ThumbsLoader(GeoImageLayer layer) {
        this(new ArrayList<ImageEntry>(layer.getImageData().getImages()), layer);
    }

    public ThumbsLoader(Collection<ImageEntry> entries) {
        this(entries, null);
    }

    private void initCache() {
        if (!this.cacheOff) {
            this.cache = JCSCacheManager.getCache("geoimage-thumbnails", 0, 120, Config.getDirs().getCacheDirectory(true).getPath() + File.separator + "geoimage-thumbnails");
        }
    }

    @Override
    public void run() {
        Logging.debug("Load Thumbnails");
        this.tracker = new MediaTracker(MainApplication.getMap().mapView);
        for (ImageEntry entry : this.data) {
            if (this.stop) {
                return;
            }
            if (entry.hasThumbnail()) continue;
            entry.setThumbnail(this.loadThumb(entry));
            if (this.layer == null || !MainApplication.isDisplayingMapView()) continue;
            this.layer.updateBufferAndRepaint();
        }
        if (this.layer != null) {
            this.layer.thumbsLoaded();
            this.layer.updateBufferAndRepaint();
        }
    }

    private BufferedImage loadThumb(ImageEntry entry) {
        int hh;
        int ww;
        String cacheIdent = entry.getFile().toString() + ':' + 120;
        if (!this.cacheOff && this.cache != null) {
            try {
                BufferedImageCacheEntry cacheEntry = this.cache.get(cacheIdent);
                if (cacheEntry != null && cacheEntry.getImage() != null) {
                    Logging.debug(" from cache");
                    return cacheEntry.getImage();
                }
            }
            catch (IOException e) {
                Logging.warn(e);
            }
        }
        Image img = Toolkit.getDefaultToolkit().createImage(entry.getFile().getPath());
        this.tracker.addImage(img, 0);
        try {
            this.tracker.waitForID(0);
        }
        catch (InterruptedException e) {
            Logging.error(" InterruptedException while loading thumb");
            Thread.currentThread().interrupt();
            return null;
        }
        if (this.tracker.isErrorID(1) || img.getWidth(null) <= 0 || img.getHeight(null) <= 0) {
            Logging.error(" Invalid image");
            return null;
        }
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        Integer exifOrientation = entry.getExifOrientation();
        if (exifOrientation != null && ExifReader.orientationSwitchesDimensions(exifOrientation)) {
            ww = h;
            hh = w;
        } else {
            ww = w;
            hh = h;
        }
        ImageDisplay.VisRect targetSize = ImageDisplay.calculateDrawImageRectangle(new ImageDisplay.VisRect(0, 0, ww, hh), new Rectangle(0, 0, 120, 120));
        BufferedImage scaledBI = new BufferedImage(targetSize.width, targetSize.height, 1);
        Graphics2D g = scaledBI.createGraphics();
        AffineTransform scale = AffineTransform.getScaleInstance((double)targetSize.width / (double)ww, (double)targetSize.height / (double)hh);
        if (exifOrientation != null) {
            AffineTransform restoreOrientation = ExifReader.getRestoreOrientationTransform(exifOrientation, w, h);
            scale.concatenate(restoreOrientation);
        }
        while (!g.drawImage(img, scale, null)) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                Logging.warn("InterruptedException while drawing thumb");
                Thread.currentThread().interrupt();
            }
        }
        g.dispose();
        this.tracker.removeImage(img);
        if (scaledBI.getWidth() <= 0 || scaledBI.getHeight() <= 0) {
            Logging.error(" Invalid image");
            return null;
        }
        if (!this.cacheOff && this.cache != null) {
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                ImageIO.write((RenderedImage)scaledBI, "png", output);
                this.cache.put(cacheIdent, new BufferedImageCacheEntry(output.toByteArray()));
            }
            catch (IOException e) {
                Logging.warn("Failed to save geoimage thumb to cache");
                Logging.warn(e);
            }
        }
        return scaledBI;
    }
}

