/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Colors;

import java.awt.Color;
import java.awt.Graphics2D;
import java2d.AnimatingSurface;

public class Rotator3D
extends AnimatingSurface {
    private Objects3D[] objs = new Objects3D[3];
    private static final int[][][] polygons = new int[][][]{new int[][]{{5, 1, 15, 13, 21, 23, 15}, {5, 2, 21, 13, 19, 27, 21}, {5, 3, 23, 15, 17, 25, 23}, {5, 4, 19, 13, 15, 17, 19}, {5, 5, 27, 21, 23, 25, 27}, {5, 6, 27, 19, 17, 25, 27}}, new int[][]{{5, 1, 21, 13, 19, 27, 21}, {5, 5, 23, 15, 17, 25, 23}, {4, 0, 15, 14, 16, 15}, {7, 6, 16, 14, 13, 12, 18, 17, 16}, {4, 0, 12, 19, 18, 12}, {4, 2, 22, 21, 20, 22}, {7, 0, 24, 23, 22, 20, 27, 26, 24}, {4, 2, 24, 26, 25, 24}, {4, 3, 15, 13, 23, 15}, {4, 0, 23, 13, 21, 23}, {5, 0, 27, 26, 18, 19, 27}, {5, 4, 25, 17, 18, 26, 25}}, new int[][]{{4, 3, 18, 21, 16, 18}, {4, 1, 20, 16, 18, 20}, {4, 1, 18, 21, 16, 18}, {4, 3, 20, 17, 19, 20}, {4, 2, 20, 26, 27, 20}, {5, 3, 26, 18, 16, 27, 26}, {5, 0, 17, 24, 25, 19, 17}, {4, 3, 21, 25, 24, 21}, {4, 4, 18, 21, 22, 18}, {4, 2, 22, 21, 17, 22}, {4, 5, 20, 23, 16, 20}, {4, 1, 20, 23, 19, 20}, {4, 6, 21, 23, 16, 21}, {4, 4, 21, 23, 19, 21}, {4, 5, 20, 18, 22, 20}, {4, 6, 20, 22, 17, 20}}};
    private static final double[][][] points = new double[][][]{new double[][]{{1.0, 0.0, 0.0}, {-1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, -1.0, 0.0}, {0.0, 0.0, 1.0}, {0.0, 0.0, -1.0}, {1.0, 0.0, 0.0}, {-1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, -1.0, 0.0}, {0.0, 0.0, 1.0}, {0.0, 0.0, -1.0}, {1.0, 1.0, 0.0}, {1.0, 1.0, 1.0}, {0.0, 1.0, 1.0}, {-1.0, 1.0, 1.0}, {-1.0, 1.0, 0.0}, {-1.0, 1.0, -1.0}, {0.0, 1.0, -1.0}, {1.0, 1.0, -1.0}, {1.0, -1.0, 0.0}, {1.0, -1.0, 1.0}, {0.0, -1.0, 1.0}, {-1.0, -1.0, 1.0}, {-1.0, -1.0, 0.0}, {-1.0, -1.0, -1.0}, {0.0, -1.0, -1.0}, {1.0, -1.0, -1.0}}, new double[][]{{0.0, 0.0, 1.0}, {0.0, 0.0, -1.0}, {-0.8165, 0.4714, 0.33333}, {0.8165, -0.4714, -0.33333}, {0.8165, 0.4714, 0.33333}, {-0.8165, -0.4714, -0.33333}, {0.0, -0.9428, 0.3333}, {0.0, 0.9428, -0.33333}, {0.0, 0.0, 1.0}, {0.0, 0.0, -1.0}, {-0.8165, 0.4714, 0.33333}, {0.8165, -0.4714, -0.33333}, {0.8165, 0.4714, 0.33333}, {-0.8165, -0.4714, -0.33333}, {0.0, -0.9428, 0.33333}, {0.0, 0.9428, -0.33333}, {-1.2247, -0.7071, 1.0}, {1.2247, 0.7071, -1.0}, {0.0, 1.4142, 1.0}, {0.0, -1.4142, -1.0}, {-1.2247, 0.7071, -1.0}, {1.2247, -0.7071, 1.0}, {0.61237, 1.06066, 0.0}, {-0.61237, -1.06066, 0.0}, {1.2247, 0.0, 0.0}, {0.61237, -1.06066, 0.0}, {-0.61237, 1.06066, 0.0}, {-1.2247, 0.0, 0.0}}};
    private static final int[][][] faces = new int[][][]{new int[][]{{1, 1}, {1, 2}, {1, 3}, {1, 4}, {1, 0}, {1, 5}}, new int[][]{{1, 0}, {1, 1}, {3, 2, 3, 4}, {3, 5, 6, 7}, {2, 8, 9}, {2, 10, 11}}, new int[][]{{1, 2}, {1, 3}, {2, 4, 5}, {2, 6, 7}, {2, 8, 9}, {2, 10, 11}, {2, 12, 13}, {2, 14, 15}}};

    public Rotator3D() {
        this.setBackground(Color.white);
    }

    @Override
    public void reset(int w, int h) {
        this.objs[0] = new Objects3D(polygons[0], points[0], faces[0], w, h);
        this.objs[1] = new Objects3D(polygons[1], points[0], faces[1], w, h);
        this.objs[2] = new Objects3D(polygons[2], points[1], faces[2], w, h);
    }

    @Override
    public void step(int w, int h) {
        for (Objects3D obj : this.objs) {
            if (obj == null) continue;
            obj.step(w, h);
        }
    }

    @Override
    public void render(int w, int h, Graphics2D g2) {
        for (Objects3D obj : this.objs) {
            if (obj == null) continue;
            obj.render(g2);
        }
    }

    public static void main(String[] argv) {
        Rotator3D.createDemoFrame(new Rotator3D());
    }

    public class Objects3D {
        private final int UP = 0;
        private final int DOWN = 1;
        private int[][] polygons;
        private double[][] points;
        private int npoint;
        private int[][] faces;
        private int nface;
        private int ncolour = 10;
        private Color[][] colours = new Color[this.ncolour][7];
        private double[] lightvec = new double[]{0.0, 1.0, 1.0};
        private double Zeye = 10.0;
        private double angle;
        private Matrix3D orient;
        private Matrix3D tmp;
        private Matrix3D tmp2;
        private Matrix3D tmp3;
        private int scaleDirection;
        private double scale;
        private double scaleAmt;
        private double ix = 3.0;
        private double iy = 3.0;
        private double[][] rotPts;
        private int[][] scrPts;
        private int[] xx = new int[20];
        private int[] yy = new int[20];
        private double x;
        private double y;
        private int p;
        private int j;
        private int colour;
        private double bounce;
        private double persp;

        public Objects3D(int[][] polygons, double[][] points, int[][] faces, int w, int h) {
            int i;
            this.polygons = polygons;
            this.points = points;
            this.faces = faces;
            this.npoint = points.length;
            this.nface = faces.length;
            this.x = (double)w * Math.random();
            this.y = (double)h * Math.random();
            this.ix = Math.random() > 0.5 ? this.ix : -this.ix;
            this.iy = Math.random() > 0.5 ? this.iy : -this.iy;
            this.rotPts = new double[this.npoint][3];
            this.scrPts = new int[this.npoint][2];
            for (int i2 = 0; i2 < this.ncolour; ++i2) {
                int val = 255 - (this.ncolour - i2 - 1) * 100 / this.ncolour;
                Color[] c = new Color[]{new Color(val, val, val), new Color(val, 0, 0), new Color(0, val, 0), new Color(0, 0, val), new Color(val, val, 0), new Color(0, val, val), new Color(val, 0, val)};
                this.colours[i2] = c;
            }
            double len = Math.sqrt(this.lightvec[0] * this.lightvec[0] + this.lightvec[1] * this.lightvec[1] + this.lightvec[2] * this.lightvec[2]);
            this.lightvec[0] = this.lightvec[0] / len;
            this.lightvec[1] = this.lightvec[1] / len;
            this.lightvec[2] = this.lightvec[2] / len;
            double max = 0.0;
            for (i = 0; i < this.npoint; ++i) {
                len = Math.sqrt(points[i][0] * points[i][0] + points[i][1] * points[i][1] + points[i][2] * points[i][2]);
                if (!(len > max)) continue;
                max = len;
            }
            for (i = 0; i < this.nface; ++i) {
                len = Math.sqrt(points[i][0] * points[i][0] + points[i][1] * points[i][1] + points[i][2] * points[i][2]);
                points[i][0] = points[i][0] / len;
                points[i][1] = points[i][1] / len;
                points[i][2] = points[i][2] / len;
            }
            this.orient = new Matrix3D();
            this.tmp = new Matrix3D();
            this.tmp2 = new Matrix3D();
            this.tmp3 = new Matrix3D();
            this.tmp.Rotation(2, 0, 0.06283185307179587);
            this.CalcScrPts((double)w / 3.0, (double)h / 3.0, 0.0);
            this.scaleAmt = this.scale = Math.min((double)(w / 3) / max / 1.2, (double)(h / 3) / max / 1.2);
            this.scale *= Math.random() * 1.5;
            this.scaleDirection = this.scaleAmt < this.scale ? 1 : 0;
        }

        private Color getColour(int f, int index) {
            this.colour = (int)((this.rotPts[f][0] * this.lightvec[0] + this.rotPts[f][1] * this.lightvec[1] + this.rotPts[f][2] * this.lightvec[2]) * (double)this.ncolour);
            if (this.colour < 0) {
                this.colour = 0;
            }
            if (this.colour > this.ncolour - 1) {
                this.colour = this.ncolour - 1;
            }
            return this.colours[this.colour][this.polygons[this.faces[f][index]][1]];
        }

        private void CalcScrPts(double x, double y, double z) {
            this.p = 0;
            while (this.p < this.npoint) {
                this.rotPts[this.p][2] = this.points[this.p][0] * this.orient.M[2][0] + this.points[this.p][1] * this.orient.M[2][1] + this.points[this.p][2] * this.orient.M[2][2];
                this.rotPts[this.p][0] = this.points[this.p][0] * this.orient.M[0][0] + this.points[this.p][1] * this.orient.M[0][1] + this.points[this.p][2] * this.orient.M[0][2];
                this.rotPts[this.p][1] = -this.points[this.p][0] * this.orient.M[1][0] - this.points[this.p][1] * this.orient.M[1][1] - this.points[this.p][2] * this.orient.M[1][2];
                ++this.p;
            }
            this.p = this.nface;
            while (this.p < this.npoint) {
                double[] dArray = this.rotPts[this.p];
                dArray[2] = dArray[2] + z;
                this.persp = (this.Zeye - this.rotPts[this.p][2]) / (this.scale * this.Zeye);
                this.scrPts[this.p][0] = (int)(this.rotPts[this.p][0] / this.persp + x);
                this.scrPts[this.p][1] = (int)(this.rotPts[this.p][1] / this.persp + y);
                ++this.p;
            }
        }

        private boolean faceUp(int f) {
            return this.rotPts[f][0] * this.rotPts[this.nface + f][0] + this.rotPts[f][1] * this.rotPts[this.nface + f][1] + this.rotPts[f][2] * (this.rotPts[this.nface + f][2] - this.Zeye) < 0.0;
        }

        public void step(int w, int h) {
            this.x += this.ix;
            this.y += this.iy;
            if (this.x > (double)w - this.scale) {
                this.x = (double)w - this.scale - 1.0;
                this.ix = -w / 100 - 1;
            }
            if (this.x - this.scale < 0.0) {
                this.x = 2.0 + this.scale;
                this.ix = (double)(w / 100) + Math.random() * 3.0;
            }
            if (this.y > (double)h - this.scale) {
                this.y = (double)h - this.scale - 2.0;
                this.iy = -h / 100 - 1;
            }
            if (this.y - this.scale < 0.0) {
                this.y = 2.0 + this.scale;
                this.iy = (double)(h / 100) + Math.random() * 3.0;
            }
            this.angle += Math.random() * 0.15;
            this.tmp3.Rotation(1, 2, this.angle);
            this.tmp2.Rotation(1, 0, this.angle * Math.sqrt(2.0) / 2.0);
            this.tmp.Rotation(0, 2, this.angle * Math.PI / 4.0);
            this.orient.M = this.tmp3.Times(this.tmp2.Times(this.tmp.M));
            this.bounce = Math.abs(Math.cos(0.5 * this.angle)) * 2.0 - 1.0;
            if (this.scale > this.scaleAmt * 1.4) {
                this.scaleDirection = 1;
            }
            if (this.scale < this.scaleAmt * 0.4) {
                this.scaleDirection = 0;
            }
            if (this.scaleDirection == 0) {
                this.scale += Math.random();
            }
            if (this.scaleDirection == 1) {
                this.scale -= Math.random();
            }
            this.CalcScrPts(this.x, this.y, this.bounce);
        }

        public void render(Graphics2D g2) {
            for (int f = 0; f < this.nface; ++f) {
                if (!this.faceUp(f)) continue;
                this.j = 1;
                while (this.j < this.faces[f][0] + 1) {
                    this.DrawPoly(g2, this.faces[f][this.j], this.getColour(f, this.j));
                    ++this.j;
                }
            }
        }

        private void DrawPoly(Graphics2D g2, int poly, Color colour) {
            for (int point = 2; point < this.polygons[poly][0] + 2; ++point) {
                this.xx[point - 2] = this.scrPts[this.polygons[poly][point]][0];
                this.yy[point - 2] = this.scrPts[this.polygons[poly][point]][1];
            }
            g2.setColor(colour);
            g2.fillPolygon(this.xx, this.yy, this.polygons[poly][0]);
            g2.setColor(Color.black);
            g2.drawPolygon(this.xx, this.yy, this.polygons[poly][0]);
        }

        public class Matrix3D {
            public double[][] M = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
            private double[][] tmp = new double[3][3];
            private int row;
            private int col;
            private int k;

            public void Rotation(int i, int j, double angle) {
                this.row = 0;
                while (this.row < 3) {
                    this.col = 0;
                    while (this.col < 3) {
                        this.M[this.row][this.col] = this.row != this.col ? 0.0 : 1.0;
                        ++this.col;
                    }
                    ++this.row;
                }
                this.M[i][i] = Math.cos(angle);
                this.M[j][j] = Math.cos(angle);
                this.M[i][j] = Math.sin(angle);
                this.M[j][i] = -Math.sin(angle);
            }

            public double[][] Times(double[][] N) {
                this.row = 0;
                while (this.row < 3) {
                    this.col = 0;
                    while (this.col < 3) {
                        this.tmp[this.row][this.col] = 0.0;
                        this.k = 0;
                        while (this.k < 3) {
                            double[] dArray = this.tmp[this.row];
                            int n = this.col;
                            dArray[n] = dArray[n] + this.M[this.row][this.k] * N[this.k][this.col];
                            ++this.k;
                        }
                        ++this.col;
                    }
                    ++this.row;
                }
                return this.tmp;
            }
        }
    }
}

