/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.drm;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.ElementBuffer;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.MachineDataInfo;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import jogamp.common.os.MachineDataInfoRuntime;

public class drmModeModeInfo {
    StructAccessor accessor;
    private static final int mdIdx = MachineDataInfoRuntime.getStatic().ordinal();
    private final MachineDataInfo md;
    private static final int[] drmModeModeInfo_size = new int[]{68, 68, 68, 68, 68, 68, 68, 68, 68, 68};
    private static final int[] clock_offset = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] hdisplay_offset = new int[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
    private static final int[] hsync_start_offset = new int[]{6, 6, 6, 6, 6, 6, 6, 6, 6, 6};
    private static final int[] hsync_end_offset = new int[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
    private static final int[] htotal_offset = new int[]{10, 10, 10, 10, 10, 10, 10, 10, 10, 10};
    private static final int[] hskew_offset = new int[]{12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
    private static final int[] vdisplay_offset = new int[]{14, 14, 14, 14, 14, 14, 14, 14, 14, 14};
    private static final int[] vsync_start_offset = new int[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
    private static final int[] vsync_end_offset = new int[]{18, 18, 18, 18, 18, 18, 18, 18, 18, 18};
    private static final int[] vtotal_offset = new int[]{20, 20, 20, 20, 20, 20, 20, 20, 20, 20};
    private static final int[] vscan_offset = new int[]{22, 22, 22, 22, 22, 22, 22, 22, 22, 22};
    private static final int[] vrefresh_offset = new int[]{24, 24, 24, 24, 24, 24, 24, 24, 24, 24};
    private static final int[] flags_offset = new int[]{28, 28, 28, 28, 28, 28, 28, 28, 28, 28};
    private static final int[] type_offset = new int[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
    private static final int[] name_offset = new int[]{36, 36, 36, 36, 36, 36, 36, 36, 36, 36};
    private static Charset _charset = StandardCharsets.UTF_8;

    public static boolean usesNativeCode() {
        return false;
    }

    public static int size() {
        return drmModeModeInfo_size[mdIdx];
    }

    public static drmModeModeInfo create() {
        return drmModeModeInfo.create(Buffers.newDirectByteBuffer((int)drmModeModeInfo.size()));
    }

    public static drmModeModeInfo create(ByteBuffer byteBuffer) {
        return new drmModeModeInfo(byteBuffer);
    }

    public static drmModeModeInfo derefPointer(long l) {
        return drmModeModeInfo.create(ElementBuffer.derefPointer((int)drmModeModeInfo.size(), (long)l, (int)1).getByteBuffer());
    }

    drmModeModeInfo(ByteBuffer byteBuffer) {
        this.md = MachineDataInfo.StaticConfig.values()[drmModeModeInfo.mdIdx].md;
        this.accessor = new StructAccessor(byteBuffer);
    }

    public final ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public final long getDirectBufferAddress() {
        return this.accessor.getDirectBufferAddress();
    }

    public final int getClock() {
        return this.accessor.getIntAt(clock_offset[mdIdx]);
    }

    public final short getHdisplay() {
        return this.accessor.getShortAt(hdisplay_offset[mdIdx]);
    }

    public final short getHsync_start() {
        return this.accessor.getShortAt(hsync_start_offset[mdIdx]);
    }

    public final short getHsync_end() {
        return this.accessor.getShortAt(hsync_end_offset[mdIdx]);
    }

    public final short getHtotal() {
        return this.accessor.getShortAt(htotal_offset[mdIdx]);
    }

    public final short getHskew() {
        return this.accessor.getShortAt(hskew_offset[mdIdx]);
    }

    public final short getVdisplay() {
        return this.accessor.getShortAt(vdisplay_offset[mdIdx]);
    }

    public final short getVsync_start() {
        return this.accessor.getShortAt(vsync_start_offset[mdIdx]);
    }

    public final short getVsync_end() {
        return this.accessor.getShortAt(vsync_end_offset[mdIdx]);
    }

    public final short getVtotal() {
        return this.accessor.getShortAt(vtotal_offset[mdIdx]);
    }

    public final short getVscan() {
        return this.accessor.getShortAt(vscan_offset[mdIdx]);
    }

    public final int getVrefresh() {
        return this.accessor.getIntAt(vrefresh_offset[mdIdx]);
    }

    public final int getFlags() {
        return this.accessor.getIntAt(flags_offset[mdIdx]);
    }

    public final int getType() {
        return this.accessor.getIntAt(type_offset[mdIdx]);
    }

    public static int getNameElemCount() {
        return 32;
    }

    public final String getNameAsString() {
        int n = drmModeModeInfo.getNameElemCount();
        ByteBuffer byteBuffer = ElementBuffer.wrap((int)1, (ByteBuffer)this.getBuffer(), (int)name_offset[mdIdx], (int)n).getByteBuffer();
        byte[] byArray = new byte[n];
        int n2 = -1;
        while (++n2 < n) {
            byArray[n2] = byteBuffer.get(n2);
            if (0 != byArray[n2]) continue;
        }
        return new String(byArray, 0, n2, _charset);
    }

    public final ByteBuffer getName() {
        return ElementBuffer.wrap((int)1, (ByteBuffer)this.getBuffer(), (int)name_offset[mdIdx], (int)drmModeModeInfo.getNameElemCount()).getByteBuffer();
    }

    public static Charset getCharset() {
        return _charset;
    }

    public static void setCharset(Charset charset) {
        _charset = charset;
    }
}

