/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.checker.table;

import java.util.Arrays;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import nu.validator.checker.table.Cell;
import nu.validator.checker.table.HorizontalCellComparator;
import nu.validator.checker.table.Table;
import nu.validator.checker.table.VerticalCellComparator;
import org.xml.sax.SAXException;

final class RowGroup {
    private final Cell[] EMPTY_CELL_ARRAY = new Cell[0];
    private int currentRow = -1;
    private int insertionPoint = 0;
    private int nextOldCell = 0;
    private final Table owner;
    private final SortedSet<Cell> cellsIfEffect = new TreeSet<Cell>(VerticalCellComparator.THE_INSTANCE);
    private Cell[] cellsOnCurrentRow;
    private boolean rowHadCells;
    private final String type;

    RowGroup(Table owner, String type) {
        this.owner = owner;
        this.type = type;
    }

    public void cell(Cell cell) throws SAXException {
        this.rowHadCells = true;
        this.findInsertionPoint();
        cell.setPosition(this.currentRow, this.insertionPoint);
        this.owner.cell(cell);
        if (cell.getBottom() > this.currentRow + 1) {
            this.cellsIfEffect.add(cell);
        }
        this.insertionPoint = cell.getRight();
        for (int i = this.nextOldCell; i < this.cellsOnCurrentRow.length; ++i) {
            this.cellsOnCurrentRow[i].errOnHorizontalOverlap(cell);
        }
    }

    private void findInsertionPoint() {
        Cell other;
        while (this.nextOldCell < this.cellsOnCurrentRow.length && this.insertionPoint >= (other = this.cellsOnCurrentRow[this.nextOldCell]).getLeft()) {
            int right = other.getRight();
            if (right > this.insertionPoint) {
                this.insertionPoint = right;
            }
            ++this.nextOldCell;
        }
    }

    public void end() throws SAXException {
        for (Cell cell : this.cellsIfEffect) {
            cell.errIfNotRowspanZero(this.type);
        }
    }

    public void endRow() throws SAXException {
        if (!this.rowHadCells) {
            this.owner.err("Row " + (this.currentRow + 1) + " of " + (String)(this.type == null ? "an implicit row group" : "a row group established by a \u201c" + this.type + "\u201d element") + " has no cells beginning on it.");
        }
        this.findInsertionPoint();
        this.cellsOnCurrentRow = null;
        int columnCount = this.owner.getColumnCount();
        if (this.owner.isHardWidth()) {
            if (this.insertionPoint > columnCount) {
                this.owner.err("A table row was " + this.insertionPoint + " columns wide and exceeded the column count established using column markup (" + columnCount + ").");
            } else if (this.insertionPoint < columnCount) {
                this.owner.err("A table row was " + this.insertionPoint + " columns wide, which is less than the column count established using column markup (" + columnCount + ").");
            }
        } else if (columnCount == -1) {
            this.owner.setColumnCount(this.insertionPoint);
        } else if (this.insertionPoint > columnCount) {
            this.owner.warn("A table row was " + this.insertionPoint + " columns wide and exceeded the column count established by the first row (" + columnCount + ").");
        } else if (this.insertionPoint < columnCount) {
            this.owner.warn("A table row was " + this.insertionPoint + " columns wide, which is less than the column count established by the first row (" + columnCount + ").");
        }
        Iterator iter = this.cellsIfEffect.iterator();
        while (iter.hasNext()) {
            Cell cell = (Cell)iter.next();
            if (!cell.shouldBeCulled(this.currentRow + 1)) continue;
            iter.remove();
        }
    }

    public void startRow() {
        ++this.currentRow;
        this.insertionPoint = 0;
        this.nextOldCell = 0;
        this.rowHadCells = false;
        this.cellsOnCurrentRow = this.cellsIfEffect.toArray(this.EMPTY_CELL_ARRAY);
        Arrays.sort(this.cellsOnCurrentRow, HorizontalCellComparator.THE_INSTANCE);
    }
}

