/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.parser.gson;

import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.automation.Rule;
import org.openhab.core.automation.dto.RuleDTO;
import org.openhab.core.automation.dto.RuleDTOMapper;
import org.openhab.core.automation.internal.parser.gson.AbstractGSONParser;
import org.openhab.core.automation.parser.Parser;
import org.openhab.core.automation.parser.ParsingException;
import org.openhab.core.automation.parser.ParsingNestedException;
import org.osgi.service.component.annotations.Component;

@NonNullByDefault
@Component(immediate=true, service={Parser.class}, property={"parser.type=parser.rule", "format=json"})
public class RuleGSONParser
extends AbstractGSONParser<Rule> {
    @Override
    public Set<Rule> parse(InputStreamReader reader) throws ParsingException {
        JsonReader jr = new JsonReader((Reader)reader);
        try {
            HashSet<Rule> rules = new HashSet<Rule>();
            if (jr.hasNext()) {
                JsonToken token = jr.peek();
                if (JsonToken.BEGIN_ARRAY.equals((Object)token)) {
                    List ruleDtos = (List)gson.fromJson(jr, new TypeToken<List<RuleDTO>>(){}.getType());
                    for (RuleDTO ruleDto : ruleDtos) {
                        rules.add(RuleDTOMapper.map(ruleDto));
                    }
                } else {
                    RuleDTO ruleDto = (RuleDTO)gson.fromJson(jr, RuleDTO.class);
                    rules.add(RuleDTOMapper.map(ruleDto));
                }
                HashSet<Rule> hashSet = rules;
                return hashSet;
            }
        }
        catch (Exception e) {
            throw new ParsingException(new ParsingNestedException(3, null, e));
        }
        finally {
            try {
                jr.close();
            }
            catch (IOException iOException) {}
        }
        return Set.of();
    }
}

