/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.output.pageable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.output.AbstractOutputProcessor;
import org.jfree.layouting.output.pageable.LogicalPageKey;
import org.jfree.layouting.output.pageable.PageFlowSelector;
import org.jfree.layouting.output.pageable.PageableOutputProcessor;
import org.jfree.layouting.output.pageable.PhysicalPageKey;
import org.jfree.layouting.renderer.PaginatingRenderer;
import org.jfree.layouting.renderer.PrototypeBuildingRenderer;
import org.jfree.layouting.renderer.Renderer;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.page.PageGrid;
import org.pentaho.reporting.libraries.base.config.Configuration;

public abstract class AbstractPageableProcessor
extends AbstractOutputProcessor
implements PageableOutputProcessor {
    private List physicalPages = new ArrayList();
    private PrototypeBuildingRenderer prototypeBuilder;

    protected AbstractPageableProcessor(Configuration configuration) {
        super(configuration);
    }

    @Override
    public Renderer createRenderer(LayoutProcess layoutProcess) {
        if (!this.isGlobalStateComputed()) {
            this.prototypeBuilder = new PrototypeBuildingRenderer(layoutProcess);
            return this.prototypeBuilder;
        }
        return new PaginatingRenderer(layoutProcess);
    }

    public PrototypeBuildingRenderer getPrototypeBuilder() {
        return this.prototypeBuilder;
    }

    @Override
    protected void processingPagesFinished() {
        super.processingPagesFinished();
        this.physicalPages = Collections.unmodifiableList(this.physicalPages);
    }

    @Override
    public int getPhysicalPageCount() {
        return this.physicalPages.size();
    }

    @Override
    public PhysicalPageKey getPhysicalPage(int n) {
        if (!this.isPaginationFinished()) {
            throw new IllegalStateException();
        }
        return (PhysicalPageKey)this.physicalPages.get(n);
    }

    @Override
    protected LogicalPageKey createLogicalPage(int n, int n2) {
        LogicalPageKey logicalPageKey = super.createLogicalPage(n, n2);
        for (int i = 0; i < logicalPageKey.getHeight(); ++i) {
            for (int j = 0; j < logicalPageKey.getWidth(); ++j) {
                this.physicalPages.add(logicalPageKey.getPage(j, i));
            }
        }
        return logicalPageKey;
    }

    @Override
    protected void processPageContent(LogicalPageKey logicalPageKey, LogicalPageBox logicalPageBox) {
        PageGrid pageGrid = logicalPageBox.getPageGrid();
        int n = pageGrid.getRowCount();
        int n2 = pageGrid.getColumnCount();
        PageFlowSelector pageFlowSelector = this.getFlowSelector();
        if (pageFlowSelector != null) {
            if (pageFlowSelector.isLogicalPageAccepted(logicalPageKey)) {
                this.processLogicalPage(logicalPageKey, logicalPageBox);
            }
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    PhysicalPageKey physicalPageKey = logicalPageKey.getPage(j, i);
                    if (!pageFlowSelector.isPhysicalPageAccepted(physicalPageKey)) continue;
                    this.processPhysicalPage(pageGrid, logicalPageBox, i, j, physicalPageKey);
                }
            }
        }
    }

    protected abstract PageFlowSelector getFlowSelector();

    protected abstract void processPhysicalPage(PageGrid var1, LogicalPageBox var2, int var3, int var4, PhysicalPageKey var5);

    protected abstract void processLogicalPage(LogicalPageKey var1, LogicalPageBox var2);
}

