/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.expr.Exprs;
import com.googlecode.dex2jar.ir.expr.Local;
import com.googlecode.dex2jar.ir.expr.Value;
import com.googlecode.dex2jar.ir.stmt.AssignStmt;
import com.googlecode.dex2jar.ir.stmt.BaseSwitchStmt;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.stmt.StmtList;
import com.googlecode.dex2jar.ir.stmt.Stmts;
import com.googlecode.dex2jar.ir.ts.Cfg;
import com.googlecode.dex2jar.ir.ts.Transformer;
import com.googlecode.dex2jar.ir.ts.UniqueQueue;
import com.googlecode.dex2jar.ir.ts.an.AnalyzeValue;
import com.googlecode.dex2jar.ir.ts.an.BaseAnalyze;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SSATransformer
implements Transformer {
    private void cleanTagsAndReIndex(IrMethod method) {
        int i = 0;
        for (Local local : method.locals) {
            local.tag = null;
            local._ls_index = i++;
        }
    }

    private void deleteDeadCode(IrMethod method) {
        Iterator<Stmt> it = method.stmts.iterator();
        while (it.hasNext()) {
            Stmt stmt = it.next();
            if (stmt.visited || stmt.st == Stmt.ST.LABEL) continue;
            it.remove();
        }
    }

    private void replaceLocalsWithSSA(IrMethod method) {
        final List<Local> locals = method.locals;
        locals.clear();
        StmtList stmts = method.stmts;
        Cfg.TravelCallBack tcb = new Cfg.TravelCallBack(){

            @Override
            public Value onAssign(Local a, AssignStmt as) {
                if (a._ls_index < 0) {
                    locals.add(a);
                    return a;
                }
                SSAValue lsv = (SSAValue)a.tag;
                Local b = lsv.local;
                locals.add(b);
                return b;
            }

            @Override
            public Value onUse(Local a) {
                if (a._ls_index < 0) {
                    return a;
                }
                SSAValue lsv = (SSAValue)a.tag;
                Local b = lsv.local;
                return b;
            }
        };
        HashSet<Local> froms = new HashSet<Local>();
        ArrayList<LabelStmt> phiLabels = new ArrayList<LabelStmt>();
        for (Stmt p = stmts.getFirst(); p != null; p = p.getNext()) {
            if (p.st == Stmt.ST.LABEL) {
                LabelStmt labelStmt = (LabelStmt)p;
                ArrayList<AssignStmt> phis = null;
                SSAValue[] frame = (SSAValue[])p.frame;
                if (frame != null) {
                    for (SSAValue v : frame) {
                        if (v == null || !v.used) continue;
                        if (v.parent != null) {
                            froms.add(v.parent.local);
                        }
                        if (v.otherParents != null) {
                            for (SSAValue parent : v.otherParents) {
                                froms.add(parent.local);
                            }
                        }
                        froms.remove(v.local);
                        if (phis == null) {
                            phis = new ArrayList<AssignStmt>();
                        }
                        locals.add(v.local);
                        phis.add(Stmts.nAssign(v.local, Exprs.nPhi(froms.toArray(new Value[froms.size()]))));
                        froms.clear();
                    }
                }
                labelStmt.phis = phis;
                if (phis != null) {
                    phiLabels.add(labelStmt);
                }
            } else {
                Cfg.travelMod(p, tcb, true);
            }
            p.frame = null;
        }
        if (phiLabels.size() > 0) {
            method.phiLabels = phiLabels;
        }
    }

    @Override
    public void transform(IrMethod method) {
        boolean needSSA = this.prepare(method);
        if (needSSA) {
            new SSAAnalyze(method).analyze();
            this.deleteDeadCode(method);
            this.replaceLocalsWithSSA(method);
        }
        this.cleanTagsAndReIndex(method);
    }

    private boolean prepare(final IrMethod method) {
        int index = Cfg.reIndexLocal(method);
        final int[] readCounts = new int[index];
        final int[] writeCounts = new int[index];
        Cfg.travel(method.stmts, new Cfg.TravelCallBack(){

            @Override
            public Value onAssign(Local v, AssignStmt as) {
                int n = v._ls_index;
                writeCounts[n] = writeCounts[n] + 1;
                return v;
            }

            @Override
            public Value onUse(Local v) {
                int n = v._ls_index;
                readCounts[n] = readCounts[n] + 1;
                return v;
            }
        }, true);
        boolean needTravel = false;
        boolean needSSAAnalyze = false;
        index = 0;
        List<Local> oldLocals = method.locals;
        ArrayList<Local> locals = new ArrayList<Local>(oldLocals);
        oldLocals.clear();
        for (Local local : locals) {
            int idx = local._ls_index;
            int read = readCounts[idx];
            int write = writeCounts[idx];
            if (read <= 0 || write == 0) {
                // empty if block
            }
            if (read == 0 && write == 0) continue;
            if (write <= 1) {
                local._ls_index = -1;
                oldLocals.add(local);
                continue;
            }
            if (read == 0) {
                local._ls_index = -2;
                needTravel = true;
                continue;
            }
            needSSAAnalyze = true;
            local._ls_index = index++;
            oldLocals.add(local);
        }
        if (needSSAAnalyze || needTravel) {
            Cfg.travelMod(method.stmts, new Cfg.TravelCallBack(){

                @Override
                public Value onAssign(Local v, AssignStmt as) {
                    if (v._ls_index == -1) {
                        return v;
                    }
                    if (v._ls_index == -2) {
                        Local n = (Local)v.clone();
                        method.locals.add(n);
                        return n;
                    }
                    return v.clone();
                }

                @Override
                public Value onUse(Local v) {
                    if (v._ls_index == -1) {
                        return v;
                    }
                    return v.clone();
                }
            }, true);
        }
        return needSSAAnalyze;
    }

    private static class SSAValue
    implements AnalyzeValue {
        public Local local;
        public Set<SSAValue> otherParents;
        public boolean used = false;
        public SSAValue parent;

        private SSAValue() {
        }

        @Override
        public char toRsp() {
            return this.used ? (char)'x' : '.';
        }

        public String toString() {
            if (this.local != null) {
                return this.local.toString();
            }
            return "N";
        }
    }

    static class SSAAnalyze
    extends BaseAnalyze<SSAValue> {
        public int nextIndex;

        public SSAAnalyze(IrMethod method) {
            super(method, false);
        }

        protected void afterExec(SSAValue[] frame, Stmt stmt) {
            if (stmt._cfg_froms.size() < 2) {
                this.setFrame(stmt, null);
            }
        }

        @Override
        public Local onUse(Local local) {
            if (local._ls_index < 0) {
                return local;
            }
            return super.onUse(local);
        }

        @Override
        public Local onAssign(Local local, AssignStmt as) {
            if (local._ls_index < 0) {
                return local;
            }
            return super.onAssign(local, as);
        }

        @Override
        protected void analyzeValue() {
            Set<SSAValue> set = this.markUsed();
            this.aValues.clear();
            this.aValues = null;
            Iterator<SSAValue> iterator = set.iterator();
            while (iterator.hasNext()) {
                SSAValue v0;
                SSAValue v = v0 = iterator.next();
                if (!v.used || v.local != null) continue;
                v.local = new Local(this.nextIndex++);
            }
        }

        protected void clearLsEmptyValueFromFrame() {
            for (Stmt p = this.method.stmts.getFirst(); p != null; p = p.getNext()) {
                SSAValue[] frame = (SSAValue[])p.frame;
                if (frame == null) continue;
                for (int i = 0; i < frame.length; ++i) {
                    SSAValue r = frame[i];
                    if (r == null || r.used) continue;
                    frame[i] = null;
                }
            }
        }

        @Override
        protected void init() {
            super.init();
            this.nextIndex = this.method.locals.size();
        }

        @Override
        protected void initCFG() {
            Cfg.createCFG(this.method);
        }

        protected Set<SSAValue> markUsed() {
            HashSet<SSAValue> used = new HashSet<SSAValue>(this.aValues.size() / 2);
            UniqueQueue q = new UniqueQueue();
            q.addAll(this.aValues);
            while (!q.isEmpty()) {
                SSAValue v = (SSAValue)q.poll();
                if (!v.used) continue;
                used.add(v);
                SSAValue p = v.parent;
                if (p != null && !p.used) {
                    p.used = true;
                    q.add(p);
                }
                if (v.otherParents == null) continue;
                for (SSAValue p2 : v.otherParents) {
                    if (p2.used) continue;
                    p2.used = true;
                    q.add(p2);
                }
            }
            return used;
        }

        @Override
        public SSAValue[] merge(SSAValue[] frame, SSAValue[] distFrame, Stmt src, Stmt dist) {
            if (distFrame != null) {
                this.relationMerge(frame, dist, distFrame);
            } else if (dist._cfg_froms.size() > 1) {
                distFrame = (SSAValue[])this.newFrame();
                this.relationMerge(frame, dist, distFrame);
            } else if (SSAAnalyze.needCopyFrame(src)) {
                distFrame = (SSAValue[])this.newFrame();
                System.arraycopy(frame, 0, distFrame, 0, distFrame.length);
            } else {
                distFrame = frame;
            }
            return distFrame;
        }

        private static boolean needCopyFrame(Stmt src) {
            int c = 0;
            if (src.exceptionHandlers != null && (c += src.exceptionHandlers.size()) > 1) {
                return true;
            }
            if (src.st.canContinue() && ++c > 1) {
                return true;
            }
            if (src.st.canBranch() && ++c > 1) {
                return true;
            }
            if (src.st.canSwitch()) {
                ++c;
                BaseSwitchStmt bss = (BaseSwitchStmt)src;
                c += bss.targets.length;
            }
            return c > 1;
        }

        protected SSAValue[] newFrame(int size) {
            return new SSAValue[size];
        }

        @Override
        protected SSAValue newValue() {
            return new SSAValue();
        }

        @Override
        protected SSAValue onAssignLocal(Local local, Value value) {
            SSAValue aValue = this.newValue();
            aValue.local = local;
            local.tag = aValue;
            return aValue;
        }

        @Override
        protected void onUseLocal(SSAValue aValue, Local local) {
            local.tag = aValue;
            aValue.used = true;
        }

        protected void relationMerge(SSAValue[] frame, Stmt dist, SSAValue[] distFrame) {
            for (int i = 0; i < this.localSize; ++i) {
                SSAValue srcValue = frame[i];
                if (srcValue == null) continue;
                SSAValue distValue = distFrame[i];
                if (distValue == null) {
                    if (dist.visited) continue;
                    distValue = this.newValue();
                    this.aValues.add(distValue);
                    distFrame[i] = distValue;
                    this.linkParentChildren(srcValue, distValue);
                    continue;
                }
                this.linkParentChildren(srcValue, distValue);
            }
        }

        private void linkParentChildren(SSAValue p, SSAValue c) {
            if (c.parent == null) {
                c.parent = p;
            } else {
                if (c.parent == p) {
                    return;
                }
                Set<SSAValue> ps = c.otherParents;
                if (ps == null) {
                    c.otherParents = ps = new HashSet<SSAValue>(3);
                }
                ps.add(p);
            }
        }
    }
}

