/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.scriptvalues_mod;

import java.math.BigDecimal;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.pentaho.di.compatibility.Row;
import org.pentaho.di.compatibility.Value;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.KettleURLClassLoader;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.scriptvalues_mod.Messages;
import org.pentaho.di.trans.steps.scriptvalues_mod.ScriptValuesAddClasses;
import org.pentaho.di.trans.steps.scriptvalues_mod.ScriptValuesAddedFunctions;
import org.pentaho.di.trans.steps.scriptvalues_mod.ScriptValuesMod;
import org.pentaho.di.trans.steps.scriptvalues_mod.ScriptValuesModData;
import org.pentaho.di.trans.steps.scriptvalues_mod.ScriptValuesModDummy;
import org.pentaho.di.trans.steps.scriptvalues_mod.ScriptValuesScript;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptValuesMetaMod
extends BaseStepMeta
implements StepMetaInterface {
    private static final String JSSCRIPT_TAG_TYPE = "jsScript_type";
    private static final String JSSCRIPT_TAG_NAME = "jsScript_name";
    private static final String JSSCRIPT_TAG_SCRIPT = "jsScript_script";
    private ScriptValuesAddClasses[] additionalClasses;
    private ScriptValuesScript[] jsScripts;
    private String[] name;
    private String[] rename;
    private int[] type;
    private int[] length;
    private int[] precision;
    private boolean[] replace;
    private boolean compatible = true;

    public ScriptValuesMetaMod() {
        try {
            this.parseXmlForAdditionalClasses();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int[] getLength() {
        return this.length;
    }

    public void setLength(int[] length) {
        this.length = length;
    }

    public String[] getName() {
        return this.name;
    }

    public void setName(String[] name) {
        this.name = name;
    }

    public int[] getPrecision() {
        return this.precision;
    }

    public void setPrecision(int[] precision) {
        this.precision = precision;
    }

    public String[] getRename() {
        return this.rename;
    }

    public void setRename(String[] rename) {
        this.rename = rename;
    }

    public int[] getType() {
        return this.type;
    }

    public void setType(int[] type) {
        this.type = type;
    }

    public int getNumberOfJSScripts() {
        return this.jsScripts.length;
    }

    public String[] getJSScriptNames() {
        String[] strJSNames = new String[this.jsScripts.length];
        for (int i = 0; i < this.jsScripts.length; ++i) {
            strJSNames[i] = this.jsScripts[i].getScriptName();
        }
        return strJSNames;
    }

    public ScriptValuesScript[] getJSScripts() {
        return this.jsScripts;
    }

    public void setJSScripts(ScriptValuesScript[] jsScripts) {
        this.jsScripts = jsScripts;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrfields) {
        this.name = new String[nrfields];
        this.rename = new String[nrfields];
        this.type = new int[nrfields];
        this.length = new int[nrfields];
        this.precision = new int[nrfields];
        this.replace = new boolean[nrfields];
    }

    @Override
    public Object clone() {
        ScriptValuesMetaMod retval = (ScriptValuesMetaMod)super.clone();
        int nrfields = this.name.length;
        retval.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            retval.name[i] = this.name[i];
            retval.rename[i] = this.rename[i];
            retval.type[i] = this.type[i];
            retval.length[i] = this.length[i];
            retval.precision[i] = this.precision[i];
            retval.replace[i] = this.replace[i];
        }
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            Node fnode;
            int i;
            String script = XMLHandler.getTagValue((Node)stepnode, (String)"script");
            String strCompatible = XMLHandler.getTagValue((Node)stepnode, (String)"compatible");
            this.compatible = strCompatible == null ? true : "Y".equalsIgnoreCase(strCompatible);
            if (!Const.isEmpty((String)script)) {
                this.jsScripts = new ScriptValuesScript[1];
                this.jsScripts[0] = new ScriptValuesScript(0, "ScriptValue", script);
            } else {
                Node scripts = XMLHandler.getSubNode((Node)stepnode, (String)"jsScripts");
                int nrscripts = XMLHandler.countNodes((Node)scripts, (String)"jsScript");
                this.jsScripts = new ScriptValuesScript[nrscripts];
                for (i = 0; i < nrscripts; ++i) {
                    fnode = XMLHandler.getSubNodeByNr((Node)scripts, (String)"jsScript", (int)i);
                    this.jsScripts[i] = new ScriptValuesScript(Integer.parseInt(XMLHandler.getTagValue((Node)fnode, (String)JSSCRIPT_TAG_TYPE)), XMLHandler.getTagValue((Node)fnode, (String)JSSCRIPT_TAG_NAME), XMLHandler.getTagValue((Node)fnode, (String)JSSCRIPT_TAG_SCRIPT));
                }
            }
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrfields);
            for (i = 0; i < nrfields; ++i) {
                fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.name[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
                this.rename[i] = XMLHandler.getTagValue((Node)fnode, (String)"rename");
                this.type[i] = ValueMeta.getType((String)XMLHandler.getTagValue((Node)fnode, (String)"type"));
                String slen = XMLHandler.getTagValue((Node)fnode, (String)"length");
                String sprc = XMLHandler.getTagValue((Node)fnode, (String)"precision");
                this.length[i] = Const.toInt((String)slen, (int)-1);
                this.precision[i] = Const.toInt((String)sprc, (int)-1);
                this.replace[i] = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)fnode, (String)"replace"));
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("ScriptValuesMetaMod.Exception.UnableToLoadStepInfoFromXML"), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.jsScripts = new ScriptValuesScript[1];
        this.jsScripts[0] = new ScriptValuesScript(0, Messages.getString("ScriptValuesMod.Script1"), "//" + Messages.getString("ScriptValuesMod.ScriptHere") + Const.CR + Const.CR);
        int nrfields = 0;
        this.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            this.name[i] = "newvalue";
            this.rename[i] = "newvalue";
            this.type[i] = 1;
            this.length[i] = -1;
            this.precision[i] = -1;
            this.replace[i] = false;
        }
        this.compatible = false;
    }

    @Override
    public void getFields(RowMetaInterface row, String originStepname, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        for (int i = 0; i < this.name.length; ++i) {
            ValueMetaInterface v;
            if (Const.isEmpty((String)this.name[i])) continue;
            if (this.replace[i]) {
                v = row.searchValueMeta(this.name[i]);
                if (v == null && Const.isEmpty((String)this.rename[i])) {
                    throw new KettleStepException(Messages.getString("ScriptValuesMetaMod.Exception.FieldToReplaceNotFound", this.name[i]));
                }
                v = row.searchValueMeta(this.rename[i]);
                v.setType(this.type[i]);
            } else {
                v = this.rename[i] != null && this.rename[i].length() != 0 ? new ValueMeta(this.rename[i], this.type[i]) : new ValueMeta(this.name[i], this.type[i]);
            }
            v.setLength(this.length[i]);
            v.setPrecision(this.precision[i]);
            v.setOrigin(originStepname);
            if (this.replace[i]) continue;
            row.addValueMeta(v);
        }
    }

    @Override
    public String getXML() {
        int i;
        StringBuffer retval = new StringBuffer(300);
        retval.append("    ").append(XMLHandler.addTagValue((String)"compatible", (boolean)this.compatible));
        retval.append("    <jsScripts>");
        for (i = 0; i < this.jsScripts.length; ++i) {
            retval.append("      <jsScript>");
            retval.append("        ").append(XMLHandler.addTagValue((String)JSSCRIPT_TAG_TYPE, (int)this.jsScripts[i].getScriptType()));
            retval.append("        ").append(XMLHandler.addTagValue((String)JSSCRIPT_TAG_NAME, (String)this.jsScripts[i].getScriptName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)JSSCRIPT_TAG_SCRIPT, (String)this.jsScripts[i].getScript()));
            retval.append("      </jsScript>");
        }
        retval.append("    </jsScripts>");
        retval.append("    <fields>");
        for (i = 0; i < this.name.length; ++i) {
            retval.append("      <field>");
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.name[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"rename", (String)this.rename[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)ValueMeta.getTypeDesc((int)this.type[i])));
            retval.append("        ").append(XMLHandler.addTagValue((String)"length", (int)this.length[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"precision", (int)this.precision[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"replace", (boolean)this.replace[i]));
            retval.append("      </field>");
        }
        retval.append("    </fields>");
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            int i;
            String script = rep.getStepAttributeString(id_step, "script");
            this.compatible = rep.getStepAttributeBoolean(id_step, 0, "compatible", true);
            if (!Const.isEmpty((String)script)) {
                this.jsScripts = new ScriptValuesScript[1];
                this.jsScripts[0] = new ScriptValuesScript(0, "ScriptValue", script);
            } else {
                int nrScripts = rep.countNrStepAttributes(id_step, JSSCRIPT_TAG_NAME);
                this.jsScripts = new ScriptValuesScript[nrScripts];
                for (i = 0; i < nrScripts; ++i) {
                    this.jsScripts[i] = new ScriptValuesScript((int)rep.getStepAttributeInteger(id_step, i, JSSCRIPT_TAG_TYPE), rep.getStepAttributeString(id_step, i, JSSCRIPT_TAG_NAME), rep.getStepAttributeString(id_step, i, JSSCRIPT_TAG_SCRIPT));
                }
            }
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (i = 0; i < nrfields; ++i) {
                this.name[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.rename[i] = rep.getStepAttributeString(id_step, i, "field_rename");
                this.type[i] = ValueMeta.getType((String)rep.getStepAttributeString(id_step, i, "field_type"));
                this.length[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_length");
                this.precision[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_precision");
                this.replace[i] = rep.getStepAttributeBoolean(id_step, i, "field_replace");
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("ScriptValuesMetaMod.Exception.UnexpectedErrorInReadingStepInfo"), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "compatible", this.compatible);
            for (i = 0; i < this.jsScripts.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, JSSCRIPT_TAG_NAME, this.jsScripts[i].getScriptName());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, JSSCRIPT_TAG_SCRIPT, this.jsScripts[i].getScript());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, JSSCRIPT_TAG_TYPE, this.jsScripts[i].getScriptType());
            }
            for (i = 0; i < this.name.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_name", this.name[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_rename", this.rename[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_type", ValueMeta.getTypeDesc((int)this.type[i]));
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_length", this.length[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_precision", this.precision[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_replace", this.replace[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("ScriptValuesMetaMod.Exception.UnableToSaveStepInfo") + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        int i;
        boolean error_found = false;
        String error_message = "";
        Context jscx = ContextFactory.getGlobal().enterContext();
        ScriptableObject jsscope = jscx.initStandardObjects(null, false);
        jscx.setOptimizationLevel(-1);
        String strActiveStartScriptName = "";
        String strActiveEndScriptName = "";
        String strActiveScript = "";
        String strActiveStartScript = "";
        String strActiveEndScript = "";
        if (this.jsScripts.length > 0) {
            for (i = 0; i < this.jsScripts.length; ++i) {
                if (this.jsScripts[i].isTransformScript()) {
                    strActiveScript = this.jsScripts[i].getScript();
                    continue;
                }
                if (this.jsScripts[i].isStartScript()) {
                    strActiveStartScriptName = this.jsScripts[i].getScriptName();
                    strActiveStartScript = this.jsScripts[i].getScript();
                    continue;
                }
                if (!this.jsScripts[i].isEndScript()) continue;
                strActiveEndScriptName = this.jsScripts[i].getScriptName();
                strActiveEndScript = this.jsScripts[i].getScript();
            }
        }
        if (prev != null && strActiveScript.length() > 0) {
            cr = new CheckResult(1, Messages.getString("ScriptValuesMetaMod.CheckResult.ConnectedStepOK", String.valueOf(prev.size())), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
            for (i = 0; i < this.getNumberOfJSScripts(); ++i) {
                Scriptable jsR = Context.toObject((Object)this.jsScripts[i].getScript(), (Scriptable)jsscope);
                jsscope.put(this.jsScripts[i].getScriptName(), (Scriptable)jsscope, (Object)jsR);
            }
            try {
                if (this.getAddClasses() != null) {
                    for (i = 0; i < this.getAddClasses().length; ++i) {
                        Object jsOut = Context.javaToJS((Object)this.getAddClasses()[i].getAddObject(), (Scriptable)jsscope);
                        ScriptableObject.putProperty((Scriptable)jsscope, (String)this.getAddClasses()[i].getJSName(), (Object)jsOut);
                    }
                }
            }
            catch (Exception e) {
                error_message = "Couldn't add JavaClasses to Context! Error:";
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
                remarks.add((CheckResultInterface)cr);
            }
            try {
                Context.javaToJS(ScriptValuesAddedFunctions.class, (Scriptable)jsscope);
                jsscope.defineFunctionProperties(ScriptValuesAddedFunctions.jsFunctionList, ScriptValuesAddedFunctions.class, 2);
            }
            catch (Exception ex) {
                error_message = "Couldn't add Default Functions! Error:" + Const.CR + ex.toString();
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
                remarks.add((CheckResultInterface)cr);
            }
            try {
                jsscope.put("SKIP_TRANSFORMATION", (Scriptable)jsscope, (Object)1);
                jsscope.put("ABORT_TRANSFORMATION", (Scriptable)jsscope, (Object)-1);
                jsscope.put("ERROR_TRANSFORMATION", (Scriptable)jsscope, (Object)-2);
                jsscope.put("CONTINUE_TRANSFORMATION", (Scriptable)jsscope, (Object)0);
            }
            catch (Exception ex) {
                error_message = "Couldn't add Transformation Constants! Error:" + Const.CR + ex.toString();
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
                remarks.add((CheckResultInterface)cr);
            }
            try {
                ScriptValuesModDummy dummyStep = new ScriptValuesModDummy(prev, transMeta.getStepFields(stepinfo));
                Scriptable jsvalue = Context.toObject((Object)dummyStep, (Scriptable)jsscope);
                jsscope.put("_step_", (Scriptable)jsscope, (Object)jsvalue);
                Object[] row = new Object[prev.size()];
                Scriptable jsRowMeta = Context.toObject((Object)prev, (Scriptable)jsscope);
                jsscope.put("rowMeta", (Scriptable)jsscope, (Object)jsRowMeta);
                for (int i2 = 0; i2 < prev.size(); ++i2) {
                    ValueMetaInterface valueMeta = prev.getValueMeta(i2);
                    Object valueData = null;
                    if (valueMeta.isDate()) {
                        valueData = new Date();
                    }
                    if (valueMeta.isString()) {
                        valueData = "test value test value test value test value test value test value test value test value test value test value";
                    }
                    if (valueMeta.isInteger()) {
                        valueData = 0L;
                    }
                    if (valueMeta.isNumber()) {
                        valueData = new Double(0.0);
                    }
                    if (valueMeta.isBigNumber()) {
                        valueData = BigDecimal.ZERO;
                    }
                    if (valueMeta.isBoolean()) {
                        valueData = Boolean.TRUE;
                    }
                    if (valueMeta.isBinary()) {
                        valueData = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
                    }
                    row[i2] = valueData;
                    if (this.isCompatible()) {
                        Value value = valueMeta.createOriginalValue(valueData);
                        Scriptable jsarg = Context.toObject((Object)value, (Scriptable)jsscope);
                        jsscope.put(valueMeta.getName(), (Scriptable)jsscope, (Object)jsarg);
                        continue;
                    }
                    Scriptable jsarg = Context.toObject((Object)valueData, (Scriptable)jsscope);
                    jsscope.put(valueMeta.getName(), (Scriptable)jsscope, (Object)jsarg);
                }
                Scriptable jsval = Context.toObject(Value.class, (Scriptable)jsscope);
                jsscope.put("Value", (Scriptable)jsscope, (Object)jsval);
                if (this.isCompatible()) {
                    Row v2Row = RowMeta.createOriginalRow((RowMetaInterface)prev, (Object[])row);
                    Scriptable jsV2Row = Context.toObject((Object)v2Row, (Scriptable)jsscope);
                    jsscope.put("row", (Scriptable)jsscope, (Object)jsV2Row);
                } else {
                    Scriptable jsRow = Context.toObject((Object)row, (Scriptable)jsscope);
                    jsscope.put("row", (Scriptable)jsscope, (Object)jsRow);
                }
            }
            catch (Exception ev) {
                error_message = "Couldn't add Input fields to Script! Error:" + Const.CR + ev.toString();
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
                remarks.add((CheckResultInterface)cr);
            }
            try {
                if (strActiveStartScript != null && strActiveStartScript.length() > 0) {
                    jscx.evaluateString((Scriptable)jsscope, strActiveStartScript, "trans_Start", 1, null);
                    error_message = "Found Start Script. " + strActiveStartScriptName + " Processing OK";
                    cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepinfo);
                    remarks.add((CheckResultInterface)cr);
                }
            }
            catch (Exception e) {
                error_message = "Couldn't process Start Script! Error:" + Const.CR + e.toString();
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
                remarks.add((CheckResultInterface)cr);
            }
            try {
                Script jsscript = jscx.compileString(strActiveScript, "script", 1, null);
                cr = new CheckResult(1, Messages.getString("ScriptValuesMetaMod.CheckResult.ScriptCompiledOK"), (CheckResultSourceInterface)stepinfo);
                remarks.add((CheckResultInterface)cr);
                try {
                    jsscript.exec(jscx, (Scriptable)jsscope);
                    cr = new CheckResult(1, Messages.getString("ScriptValuesMetaMod.CheckResult.ScriptCompiledOK2"), (CheckResultSourceInterface)stepinfo);
                    remarks.add((CheckResultInterface)cr);
                    if (this.name.length > 0) {
                        StringBuffer message = new StringBuffer(Messages.getString("ScriptValuesMetaMod.CheckResult.FailedToGetValues", String.valueOf(this.name.length)) + Const.CR + Const.CR);
                        cr = error_found ? new CheckResult(4, message.toString(), (CheckResultSourceInterface)stepinfo) : new CheckResult(1, message.toString(), (CheckResultSourceInterface)stepinfo);
                        remarks.add((CheckResultInterface)cr);
                    }
                }
                catch (JavaScriptException jse) {
                    Context.exit();
                    error_message = Messages.getString("ScriptValuesMetaMod.CheckResult.CouldNotExecuteScript") + Const.CR + jse.toString();
                    cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
                    remarks.add((CheckResultInterface)cr);
                }
                catch (Exception e) {
                    Context.exit();
                    error_message = Messages.getString("ScriptValuesMetaMod.CheckResult.CouldNotExecuteScript2") + Const.CR + e.toString();
                    cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
                    remarks.add((CheckResultInterface)cr);
                }
                try {
                    if (strActiveEndScript != null && strActiveEndScript.length() > 0) {
                        jscx.evaluateString((Scriptable)jsscope, strActiveEndScript, "trans_End", 1, null);
                        error_message = "Found End Script. " + strActiveEndScriptName + " Processing OK";
                        cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepinfo);
                        remarks.add((CheckResultInterface)cr);
                    }
                }
                catch (Exception e) {
                    error_message = "Couldn't process End Script! Error:" + Const.CR + e.toString();
                    cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
                    remarks.add((CheckResultInterface)cr);
                }
            }
            catch (Exception e) {
                Context.exit();
                error_message = Messages.getString("ScriptValuesMetaMod.CheckResult.CouldNotCompileScript") + Const.CR + e.toString();
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
                remarks.add((CheckResultInterface)cr);
            }
        } else {
            Context.exit();
            error_message = Messages.getString("ScriptValuesMetaMod.CheckResult.CouldNotGetFieldsFromPreviousStep");
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, Messages.getString("ScriptValuesMetaMod.CheckResult.ConnectedStepOK2"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, Messages.getString("ScriptValuesMetaMod.CheckResult.NoInputReceived"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public String getFunctionFromScript(String strFunction, String strScript) {
        String sRC = "";
        int iStartPos = strScript.indexOf(strFunction);
        if (iStartPos > 0) {
            iStartPos = strScript.indexOf(123, iStartPos);
            int iCounter = 1;
            while (iCounter != 0) {
                if (strScript.charAt(iStartPos++) == '{') {
                    ++iCounter;
                } else if (strScript.charAt(iStartPos++) == '}') {
                    --iCounter;
                }
                sRC = sRC + strScript.charAt(iStartPos);
            }
        }
        return sRC;
    }

    /*
     * Unable to fully structure code
     */
    public boolean getValue(Scriptable scope, int i, Value res, StringBuffer message) {
        block26: {
            block24: {
                block23: {
                    error_found = false;
                    if (this.name[i] == null || this.name[i].length() <= 0) break block24;
                    res.setName(this.rename[i]);
                    res.setType(this.type[i]);
                    try {
                        block25: {
                            result = scope.get(this.name[i], scope);
                            if (result == null) break block25;
                            classname = result.getClass().getName();
                            switch (this.type[i]) {
                                case 1: {
                                    if (classname.equalsIgnoreCase("org.mozilla.javascript.Undefined")) {
                                        res.setNull();
                                        break;
                                    }
                                    if (classname.equalsIgnoreCase("org.mozilla.javascript.NativeJavaObject")) {
                                        v = (Value)Context.jsToJava((Object)result, Value.class);
                                        res.setValue(v.getNumber());
                                        break;
                                    }
                                    res.setValue(((Double)result).doubleValue());
                                    break;
                                }
                                case 5: {
                                    if (classname.equalsIgnoreCase("java.lang.Byte")) {
                                        res.setValue(((Byte)result).longValue());
                                        break;
                                    }
                                    if (classname.equalsIgnoreCase("java.lang.Short")) {
                                        res.setValue(((Short)result).longValue());
                                        break;
                                    }
                                    if (classname.equalsIgnoreCase("java.lang.Integer")) {
                                        res.setValue(((Integer)result).longValue());
                                        break;
                                    }
                                    if (classname.equalsIgnoreCase("java.lang.Long")) {
                                        res.setValue(((Long)result).longValue());
                                        break;
                                    }
                                    if (classname.equalsIgnoreCase("org.mozilla.javascript.Undefined")) {
                                        res.setNull();
                                        break;
                                    }
                                    if (classname.equalsIgnoreCase("org.mozilla.javascript.NativeJavaObject")) {
                                        v = (Value)Context.jsToJava((Object)result, Value.class);
                                        res.setValue(v.getInteger());
                                        break;
                                    }
                                    res.setValue(Math.round((Double)result));
                                    break;
                                }
                                case 2: {
                                    if (classname.equalsIgnoreCase("org.mozilla.javascript.NativeJavaObject") || classname.equalsIgnoreCase("org.mozilla.javascript.Undefined")) {
                                        try {
                                            v = (Value)Context.jsToJava((Object)result, Value.class);
                                            res.setValue(v.getString());
                                        }
                                        catch (Exception ev) {
                                            s = (String)Context.jsToJava((Object)result, String.class);
                                            res.setValue(s);
                                        }
                                        break;
                                    }
                                    res.setValue((String)result);
                                    break;
                                }
                                case 3: {
                                    dbl = 0.0;
                                    if (classname.equalsIgnoreCase("org.mozilla.javascript.Undefined")) {
                                        res.setNull();
                                        break;
                                    }
                                    if (!classname.equalsIgnoreCase("org.mozilla.javascript.NativeDate")) ** GOTO lbl62
                                    dbl = Context.toNumber((Object)result);
                                    ** GOTO lbl76
lbl62:
                                    // 1 sources

                                    if (!classname.equalsIgnoreCase("org.mozilla.javascript.NativeJavaObject")) ** GOTO lbl75
                                    try {
                                        dat = (Date)Context.jsToJava((Object)result, Date.class);
                                        dbl = dat.getTime();
                                    }
                                    catch (Exception e) {
                                        v = (Value)Context.jsToJava((Object)result, Value.class);
                                        dat = v.getDate();
                                        if (dat == null) ** GOTO lbl73
                                        dbl = dat.getTime();
                                        ** GOTO lbl76
lbl73:
                                        // 1 sources

                                        res.setNull();
                                    }
                                    ** GOTO lbl76
lbl75:
                                    // 1 sources

                                    dbl = (Double)result;
lbl76:
                                    // 5 sources

                                    lng = Math.round(dbl);
                                    dat = new Date(lng);
                                    res.setValue(dat);
                                    break;
                                }
                                case 4: {
                                    res.setValue(((Boolean)result).booleanValue());
                                    break;
                                }
                                default: {
                                    res.setNull();
                                    break;
                                }
                            }
                            break block23;
                        }
                        res.setNull();
                    }
                    catch (Exception e) {
                        message.append(Messages.getString("ScriptValuesMetaMod.CheckResult.ErrorRetrievingValue", this.name[i]) + " : " + e.toString());
                        error_found = true;
                    }
                }
                res.setLength(this.length[i], this.precision[i]);
                message.append(Messages.getString("ScriptValuesMetaMod.CheckResult.RetrievedValue", this.name[i], res.toStringMeta()));
                break block26;
            }
            message.append(Messages.getString("ScriptValuesMetaMod.CheckResult.ValueIsEmpty", String.valueOf(i)));
            error_found = true;
        }
        return error_found;
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new ScriptValuesMod(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new ScriptValuesModData();
    }

    public void parseXmlForAdditionalClasses() throws KettleException {
        try {
            Properties sysprops = System.getProperties();
            String strActPath = sysprops.getProperty("user.dir");
            Document dom = XMLHandler.loadXMLFile((String)(strActPath + "/plugins/steps/ScriptValues_mod/plugin.xml"));
            Element stepnode = dom.getDocumentElement();
            Node libraries = XMLHandler.getSubNode((Node)stepnode, (String)"js_libraries");
            int nbOfLibs = XMLHandler.countNodes((Node)libraries, (String)"js_lib");
            this.additionalClasses = new ScriptValuesAddClasses[nbOfLibs];
            for (int i = 0; i < nbOfLibs; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)libraries, (String)"js_lib", (int)i);
                String strJarName = XMLHandler.getTagAttribute((Node)fnode, (String)"name");
                String strClassName = XMLHandler.getTagAttribute((Node)fnode, (String)"classname");
                String strJSName = XMLHandler.getTagAttribute((Node)fnode, (String)"js_name");
                Class<?> addClass = ScriptValuesMetaMod.LoadAdditionalClass(strActPath + "/plugins/steps/ScriptValues_mod/" + strJarName, strClassName);
                Object addObject = addClass.newInstance();
                this.additionalClasses[i] = new ScriptValuesAddClasses(addClass, addObject, strJSName);
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("ScriptValuesMetaMod.Exception.UnableToParseXMLforAdditionalClasses"), (Throwable)e);
        }
    }

    private static Class<?> LoadAdditionalClass(String strJar, String strClassName) throws KettleException {
        try {
            Thread t = Thread.currentThread();
            ClassLoader cl = t.getContextClassLoader();
            URL u = new URL("jar:file:" + strJar + "!/");
            KettleURLClassLoader kl = new KettleURLClassLoader(new URL[]{u}, cl);
            Class<?> toRun = kl.loadClass(strClassName);
            return toRun;
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("ScriptValuesMetaMod.Exception.UnableToLoadAdditionalClass"), (Throwable)e);
        }
    }

    public ScriptValuesAddClasses[] getAddClasses() {
        return this.additionalClasses;
    }

    public boolean isCompatible() {
        return this.compatible;
    }

    public void setCompatible(boolean compatible) {
        this.compatible = compatible;
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    @Override
    public String getDialogClassName() {
        return "org.pentaho.di.ui.trans.steps.scriptvalues_mod.ScriptValuesModDialog";
    }

    public boolean[] getReplace() {
        return this.replace;
    }

    public void setReplace(boolean[] replace) {
        this.replace = replace;
    }
}

