/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers;

import java.security.Principal;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.util.Assert;

public abstract class AbstractAuthenticationToken
implements Authentication {
    private Object details;
    private GrantedAuthority[] authorities;
    private boolean authenticated = false;

    public AbstractAuthenticationToken() {
    }

    public AbstractAuthenticationToken(GrantedAuthority[] authorities) {
        if (authorities != null) {
            for (int i = 0; i < authorities.length; ++i) {
                Assert.notNull((Object)authorities[i], (String)("Granted authority element " + i + " is null - GrantedAuthority[] cannot contain any null elements"));
            }
        }
        this.authorities = authorities;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractAuthenticationToken) {
            AbstractAuthenticationToken test = (AbstractAuthenticationToken)obj;
            if (this.getAuthorities() != null || test.getAuthorities() != null) {
                if (this.getAuthorities() == null || test.getAuthorities() == null) {
                    return false;
                }
                if (this.getAuthorities().length != test.getAuthorities().length) {
                    return false;
                }
                for (int i = 0; i < this.getAuthorities().length; ++i) {
                    if (this.getAuthorities()[i].equals(test.getAuthorities()[i])) continue;
                    return false;
                }
            }
            if (this.details == null && test.getDetails() != null) {
                return false;
            }
            if (this.details != null && test.getDetails() == null) {
                return false;
            }
            if (this.details != null && !this.details.equals(test.getDetails())) {
                return false;
            }
            if (this.getCredentials() == null && test.getCredentials() != null) {
                return false;
            }
            if (this.getCredentials() != null && !this.getCredentials().equals(test.getCredentials())) {
                return false;
            }
            if (this.getPrincipal() == null && test.getPrincipal() != null) {
                return false;
            }
            if (this.getPrincipal() != null && !this.getPrincipal().equals(test.getPrincipal())) {
                return false;
            }
            return this.isAuthenticated() == test.isAuthenticated();
        }
        return false;
    }

    public GrantedAuthority[] getAuthorities() {
        if (this.authorities == null) {
            return null;
        }
        GrantedAuthority[] copy = new GrantedAuthority[this.authorities.length];
        System.arraycopy(this.authorities, 0, copy, 0, this.authorities.length);
        return copy;
    }

    public Object getDetails() {
        return this.details;
    }

    public String getName() {
        if (this.getPrincipal() instanceof UserDetails) {
            return ((UserDetails)this.getPrincipal()).getUsername();
        }
        if (this.getPrincipal() instanceof Principal) {
            return ((Principal)this.getPrincipal()).getName();
        }
        return this.getPrincipal() == null ? "" : this.getPrincipal().toString();
    }

    public int hashCode() {
        int code = 31;
        GrantedAuthority[] authorities = this.getAuthorities();
        if (authorities != null) {
            for (int i = 0; i < authorities.length; ++i) {
                code ^= authorities[i].hashCode();
            }
        }
        if (this.getPrincipal() != null) {
            code ^= this.getPrincipal().hashCode();
        }
        if (this.getCredentials() != null) {
            code ^= this.getCredentials().hashCode();
        }
        if (this.getDetails() != null) {
            code ^= this.getDetails().hashCode();
        }
        if (this.isAuthenticated()) {
            code ^= 0xFFFFFFDB;
        }
        return code;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
    }

    public void setDetails(Object details) {
        this.details = details;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString()).append(": ");
        sb.append("Principal: ").append(this.getPrincipal()).append("; ");
        sb.append("Password: [PROTECTED]; ");
        sb.append("Authenticated: ").append(this.isAuthenticated()).append("; ");
        sb.append("Details: ").append(this.getDetails()).append("; ");
        if (this.getAuthorities() != null) {
            sb.append("Granted Authorities: ");
            for (int i = 0; i < this.getAuthorities().length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.getAuthorities()[i].toString());
            }
        } else {
            sb.append("Not granted any authorities");
        }
        return sb.toString();
    }

    public abstract /* synthetic */ Object getPrincipal();

    public abstract /* synthetic */ Object getCredentials();
}

