untrusted comment: verify with openbsd-74-base.pub
RWRoyQmAD08aja1JAQm71CDP6fV3tGuWZowioSppdcnBQ+R6jC+1KaBovFP0BCqJve0vO+3aomGrUwaLeufRExlGHI/0ZpIO9gY=

OpenBSD 7.4 errata 018, August 2, 2024:

sndiod(8) main process could crash due to buffer overread.

Apply by doing:
    signify -Vep /etc/signify/openbsd-74-base.pub -x 018_sndiod.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install sndiod:
    cd /usr/src/usr.bin/sndiod
    make obj
    make
    make install

Index: usr.bin/sndiod/sock.c
===================================================================
RCS file: /cvs/src/usr.bin/sndiod/sock.c,v
diff -u -p -r1.47 sock.c
--- usr.bin/sndiod/sock.c	26 Dec 2022 19:16:03 -0000	1.47
+++ usr.bin/sndiod/sock.c	31 Jul 2024 12:04:17 -0000
@@ -988,7 +988,7 @@ sock_execmsg(struct sock *f)
 	struct slot *s = f->slot;
 	struct amsg *m = &f->rmsg;
 	unsigned char *data;
-	int size, ctl;
+	unsigned int size, ctl;
 
 	switch (ntohl(m->cmd)) {
 	case AMSG_DATA:
@@ -1020,7 +1020,7 @@ sock_execmsg(struct sock *f)
 			return 0;
 		}
 		size = ntohl(m->u.data.size);
-		if (size <= 0) {
+		if (size == 0) {
 #ifdef DEBUG
 			if (log_level >= 1) {
 				sock_log(f);
