/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.json;

import twitter4j.PagableResponseList;
import twitter4j.RateLimitStatus;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.ResponseListImpl;
import twitter4j.internal.org.json.JSONObject;
import twitter4j.internal.util.z_T4JInternalParseUtil;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PagableResponseListImpl<T>
extends ResponseListImpl
implements PagableResponseList {
    private final long previousCursor;
    private final long nextCursor;
    private static final long serialVersionUID = 1531950333538983361L;

    PagableResponseListImpl(RateLimitStatus rateLimitStatus, RateLimitStatus featureSpecificRateLimitStatus, int accessLevel) {
        super(rateLimitStatus, featureSpecificRateLimitStatus, accessLevel);
        this.previousCursor = 0L;
        this.nextCursor = 0L;
    }

    PagableResponseListImpl(int size, JSONObject json, HttpResponse res) {
        super(size, res);
        this.previousCursor = z_T4JInternalParseUtil.getLong("previous_cursor", json);
        this.nextCursor = z_T4JInternalParseUtil.getLong("next_cursor", json);
    }

    @Override
    public boolean hasPrevious() {
        return 0L != this.previousCursor;
    }

    @Override
    public long getPreviousCursor() {
        return this.previousCursor;
    }

    @Override
    public boolean hasNext() {
        return 0L != this.nextCursor;
    }

    @Override
    public long getNextCursor() {
        return this.nextCursor;
    }
}

