/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.r.inlays.components;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t\u001a \u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0002\u00a8\u0006\u000e"}, d2={"convertRGBtoHSL", "", "rgb", "", "result", "convertHSLtoRGB", "", "hslFloats", "alpha", "", "hueToRGB", "p", "q", "h", "intellij.notebooks.visualization"})
public final class HSLUtilKt {
    public static final void convertRGBtoHSL(@NotNull float[] rgb, @NotNull float[] result) {
        Intrinsics.checkNotNullParameter((Object)rgb, (String)"rgb");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        float r = rgb[0];
        float g = rgb[1];
        float b = rgb[2];
        float min = Math.min(r, Math.min(g, b));
        float max = Math.max(r, Math.max(g, b));
        float h = 0.0f;
        if (max == min) {
            h = 0.0f;
        } else if (max == r) {
            h = ((float)60 * (g - b) / (max - min) + (float)360) % (float)360;
        } else if (max == g) {
            h = (float)60 * (b - r) / (max - min) + (float)120;
        } else if (max == b) {
            h = (float)60 * (r - g) / (max - min) + (float)240;
        }
        float l = (max + min) / (float)2;
        float s = 0.0f;
        s = max == min ? 0.0f : (l <= 0.5f ? (max - min) / (max + min) : (max - min) / ((float)2 - max - min));
        result[0] = h;
        result[1] = s * (float)100;
        result[2] = l * (float)100;
    }

    public static final int convertHSLtoRGB(@NotNull float[] hslFloats, float alpha) {
        Intrinsics.checkNotNullParameter((Object)hslFloats, (String)"hslFloats");
        float h = hslFloats[0];
        float s = hslFloats[1];
        float l = hslFloats[2];
        if (s < 0.0f || s > 100.0f) {
            String message = "Color parameter outside of expected range - Saturation";
            throw new IllegalArgumentException(message);
        }
        if (l < 0.0f || l > 100.0f) {
            String message = "Color parameter outside of expected range - Luminance";
            throw new IllegalArgumentException(message);
        }
        if (alpha < 0.0f || alpha > 1.0f) {
            String message = "Color parameter outside of expected range - Alpha";
            throw new IllegalArgumentException(message);
        }
        h %= 360.0f;
        float q = 0.0f;
        q = (double)l < 0.5 ? l * (1.0f + s) : (l /= 100.0f) + (s /= 100.0f) - s * l;
        float p = (float)2 * l - q;
        float r = Math.max(0.0f, HSLUtilKt.hueToRGB(p, q, (h /= 360.0f) + 0.33333334f));
        float g = Math.max(0.0f, HSLUtilKt.hueToRGB(p, q, h));
        float b = Math.max(0.0f, HSLUtilKt.hueToRGB(p, q, h - 0.33333334f));
        r = Math.min(r, 1.0f);
        g = Math.min(g, 1.0f);
        b = Math.min(b, 1.0f);
        return ((int)(alpha * (float)255) << 24) + ((int)(r * (float)255) << 16) + ((int)(g * (float)255) << 8) + (int)(b * (float)255);
    }

    private static final float hueToRGB(float p, float q, float h) {
        float h2 = h;
        if (h2 < 0.0f) {
            h2 += 1.0f;
        }
        if (h2 > 1.0f) {
            h2 -= 1.0f;
        }
        if ((float)6 * h2 < 1.0f) {
            return p + (q - p) * (float)6 * h2;
        }
        if ((float)2 * h2 < 1.0f) {
            return q;
        }
        return (float)3 * h2 < 2.0f ? p + (q - p) * (float)6 * (0.6666667f - h2) : p;
    }
}

