/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.quickfixes;

import com.intellij.codeInsight.intention.EventTrackingIntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNamedElementWithCustomPresentation;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.statistics.SpellcheckerActionStatistics;
import com.intellij.spellchecker.statistics.SpellcheckerRateTracker;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import icons.SpellcheckerIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RenameTo
extends PsiUpdateModCommandQuickFix
implements Iconable,
EventTrackingIntentionAction {
    private final SpellcheckerRateTracker tracker;

    public RenameTo(SpellcheckerRateTracker tracker) {
        this.tracker = tracker;
    }

    @NotNull
    public String getFamilyName() {
        String string = RenameTo.getFixName();
        if (string == null) {
            RenameTo.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement psiElement, @NotNull ModPsiUpdater updater) {
        String name;
        PsiNamedElement named;
        if (project == null) {
            RenameTo.$$$reportNull$$$0(1);
        }
        if (psiElement == null) {
            RenameTo.$$$reportNull$$$0(2);
        }
        if (updater == null) {
            RenameTo.$$$reportNull$$$0(3);
        }
        if ((named = (PsiNamedElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)psiElement, (Class[])new Class[]{PsiNamedElement.class})) == null) {
            return;
        }
        if (named instanceof PsiNamedElementWithCustomPresentation) {
            PsiNamedElementWithCustomPresentation custom = (PsiNamedElementWithCustomPresentation)named;
            v0 = custom.getPresentationName();
        } else {
            v0 = name = named.getName();
        }
        if (name == null) {
            return;
        }
        List<String> names = SpellCheckerManager.getInstance(project).getSuggestions(name).stream().filter(suggestion -> RenameUtil.isValidName((Project)project, (PsiElement)psiElement, (String)suggestion)).toList();
        updater.rename(named, psiElement, names);
        if (!IntentionPreviewUtils.isIntentionPreviewActive()) {
            SpellcheckerActionStatistics.renameToPerformed(this.tracker, names.size());
        }
    }

    public void suggestionShown(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            RenameTo.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            RenameTo.$$$reportNull$$$0(5);
        }
        if (psiFile == null) {
            RenameTo.$$$reportNull$$$0(6);
        }
        if (this.tracker.markShown()) {
            SpellcheckerActionStatistics.suggestionShown(this.tracker);
        }
    }

    @Nls
    public static String getFixName() {
        return SpellCheckerBundle.message("rename.to", new Object[0]);
    }

    public Icon getIcon(int flags) {
        return SpellcheckerIcons.Spellcheck;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/quickfixes/RenameTo";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/quickfixes/RenameTo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "suggestionShown";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

