/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ast.util;

import com.vladsch.flexmark.ast.ImageRef;
import com.vladsch.flexmark.ast.LinkRef;
import com.vladsch.flexmark.ast.RefNode;
import com.vladsch.flexmark.ast.Reference;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.KeepType;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeRepository;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.sequence.Escaping;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ReferenceRepository
extends NodeRepository<Reference> {
    public ReferenceRepository(DataHolder options) {
        super(Parser.REFERENCES_KEEP.get(options));
    }

    @Override
    @NotNull
    public DataKey<ReferenceRepository> getDataKey() {
        return Parser.REFERENCES;
    }

    @Override
    @NotNull
    public DataKey<KeepType> getKeepDataKey() {
        return Parser.REFERENCES_KEEP;
    }

    @Override
    @NotNull
    public String normalizeKey(@NotNull CharSequence key) {
        return Escaping.normalizeReference(key, true);
    }

    @Override
    @NotNull
    public Set<Reference> getReferencedElements(Node parent) {
        HashSet<Reference> references = new HashSet<Reference>();
        this.visitNodes(parent, value -> {
            Reference reference;
            if (value instanceof RefNode && (reference = ((RefNode)value).getReferenceNode(this)) != null) {
                references.add(reference);
            }
        }, LinkRef.class, ImageRef.class);
        return references;
    }
}

