/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import org.traccar.BaseFrameDecoder;

public class BceFrameDecoder
extends BaseFrameDecoder {
    private static final int HANDSHAKE_LENGTH = 7;
    private boolean header = true;

    private static byte checksum(ByteBuf buf, int end) {
        byte result = 0;
        for (int i = 0; i < end; ++i) {
            result = (byte)(result + buf.getByte(buf.readerIndex() + i));
        }
        return result;
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ByteBuf buf) throws Exception {
        if (this.header && buf.readableBytes() >= 7) {
            buf.skipBytes(7);
            this.header = false;
        }
        int end = 8;
        while (buf.readableBytes() >= end + 2 + 1 + 1 + 1) {
            end += buf.getUnsignedShortLE(buf.readerIndex() + end) + 2;
            if (buf.readableBytes() <= end || BceFrameDecoder.checksum(buf, end) != buf.getByte(buf.readerIndex() + end)) continue;
            return buf.readRetainedSlice(end + 1);
        }
        return null;
    }
}

