/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.response;

import java.io.IOException;
import java.util.Map;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.util.NamedList;

public class SolrResponseBase
extends SolrResponse
implements MapWriter {
    private long elapsedTime = -1L;
    private NamedList<Object> response = null;
    private String requestUrl = null;

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        if (this.response != null) {
            this.response.writeMap(ew);
        }
    }

    @Override
    public long getElapsedTime() {
        return this.elapsedTime;
    }

    @Override
    public void setElapsedTime(long elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    @Override
    public NamedList<Object> getResponse() {
        return this.response;
    }

    @Override
    public void setResponse(NamedList<Object> response) {
        this.response = response;
    }

    public String toString() {
        return this.response.toString();
    }

    public NamedList<?> getResponseHeader() {
        Object responseHeader = this.response.get("responseHeader");
        if (responseHeader == null) {
            return null;
        }
        if (responseHeader instanceof NamedList) {
            return (NamedList)responseHeader;
        }
        if (responseHeader instanceof Map) {
            Map responseHeaderAsMap = (Map)responseHeader;
            return new NamedList(responseHeaderAsMap);
        }
        throw new IllegalStateException("'responseHeader' key was an unexpected type [" + responseHeader.getClass().getSimpleName() + "]");
    }

    public int getStatus() {
        NamedList<?> header = this.getResponseHeader();
        if (header != null) {
            return (Integer)header.get("status");
        }
        return 0;
    }

    public int getQTime() {
        NamedList<?> header = this.getResponseHeader();
        if (header != null) {
            return (Integer)header.get("QTime");
        }
        return 0;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }
}

