/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.images;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.resources.ImageCache;
import net.sf.freecol.common.resources.ImageResource;
import net.sf.freecol.common.util.ImageUtils;

public final class DeltaAnimationImageCreator {
    private final ImageLibrary lib;
    private final ImageCache imageCache;

    public DeltaAnimationImageCreator(ImageLibrary lib, ImageCache imageCache) {
        this.lib = lib;
        this.imageCache = imageCache;
    }

    public BufferedImage getAnimatedScaledRiverDeltaTerrainImage(Direction direction, long ticks) {
        ImageResource riverPebblesImageResource = DeltaAnimationImageCreator.getRiverPebblesImageResource();
        if (riverPebblesImageResource == null) {
            return null;
        }
        ImageResource waterImageResource = ImageCache.getImageResource("image.tile.river.water");
        int waterVariationNumber = waterImageResource.getVariationNumberForTick(ticks);
        String generatedKey = waterImageResource.getCachingKey() + ".riverDelta." + direction + "." + waterVariationNumber + "$gen";
        BufferedImage result = this.imageCache.getCachedImageOrGenerate(generatedKey, this.lib.getTileSize(), false, waterVariationNumber, () -> {
            BufferedImage riverPebblesImage = riverPebblesImageResource.getImage(this.lib.getTileSize(), false);
            BufferedImage waterImage = waterImageResource.getVariation(waterVariationNumber).getImage(this.lib.getTileSize(), false);
            String riverWaterMaskKey = "image.mask.river.delta." + direction.toString().toLowerCase();
            BufferedImage riverWaterMaskImage = this.imageCache.getSizedImage(riverWaterMaskKey, this.lib.getTileSize(), false);
            String riverPebblesMaskKey = "image.mask.river.delta.pebbles." + direction.toString().toLowerCase();
            BufferedImage riverPebblesMaskImage = this.imageCache.getSizedImage(riverPebblesMaskKey, this.lib.getTileSize(), false);
            BufferedImage baseTileMask = this.lib.getTerrainMask(null);
            return DeltaAnimationImageCreator.generateImage(riverPebblesImage, waterImage, waterVariationNumber, riverWaterMaskImage, riverPebblesMaskImage, baseTileMask);
        });
        return result;
    }

    private static ImageResource getRiverPebblesImageResource() {
        String key = "image.tile.river.pebbles";
        return ImageCache.getImageResource("image.tile.river.pebbles");
    }

    private static BufferedImage generateImage(BufferedImage pebblesImage, BufferedImage waterImage, int waterImageVariationNumber, BufferedImage riverWaterMaskImage, BufferedImage riverPebblesMaskImage, BufferedImage tileMask) {
        int width = waterImage.getWidth();
        int height = waterImage.getHeight();
        if (pebblesImage.getWidth() != width || pebblesImage.getHeight() != height) {
            throw new IllegalArgumentException("All images should be of the same size.");
        }
        if (riverWaterMaskImage.getWidth() != width || riverWaterMaskImage.getHeight() != height) {
            throw new IllegalArgumentException("All images should be of the same size.");
        }
        if (riverPebblesMaskImage.getWidth() != width || riverPebblesMaskImage.getHeight() != height) {
            throw new IllegalArgumentException("All images should be of the same size.");
        }
        if (tileMask.getWidth() != width || tileMask.getHeight() != height) {
            throw new IllegalArgumentException("All images should be of the same size.");
        }
        BufferedImage maskedPebblesImage = ImageUtils.imageWithAlphaFromMask(pebblesImage, riverPebblesMaskImage);
        BufferedImage maskedWaterImage = ImageUtils.imageWithAlphaFromMask(waterImage, riverWaterMaskImage);
        BufferedImage riverAndPebblesImage = new BufferedImage(width, height, 2);
        Graphics2D g2d = riverAndPebblesImage.createGraphics();
        g2d.drawImage((Image)maskedPebblesImage, 0, 0, null);
        g2d.setComposite(AlphaComposite.getInstance(3, 0.9f));
        g2d.drawImage((Image)maskedWaterImage, 0, 0, null);
        g2d.dispose();
        return ImageUtils.imageWithAlphaFromMask(riverAndPebblesImage, tileMask);
    }
}

