/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.DirectoryEntry;
import org.apache.batik.svggen.font.table.GlyfCompositeDescript;
import org.apache.batik.svggen.font.table.GlyfDescript;
import org.apache.batik.svggen.font.table.GlyfSimpleDescript;
import org.apache.batik.svggen.font.table.LocaTable;
import org.apache.batik.svggen.font.table.Table;

public class GlyfTable
implements Table {
    private byte[] buf = null;
    private GlyfDescript[] descript;

    protected GlyfTable(DirectoryEntry directoryEntry, RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.seek(directoryEntry.getOffset());
        this.buf = new byte[directoryEntry.getLength()];
        randomAccessFile.read(this.buf);
    }

    public void init(int n, LocaTable locaTable) {
        short s;
        int n2;
        if (this.buf == null) {
            return;
        }
        this.descript = new GlyfDescript[n];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.buf);
        int n3 = 0;
        while (n3 < n) {
            n2 = locaTable.getOffset((short)(n3 + 1)) - locaTable.getOffset(n3);
            if (n2 > 0) {
                byteArrayInputStream.reset();
                byteArrayInputStream.skip(locaTable.getOffset(n3));
                s = (short)(byteArrayInputStream.read() << 8 | byteArrayInputStream.read());
                if (s >= 0) {
                    this.descript[n3] = new GlyfSimpleDescript(this, s, byteArrayInputStream);
                }
            } else {
                this.descript[n3] = null;
            }
            ++n3;
        }
        n2 = 0;
        while (n2 < n) {
            s = locaTable.getOffset((short)(n2 + 1)) - locaTable.getOffset(n2);
            if (s > 0) {
                byteArrayInputStream.reset();
                byteArrayInputStream.skip(locaTable.getOffset(n2));
                short s2 = (short)(byteArrayInputStream.read() << 8 | byteArrayInputStream.read());
                if (s2 < 0) {
                    this.descript[n2] = new GlyfCompositeDescript(this, byteArrayInputStream);
                }
            }
            ++n2;
        }
        this.buf = null;
    }

    public GlyfDescript getDescription(int n) {
        return this.descript[n];
    }

    public int getType() {
        return 1735162214;
    }
}

