/*
 * Decompiled with CFR 0.152.
 */
package tr.view.action.recurrence;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.openide.util.NbBundle;
import tr.model.action.Period;
import tr.model.action.PeriodDay;
import tr.model.action.PeriodMonth;
import tr.model.action.PeriodType;
import tr.model.action.PeriodWeek;
import tr.model.action.PeriodWeekday;
import tr.model.action.PeriodYear;
import tr.model.action.Recurrence;
import tr.swing.date.field.DateField;
import tr.view.action.recurrence.PeriodTypeComboBox;

public final class NewRecurrenceVisualPanel3
extends JPanel {
    private static final Class clazz = NewRecurrenceVisualPanel3.class;
    private static int counter;
    private final Recurrence recurrence;
    private Map<PeriodType, Period> mapPeriods;
    private ButtonGroup buttonGroup;
    private DateField endDateField;
    private JRadioButton endDateRadio;
    private JLabel endLabel;
    private JRadioButton endNbrRadio;
    private JSpinner endNbrSpinner;
    private JRadioButton endNeverRadio;
    private JTextArea errorText;
    private JSpinner frequencySpinner;
    private JLabel createLabel;
    private PeriodTypeComboBox periodCombo;

    public NewRecurrenceVisualPanel3(Recurrence recurrence) {
        this.recurrence = recurrence;
        this.initPeriods();
        this.initView();
        this.loadValues();
    }

    public String getName() {
        return this.getMsg("define.subsequent.recurrence");
    }

    public String getMsg(String key) {
        return NbBundle.getMessage((Class)clazz, (String)key);
    }

    private void initPeriods() {
        this.setPeriod((Period)new PeriodWeekday());
        this.setPeriod((Period)new PeriodDay());
        this.setPeriod((Period)new PeriodWeek());
        this.setPeriod((Period)new PeriodMonth());
        this.setPeriod((Period)new PeriodYear());
        this.setPeriod(this.recurrence.getPeriod());
    }

    private Period getPeriod(PeriodType type) {
        if (this.mapPeriods == null) {
            this.mapPeriods = new HashMap<PeriodType, Period>();
        }
        return this.mapPeriods.get(type);
    }

    private void setPeriod(Period period) {
        if (this.mapPeriods == null) {
            this.mapPeriods = new HashMap<PeriodType, Period>();
        }
        this.mapPeriods.put(period.getType(), period);
    }

    private void enableDisableComponents() {
        this.endDateField.setEnabled(this.endDateRadio.isSelected());
        this.endNbrSpinner.setEnabled(this.endNbrRadio.isSelected());
    }

    private void setEndValues() {
        if (this.endNbrRadio.isSelected()) {
            this.recurrence.setEndNbr((Integer)this.endNbrSpinner.getValue());
            this.recurrence.setEndDate(null);
            return;
        }
        if (this.endDateRadio.isSelected()) {
            this.recurrence.setEndNbr(null);
            this.recurrence.setEndDate(this.endDateField.getDate());
            return;
        }
    }

    public void loadValues() {
        this.frequencySpinner.setValue(this.recurrence.getFrequency());
        this.periodCombo.setSelectedItem(this.recurrence.getPeriod().getType());
        this.endNbrRadio.setSelected(this.recurrence.getEndNbr() != null);
        this.endNbrSpinner.setValue(this.recurrence.getEndNbr() == null ? 2 : this.recurrence.getEndNbr());
        this.endDateRadio.setSelected(this.recurrence.getEndDate() != null);
        this.endDateField.setDate(this.recurrence.getEndDate());
        this.endNeverRadio.setSelected(!this.endNbrRadio.isSelected() && !this.endDateRadio.isSelected());
        this.enableDisableComponents();
    }

    public void stateChange() {
        this.putClientProperty("state.change", ++counter);
    }

    public boolean isValidForm() {
        if (this.endDateRadio.isSelected() && this.endDateField.getDate() == null) {
            this.errorText.setText(this.getMsg("termination.date.must.be.entered"));
            return false;
        }
        this.errorText.setText("");
        return true;
    }

    private void periodComboBoxActionPerformed(ActionEvent evt) {
        this.recurrence.setPeriod(this.getPeriod((PeriodType)this.periodCombo.getSelectedItem()));
        this.stateChange();
        this.setEndValues();
    }

    private void endNbrRadioButtonActionPerformed(ActionEvent evt) {
        this.setEndValues();
        this.stateChange();
        this.enableDisableComponents();
    }

    private void frequencySpinnerStateChanged(ChangeEvent evt) {
        this.recurrence.setFrequency(((Integer)this.frequencySpinner.getValue()).intValue());
        this.stateChange();
        this.setEndValues();
    }

    private void endNeverRadioButtonStateChanged(ChangeEvent evt) {
        this.stateChange();
        this.setEndValues();
        this.enableDisableComponents();
    }

    private void endNbrSpinnerStateChanged(ChangeEvent evt) {
        this.stateChange();
        this.setEndValues();
    }

    private void endDateFieldPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("value")) {
            this.stateChange();
            this.setEndValues();
        }
    }

    private void endDateRadioButtonStateChanged(ChangeEvent evt) {
        this.stateChange();
        this.setEndValues();
        this.enableDisableComponents();
    }

    private void initView() {
        this.createLabel = new JLabel(this.getMsg("create.subsequent.action.in"));
        this.frequencySpinner = new JSpinner();
        this.frequencySpinner.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.frequencySpinner.setPreferredSize(new Dimension(50, 23));
        this.frequencySpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                NewRecurrenceVisualPanel3.this.frequencySpinnerStateChanged(evt);
            }
        });
        this.periodCombo = new PeriodTypeComboBox();
        this.periodCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewRecurrenceVisualPanel3.this.periodComboBoxActionPerformed(evt);
            }
        });
        this.endLabel = new JLabel(this.getMsg("terminate"));
        this.endLabel.setHorizontalAlignment(11);
        this.endNeverRadio = new JRadioButton(this.getMsg("never"));
        this.endNeverRadio.setVerticalTextPosition(1);
        this.endNeverRadio.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                NewRecurrenceVisualPanel3.this.endNeverRadioButtonStateChanged(evt);
            }
        });
        this.endNbrRadio = new JRadioButton(this.getMsg("after"));
        this.endNbrRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewRecurrenceVisualPanel3.this.endNbrRadioButtonActionPerformed(evt);
            }
        });
        this.endNbrSpinner = new JSpinner();
        this.endNbrSpinner.setModel(new SpinnerNumberModel((Number)2, Integer.valueOf(2), null, (Number)1));
        this.endNbrSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                NewRecurrenceVisualPanel3.this.endNbrSpinnerStateChanged(evt);
            }
        });
        this.endDateRadio = new JRadioButton(this.getMsg("after"));
        this.endDateRadio.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                NewRecurrenceVisualPanel3.this.endDateRadioButtonStateChanged(evt);
            }
        });
        this.endDateField = new DateField();
        this.endDateField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                NewRecurrenceVisualPanel3.this.endDateFieldPropertyChange(evt);
            }
        });
        this.errorText = new JTextArea();
        this.errorText.setForeground(Color.red);
        this.errorText.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.errorText.setEditable(false);
        this.errorText.setWrapStyleWord(true);
        this.errorText.setLineWrap(true);
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.endNeverRadio);
        this.buttonGroup.add(this.endNbrRadio);
        this.buttonGroup.add(this.endDateRadio);
        JPanel panel = new JPanel((LayoutManager)new MigLayout("", "0[]2[grow]0", "0[]2[]2[grow]0"));
        panel.add((Component)this.createLabel, "align left, span, split 3");
        panel.add((Component)this.frequencySpinner, "align left");
        panel.add((Component)this.periodCombo, "align left, wrap");
        panel.add((Component)this.endLabel, "align left, span, split 6");
        panel.add((Component)this.endNeverRadio, "align left");
        panel.add((Component)this.endNbrRadio, "align left");
        panel.add((Component)this.endNbrSpinner, "align left, w 54");
        panel.add((Component)this.endDateRadio, "align left");
        panel.add((Component)this.endDateField, "align left, wrap");
        panel.add((Component)this.errorText, "gaptop 15, span, grow, shrink");
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "Center");
    }

    private void initComponents() {
    }
}

