/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.ObjectStreamException;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.namednumber.IpV4OptionType;
import org.pcap4j.util.ByteArrays;

public final class IpV4NoOperationOption
implements IpV4Packet.IpV4Option {
    private static final long serialVersionUID = 194338954674452009L;
    private static final IpV4NoOperationOption INSTANCE = new IpV4NoOperationOption();
    private static final IpV4OptionType type = IpV4OptionType.NO_OPERATION;

    private IpV4NoOperationOption() {
    }

    public static IpV4NoOperationOption getInstance() {
        return INSTANCE;
    }

    public static IpV4NoOperationOption newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        if (rawData[offset] != (Byte)type.value()) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The type must be: ").append(type.valueAsString()).append(" rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        return IpV4NoOperationOption.getInstance();
    }

    @Override
    public IpV4OptionType getType() {
        return type;
    }

    @Override
    public int length() {
        return 1;
    }

    @Override
    public byte[] getRawData() {
        return new byte[]{1};
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[option-type: ").append(type);
        sb.append("]");
        return sb.toString();
    }

    private Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }
}

